/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.promotion.bing;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public class BingReportUtils {
    private static final Logger log = LoggerFactory.getLogger(BingReportUtils.class);
    private static final String BING_REPORTING_API_URL = "https://reporting.api.bingads.microsoft.com/Reporting/v13/GenerateReport/Submit";
    private static final String BING_POLL_API_URL = "https://reporting.api.bingads.microsoft.com/Reporting/v13/GenerateReport/Poll";

    public static String submitReportRequestWithRestApi(RestApiHelper restApiHelper, String customerId, String customerAccountId, String developerToken, String accessToken, Date startDate, Date endDate, String deviceFilter) {
        try {
            log.info("\u3010Bing\u5de5\u5177\u3011\u4f7f\u7528 RestApiHelper \u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\uff0ccustomerId: {}, customerAccountId: {}", (Object)customerId, (Object)customerAccountId);
            JSONObject reportRequest = BingReportUtils.buildReportRequestJson(customerId, customerAccountId, startDate, endDate, deviceFilter);
            JSONObject requestBody = new JSONObject();
            requestBody.put("ReportRequest", (Object)reportRequest);
            String requestJson = requestBody.toJSONString();
            log.debug("\u3010Bing\u5de5\u5177\u3011\u8bf7\u6c42\u4f53: {}", (Object)requestJson);
            HttpHeaders headers = BingReportUtils.buildRequestHeaders(customerId, customerAccountId, developerToken, accessToken);
            String responseBody = restApiHelper.post(BING_REPORTING_API_URL, requestJson, headers, new MediaType[0]);
            log.info("\u3010Bing\u5de5\u5177\u3011\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\u54cd\u5e94: {}", (Object)responseBody);
            String jsonString = BingReportUtils.extractJsonFromResponse(responseBody);
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                log.error("\u3010Bing\u5de5\u5177\u3011\u65e0\u6cd5\u4ece\u54cd\u5e94\u4e2d\u63d0\u53d6\u6709\u6548\u7684 JSON \u5b57\u7b26\u4e32");
                return null;
            }
            JSONObject responseJson = JSON.parseObject((String)jsonString);
            String reportRequestId = responseJson.getString("ReportRequestId");
            log.info("\u3010Bing\u5de5\u5177\u3011\u6210\u529f\u63d0\u53d6\u62a5\u544a\u8bf7\u6c42ID: {}", (Object)reportRequestId);
            return reportRequestId;
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static ReportStatus pollReportStatusWithRestApi(RestApiHelper restApiHelper, String customerId, String customerAccountId, String developerToken, String accessToken, String reportRequestId) {
        try {
            log.info("\u3010Bing\u5de5\u5177\u3011\u4f7f\u7528 RestApiHelper \u8f6e\u8be2\u62a5\u544a\u72b6\u6001\uff0creportRequestId: {}", (Object)reportRequestId);
            HttpHeaders headers = BingReportUtils.buildRequestHeaders(customerId, customerAccountId, developerToken, accessToken);
            JSONObject requestBody = new JSONObject();
            requestBody.put("ReportRequestId", (Object)reportRequestId);
            String requestJson = requestBody.toJSONString();
            String responseBody = restApiHelper.post(BING_POLL_API_URL, requestJson, headers, new MediaType[0]);
            log.debug("\u3010Bing\u5de5\u5177\u3011\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u54cd\u5e94: {}", (Object)responseBody);
            String jsonString = BingReportUtils.extractJsonFromResponse(responseBody);
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                log.error("\u3010Bing\u5de5\u5177\u3011\u65e0\u6cd5\u4ece\u8f6e\u8be2\u54cd\u5e94\u4e2d\u63d0\u53d6\u6709\u6548\u7684 JSON \u5b57\u7b26\u4e32");
                return null;
            }
            JSONObject responseJson = JSON.parseObject((String)jsonString);
            JSONObject reportStatus = responseJson.getJSONObject("ReportRequestStatus");
            ReportStatus status = new ReportStatus();
            status.setStatus(reportStatus.getString("Status"));
            status.setDownloadUrl(reportStatus.getString("ReportDownloadUrl"));
            log.info("\u3010Bing\u5de5\u5177\u3011\u62a5\u544a\u72b6\u6001: {}, \u4e0b\u8f7dURL: {}", (Object)status.getStatus(), (Object)status.getDownloadUrl());
            return status;
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static String extractJsonFromResponse(String responseBody) {
        if (StringUtils.isBlank((CharSequence)responseBody)) {
            return null;
        }
        try {
            String trimmed = responseBody.trim();
            if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
                log.debug("\u3010Bing\u5de5\u5177\u3011\u54cd\u5e94\u662f\u7eaf JSON \u683c\u5f0f");
                return trimmed;
            }
            int jsonStart = trimmed.indexOf("{");
            int jsonEnd = trimmed.lastIndexOf("}");
            if (jsonStart >= 0 && jsonEnd > jsonStart) {
                String extractedJson = trimmed.substring(jsonStart, jsonEnd + 1);
                log.debug("\u3010Bing\u5de5\u5177\u3011\u4ece\u54cd\u5e94\u4e2d\u63d0\u53d6\u7684 JSON: {}", (Object)extractedJson);
                JSON.parseObject((String)extractedJson);
                return extractedJson;
            }
            log.warn("\u3010Bing\u5de5\u5177\u3011\u65e0\u6cd5\u4ece\u54cd\u5e94\u4e2d\u627e\u5230\u6709\u6548\u7684 JSON \u683c\u5f0f: {}", (Object)responseBody);
            return null;
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011\u63d0\u53d6 JSON \u5b57\u7b26\u4e32\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u54cd\u5e94\u5185\u5bb9: {}", (Object)responseBody, (Object)e);
            return null;
        }
    }

    private static JSONObject buildReportRequestJson(String customerId, String customerAccountId, Date startDate, Date endDate, String deviceFilter) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject reportRequest = new JSONObject();
        reportRequest.put("Type", (Object)"SearchQueryPerformanceReportRequest");
        reportRequest.put("ReportName", (Object)("SearchQueryPerformance_" + sdf.format(new Date()).replace("-", "_")));
        reportRequest.put("Format", (Object)"Csv");
        reportRequest.put("Aggregation", (Object)"Daily");
        reportRequest.put("ReturnOnlyCompleteData", (Object)false);
        reportRequest.put("ExcludeReportHeader", (Object)true);
        reportRequest.put("ExcludeReportFooter", (Object)true);
        reportRequest.put("ExcludeColumnHeaders", (Object)false);
        JSONObject time = new JSONObject();
        JSONObject startDateObj = new JSONObject();
        String[] startParts = sdf.format(startDate).split("-");
        startDateObj.put("Year", (Object)Integer.parseInt(startParts[0]));
        startDateObj.put("Month", (Object)Integer.parseInt(startParts[1]));
        startDateObj.put("Day", (Object)Integer.parseInt(startParts[2]));
        JSONObject endDateObj = new JSONObject();
        String[] endParts = sdf.format(endDate).split("-");
        endDateObj.put("Year", (Object)Integer.parseInt(endParts[0]));
        endDateObj.put("Month", (Object)Integer.parseInt(endParts[1]));
        endDateObj.put("Day", (Object)Integer.parseInt(endParts[2]));
        time.put("CustomDateRangeStart", (Object)startDateObj);
        time.put("CustomDateRangeEnd", (Object)endDateObj);
        reportRequest.put("Time", (Object)time);
        if (StringUtils.isNotBlank((CharSequence)customerAccountId)) {
            JSONObject scope = new JSONObject();
            ArrayList<Long> accountIds = new ArrayList<Long>();
            accountIds.add(Long.parseLong(customerAccountId));
            scope.put("AccountIds", accountIds);
            reportRequest.put("Scope", (Object)scope);
        }
        List<String> columns = Arrays.asList("TimePeriod", "SearchQuery", "CampaignName", "AdGroupName", "Keyword", "Impressions", "Clicks", "Spend", "Ctr", "AverageCpc", "DeviceType", "DeliveredMatchType");
        reportRequest.put("Columns", columns);
        if (StringUtils.isNotBlank((CharSequence)deviceFilter)) {
            JSONObject filter = new JSONObject();
            filter.put("DeviceType", (Object)deviceFilter);
            reportRequest.put("Filter", (Object)filter);
        }
        return reportRequest;
    }

    private static HttpHeaders buildRequestHeaders(String customerId, String customerAccountId, String developerToken, String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        headers.set("Authorization", "Bearer " + accessToken);
        headers.set("Connection", "keep-alive");
        headers.set("Content-Type", "application/json");
        headers.set("CustomerAccountId", customerAccountId);
        headers.set("CustomerId", customerId);
        headers.set("DeveloperToken", developerToken);
        return headers;
    }

    public static List<String[]> downloadCsvReport(String downloadUrl) {
        List<String[]> reportData = new ArrayList<String[]>();
        try {
            log.info("\u3010Bing\u5de5\u5177\u3011\u5f00\u59cb\u4e0b\u8f7d\u62a5\u544a\uff0cURL: {}", (Object)downloadUrl);
            byte[] fileData = BingReportUtils.downloadBinaryFileWithHutool(downloadUrl);
            log.info("\u3010Bing\u5de5\u5177\u3011\u62a5\u544a\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6570\u636e\u5927\u5c0f: {} bytes", (Object)(fileData != null ? fileData.length : 0));
            if (fileData == null || fileData.length == 0) {
                log.warn("\u3010Bing\u5de5\u5177\u3011\u4e0b\u8f7d\u7684\u62a5\u544a\u6570\u636e\u4e3a\u7a7a");
                return reportData;
            }
            if (BingReportUtils.isZipFile(downloadUrl, fileData)) {
                log.info("\u3010Bing\u5de5\u5177\u3011\u68c0\u6d4b\u5230\u538b\u7f29\u5305\uff0c\u5f00\u59cb\u89e3\u538b");
                reportData = BingReportUtils.extractAndParseZipFile(fileData);
            } else {
                log.info("\u3010Bing\u5de5\u5177\u3011\u68c0\u6d4b\u5230\u975e\u538b\u7f29\u6587\u4ef6\uff0c\u76f4\u63a5\u89e3\u6790");
                if (BingReportUtils.isExcelFile(downloadUrl)) {
                    reportData = BingReportUtils.parseExcelContent(fileData);
                } else {
                    String fileContent = new String(fileData, "UTF-8");
                    reportData = BingReportUtils.parseCsvContent(fileContent);
                }
            }
            log.info("\u3010Bing\u5de5\u5177\u3011\u62a5\u544a\u89e3\u6790\u5b8c\u6210\uff0c\u5171{}\u884c\u6570\u636e", (Object)reportData.size());
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011\u4e0b\u8f7d\u62a5\u544a\u5931\u8d25", (Throwable)e);
        }
        return reportData;
    }

    private static byte[] downloadBinaryFileWithHutool(String downloadUrl) {
        int MAX_RETRY_COUNT = 3;
        long RETRY_DELAY_MS = 2000L;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            try {
                log.info("\u3010Bing\u5de5\u5177\u3011\u5f00\u59cb\u4f7f\u7528 Hutool HttpRequest \u4e0b\u8f7d\u4e8c\u8fdb\u5236\u6587\u4ef6\uff08\u7b2c{}\u6b21\u5c1d\u8bd5/\u5171{}\u6b21\uff09: {}", new Object[]{attemptCount, 3, downloadUrl});
                HttpResponse response = ((HttpRequest)HttpRequest.get((String)downloadUrl).header("Accept", "*/*")).timeout(60000).execute();
                if (response.isOk()) {
                    byte[] data = response.bodyBytes();
                    if (data != null && data.length > 0) {
                        log.info("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5b8c\u6210\uff0c\u72b6\u6001\u7801: {}, \u6570\u636e\u5927\u5c0f: {} bytes", (Object)response.getStatus(), (Object)data.length);
                        if (data.length >= 10) {
                            StringBuilder hexStr = new StringBuilder();
                            for (int i = 0; i < Math.min(10, data.length); ++i) {
                                hexStr.append(String.format("%02X ", data[i] & 0xFF));
                            }
                            log.info("\u3010Bing\u5de5\u5177\u3011\u6587\u4ef6\u5934\u5b57\u8282: {}", (Object)hexStr.toString());
                        }
                        return data;
                    }
                    log.error("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u54cd\u5e94\u4f53\u4e3a\u7a7a");
                    if (attemptCount < 3) {
                        log.info("\u3010Bing\u5de5\u5177\u3011\u54cd\u5e94\u4f53\u4e3a\u7a7a\uff0c\u5c06\u5728{}ms\u540e\u8fdb\u884c\u7b2c{}\u6b21\u91cd\u8bd5", (Object)2000L, (Object)(attemptCount + 1));
                        Thread.sleep(2000L);
                        continue;
                    }
                    return null;
                }
                int statusCode = response.getStatus();
                String responseBody = response.body();
                if (statusCode == 403) {
                    if (attemptCount < 3) {
                        log.warn("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5931\u8d25\uff08\u8ba4\u8bc1\u5931\u8d25\uff09\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}, \u5c06\u5728{}ms\u540e\u8fdb\u884c\u7b2c{}\u6b21\u91cd\u8bd5", new Object[]{statusCode, responseBody, 2000L, attemptCount + 1});
                        Thread.sleep(2000L);
                        continue;
                    }
                    log.warn("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5931\u8d25\uff08\u8ba4\u8bc1\u5931\u8d25\uff09\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: {}\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", new Object[]{3, statusCode, responseBody});
                } else {
                    if (attemptCount < 3) {
                        log.error("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}, \u5c06\u5728{}ms\u540e\u8fdb\u884c\u7b2c{}\u6b21\u91cd\u8bd5", new Object[]{statusCode, responseBody, 2000L, attemptCount + 1});
                        Thread.sleep(2000L);
                        continue;
                    }
                    log.error("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5931\u8d25\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: {}\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", new Object[]{3, statusCode, responseBody});
                }
                return null;
            }
            catch (InterruptedException ie) {
                log.warn("\u3010Bing\u5de5\u5177\u3011\u4e0b\u8f7d\u91cd\u8bd5\u88ab\u4e2d\u65ad");
                Thread.currentThread().interrupt();
                return null;
            }
            catch (Exception e) {
                if (attemptCount < 3) {
                    log.error("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5f02\u5e38\uff08\u7b2c{}\u6b21\u5c1d\u8bd5\uff09: {}\uff0c\u5c06\u5728{}ms\u540e\u8fdb\u884c\u7b2c{}\u6b21\u91cd\u8bd5", new Object[]{attemptCount, e.getMessage(), 2000L, attemptCount + 1});
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        log.warn("\u3010Bing\u5de5\u5177\u3011\u91cd\u8bd5\u7b49\u5f85\u88ab\u4e2d\u65ad");
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                log.error("\u3010Bing\u5de5\u5177\u3011Hutool HttpRequest \u4e0b\u8f7d\u5f02\u5e38\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: {}: {}", new Object[]{3, e.getMessage(), e});
                return null;
            }
        }
        return null;
    }

    private static boolean isZipFile(String downloadUrl, byte[] fileData) {
        log.info("\u3010Bing\u5de5\u5177\u3011\u68c0\u6d4b\u6587\u4ef6\u7c7b\u578b\uff0cURL: {}, \u6570\u636e\u5927\u5c0f: {} bytes", (Object)downloadUrl, (Object)(fileData != null ? fileData.length : 0));
        boolean urlIndicatesZip = downloadUrl != null && downloadUrl.toLowerCase().contains(".zip");
        log.info("\u3010Bing\u5de5\u5177\u3011URL \u6307\u793a ZIP: {}", (Object)urlIndicatesZip);
        boolean headerIndicatesZip = false;
        if (fileData != null && fileData.length >= 2) {
            byte first = fileData[0];
            byte second = fileData[1];
            headerIndicatesZip = first == 80 && second == 75;
            log.info("\u3010Bing\u5de5\u5177\u3011\u6587\u4ef6\u5934\u68c0\u6d4b: \u7b2c\u4e00\u5b57\u8282=0x{}, \u7b2c\u4e8c\u5b57\u8282=0x{}, \u662f\u5426ZIP: {}", new Object[]{String.format("%02X", first & 0xFF), String.format("%02X", second & 0xFF), headerIndicatesZip});
        } else {
            log.warn("\u3010Bing\u5de5\u5177\u3011\u6587\u4ef6\u6570\u636e\u4e0d\u8db3\uff0c\u65e0\u6cd5\u68c0\u6d4b\u6587\u4ef6\u5934");
        }
        boolean isZip = urlIndicatesZip || headerIndicatesZip;
        log.info("\u3010Bing\u5de5\u5177\u3011\u6700\u7ec8\u5224\u65ad\u662f\u5426\u4e3a ZIP \u6587\u4ef6: {}", (Object)isZip);
        return isZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> extractAndParseZipFile(byte[] zipData) {
        ArrayList<String[]> allData = new ArrayList<String[]>();
        log.info("\u3010Bing\u5de5\u5177\u3011\u5f00\u59cb\u4f7f\u7528 Hutool \u89e3\u538b ZIP \u6587\u4ef6\uff0c\u6570\u636e\u5927\u5c0f: {} bytes", (Object)zipData.length);
        if (zipData == null || zipData.length < 22) {
            log.error("\u3010Bing\u5de5\u5177\u3011ZIP \u6570\u636e\u65e0\u6548\uff0c\u5927\u5c0f\u4e0d\u8db3");
            return BingReportUtils.tryParseAsPlainFile(zipData);
        }
        if (zipData[0] != 80 || zipData[1] != 75) {
            log.warn("\u3010Bing\u5de5\u5177\u3011\u6570\u636e\u4e0d\u662f\u6709\u6548\u7684 ZIP \u683c\u5f0f\uff0c\u5c1d\u8bd5\u4f5c\u4e3a\u666e\u901a\u6587\u4ef6\u89e3\u6790");
            return BingReportUtils.tryParseAsPlainFile(zipData);
        }
        try {
            log.info("\u3010Bing\u5de5\u5177\u3011\u4f7f\u7528 Hutool \u65b9\u5f0f\u89e3\u538b ZIP \u6587\u4ef6");
            File tempZipFile = File.createTempFile("bing_report_", ".zip");
            File tempExtractDir = File.createTempFile("bing_extract_", "");
            tempExtractDir.delete();
            tempExtractDir.mkdirs();
            try {
                FileUtil.writeBytes((byte[])zipData, (File)tempZipFile);
                log.info("\u3010Bing\u5de5\u5177\u3011\u5199\u5165\u4e34\u65f6 ZIP \u6587\u4ef6: {}", (Object)tempZipFile.getAbsolutePath());
                ZipUtil.unzip((File)tempZipFile, (File)tempExtractDir);
                log.info("\u3010Bing\u5de5\u5177\u3011\u89e3\u538b\u5230\u4e34\u65f6\u76ee\u5f55: {}", (Object)tempExtractDir.getAbsolutePath());
                File[] extractedFiles = tempExtractDir.listFiles();
                if (extractedFiles != null) {
                    int fileCount = 0;
                    for (File extractedFile : extractedFiles) {
                        if (extractedFile.isDirectory()) {
                            log.info("\u3010Bing\u5de5\u5177\u3011\u8df3\u8fc7\u76ee\u5f55: {}", (Object)extractedFile.getName());
                            continue;
                        }
                        String fileName = extractedFile.getName();
                        log.info("\u3010Bing\u5de5\u5177\u3011\u5904\u7406\u89e3\u538b\u6587\u4ef6 #{}: {}, \u5927\u5c0f: {} bytes", new Object[]{++fileCount, fileName, extractedFile.length()});
                        byte[] fileData = FileUtil.readBytes((File)extractedFile);
                        log.info("\u3010Bing\u5de5\u5177\u3011\u6587\u4ef6 {} \u8bfb\u53d6\u5b8c\u6210: {} bytes", (Object)fileName, (Object)fileData.length);
                        try {
                            List<String[]> fileDataParsed;
                            if (BingReportUtils.isExcelFile(fileName)) {
                                log.info("\u3010Bing\u5de5\u5177\u3011\u89e3\u6790 Excel \u6587\u4ef6: {}", (Object)fileName);
                                fileDataParsed = BingReportUtils.parseExcelContent(fileData);
                            } else if (BingReportUtils.isCsvFile(fileName)) {
                                log.info("\u3010Bing\u5de5\u5177\u3011\u89e3\u6790 CSV \u6587\u4ef6: {}", (Object)fileName);
                                String csvContent = new String(fileData, "UTF-8");
                                fileDataParsed = BingReportUtils.parseCsvContent(csvContent);
                            } else {
                                log.warn("\u3010Bing\u5de5\u5177\u3011\u8df3\u8fc7\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b: {}", (Object)fileName);
                                continue;
                            }
                            allData.addAll(fileDataParsed);
                            log.info("\u3010Bing\u5de5\u5177\u3011\u6587\u4ef6 {} \u89e3\u6790\u5b8c\u6210\uff0c\u6570\u636e\u884c\u6570: {}", (Object)fileName, (Object)fileDataParsed.size());
                        }
                        catch (Exception parseEx) {
                            log.error("\u3010Bing\u5de5\u5177\u3011\u89e3\u6790\u6587\u4ef6 {} \u5931\u8d25\uff0c\u8df3\u8fc7\u8be5\u6587\u4ef6", (Object)fileName, (Object)parseEx);
                        }
                    }
                    log.info("\u3010Bing\u5de5\u5177\u3011Hutool ZIP \u89e3\u538b\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u6587\u4ef6\uff0c\u603b\u6570\u636e\u884c\u6570: {}", (Object)fileCount, (Object)allData.size());
                } else {
                    log.warn("\u3010Bing\u5de5\u5177\u3011\u89e3\u538b\u76ee\u5f55\u4e3a\u7a7a\u6216\u65e0\u6cd5\u8bfb\u53d6");
                }
            }
            finally {
                try {
                    if (tempZipFile.exists()) {
                        tempZipFile.delete();
                        log.debug("\u3010Bing\u5de5\u5177\u3011\u5220\u9664\u4e34\u65f6 ZIP \u6587\u4ef6: {}", (Object)tempZipFile.getAbsolutePath());
                    }
                    if (tempExtractDir.exists()) {
                        FileUtil.del((File)tempExtractDir);
                        log.debug("\u3010Bing\u5de5\u5177\u3011\u5220\u9664\u4e34\u65f6\u89e3\u538b\u76ee\u5f55: {}", (Object)tempExtractDir.getAbsolutePath());
                    }
                }
                catch (Exception cleanupEx) {
                    log.warn("\u3010Bing\u5de5\u5177\u3011\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)cleanupEx);
                }
            }
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011Hutool \u89e3\u538b ZIP \u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            log.info("\u3010Bing\u5de5\u5177\u3011ZIP \u89e3\u538b\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f5c\u4e3a\u666e\u901a\u6587\u4ef6\u89e3\u6790");
            return BingReportUtils.tryParseAsPlainFile(zipData);
        }
        return allData;
    }

    private static List<String[]> tryParseAsPlainFile(byte[] fileData) {
        if (fileData == null || fileData.length == 0) {
            log.warn("\u3010Bing\u5de5\u5177\u3011\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790");
            return new ArrayList<String[]>();
        }
        try {
            log.info("\u3010Bing\u5de5\u5177\u3011\u5c1d\u8bd5\u4f5c\u4e3a\u666e\u901a\u6587\u4ef6\u89e3\u6790\uff0c\u6570\u636e\u5927\u5c0f: {} bytes", (Object)fileData.length);
            String content = new String(fileData, "UTF-8");
            if (content.contains(",") || content.contains("\n") || content.contains("\r")) {
                log.info("\u3010Bing\u5de5\u5177\u3011\u68c0\u6d4b\u5230 CSV \u7279\u5f81\uff0c\u4f5c\u4e3a CSV \u89e3\u6790");
                return BingReportUtils.parseCsvContent(content);
            }
            log.warn("\u3010Bing\u5de5\u5177\u3011\u65e0\u6cd5\u8bc6\u522b\u6587\u4ef6\u683c\u5f0f\uff0c\u8fd4\u56de\u7a7a\u6570\u636e");
            return new ArrayList<String[]>();
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011\u4f5c\u4e3a\u666e\u901a\u6587\u4ef6\u89e3\u6790\u4e5f\u5931\u8d25", (Throwable)e);
            return new ArrayList<String[]>();
        }
    }

    private static boolean isCsvFile(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        String lowerName = fileName.toLowerCase();
        return lowerName.endsWith(".csv") || lowerName.endsWith(".txt");
    }

    private static boolean isExcelFile(String downloadUrl) {
        if (StringUtils.isBlank((CharSequence)downloadUrl)) {
            return false;
        }
        String lowerUrl = downloadUrl.toLowerCase();
        return lowerUrl.contains(".xlsx") || lowerUrl.contains(".xls") || lowerUrl.contains("excel");
    }

    private static List<String[]> parseExcelContent(byte[] fileData) {
        final ArrayList<String[]> excelData = new ArrayList<String[]>();
        try {
            log.info("\u3010Bing\u5de5\u5177\u3011\u5f00\u59cb\u4f7f\u7528 EasyExcel \u89e3\u6790 Excel \u5185\u5bb9");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData);
            EasyExcel.read((InputStream)inputStream, (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invoke(Map<Integer, String> data, AnalysisContext context) {
                    ArrayList<String> rowData = new ArrayList<String>();
                    int maxIndex = data.keySet().stream().mapToInt(Integer::intValue).max().orElse(-1);
                    for (int i = 0; i <= maxIndex; ++i) {
                        rowData.add(data.getOrDefault(i, ""));
                    }
                    excelData.add(rowData.toArray(new String[0]));
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                    log.info("\u3010Bing\u5de5\u5177\u3011EasyExcel \u89e3\u6790\u5b8c\u6210\uff0c\u5171{}\u884c\u6570\u636e", (Object)excelData.size());
                }
            }).sheet().doRead();
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011EasyExcel \u89e3\u6790 Excel \u5185\u5bb9\u5931\u8d25", (Throwable)e);
            log.info("\u3010Bing\u5de5\u5177\u3011\u5c1d\u8bd5\u5c06\u5185\u5bb9\u4f5c\u4e3a CSV \u89e3\u6790");
            return BingReportUtils.parseCsvContent(((Object)excelData).toString());
        }
        return excelData;
    }

    private static List<String[]> parseCsvContent(String csvContent) {
        ArrayList<String[]> csvData = new ArrayList<String[]>();
        try {
            String[] lines;
            log.info("\u3010Bing\u5de5\u5177\u3011\u5f00\u59cb\u89e3\u6790 CSV \u5185\u5bb9");
            for (String line : lines = csvContent.split("\\r?\\n")) {
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                String[] fields = BingReportUtils.parseCsvLine(line);
                csvData.add(fields);
            }
            log.info("\u3010Bing\u5de5\u5177\u3011CSV \u89e3\u6790\u5b8c\u6210\uff0c\u5171{}\u884c\u6570\u636e", (Object)csvData.size());
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5de5\u5177\u3011\u89e3\u6790 CSV \u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        return csvData;
    }

    private static String[] parseCsvLine(String line) {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder currentField = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ',' && !inQuotes) {
                fields.add(currentField.toString().trim());
                currentField.setLength(0);
                continue;
            }
            currentField.append(c);
        }
        fields.add(currentField.toString().trim());
        return fields.toArray(new String[0]);
    }

    public static class ReportStatus {
        private String status;
        private String downloadUrl;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        public boolean isSuccess() {
            return "Success".equalsIgnoreCase(this.status);
        }

        public boolean isPending() {
            return "Pending".equalsIgnoreCase(this.status) || "InProgress".equalsIgnoreCase(this.status);
        }

        public boolean isError() {
            return "Error".equalsIgnoreCase(this.status) || "Failed".equalsIgnoreCase(this.status);
        }
    }
}

