/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.tydic.nbchat.train.api.bo.eums.RpCourseItemType;
import com.tydic.nbchat.train.api.bo.report.QueryReportRequest;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseCountItemReqBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseCountItemRspBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseDataAnalysisReqBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseDataAnalysisRspBO;
import com.tydic.nbchat.train.api.bo.report.dialogue.TrainRpDialogueCountItemRspBO;
import com.tydic.nbchat.train.api.bo.report.exam.TrainRpExamStudentsQueryReqBO;
import com.tydic.nbchat.train.api.bo.report.item.StstAnalysisItemValue;
import com.tydic.nbchat.train.api.bo.report.item.StstCountItemValue;
import com.tydic.nbchat.train.api.bo.report.students.TrainRpStudentsQueryReqBO;
import com.tydic.nbchat.train.api.bo.report.students.TrainRpstudentsCountItemRspBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseCountApi;
import com.tydic.nbchat.train.mapper.NbchatTrainRpDayItemMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpDayItem;
import com.tydic.nbchat.train.mapper.po.QoqPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbcahtTrainRpCourseCountServiceImpl
implements NbcahtTrainRpCourseCountApi {
    private static final Logger log = LoggerFactory.getLogger(NbcahtTrainRpCourseCountServiceImpl.class);
    @Resource
    NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper;

    public Rsp<TrainRpCourseCountItemRspBO> countCourseStudyItem(TrainRpCourseCountItemReqBO itemReqBO) {
        log.info("\u7edf\u8ba1\u73af\u6bd4\u6570\u636e\uff1a{}", (Object)itemReqBO);
        TrainRpCourseCountItemRspBO rspBO = new TrainRpCourseCountItemRspBO();
        StstCountItemValue studyCount = this.countQoq(RpCourseItemType.course_pn_count.getCode(), itemReqBO.getTenantCode());
        StstCountItemValue studyEndCount = this.countQoq(RpCourseItemType.course_pn_end_count.getCode(), itemReqBO.getTenantCode());
        rspBO.setStudyCount(studyCount);
        rspBO.setStudyEndCount(studyEndCount);
        log.info("\u7edf\u8ba1\u73af\u6bd4\u6570\u636e-\u7ed3\u675f\uff1a{}", (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp getEvaluationCount(TrainRpExamStudentsQueryReqBO request) {
        log.info("\u83b7\u53d6\u6d4b\u8bc4\u4eba\u6b21/\u83b7\u53d6\u6d4b\u8bc4\u4eba\u6570-\u7edf\u8ba1\u73af\u6bd4\u6570\u636e\uff1a{}", (Object)request);
        TrainRpDialogueCountItemRspBO rspBO = new TrainRpDialogueCountItemRspBO();
        StstCountItemValue ptCount = this.countQoq(RpCourseItemType.exam_pt_count.getCode(), request.getTenantCode());
        StstCountItemValue pnCount = this.countQoq(RpCourseItemType.exam_pn_count.getCode(), request.getTenantCode());
        StstCountItemValue avgScoreCount = this.countQoq(RpCourseItemType.exam_avg_score_count.getCode(), request.getTenantCode());
        rspBO.setPtCount(ptCount);
        rspBO.setPnCount(pnCount);
        rspBO.setAvgScoreCount(avgScoreCount);
        log.info("\u83b7\u53d6\u6d4b\u8bc4\u4eba\u6b21/\u83b7\u53d6\u6d4b\u8bc4\u4eba\u6570-\u7edf\u8ba1\u73af\u6bd4\u6570\u636e-\u7ed3\u675f\uff1a{}", (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp getNewStudentsCount(TrainRpStudentsQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u65b0\u589e\u5b66\u5458\u6570/\u67e5\u8be2\u5b66\u5458\u603b\u6570-\u7edf\u8ba1\u73af\u6bd4\u6570\u636e\uff1a{}", (Object)reqBO);
        TrainRpstudentsCountItemRspBO rspBO = new TrainRpstudentsCountItemRspBO();
        StstCountItemValue userNewCount = this.countQoq(RpCourseItemType.user_new_count.getCode(), reqBO.getTenantCode());
        StstCountItemValue userTotalCount = this.countQoq(RpCourseItemType.user_total_count.getCode(), reqBO.getTenantCode());
        rspBO.setUserNewCount(userNewCount);
        rspBO.setUserTotalCount(userTotalCount);
        log.info("\u67e5\u8be2\u65b0\u589e\u5b66\u5458\u6570/\u67e5\u8be2\u5b66\u5458\u603b\u6570-\u7edf\u8ba1\u73af\u6bd4\u6570\u636e-\u7ed3\u675f\uff1a{}", (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList<TrainRpCourseDataAnalysisRspBO> getCourseItemAnalysisDataList(TrainRpCourseDataAnalysisReqBO reqBO) {
        log.info("\u7edf\u8ba1\u8bfe\u7a0b\u5b66\u4e60\u8d8b\u52bf\uff1a{}", (Object)reqBO);
        if (reqBO.getStartDate() == null) {
            reqBO.setStartDate(DateTimeUtil.DateAddDayOfYear((int)-30));
        }
        if (reqBO.getEndDate() == null) {
            reqBO.setEndDate(new Date());
        }
        ArrayList<TrainRpCourseDataAnalysisRspBO> res = new ArrayList<TrainRpCourseDataAnalysisRspBO>();
        for (RpCourseItemType value : RpCourseItemType.courseItems()) {
            TrainRpCourseDataAnalysisRspBO bo = this.calGraph(reqBO, value);
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp<TrainRpDialogueCountItemRspBO> countDialogueItem(TrainRpCourseCountItemReqBO request) {
        log.info("\u7edf\u8ba1\u573a\u666f\u5b9e\u8df5\u73af\u6bd4\uff1a{}", (Object)request);
        TrainRpDialogueCountItemRspBO rspBO = new TrainRpDialogueCountItemRspBO();
        StstCountItemValue ptCount = this.countQoq(RpCourseItemType.dialogue_pt_count.getCode(), request.getTenantCode());
        StstCountItemValue pnCount = this.countQoq(RpCourseItemType.dialogue_pn_count.getCode(), request.getTenantCode());
        StstCountItemValue avgScoreCount = this.countQoq(RpCourseItemType.dialogue_avg_score_count.getCode(), request.getTenantCode());
        rspBO.setPtCount(ptCount);
        rspBO.setPnCount(pnCount);
        rspBO.setAvgScoreCount(avgScoreCount);
        log.info("\u7edf\u8ba1\u73af\u6bd4\u6570\u636e-\u7ed3\u675f\uff1a{}", (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public TrainRpCourseDataAnalysisRspBO calGraph(QueryReportRequest request, RpCourseItemType itemType) {
        TrainRpCourseDataAnalysisReqBO reqBO = new TrainRpCourseDataAnalysisReqBO();
        BeanUtils.copyProperties((Object)request, (Object)reqBO);
        return this.calGraph(reqBO, itemType);
    }

    public TrainRpCourseDataAnalysisRspBO calGraph(TrainRpCourseDataAnalysisReqBO reqBO, RpCourseItemType itemType) {
        NbchatTrainRpDayItem rec = new NbchatTrainRpDayItem();
        BeanUtils.copyProperties((Object)reqBO, (Object)rec);
        rec.setItemCode(itemType.getCode());
        List pns = this.nbchatTrainRpDayItemMapper.countGraph(rec);
        TrainRpCourseDataAnalysisRspBO pnBO = new TrainRpCourseDataAnalysisRspBO();
        pnBO.setItemName(itemType.getName());
        pnBO.setItemCode(itemType.getCode());
        ArrayList<StstAnalysisItemValue> itemValues = new ArrayList<StstAnalysisItemValue>();
        for (NbchatTrainRpDayItem pn : pns) {
            StstAnalysisItemValue value = new StstAnalysisItemValue();
            value.setCountDay(DateTimeUtil.getTimeShortString((Date)pn.getCountDay(), (String)"yyyyMMdd"));
            value.setItemValue(pn.getValue());
            itemValues.add(value);
        }
        pnBO.setItemValues(itemValues);
        return pnBO;
    }

    public StstCountItemValue countQoq(String itemCode, String tenantCode) {
        StstCountItemValue countRec = new StstCountItemValue();
        NbchatTrainRpDayItem param = new NbchatTrainRpDayItem();
        param.setCountDay(DateTimeUtil.DateAddDayOfYear((int)-1));
        param.setItemCode(itemCode);
        param.setTenantCode(tenantCode);
        int coursePnCount = this.nbchatTrainRpDayItemMapper.countByCode(param);
        countRec.setTotal(Integer.valueOf(coursePnCount));
        int dayQoq = this.calQoq(param, -2);
        countRec.setDayQoq(Integer.valueOf(dayQoq));
        int weekQoq = this.calQoq(param, -8);
        countRec.setWeekQoq(Integer.valueOf(weekQoq));
        int monQoq = this.calQoq(param, -31);
        countRec.setMonthQoq(Integer.valueOf(monQoq));
        return countRec;
    }

    public int calQoq(NbchatTrainRpDayItem param, Integer targetDay) {
        param.setCountDay2(DateTimeUtil.DateAddDayOfYear((int)targetDay));
        List qoqRecDay = new ArrayList();
        qoqRecDay = this.nbchatTrainRpDayItemMapper.countQoqRec(param);
        if (CollectionUtils.isEmpty(qoqRecDay)) {
            return 0;
        }
        if (qoqRecDay.size() == 1) {
            String countDay = ((QoqPO)qoqRecDay.get(0)).getCountDay();
            String day1 = DateTimeUtil.getTimeShortString((Date)param.getCountDay(), (String)"yyyy-MM-dd");
            String day2 = DateTimeUtil.getTimeShortString((Date)param.getCountDay2(), (String)"yyyy-MM-dd");
            if (Objects.equals(countDay, day2)) {
                return 0;
            }
            return ((QoqPO)qoqRecDay.get(0)).getValue() * 100;
        }
        QoqPO qoqPO1 = (QoqPO)qoqRecDay.get(0);
        QoqPO qoqPO2 = (QoqPO)qoqRecDay.get(1);
        if (qoqPO1.getValue() == 0) {
            return qoqPO2.getValue() * 100;
        }
        return 100 * (qoqPO2.getValue() - qoqPO1.getValue()) / qoqPO1.getValue();
    }
}

