/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseRankingQueryReqBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseRankingQueryRspBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseTop5QueryReqBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseTop5QueryRspBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseTopApi;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRpStudyPnMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpStudyPn;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpStudyPnSelectCondition;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbcahtTrainRpCourseTopServiceImpl
implements NbcahtTrainRpCourseTopApi {
    private static final Logger log = LoggerFactory.getLogger(NbcahtTrainRpCourseTopServiceImpl.class);
    @Resource
    NbchatTrainRpStudyPnMapper nbchatTrainRpStudyPnMapper;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NbchatUserApi nbchatUserApi;

    public RspList<TrainRpCourseTop5QueryRspBO> getCourseHotTopList(TrainRpCourseTop5QueryReqBO top5QueryReqBO) {
        Date date = DateTimeUtil.DateAddDayOfYear((int)-1);
        String timeShortString = DateTimeUtil.getTimeShortString((Date)date, (String)"yyyy-MM-dd");
        List top5 = this.nbchatTrainRpStudyPnMapper.queryTop5(timeShortString, top5QueryReqBO.getTenantCode());
        ArrayList<TrainRpCourseTop5QueryRspBO> res = new ArrayList<TrainRpCourseTop5QueryRspBO>();
        int i = 1;
        for (NbchatTrainRpStudyPn pn : top5) {
            NbchatTrainCourse nbchatTrainCourse = this.nbchatTrainCourseMapper.selectByPrimaryKey(pn.getCourseId());
            if (ObjectUtils.isEmpty((Object)nbchatTrainCourse)) continue;
            TrainRpCourseTop5QueryRspBO rspBO = new TrainRpCourseTop5QueryRspBO();
            rspBO.setTopIndex(Integer.valueOf(i++));
            rspBO.setCourseId(pn.getCourseId());
            rspBO.setStudyCount(pn.getValue());
            rspBO.setCourseName(nbchatTrainCourse.getCourseName());
            res.add(rspBO);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public RspList<TrainRpCourseRankingQueryRspBO> getCourseRankingList(TrainRpCourseRankingQueryReqBO queryReqBO) {
        ArrayList result = new ArrayList();
        String tenantCode = this.GetTenantByUserID(queryReqBO.getUserId());
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        NbchatTrainRpStudyPnSelectCondition nbchatTrainRpStudyPnSelectCondition = new NbchatTrainRpStudyPnSelectCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)nbchatTrainRpStudyPnSelectCondition);
        nbchatTrainRpStudyPnSelectCondition.setTenantCode(tenantCode);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        List nbchatTrainRpStudyPnList = this.nbchatTrainRpStudyPnMapper.getCourseRankingByTenantCode(nbchatTrainRpStudyPnSelectCondition);
        log.info("\u8bfe\u7a0b\u6392\u884c\u7edf\u8ba1\u67e5\u8be2-{}", (Object)nbchatTrainRpStudyPnList);
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            log.error("\u8bfe\u7a0b\u6392\u884c\u7edf\u8ba1\u67e5\u8be2-\u67e5\u8be2\u8bfe\u7a0b\u6392\u884c\u4fe1\u606f\u5931\u8d25-\u672a\u5f55\u5165\u8bfe\u7a0b");
            return BaseRspUtils.createSuccessRspList(result);
        }
        NiccCommonUtil.copyList((List)page.getResult(), result, TrainRpCourseRankingQueryRspBO.class);
        result.forEach(userQueryRspBO -> {
            NbchatTrainCourse nbchatTrainCourse = this.nbchatTrainCourseMapper.selectByPrimaryKey(userQueryRspBO.getCourseId());
            if (!ObjectUtils.isEmpty((Object)nbchatTrainCourse)) {
                userQueryRspBO.setStudyEndRate(Double.valueOf(userQueryRspBO.getStudyEndRate() * 100.0));
                userQueryRspBO.setCourseName(nbchatTrainCourse.getCourseName());
            } else {
                log.error("\u8bfe\u7a0b\u6392\u884c\u7edf\u8ba1\u67e5\u8be2-\u8bfe\u7a0b\uff1a{}\u4e0d\u5b58\u5728", (Object)userQueryRspBO.getCourseId());
            }
        });
        return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
    }

    private String GetTenantByUserID(String userId) {
        Rsp rsp = this.nbchatUserApi.getUserInfo(userId);
        if (rsp.isSuccess()) {
            NbchatUserInfo nbchatUserInfo = (NbchatUserInfo)rsp.getData();
            return nbchatUserInfo.getTenantCode();
        }
        log.error("\u8bfe\u7a0b\u6392\u884c\u7edf\u8ba1\u67e5\u8be2-\u67e5\u8be2\u7528\u6237\u6240\u5c5e\u79df\u6237\uff1a{}|{}", (Object)userId, (Object)rsp.getRspDesc());
        return null;
    }
}

