/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.tydic.nbchat.train.api.bo.eums.RpCourseItemType;
import com.tydic.nbchat.train.api.bo.report.CountRpDayItemRequest;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpDayItemApi;
import com.tydic.nbchat.train.mapper.NbchatTrainRpDayItemMapper;
import com.tydic.nbchat.train.mapper.OpRpStstDayItemMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpDayItemCountParam;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NbcahtTrainRpDayItemServiceImpl
implements NbcahtTrainRpDayItemApi {
    private static final Logger log = LoggerFactory.getLogger(NbcahtTrainRpDayItemServiceImpl.class);
    private final NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper;
    private final OpRpStstDayItemMapper opRpStstDayItemMapper;

    public NbcahtTrainRpDayItemServiceImpl(NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper, OpRpStstDayItemMapper opRpStstDayItemMapper) {
        this.nbchatTrainRpDayItemMapper = nbchatTrainRpDayItemMapper;
        this.opRpStstDayItemMapper = opRpStstDayItemMapper;
    }

    public Rsp countRpDayItem(CountRpDayItemRequest request) {
        log.info("\u6307\u6807\u65e5\u62a5\u8868\u7edf\u8ba1:{}", (Object)request);
        if (ObjectUtils.allNull((Object[])new Object[]{request.getStartTime(), request.getEndTime()})) {
            request.setStartTime(DateTimeUtil.getStartTimeOfDay());
            request.setEndTime(DateTimeUtil.getEndTimeOfDay());
        }
        NbchatTrainRpDayItemCountParam countParam = new NbchatTrainRpDayItemCountParam();
        countParam.setItemCode(request.getItemCode());
        countParam.setStartTime(request.getStartTime());
        countParam.setEndTime(request.getEndTime());
        int del = this.nbchatTrainRpDayItemMapper.deleteItem(countParam);
        int del2 = this.opRpStstDayItemMapper.deleteItem(countParam);
        log.info("\u6307\u6807\u65e5\u62a5\u8868\u7edf\u8ba1-\u5220\u9664\u6570\u636e:{}|{}|{}", new Object[]{countParam, del, del2});
        int count = 0;
        if (RpCourseItemType.course_pn_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countCoursePnItems(countParam);
        } else if (RpCourseItemType.course_pn_end_count.getCode().equals(request.getItemCode())) {
            countParam.setIsFinish(EntityValidType.NORMAL.getCode());
            count = this.nbchatTrainRpDayItemMapper.countCoursePnItems(countParam);
        } else if (RpCourseItemType.course_pt_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countCoursePtItems(countParam);
        } else if (RpCourseItemType.dialogue_pt_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countDialoguePtItems(countParam);
        } else if (RpCourseItemType.dialogue_pn_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countDialoguePnItems(countParam);
        } else if (RpCourseItemType.dialogue_avg_score_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countDialogueAvgScoreItems(countParam);
        } else if (RpCourseItemType.dialogue_level_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countDialogueLevelItems(countParam);
        } else if (RpCourseItemType.dialogue_rank_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countDialogueRankList(countParam);
        } else if (RpCourseItemType.exam_pt_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countExamPtItems(countParam);
        } else if (RpCourseItemType.exam_pn_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countExamPnItems(countParam);
        } else if (RpCourseItemType.exam_avg_score_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countExamAvgScoreItems(countParam);
        } else if (RpCourseItemType.user_new_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countUserNewItems(countParam);
        } else if (RpCourseItemType.exam_comprehensive_score_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countExamComprehensiveScoreItems(countParam);
        } else if (RpCourseItemType.user_total_count.getCode().equals(request.getItemCode())) {
            count = this.nbchatTrainRpDayItemMapper.countUserTotalItems(countParam);
        } else if (RpCourseItemType.new_registrations.getCode().equals(request.getItemCode())) {
            count = this.opRpStstDayItemMapper.countUserNewItems(countParam);
            this.opRpStstDayItemMapper.countEnterpriseUserNewItems(countParam);
        } else if (RpCourseItemType.question_creators.getCode().equals(request.getItemCode())) {
            count = this.opRpStstDayItemMapper.countQuestionCreatorsNewItems(countParam);
        } else if (RpCourseItemType.ppt_creators.getCode().equals(request.getItemCode())) {
            count = this.opRpStstDayItemMapper.countQuestionCreatorsNewItems(countParam);
        } else if (RpCourseItemType.video_creators.getCode().equals(request.getItemCode())) {
            count = this.opRpStstDayItemMapper.countVideoCreatorsNewItems(countParam);
            int countCommonTenant = this.opRpStstDayItemMapper.countCommonTenantVideoCreatorsNewItems(countParam);
            count += countCommonTenant;
        } else if (RpCourseItemType.video_success.getCode().equals(request.getItemCode())) {
            count = this.opRpStstDayItemMapper.countVideoSuccessNewItems(countParam);
            int countCommonTenant = this.opRpStstDayItemMapper.countCommonTenantVideoSuccessNewItems(countParam);
            count += countCommonTenant;
        } else {
            return BaseRspUtils.createErrorRsp((String)("\u6307\u6807\u6682\u4e0d\u652f\u6301:" + request.getItemCode()));
        }
        log.info("\u6307\u6807\u65e5\u62a5\u8868\u7edf\u8ba1-\u5b8c\u6210:{}|{}", (Object)countParam, (Object)count);
        return BaseRspUtils.createSuccessRsp((Object)count, (String)("\u6307\u6807\u7edf\u8ba1\u5b8c\u6210:" + request.getItemCode()));
    }
}

