/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.tydic.nbchat.train.api.NbchatTrainStudentsArchiveReportApi;
import com.tydic.nbchat.train.api.bo.course.NbchatTrainStudentCourseBO;
import com.tydic.nbchat.train.api.bo.course.NbchatTrainStudentTrainingBO;
import com.tydic.nbchat.train.api.bo.course.TranStudentArchiveQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranStudentArchiveRspBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.api.trainTask.TrainTaskApi;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRpStudentsArchiveMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainStudentArchivePO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainRpStudentsArchiveServiceImpl
implements NbchatTrainStudentsArchiveReportApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainRpStudentsArchiveServiceImpl.class);
    @Resource
    private NbchatTrainRpStudentsArchiveMapper nbchatTrainRpStudentsArchiveMapper;
    @Resource
    private NameMapper nameMapper;
    @Resource
    private TrainTaskApi trainTaskApi;

    public Rsp getStudentArchive(TranStudentArchiveQueryReqBO reqBO) {
        log.info("\u5b66\u5458\u6863\u6848\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqBO);
        String deptName = this.nameMapper.queryOrganizeName(reqBO.getDeptId());
        NbchatTrainStudentArchivePO nbchatTrainStudentArchivePO = this.nbchatTrainRpStudentsArchiveMapper.queryArchive(reqBO.getId(), null);
        String formattedDate = DateTimeUtil.getTimeShortString((Date)nbchatTrainStudentArchivePO.getCreateTime(), (String)"yyyy-MM-dd");
        nbchatTrainStudentArchivePO.setEntryTime(formattedDate);
        String name = this.splitDeptName(deptName);
        nbchatTrainStudentArchivePO.setProjectName(name);
        TranStudentArchiveRspBO rspBO = new TranStudentArchiveRspBO();
        BeanUtils.copyProperties((Object)nbchatTrainStudentArchivePO, (Object)rspBO);
        NbchatTrainTaskBO taskBO = new NbchatTrainTaskBO();
        taskBO.setUserId(rspBO.getUserId());
        taskBO.setDeptId(reqBO.getDeptId());
        taskBO.setTenantCode(reqBO.getTenantCode());
        RspList rspList = this.trainTaskApi.queryTask(taskBO);
        List rows = rspList.getRows();
        rspBO.setTrainingList(new ArrayList());
        ArrayList list = new ArrayList();
        rows.forEach(s -> {
            if (s.getFinishStatus().equals("1") && s.getInfoList() != null) {
                NbchatTrainStudentTrainingBO bo = new NbchatTrainStudentTrainingBO();
                bo.setTaskId(s.getTaskId());
                bo.setTaskName(s.getTaskName());
                s.getInfoList().forEach(item -> {
                    NbchatTrainStudentCourseBO courseBO = new NbchatTrainStudentCourseBO();
                    courseBO.setTaskId(s.getTaskId());
                    courseBO.setCourseId(item.getCourseId());
                    courseBO.setCourseName(item.getCourseName());
                    courseBO.setScore(item.getTestScore());
                    Double videoDuration = this.nbchatTrainRpStudentsArchiveMapper.queryVideoDuration(item.getCourseId(), rspBO.getTenantCode());
                    if (videoDuration != null) {
                        Double hours = this.calculateVideoDuration(videoDuration);
                        courseBO.setVideoDuration(hours);
                    }
                    if (bo.getCourseList() == null) {
                        bo.setCourseList(new ArrayList());
                    }
                    bo.getCourseList().add(courseBO);
                });
                list.add(bo);
            }
        });
        list.forEach(item -> {
            if (item.getCourseList() != null && !item.getCourseList().isEmpty()) {
                rspBO.getTrainingList().add(item);
            }
        });
        return BaseRspUtils.createSuccessRsp((Object)rspBO, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public RspList getStudentArchiveList(TranStudentArchiveQueryReqBO reqBO) {
        log.info("\u6279\u91cf\u67e5\u8be2\u5b66\u5458\u6863\u6848\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqBO);
        ArrayList list = new ArrayList();
        if (reqBO.getIds() != null) {
            reqBO.getIds().forEach(item -> {
                reqBO.setId(item);
                Rsp studentArchive = this.getStudentArchive(reqBO);
                list.add((TranStudentArchiveRspBO)studentArchive.getData());
            });
            return BaseRspUtils.createSuccessRspList(list, (long)list.size());
        }
        List nbchatTrainStudentArchivePOS = this.nbchatTrainRpStudentsArchiveMapper.queryIds(reqBO.getDeptId(), reqBO.getTenantCode(), reqBO.getSupportSubDept());
        ArrayList reqBOList = new ArrayList();
        NiccCommonUtil.copyList((List)nbchatTrainStudentArchivePOS, reqBOList, TranStudentArchiveQueryReqBO.class);
        reqBOList.forEach(item -> {
            Rsp studentArchive = this.getStudentArchive((TranStudentArchiveQueryReqBO)item);
            list.add((TranStudentArchiveRspBO)studentArchive.getData());
        });
        return BaseRspUtils.createSuccessRspList(list, (long)list.size());
    }

    public String splitDeptName(String deptName) {
        if (deptName != null && !deptName.isEmpty()) {
            String[] split = deptName.split("-");
            if (split.length < 3) {
                deptName = split[split.length - 1];
            } else {
                CharSequence[] strings = Arrays.copyOfRange(split, 1, 3);
                deptName = String.join((CharSequence)"-", strings);
            }
        }
        return deptName;
    }

    public Double calculateVideoDuration(Double videoDuration) {
        double video = videoDuration / 60.0;
        if (video < 20.0) {
            return 0.2;
        }
        if (video < 45.0) {
            return 0.5;
        }
        double fullHours = Math.floor(video / 45.0);
        double remainingMinutes = video % 45.0;
        return fullHours + (remainingMinutes < 20.0 ? 0.2 : 0.5);
    }
}

