/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.tydic.nbchat.train.api.NbchatTrainStudentsReportApi;
import com.tydic.nbchat.train.api.bo.eums.RpCourseItemType;
import com.tydic.nbchat.train.api.bo.report.QueryReportRequest;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseDataAnalysisRspBO;
import com.tydic.nbchat.train.api.bo.report.students.TrainRpStudentsQueryReqBO;
import com.tydic.nbchat.train.api.bo.report.students.TrainRpStudentsQueryRspBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseCountApi;
import com.tydic.nbchat.train.mapper.NbchatTrainRpDayItemMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpDayItemCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainRpStudentsServiceImpl
implements NbchatTrainStudentsReportApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainRpStudentsServiceImpl.class);
    private final NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper;
    private final NbcahtTrainRpCourseCountApi nbcahtTrainRpCourseCountApi;

    public Rsp getNewStudentsCount(TrainRpStudentsQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u65b0\u589e\u5b66\u5458\u6570/\u67e5\u8be2\u5b66\u5458\u603b\u6570-\u7edf\u8ba1\u73af\u6bd4\u6570\u636e\uff1a{}", (Object)reqBO);
        Rsp rsp = this.nbcahtTrainRpCourseCountApi.getNewStudentsCount(reqBO);
        log.info("\u67e5\u8be2\u65b0\u589e\u5b66\u5458\u6570/\u67e5\u8be2\u5b66\u5458\u603b\u6570-\u7edf\u8ba1\u73af\u6bd4\u6570\u636e-\u7ed3\u675f\uff1a{}", (Object)rsp);
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public RspList getDataTrend(QueryReportRequest request) {
        log.info("\u7edf\u8ba1\u8bfe\u7a0b\u5b66\u4e60\u8d8b\u52bf\uff1a{}", (Object)request);
        if (request.getStartDate() == null) {
            request.setStartDate(DateTimeUtil.DateAddDayOfYear((int)-30));
        }
        if (request.getEndDate() == null) {
            request.setEndDate(new Date());
        }
        ArrayList<TrainRpCourseDataAnalysisRspBO> res = new ArrayList<TrainRpCourseDataAnalysisRspBO>();
        for (RpCourseItemType value : RpCourseItemType.studentsItems()) {
            TrainRpCourseDataAnalysisRspBO bo = this.nbcahtTrainRpCourseCountApi.calGraph(request, value);
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp analyzeData(TrainRpStudentsQueryReqBO reqBO) {
        log.info("\u6570\u636e\u5206\u6790\uff1a{}", (Object)reqBO);
        TrainRpStudentsQueryRspBO trainRpStudentsQueryRspBO = new TrainRpStudentsQueryRspBO();
        NbchatTrainRpDayItemCondition nbchatTrainRpDayItemCondition = new NbchatTrainRpDayItemCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)nbchatTrainRpDayItemCondition);
        NbchatTrainRpDayItemCondition analyzeData = this.nbchatTrainRpDayItemMapper.analyzeData(nbchatTrainRpDayItemCondition);
        if (ObjectUtils.isEmpty((Object)analyzeData)) {
            log.warn("\u6570\u636e\u5206\u6790\u8fd4\u56de\u4e3a\u7a7a");
            return BaseRspUtils.createSuccessRsp((Object)"\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e");
        }
        BeanUtils.copyProperties((Object)analyzeData, (Object)trainRpStudentsQueryRspBO, TrainRpStudentsQueryRspBO.class);
        log.info("\u6570\u636e\u5206\u6790-\u7ed3\u675f\uff1a{}", (Object)trainRpStudentsQueryRspBO);
        return BaseRspUtils.createSuccessRsp((Object)trainRpStudentsQueryRspBO, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public NbchatTrainRpStudentsServiceImpl(NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper, NbcahtTrainRpCourseCountApi nbcahtTrainRpCourseCountApi) {
        this.nbchatTrainRpDayItemMapper = nbchatTrainRpDayItemMapper;
        this.nbcahtTrainRpCourseCountApi = nbcahtTrainRpCourseCountApi;
    }
}

