/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysUpvoteRecordApi;
import com.tydic.nbchat.admin.api.bo.SysUpvoteRecordBO;
import com.tydic.nbchat.admin.api.rp.OpQueryApi;
import com.tydic.nbchat.admin.api.rp.OpQueryVideoBO;
import com.tydic.nbchat.train.api.NbchatTrainRpVideoService;
import com.tydic.nbchat.train.api.bo.constants.RedisConstants;
import com.tydic.nbchat.train.api.bo.eums.TaskStateType;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoCountQueryRspBO;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoQueryReqBO;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoQueryRspBO;
import com.tydic.nbchat.train.core.busi.TdhQueueCountBusiService;
import com.tydic.nbchat.train.core.config.UserConcurrencyConfig;
import com.tydic.nbchat.train.mapper.TdhCreationTaskMapper;
import com.tydic.nbchat.train.mapper.po.NbchatVideoCondition;
import com.tydic.nbchat.train.mapper.po.VipItem;
import com.tydic.nbchat.user.api.bo.eums.UserTypeEnum;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainRpVideoServiceImpl
implements NbchatTrainRpVideoService {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainRpVideoServiceImpl.class);
    @Resource
    private TdhCreationTaskMapper tdhCreationTaskMapper;
    @Resource
    private RedisHelper redisHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private OpQueryApi opQueryApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private SysUpvoteRecordApi sysUpvoteRecordApi;
    public static final String process_format = "%.0f%%";
    private final TdhQueueCountBusiService tdhQueueCountBusiService;
    private final UserConcurrencyConfig userConcurrencyConfig;

    public NbchatTrainRpVideoServiceImpl(TdhQueueCountBusiService tdhQueueCountBusiService, UserConcurrencyConfig userConcurrencyConfig) {
        this.tdhQueueCountBusiService = tdhQueueCountBusiService;
        this.userConcurrencyConfig = userConcurrencyConfig;
    }

    public Rsp getVideoCount(NbchatVideoQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u89c6\u9891\u5236\u4f5c\u6570\u91cf, \u8bf7\u6c42\u7528\u6237ID: {}", (Object)reqBO.get_userId());
        NbchatVideoCountQueryRspBO rspBO = new NbchatVideoCountQueryRspBO();
        HashMap<String, Integer> statsMap = new HashMap<String, Integer>();
        try {
            if (this.redisHelper.hasKey("nbchat-train:tdh_video_count")) {
                log.debug("\u4eceRedis\u7f13\u5b58\u83b7\u53d6\u89c6\u9891\u7edf\u8ba1\u6570\u636e");
                Map videoMap = (Map)this.redisHelper.get("nbchat-train:tdh_video_count");
                for (Map.Entry entry : videoMap.entrySet()) {
                    statsMap.put((String)entry.getKey(), (Integer)entry.getValue());
                }
            } else {
                log.debug("Redis\u4e2d\u65e0\u7f13\u5b58\u6570\u636e\uff0c\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u89c6\u9891\u7edf\u8ba1\u6570\u636e");
                statsMap.put("lastWeek", this.tdhCreationTaskMapper.getVideoCount(6, null));
                statsMap.put("lastMonth", this.tdhCreationTaskMapper.getVideoCount(29, null));
                statsMap.put("enterpriseLastWeek", this.tdhCreationTaskMapper.getVideoCount(6, UserTypeEnum.COMPANY_USER.getCode()));
                statsMap.put("enterpriseLastMonth", this.tdhCreationTaskMapper.getVideoCount(29, UserTypeEnum.COMPANY_USER.getCode()));
                statsMap.put("personalLastWeek", this.tdhCreationTaskMapper.getVideoCount(6, UserTypeEnum.COMMON_USER.getCode()));
                statsMap.put("personalLastMonth", this.tdhCreationTaskMapper.getVideoCount(29, UserTypeEnum.COMMON_USER.getCode()));
                LocalDateTime endOfDay = LocalDate.now().atTime(23, 59, 59);
                long seconds = Duration.between(LocalDateTime.now(), endOfDay).getSeconds();
                seconds = Math.max(seconds, 60L);
                this.redisHelper.set("nbchat-train:tdh_video_count", statsMap, seconds);
            }
            int today = this.tdhCreationTaskMapper.getVideoCount(0, null);
            int enterpriseToday = this.tdhCreationTaskMapper.getVideoCount(0, UserTypeEnum.COMPANY_USER.getCode());
            int personalToday = this.tdhCreationTaskMapper.getVideoCount(0, UserTypeEnum.COMMON_USER.getCode());
            rspBO.setToday(today);
            rspBO.setLastWeek(statsMap.getOrDefault("lastWeek", 0) + today);
            rspBO.setLastMonth(statsMap.getOrDefault("lastMonth", 0) + today);
            rspBO.setEnterpriseToday(enterpriseToday);
            rspBO.setEnterpriseLastWeek(statsMap.getOrDefault("enterpriseLastWeek", 0) + enterpriseToday);
            rspBO.setEnterpriseLastMonth(statsMap.getOrDefault("enterpriseLastMonth", 0) + enterpriseToday);
            rspBO.setPersonalToday(personalToday);
            rspBO.setPersonalLastWeek(statsMap.getOrDefault("personalLastWeek", 0) + personalToday);
            rspBO.setPersonalLastMonth(statsMap.getOrDefault("personalLastMonth", 0) + personalToday);
            log.debug("\u89c6\u9891\u7edf\u8ba1\u6570\u636e\u67e5\u8be2\u5b8c\u6210: {}", (Object)rspBO);
            return BaseRspUtils.createSuccessRsp((Object)rspBO);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c6\u9891\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createSuccessRsp((Object)new NbchatVideoCountQueryRspBO());
        }
    }

    public RspList getVideoList(NbchatVideoQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u89c6\u9891\u5217\u8868:{}", (Object)reqBO);
        ArrayList rspBOList = new ArrayList();
        NbchatVideoCondition condition = new NbchatVideoCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        Page page = null;
        if (Boolean.TRUE.equals(reqBO.getIsPaged())) {
            page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        }
        if (condition.getTaskStateList() != null && (condition.getTaskStateList().contains(TaskStateType.GENERATING.getCode()) || condition.getTaskStateList().contains(TaskStateType.IN_THE_LINE.getCode()))) {
            condition.setIsValid(EntityValidType.NORMAL.getCode());
        }
        ArrayList vipTypesPO = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getVipTypes())) {
            NiccCommonUtil.copyList((List)reqBO.getVipTypes(), vipTypesPO, VipItem.class);
        }
        condition.setVipTypes(vipTypesPO);
        List videoList = this.tdhCreationTaskMapper.getVideoList(condition);
        if (CollectionUtils.isEmpty((Collection)videoList)) {
            return BaseRspUtils.createSuccessRspList(rspBOList, (long)0L);
        }
        NiccCommonUtil.copyList((List)videoList, rspBOList, NbchatVideoQueryRspBO.class);
        Map queueMap = this.tdhQueueCountBusiService.getTaskQueueMap();
        rspBOList.forEach(bo -> {
            this.calculateDuration((NbchatVideoQueryRspBO)bo);
            this.calculateProcessRate((NbchatVideoQueryRspBO)bo);
            this.calculateQueueNum((NbchatVideoQueryRspBO)bo, queueMap);
            Rsp rsp = this.opQueryApi.opQueryVideo(bo.getTaskId());
            if (rsp.isSuccess()) {
                bo.setShareNum(((OpQueryVideoBO)rsp.getData()).getShareNum());
                bo.setDownNum(((OpQueryVideoBO)rsp.getData()).getDownNum());
                bo.setPlayNum(((OpQueryVideoBO)rsp.getData()).getPlayNum());
                bo.setPlayNotVideoUserNum(((OpQueryVideoBO)rsp.getData()).getPlayNotVideoUserNum());
                bo.setPlayBySameVideoShareUserNum(((OpQueryVideoBO)rsp.getData()).getPlayBySameVideoShareUserNum());
                bo.setViewNum(((OpQueryVideoBO)rsp.getData()).getViewNum());
                bo.setViewNotVideoUserNum(((OpQueryVideoBO)rsp.getData()).getViewNotVideoUserNum());
                bo.setViewBySameVideoShareUserNum(((OpQueryVideoBO)rsp.getData()).getViewBySameVideoShareUserNum());
            }
            this.fetchVideoRatingInfo((NbchatVideoQueryRspBO)bo);
        });
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)(page != null ? page.getTotal() : (long)videoList.size()));
    }

    private void calculateDuration(NbchatVideoQueryRspBO bo) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{bo.getStartTime(), bo.getEndTime()})) {
            bo.setDuration(Long.valueOf((bo.getEndTime().getTime() - bo.getStartTime().getTime()) / 1000L));
        } else if (ObjectUtils.isEmpty((Object)bo.getEndTime())) {
            bo.setDuration(Long.valueOf((new Date().getTime() - bo.getStartTime().getTime()) / 1000L));
        }
    }

    private void calculateQueueNum(NbchatVideoQueryRspBO bo, Map<String, Integer> queueMap) {
        if (queueMap.containsKey(bo.getTaskId())) {
            Integer num = queueMap.get(bo.getTaskId());
            bo.setQueueNum(num);
        }
    }

    private void calculateProcessRate(NbchatVideoQueryRspBO bo) {
        if (TaskStateType.MISSION_COMPLETED.getCode().equals(bo.getTaskState())) {
            bo.setProcessRate("100%");
        } else if (TaskStateType.GENERATING.getCode().equals(bo.getTaskState())) {
            if (bo.getPartCountTotal() > 1) {
                float partRate = 0.9f * (float)bo.getPartCountDone().intValue() / (float)bo.getPartCountTotal().intValue() * 100.0f;
                bo.setProcessRate(String.format(process_format, Float.valueOf(partRate)));
                String redisKey = RedisConstants.processKey((String)bo.getTaskId());
                if (this.redisHelper.hasKey(redisKey)) {
                    Float processRate = Float.valueOf(((Double)this.redisHelper.get(redisKey)).floatValue());
                    float concatRate = 0.1f * processRate.floatValue();
                    bo.setProcessRate(String.format(process_format, Float.valueOf(partRate + concatRate)));
                }
                if (bo.getPartCountDone() == 0) {
                    bo.setProcessRate("1%");
                }
                if ("100%".equals(bo.getProcessRate())) {
                    bo.setProcessRate("99%");
                }
            } else {
                Integer esMakeDur = bo.getEstimatedMakeDuration();
                if (esMakeDur != null) {
                    long makeDurSec = (new Date().getTime() - bo.getStartTime().getTime()) / 1000L;
                    if (makeDurSec > (long)esMakeDur.intValue()) {
                        bo.setProcessRate("98%");
                    } else {
                        float partRate = 1.0f * (float)makeDurSec / (float)esMakeDur.intValue() * 100.0f;
                        bo.setProcessRate(String.format(process_format, Float.valueOf(partRate)));
                    }
                }
            }
        } else {
            bo.setProcessRate("0%");
        }
    }

    private void fetchVideoRatingInfo(NbchatVideoQueryRspBO bo) {
        try {
            SysUpvoteRecordBO recordBO = new SysUpvoteRecordBO();
            recordBO.setBusiId(bo.getTaskId());
            recordBO.setProductModule("1");
            RspList ratingRsp = this.sysUpvoteRecordApi.getUpvoteRecordByBusiId(recordBO);
            if (ratingRsp.isSuccess() && CollectionUtils.isNotEmpty((Collection)ratingRsp.getRows())) {
                SysUpvoteRecordBO ratingInfo = (SysUpvoteRecordBO)ratingRsp.getRows().get(0);
                bo.setRating(ratingInfo.getRating().toString());
                bo.setUnlikeInput(ratingInfo.getUnlikeInput());
                bo.setUnlikeReason(ratingInfo.getUnlikeReason());
                bo.setContent(ratingInfo.getContent());
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u89c6\u9891\u8bc4\u7ea7\u4fe1\u606f\u5931\u8d25, taskId: {}", (Object)bo.getTaskId(), (Object)e);
        }
    }
}

