/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nbchat.robot.api.NbchatRobotToolsApi;
import com.tydic.nbchat.robot.api.bo.tools.RobotPromptMessageRequest;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service
public class RpSearchLogService {
    private static final Logger log = LoggerFactory.getLogger(RpSearchLogService.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=120000)
    private NbchatRobotToolsApi nbchatRobotToolsApi;

    @Async(value="searchLogTaskExecutor")
    public Future<List<RpSearchLog>> findRpSearchLog(AppService appService, PromotionTypeEnum promotionType) {
        return this.findRpSearchLog(appService, null, promotionType);
    }

    @Async(value="searchLogTaskExecutor")
    public Future<List<RpSearchLog>> findRpSearchLog(AppService appService, Date dayData, PromotionTypeEnum promotionType) {
        return this.findRpSearchLog(appService, dayData, null, promotionType);
    }

    @Async(value="searchLogTaskExecutor")
    public Future<List<RpSearchLog>> findRpSearchLog(AppService appService, Date startData, Date endData, PromotionTypeEnum promotionType) {
        RspList<RpSearchLog> rspList;
        ArrayList result = new ArrayList();
        int page = 1;
        if (!(rspList = this.doFindRpSearchLog(appService, startData, endData, promotionType, page++, 0)).isSuccess() || rspList.getCount() == 0L) {
            return new AsyncResult(result);
        }
        result.addAll(rspList.getRows());
        long totalCount = rspList.getCount();
        int limit = result.size();
        int totalPage = (int)(totalCount / (long)limit + (long)(totalCount % (long)limit == 0L ? 0 : 1));
        while (page <= totalPage) {
            if (!(rspList = this.doFindRpSearchLog(appService, startData, endData, promotionType, page++, 0)).isSuccess()) continue;
            result.addAll(rspList.getRows());
        }
        return new AsyncResult(result);
    }

    @Async(value="searchLogTaskExecutor")
    public Future<Map<String, List<String>>> searchIdentifyClassify(Collection<String> terms) {
        HashMap<String, Double> modelConfig = new HashMap<String, Double>();
        modelConfig.put("temperature", 0.1);
        RobotPromptMessageRequest request = new RobotPromptMessageRequest();
        request.setRobotType("doubao_1.5pro-256k");
        request.setPresetId("keyword_clustering");
        request.setModelConfig(modelConfig);
        request.setPresetPrompts(Collections.singletonList(JSON.toJSONString(terms)));
        request.setTrim(true);
        log.info("\u8c03\u7528\u5927\u6a21\u578b\u6570\u636e-\u8bf7\u6c42:{}", (Object)JSON.toJSONString((Object)request));
        Rsp chatResult = this.nbchatRobotToolsApi.getChatResult(request);
        log.info("\u8c03\u7528\u5927\u6a21\u578b\u6570\u636e-\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)chatResult));
        if (!chatResult.isSuccess()) {
            log.error("\u67e5\u8be2\u8bc6\u522b\u5206\u7c7b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)chatResult.getRspDesc());
            return new AsyncResult(Collections.emptyMap());
        }
        String content = ((RobotToolsChatResponse)chatResult.getData()).getContent().replace("\n", "");
        if (!JSON.isValidObject((String)content)) {
            log.error("\u67e5\u8be2\u8bc6\u522b\u5206\u7c7b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5927\u6a21\u578b\u8fd4\u56de\u7684\u6570\u636e\u4e0d\u662fjson\u683c\u5f0f");
            return new AsyncResult(Collections.emptyMap());
        }
        Map result = (Map)JSON.parseObject((String)content, (TypeReference)new TypeReference<Map<String, List<String>>>(){}, (Feature[])new Feature[0]);
        return new AsyncResult((Object)result);
    }

    private RspList<RpSearchLog> doFindRpSearchLog(AppService appService, Date startData, Date endData, PromotionTypeEnum promotionType, int page, int retry) {
        if (retry > 3) {
            log.error("{}-{}-\u63a8\u5e7f\u8425\u9500\u62a5\u8868\u6570\u636e\u7b2c {} \u9875\u67e5\u8be2\u5931\u8d25", new Object[]{appService.getAppType(), promotionType.name(), page});
            return BaseRspUtils.createErrorRspList((String)"1", (String)"\u63a8\u5e7f\u6570\u636e\u67e5\u8be2\u5931\u8d25");
        }
        RspList<RpSearchLog> rspList = endData != null ? appService.findRpSearchLog(startData, endData, promotionType, page) : (startData != null ? appService.findRpSearchLog(startData, promotionType, page) : appService.findRpSearchLog(promotionType, page));
        if (rspList.isSuccess()) {
            return rspList;
        }
        log.info("{}-{}-\u63a8\u5e7f\u8425\u9500\u62a5\u8868\u6570\u636e\u7b2c {} \u9875\u67e5\u8be2\u5931\u8d25\uff0c\u7b2c {} \u6b21\u91cd\u8bd5", new Object[]{appService.getAppType(), promotionType.name(), page, ++retry});
        return this.doFindRpSearchLog(appService, startData, endData, promotionType, page, retry);
    }
}

