/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl.excel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelToImageConverter {
    public static void convertExcelToImage(String excelFilePath, String imageFilePath) {
        try (FileInputStream fis = new FileInputStream(excelFilePath);){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
            XSSFSheet sheet = workbook.getSheetAt(0);
            int totalRows = sheet.getPhysicalNumberOfRows();
            int totalCols = 0;
            for (int i = 0; i < totalRows; ++i) {
                XSSFRow row = sheet.getRow(i);
                totalCols = Math.max(totalCols, row.getPhysicalNumberOfCells());
            }
            BufferedImage image = new BufferedImage(totalCols * 60, totalRows * 20, 1);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, totalCols * 60, totalRows * 20);
            for (int i = 0; i < totalRows; ++i) {
                XSSFRow row = sheet.getRow(i);
                for (int j = 0; j < totalCols; ++j) {
                    Cell cell = row.getCell(j);
                    String cellValue = ExcelToImageConverter.getCellValue(cell);
                    graphics.setColor(Color.BLACK);
                    graphics.drawRect(j * 60, i * 20, 60, 20);
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(j * 60 + 1, i * 20 + 1, 58, 18);
                    graphics.setColor(Color.BLACK);
                    graphics.drawString(cellValue, j * 60 + 5, i * 20 + 15);
                }
            }
            ImageIO.write((RenderedImage)image, "png", new File(imageFilePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return Double.toString(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
        }
        return "";
    }

    public static void main(String[] args) {
        ExcelToImageConverter.convertExcelToImage("/tmp/1724902634271.xlsx", "/tmp/1724902634271.png");
    }
}

