/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.timer;

import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TrainPromotionTokenTimer {
    private static final Logger log = LoggerFactory.getLogger(TrainPromotionTokenTimer.class);
    private static final String NBCHAT_TRAIN_REFRESH_TOKEN_LOCK = "NBCHAT_TRAIN_REFRESH_TOKEN_LOCK";
    @Value(value="${nbchat-train.config.rp.search.timer-enable:true}")
    private boolean timeEnable;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private List<AppService> appServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0 0/1 * * ?")
    public void run() {
        if (!this.timeEnable) {
            return;
        }
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_REFRESH_TOKEN_LOCK).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                this.appServices.forEach(AppService::refreshAllTokens);
            }
            catch (Exception e) {
                log.error("\u63a8\u5e7f\u76f8\u5173\u4e09\u65b9accessToken\u5237\u65b0,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }
}

