/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.api.bo.auth;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserTokenInfo
implements Serializable {
    private String userId;
    private String tenantCode;
    private String platform;
    private Date loginTime;
    private Boolean apiAuth = Boolean.FALSE;

    @JsonIgnore
    public static String of(String userId, String tenantCode, String platform) {
        UserTokenInfo userTokenInfo = new UserTokenInfo();
        userTokenInfo.setUserId(userId);
        userTokenInfo.setTenantCode(tenantCode);
        userTokenInfo.setPlatform(platform);
        userTokenInfo.setLoginTime(new Date());
        return JSONObject.toJSONString((Object)userTokenInfo);
    }

    @JsonIgnore
    public static String of(String userId, String tenantCode) {
        return UserTokenInfo.of(userId, tenantCode, "");
    }

    @JsonIgnore
    public static UserTokenInfo parse(String token) {
        return (UserTokenInfo)JSONObject.parseObject((String)token, UserTokenInfo.class);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public Boolean getApiAuth() {
        return this.apiAuth;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setLoginTime(Date loginTime) {
        this.loginTime = loginTime;
    }

    public void setApiAuth(Boolean apiAuth) {
        this.apiAuth = apiAuth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTokenInfo)) {
            return false;
        }
        UserTokenInfo other = (UserTokenInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$apiAuth = this.getApiAuth();
        Boolean other$apiAuth = other.getApiAuth();
        if (this$apiAuth == null ? other$apiAuth != null : !((Object)this$apiAuth).equals(other$apiAuth)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        Date this$loginTime = this.getLoginTime();
        Date other$loginTime = other.getLoginTime();
        return !(this$loginTime == null ? other$loginTime != null : !((Object)this$loginTime).equals(other$loginTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserTokenInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $apiAuth = this.getApiAuth();
        result = result * 59 + ($apiAuth == null ? 43 : ((Object)$apiAuth).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        Date $loginTime = this.getLoginTime();
        result = result * 59 + ($loginTime == null ? 43 : ((Object)$loginTime).hashCode());
        return result;
    }

    public String toString() {
        return "UserTokenInfo(userId=" + this.getUserId() + ", tenantCode=" + this.getTenantCode() + ", platform=" + this.getPlatform() + ", loginTime=" + this.getLoginTime() + ", apiAuth=" + this.getApiAuth() + ")";
    }
}

