/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.ability.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.ability.ActParticipationAbilityService;
import com.tydic.newretail.act.ability.CouponInstanceAbilityService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActParticipateAtomService;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.CouponInstanceAtomService;
import com.tydic.newretail.act.atom.GiftAtomService;
import com.tydic.newretail.act.atom.GiftInstanceAtomService;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomBO;
import com.tydic.newretail.act.atom.bo.GiftInstanceAtomBO;
import com.tydic.newretail.act.bo.ActParticipationReqBO;
import com.tydic.newretail.act.bo.ActParticipationRspBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.ActivityBenefitDistributeRecordBO;
import com.tydic.newretail.act.bo.ActivityParticipateRecordBO;
import com.tydic.newretail.act.bo.ActivityParticipateRecordCountBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.DistributeCouponAbilityReqBO;
import com.tydic.newretail.act.bo.DistributeCouponAbilityRspBO;
import com.tydic.newretail.act.bo.GiftInstanceBO;
import com.tydic.newretail.act.bo.GiftInstanceRspBO;
import com.tydic.newretail.act.bo.QryActBenefitRspBO;
import com.tydic.newretail.act.bo.QryScratchCardRspBO;
import com.tydic.newretail.act.bo.StaffPriceParticipateRecordBO;
import com.tydic.newretail.act.busi.ActParticipationBusiService;
import com.tydic.newretail.act.busi.GiftInstanceBusiService;
import com.tydic.newretail.act.busi.QryActAttendanceRecordBusiService;
import com.tydic.newretail.act.constant.ActMemConstants;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.act.util.LotteryUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActParticipationAbilityServiceImpl
implements ActParticipationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ActParticipationAbilityServiceImpl.class);
    @Autowired
    private ActParticipationBusiService actParticipationBusiService;
    @Autowired
    private CouponInstanceAbilityService couponInstanceAbilityService;
    @Autowired
    private ActivityBenefitAtomService activityBenefitAtomService;
    @Autowired
    private CouponInstanceAtomService couponInstanceAtomService;
    @Autowired
    private GiftInstanceAtomService giftInstanceAtomService;
    @Autowired
    private GiftInstanceBusiService giftInstanceBusiService;
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Autowired
    private GiftAtomService giftAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private ActParticipateAtomService actParticipateAtomService;
    @Autowired
    QryActAttendanceRecordBusiService qryActAttendanceRecordBusiService;

    public RspBaseBO saveActRecord(ActParticipationReqBO reqBO) {
        RspBaseBO rsp;
        try {
            rsp = this.actParticipationBusiService.saveActRecord(reqBO);
        }
        catch (ResourceException e) {
            return new RspBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBaseBO("9999", "\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5f02\u5e38");
        }
        return rsp;
    }

    public RspBaseBO participeAct(ActParticipationReqBO reqBO) {
        QryActBenefitRspBO qryActBenefitRspBO;
        if (!"04".equals(reqBO.getActivityType()) && !"06".equals(reqBO.getActivityType())) {
            return new RspBaseBO("0008", "\u6682\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8");
        }
        if (!"04".equals(reqBO.getActivityType()) || null == reqBO.getRegTime()) {
            reqBO.setRegTime(new Date());
        }
        try {
            qryActBenefitRspBO = this.actParticipationBusiService.listBenefits(reqBO);
        }
        catch (ResourceException e) {
            return new RspBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6743\u76ca\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBaseBO("0003", "\u67e5\u8be2\u6743\u76ca\u5f02\u5e38");
        }
        if (null == qryActBenefitRspBO || CollectionUtils.isEmpty((Collection)qryActBenefitRspBO.getBenefitBOS())) {
            return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        List benefitBOS = qryActBenefitRspBO.getBenefitBOS();
        ArrayList<ActivityBenefitBO> modifyBOs = new ArrayList<ActivityBenefitBO>(benefitBOS.size());
        ArrayList<ActivityBenefitDistributeRecordBO> recordBOS = new ArrayList<ActivityBenefitDistributeRecordBO>(1);
        switch (reqBO.getActivityType()) {
            case "04": {
                if (null == reqBO.getMemType() || null == reqBO.getRegTime()) {
                    log.error("\u4f1a\u5458\u7c7b\u578b\u6216\u6ce8\u518c\u65f6\u95f4\u4e3a\u7a7a");
                    return new RspBaseBO("0001", "\u4f1a\u5458\u7c7b\u578b\u6216\u6ce8\u518c\u65f6\u95f4\u4e3a\u7a7a");
                }
                if (!ActMemConstants.MEM_TYPE_NOMAL.equals(reqBO.getMemType())) {
                    log.error("\u4f1a\u5458\u7c7b\u578b\u9519\u8bef");
                    return new RspBaseBO("0008", "\u4f1a\u5458\u7c7b\u578b\u9519\u8bef");
                }
                this.giftBenefit(benefitBOS, recordBOS, modifyBOs, reqBO, reqBO.getMemId().toString(), "MEM_REGISTER", null, qryActBenefitRspBO.getActivityTypeStr());
                break;
            }
            case "06": {
                if (null == reqBO.getTotalAmount()) {
                    log.error("\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a");
                    return new RspBaseBO("0001", "\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a");
                }
                if (null == reqBO.getOrderId()) {
                    log.error("\u8ba2\u5355ID\u4e3a\u7a7a");
                    return new RspBaseBO("0001", "\u8ba2\u5355ID\u4e3a\u7a7a");
                }
                this.giftBenefit(benefitBOS, recordBOS, modifyBOs, reqBO, reqBO.getOrderId(), "PAY_GIFT", null, qryActBenefitRspBO.getActivityTypeStr());
                break;
            }
        }
        this.modifyBeneFitRecord(recordBOS, modifyBOs);
        this.saveActRecords(reqBO, (ActivityBO)qryActBenefitRspBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void modifyBeneFitRecord(List<ActivityBenefitDistributeRecordBO> recordBOS, List<ActivityBenefitBO> modifyBOs) {
        if (CollectionUtils.isNotEmpty(modifyBOs)) {
            try {
                this.activityBenefitAtomService.modifyBatch(modifyBOs);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty(recordBOS)) {
            try {
                this.activityBenefitAtomService.modifyRecordBatch(recordBOS);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u53d1\u653e\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private boolean giftBenefit(List<ActivityBenefitBO> benefitBOS, List<ActivityBenefitDistributeRecordBO> recordBOS, List<ActivityBenefitBO> modifyBOs, ActParticipationReqBO reqBO, String instanceId, String channel, String sendChannel, String remark) {
        boolean successFlag = true;
        for (ActivityBenefitBO benefit : benefitBOS) {
            Long recordId;
            if (!"00".equals(benefit.getBenefitType()) && !"01".equals(benefit.getBenefitType()) || StringUtils.isBlank((CharSequence)benefit.getParam1())) continue;
            int count = 1;
            if (StringUtils.isNotBlank((CharSequence)benefit.getParam3())) {
                count = Integer.parseInt(benefit.getParam3());
            }
            if (null == (recordId = this.saveBenefitRecord(benefit, reqBO.getMemId(), remark))) {
                log.error("\u65b0\u589e\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u5931\u8d25");
                continue;
            }
            GiftInstanceRspBO giftInstanceRspBO = null;
            if ("00".equals(benefit.getBenefitType())) {
                successFlag = this.distributeCoupons(Long.parseLong(benefit.getParam1()), reqBO.getMemId(), instanceId, count, channel, benefit.getActivityId());
            } else if ("01".equals(benefit.getBenefitType()) && (null == (giftInstanceRspBO = this.distributeGifts(Long.parseLong(benefit.getParam1()), reqBO.getMemId(), instanceId, count, sendChannel, benefit.getActivityId())) || null == giftInstanceRspBO.getGiftInstanceId())) {
                successFlag = false;
            }
            ActivityBenefitDistributeRecordBO record = this.getModifyBenefitRecord(successFlag, giftInstanceRspBO, recordId, benefit.getBenefitType());
            record.setBenefitObjId(Long.valueOf(Long.parseLong(benefit.getParam1())));
            recordBOS.add(record);
            if (!successFlag || null == benefit.getAvailableCount()) continue;
            benefit.setAvailableCount(Integer.valueOf(benefit.getAvailableCount() - count));
            modifyBOs.add(benefit);
        }
        return successFlag;
    }

    private ActivityBenefitDistributeRecordBO getModifyBenefitRecord(boolean disFlag, GiftInstanceRspBO giftInstanceReqBO, Long recordId, String benefitType) {
        ActivityBenefitDistributeRecordBO record = new ActivityBenefitDistributeRecordBO();
        record.setBenefitDistRecordId(recordId);
        record.setDistStatus("02");
        if ("00".equals(benefitType) && disFlag) {
            record.setDistStatus("01");
        }
        if ("01".equals(benefitType) && null != giftInstanceReqBO) {
            if (null != giftInstanceReqBO.getGiftInstanceId()) {
                record.setDistStatus("00");
                record.setBenefitObjInstanceId(giftInstanceReqBO.getGiftInstanceId());
            } else if (StringUtils.isNotBlank((CharSequence)giftInstanceReqBO.getRespDesc())) {
                record.setRemark(giftInstanceReqBO.getRespDesc());
            }
        }
        record.setLastUpdTime(new Date());
        return record;
    }

    private Long saveBenefitRecord(ActivityBenefitBO benefit, Long memId, String remark) {
        ArrayList<ActivityBenefitDistributeRecordBO> recordBOS = new ArrayList<ActivityBenefitDistributeRecordBO>(1);
        recordBOS.add(this.getBenefitRecord(benefit, memId, remark));
        List<ActivityBenefitDistributeRecordBO> rspList = null;
        try {
            rspList = this.activityBenefitAtomService.saveRecordBatch(recordBOS);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
        return rspList.get(0).getBenefitDistRecordId();
    }

    private ActivityBenefitDistributeRecordBO getBenefitRecord(ActivityBenefitBO benefit, Long uid, String remark) {
        ActivityBenefitDistributeRecordBO record = new ActivityBenefitDistributeRecordBO();
        record.setActivityBenefitId(benefit.getActivityBenefitId());
        record.setActivityId(benefit.getActivityId());
        record.setBenefitType(benefit.getBenefitType());
        record.setCrtTime(new Date());
        record.setDistCount(Integer.valueOf(1));
        record.setLastUpdTime(new Date());
        record.setTenantId(benefit.getTenantId());
        record.setTotalAmount(benefit.getAmountCount());
        record.setUid(uid);
        record.setRemark(remark);
        String status = "00";
        record.setDistStatus(status);
        return record;
    }

    private boolean distributeCoupons(Long couponId, Long memId, String instanceId, int count, String channel, Long actId) {
        boolean disFlag = true;
        for (int i = 0; i < count; ++i) {
            ArrayList<Long> uids = new ArrayList<Long>(1);
            uids.add(memId);
            DistributeCouponAbilityReqBO disCouponReqBO = new DistributeCouponAbilityReqBO();
            disCouponReqBO.setCouponId(couponId);
            disCouponReqBO.setUserIds(uids);
            disCouponReqBO.setCouponSrcChannel(channel);
            disCouponReqBO.setCouponSrcInstance(instanceId);
            disCouponReqBO.setActivityId(actId);
            DistributeCouponAbilityRspBO rsp = null;
            try {
                rsp = this.couponInstanceAbilityService.distributeCoupon(disCouponReqBO);
            }
            catch (Exception e) {
                log.error("\u6d3e\u5238\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (null != rsp && "0000".equals(rsp.getRespCode()) && !CollectionUtils.isNotEmpty((Collection)rsp.getFailList())) continue;
            disFlag = false;
        }
        return disFlag;
    }

    private GiftInstanceRspBO distributeGifts(Long giftId, Long memId, String instanceId, int count, String sendChannel, Long actId) {
        boolean disFlag = true;
        GiftInstanceBO giftInstanceReqBO = new GiftInstanceBO();
        giftInstanceReqBO.setUid(memId.toString());
        giftInstanceReqBO.setGiftId(giftId);
        giftInstanceReqBO.setTotalCount(Integer.valueOf(count));
        giftInstanceReqBO.setSendChannel(sendChannel);
        giftInstanceReqBO.setActivityId(actId);
        GiftInstanceRspBO giftInstanceRspBO = new GiftInstanceRspBO();
        try {
            giftInstanceRspBO = this.giftInstanceBusiService.saveGiftDistribute(giftInstanceReqBO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u8d60\u54c1\u5956\u54c1\u5b9e\u4f8b\u5f02\u5e38\uff1a" + e.getMessage());
            giftInstanceRspBO.setRespDesc("\u65b0\u589e\u8d60\u54c1\u5956\u54c1\u5b9e\u4f8b\u63a5\u53e3\u5f02\u5e38");
        }
        return giftInstanceRspBO;
    }

    public RspBaseBO cancelAct(ActParticipationReqBO reqBO) {
        if (null == reqBO.getOrderId() || null == reqBO.getMemId()) {
            log.error("\u8ba2\u5355ID\u6216\u4f1a\u5458ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u8ba2\u5355ID\u6216\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        try {
            this.couponInstanceAtomService.removeByInstance(reqBO.getMemId(), reqBO.getOrderId(), "PAY_GIFT");
        }
        catch (ResourceException e) {
            return new RspBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u53d6\u6d88\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBaseBO("9999", "\u6d3b\u52a8\u53d6\u6d88\u5f02\u5e38");
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public ActParticipationRspBO lottery(ActParticipationReqBO reqBO) {
        ActParticipationRspBO rsp;
        if (null == reqBO.getMemId() || null == reqBO.getActivityId()) {
            log.error("\u4f1a\u5458ID\u6216\u6d3b\u52a8ID\u4e3a\u7a7a");
            return new ActParticipationRspBO("0001", "\u4f1a\u5458ID\u6216\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            rsp = this.lotteryMethod(reqBO);
        }
        catch (ResourceException e) {
            return new ActParticipationRspBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u522e\u5956\u5f02\u5e38\uff1a" + e.getMessage());
            return new ActParticipationRspBO("9999", "\u522e\u5956\u5f02\u5e38");
        }
        return rsp;
    }

    private ActParticipationRspBO lotteryMethod(ActParticipationReqBO reqBO) {
        ActivityBenefitBO benefitBO;
        String channel;
        String remark;
        ActivityBO qryAct = new ActivityBO();
        qryAct.setActivityId(reqBO.getActivityId());
        qryAct.setActivityStatus("02");
        ActivityBO activityBO = this.actInfoAtomService.getActivityInfo(qryAct);
        if (null == activityBO) {
            log.error("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
            return new ActParticipationRspBO("0002", "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
        }
        String sendChannel = null;
        if ("05".equals(activityBO.getActivityType())) {
            remark = "\u522e\u522e\u5361";
            channel = "SCRATCH_CARD";
        } else if ("07".equals(activityBO.getActivityType())) {
            remark = "\u8f6c\u76d8\u62bd\u5956";
            channel = "TURNAROUND_DRAW";
            sendChannel = "00";
        } else {
            return new ActParticipationRspBO("0008", "\u6682\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8");
        }
        Date nowDate = new Date();
        if (null != activityBO.getStartTime() && nowDate.before(activityBO.getStartTime())) {
            log.error("\u6d3b\u52a8\u672a\u5f00\u59cb");
            return new ActParticipationRspBO("0021", "\u6d3b\u52a8\u672a\u5f00\u59cb");
        }
        if (null != activityBO.getEndTime() && nowDate.after(activityBO.getEndTime())) {
            log.error("\u6d3b\u52a8\u5df2\u7ed3\u675f");
            return new ActParticipationRspBO("0022", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        this.checkNumOfParti(activityBO, reqBO);
        if (!this.saveActRecords(reqBO, activityBO).booleanValue()) {
            return new ActParticipationRspBO("9999", "\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5f02\u5e38");
        }
        ActivityBenefitBO qryBenefitBO = new ActivityBenefitBO();
        qryBenefitBO.setActivityId(activityBO.getActivityId());
        List<ActivityBenefitBO> benefitBOS = this.activityBenefitAtomService.listBenefitByActId(qryBenefitBO);
        if (CollectionUtils.isEmpty(benefitBOS)) {
            return new ActParticipationRspBO("9999", "\u5956\u54c1\u6570\u91cf\u4e0d\u8db3", "00");
        }
        while (StringUtils.isNotBlank((CharSequence)(benefitBO = LotteryUtils.getPrizeIndex(benefitBOS)).getParam4()) && StringUtils.isNotBlank((CharSequence)benefitBO.getParam5())) {
            Date sDate = TkDateUtils.datetimeStrToDate((String)benefitBO.getParam4());
            Date eDate = TkDateUtils.datetimeStrToDate((String)benefitBO.getParam5());
            if (sDate == null || eDate == null) {
                log.error("\u6d3b\u52a8\u6743\u76ca\u53d1\u653e\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                return new ActParticipationRspBO("9999", "\u62bd\u5956\u5f02\u5e38");
            }
            if (new Date().getTime() < sDate.getTime() || new Date().getTime() > eDate.getTime()) continue;
        }
        if (StringUtils.isBlank((CharSequence)benefitBO.getParam1())) {
            return new ActParticipationRspBO("0000", "\u64cd\u4f5c\u6210\u529f", "00", "02", benefitBO.getActivityBenefitId());
        }
        ArrayList<ActivityBenefitBO> benes = new ArrayList<ActivityBenefitBO>(1);
        benes.add(benefitBO);
        ArrayList<ActivityBenefitBO> modifyBOs = new ArrayList<ActivityBenefitBO>(benefitBOS.size());
        ArrayList<ActivityBenefitDistributeRecordBO> recordBOS = new ArrayList<ActivityBenefitDistributeRecordBO>(1);
        if ("01".equals(benefitBO.getBenefitType())) {
            GiftInfoAtomBO giftInfoRspPO = this.giftAtomService.getGiftInfoDetail(Long.parseLong(benefitBO.getParam1()));
            if (null == giftInfoRspPO) {
                log.error("\u67e5\u4e0d\u5230\u5b9e\u7269\u5956\u54c1\u4fe1\u606f:\u6743\u76caID" + benefitBO.getParam1());
                return new ActParticipationRspBO("9999", "\u67e5\u4e0d\u5230\u5b9e\u7269\u5956\u54c1\u4fe1\u606f", "00");
            }
            if ("01".equals(giftInfoRspPO.getGiftType())) {
                return new ActParticipationRspBO("0000", "\u64cd\u4f5c\u6210\u529f", "01", "02", benefitBO.getActivityBenefitId());
            }
        }
        boolean successFlag = this.giftBenefit(benes, recordBOS, modifyBOs, reqBO, reqBO.getMemId().toString(), channel, sendChannel, remark);
        this.modifyBeneFitRecord(recordBOS, modifyBOs);
        if (successFlag) {
            if ("00".equals(benefitBO.getBenefitType())) {
                CouponInstanceBO couponinstanceBO = this.getCouponInstance(Long.parseLong(benefitBO.getParam1()), reqBO.getMemId());
                ConvertParamUtils.escapeCoupon(couponinstanceBO, this.qryEscapeAtomService);
                return new ActParticipationRspBO("0000", "\u64cd\u4f5c\u6210\u529f", "01", "00", benefitBO.getActivityBenefitId(), couponinstanceBO);
            }
            GiftInstanceBO giftinstanceBO = this.getGiftInstance(Long.parseLong(benefitBO.getParam1()), reqBO.getMemId());
            ConvertParamUtils.escaptGiftInstance(giftinstanceBO, this.qryEscapeAtomService);
            return new ActParticipationRspBO("0000", "\u64cd\u4f5c\u6210\u529f", "01", "01", benefitBO.getActivityBenefitId(), giftinstanceBO);
        }
        return new ActParticipationRspBO("9999", "\u7cfb\u7edf\u5f02\u5e38", "00");
    }

    private Boolean saveActRecords(ActParticipationReqBO reqBO, ActivityBO activityBO) {
        ArrayList<StaffPriceParticipateRecordBO> records = new ArrayList<StaffPriceParticipateRecordBO>(1);
        StaffPriceParticipateRecordBO record = new StaffPriceParticipateRecordBO();
        record.setUid(reqBO.getMemId());
        record.setTenantId(activityBO.getTenantId());
        record.setActivityType(activityBO.getActivityType());
        record.setActivityId(activityBO.getActivityId());
        record.setParticipateTime(new Date());
        records.add(record);
        try {
            this.actParticipateAtomService.saveActParticipateRecord(records);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    private CouponInstanceBO getCouponInstance(long couponId, Long memId) {
        HashSet<Long> couponIds = new HashSet<Long>(1);
        couponIds.add(couponId);
        List<CouponInstanceBO> instanceBOS = this.couponInstanceAtomService.listInsByCouponIds(memId, couponIds);
        if (CollectionUtils.isEmpty(instanceBOS)) {
            return null;
        }
        return instanceBOS.get(0);
    }

    private GiftInstanceBO getGiftInstance(long giftId, Long memId) {
        GiftInstanceAtomBO reqBO = new GiftInstanceAtomBO();
        reqBO.setGiftId(giftId);
        reqBO.setUid(memId.toString());
        RspBatchBaseBO<GiftInstanceAtomBO> rspBatchBaseBOs = this.giftInstanceAtomService.selectGiftInstanceByCondition(reqBO);
        if (rspBatchBaseBOs == null || !"0000".equals(rspBatchBaseBOs.getRespCode()) || CollectionUtils.isEmpty((Collection)rspBatchBaseBOs.getRows())) {
            return null;
        }
        GiftInstanceBO rspBo = new GiftInstanceBO();
        BeanUtils.copyProperties(rspBatchBaseBOs.getRows().get(0), (Object)rspBo);
        return rspBo;
    }

    private void checkNumOfParti(ActivityBO activityBO, ActParticipationReqBO reqBO) {
        int grandCount;
        int userCount;
        if (StringUtils.isNotBlank((CharSequence)activityBO.getParam2())) {
            userCount = Integer.parseInt(activityBO.getParam2());
            grandCount = this.actParticipateAtomService.getCountByActIdAndUid(activityBO.getActivityId(), reqBO.getMemId(), false);
            if (grandCount >= userCount) {
                throw new ResourceException("0012", "\u53ef\u62bd\u5956\u6b21\u6570\u4e0d\u8db3");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)activityBO.getParam1())) {
            userCount = Integer.parseInt(activityBO.getParam1());
            grandCount = this.actParticipateAtomService.getCountByActIdAndUid(activityBO.getActivityId(), reqBO.getMemId(), true);
            if (grandCount >= userCount) {
                throw new ResourceException("0012", "\u5f53\u5929\u53ef\u62bd\u5956\u6b21\u6570\u4e0d\u8db3");
            }
        }
    }

    public QryScratchCardRspBO getScratchCardInfo(ActParticipationReqBO reqBO) {
        QryScratchCardRspBO rsp;
        try {
            rsp = this.actParticipationBusiService.getScratchCardInfo(reqBO);
        }
        catch (ResourceException e) {
            return new QryScratchCardRspBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u522e\u522e\u4e50\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return new QryScratchCardRspBO("9999", "\u522e\u522e\u4e50\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
        }
        return rsp;
    }

    public RspBaseTBO<ActivityParticipateRecordCountBO> getParticipationTimes(ActivityParticipateRecordBO recordBO) {
        RspBaseTBO rsp;
        try {
            rsp = this.qryActAttendanceRecordBusiService.getParticipationTimes(recordBO);
        }
        catch (ResourceException e) {
            return new RspBaseTBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u53c2\u4e0e\u603b\u6b21\u6570\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBaseTBO("9999", "\u6d3b\u52a8\u53c2\u4e0e\u603b\u6b21\u6570\u67e5\u8be2\u5f02\u5e38");
        }
        return rsp;
    }
}

