/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.ability.impl;

import com.tydic.newretail.act.ability.CouponInstanceExpireTimeTask;
import com.tydic.newretail.act.atom.CouponInstanceAtomService;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponInstanceExpireTimeTaskReqBO;
import com.tydic.newretail.act.bo.CouponInstanceReqBO;
import com.tydic.newretail.act.dao.CouponInstanceDAO;
import com.tydic.newretail.act.dao.po.CouponInstancePO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponInstanceExpireTimeTaskImpl
implements CouponInstanceExpireTimeTask {
    private static final Logger log = LoggerFactory.getLogger(CouponInstanceExpireTimeTaskImpl.class);
    @Autowired
    private CouponInstanceAtomService couponInstanceAtomService;
    @Autowired
    private CouponInstanceDAO couponInstanceDAO;

    public RspBaseBO expireCouponInstance(CouponInstanceExpireTimeTaskReqBO reqBO) {
        RspBaseBO result = new RspBaseBO();
        try {
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            CouponInstanceReqBO couponInstanceReqBO = new CouponInstanceReqBO();
            couponInstanceReqBO.setUseStatus("0");
            couponInstanceReqBO.setExpireQryTime(new Date());
            List<CouponInstanceBO> expireList = this.couponInstanceAtomService.queryCouponInstance(couponInstanceReqBO);
            if (CollectionUtils.isEmpty(expireList)) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8fc7\u671f\u4f18\u60e0\u5238\u5b9e\u4f8b\u67e5\u8be2\u4e3a\u7a7a\u3002");
                }
                return result;
            }
            ArrayList<CouponInstancePO> list = new ArrayList<CouponInstancePO>();
            for (CouponInstanceBO couponInstanceBO : expireList) {
                CouponInstancePO couponInstancePO = new CouponInstancePO();
                couponInstancePO.setUseStatus("3");
                couponInstancePO.setCouponInstanceId(couponInstanceBO.getCouponInstanceId());
                list.add(couponInstancePO);
            }
            this.couponInstanceDAO.updateComputationsBatch(list);
        }
        catch (Exception e) {
            log.error("\u4f18\u60e0\u5238\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u63a5\u53e3\u62a5\u9519\uff1a", (Throwable)e);
            result.setRespCode("9999");
            result.setRespDesc("\u4f18\u60e0\u5238\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u63a5\u53e3\u62a5\u9519\uff1a" + e.getMessage());
            return result;
        }
        return result;
    }
}

