/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.ability.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.ability.ModifyActStatusTaskAbilityService;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActTouchSpotAtomService;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.atom.bo.QryActReqAtomBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.ActivityTouchSpotBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyActStatusTaskAbilityServiceImpl
implements ModifyActStatusTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ModifyActStatusTaskAbilityServiceImpl.class);
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Autowired
    private ActivityBenefitAtomService activityBenefitAtomService;
    @Autowired
    private ActCommAtomService actCommAtomService;
    @Autowired
    private CouponAtomService couponAtomService;
    @Autowired
    private ActTouchSpotAtomService actTouchSpotAtomService;

    public RspBaseBO modifyStatus(ActivityBO reqBO) {
        QryActReqAtomBO atomBO = this.getQryAtomBO(reqBO);
        List<ActivityBO> activityBOS = this.actInfoAtomService.listActByType(atomBO);
        if (CollectionUtils.isEmpty(activityBOS)) {
            return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<ActivityBO> modifyBOs = new ArrayList<ActivityBO>(activityBOS.size());
        ArrayList<ActivityCommodityBO> commodityBOs = new ArrayList<ActivityCommodityBO>();
        ArrayList<ActivityTouchSpotBO> touchSpotBOs = new ArrayList<ActivityTouchSpotBO>();
        ArrayList<ActivityBenefitBO> benefitBOs = new ArrayList<ActivityBenefitBO>();
        Date nowDate = new Date();
        HashSet<Long> actIds = new HashSet<Long>(activityBOS.size());
        for (ActivityBO act : activityBOS) {
            act.setLastUpdTime(nowDate);
            ActivityCommodityBO commodityBO = new ActivityCommodityBO();
            commodityBO.setActivityId(act.getActivityId());
            ActivityTouchSpotBO touchSpotBO = new ActivityTouchSpotBO();
            touchSpotBO.setActivityId(act.getActivityId());
            ActivityBenefitBO benefitBO = new ActivityBenefitBO();
            benefitBO.setActivityId(act.getActivityId());
            if (null != act.getEndTime() && act.getEndTime().compareTo(nowDate) <= 0) {
                act.setActivityStatus("04");
                modifyBOs.add(act);
                commodityBO.setActivityStatus("04");
                commodityBOs.add(commodityBO);
                touchSpotBO.setActivityStatus("04");
                touchSpotBOs.add(touchSpotBO);
                benefitBO.setActivityStatus("04");
                benefitBOs.add(benefitBO);
                actIds.add(act.getActivityId());
                continue;
            }
            if (null != act.getStartTime() && null != act.getEndTime() && TkDateUtils.belongCalendar((Date)nowDate, (Date)act.getStartTime(), (Date)act.getEndTime()) && !"02".equals(act.getActivityStatus()) && !"03".equals(act.getActivityStatus())) {
                act.setActivityStatus("02");
                modifyBOs.add(act);
                commodityBO.setActivityStatus("02");
                commodityBOs.add(commodityBO);
                touchSpotBO.setActivityStatus("02");
                touchSpotBOs.add(touchSpotBO);
                benefitBO.setActivityStatus("02");
                benefitBOs.add(benefitBO);
                continue;
            }
            switch (act.getActivityStatus()) {
                case "00": {
                    if (null == act.getAdvanceNoticeTime() || act.getAdvanceNoticeTime().compareTo(nowDate) > 0) break;
                    act.setActivityStatus("01");
                    modifyBOs.add(act);
                    commodityBO.setActivityStatus("01");
                    commodityBOs.add(commodityBO);
                    touchSpotBO.setActivityStatus("01");
                    touchSpotBOs.add(touchSpotBO);
                    benefitBO.setActivityStatus("01");
                    benefitBOs.add(benefitBO);
                    break;
                }
                case "01": {
                    if (null == act.getStartTime() || act.getStartTime().compareTo(nowDate) > 0) break;
                    act.setActivityStatus("02");
                    modifyBOs.add(act);
                    commodityBO.setActivityStatus("02");
                    commodityBOs.add(commodityBO);
                    touchSpotBO.setActivityStatus("02");
                    touchSpotBOs.add(touchSpotBO);
                    benefitBO.setActivityStatus("02");
                    benefitBOs.add(benefitBO);
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(modifyBOs)) {
            try {
                this.actInfoAtomService.modifyBatch(modifyBOs);
            }
            catch (ResourceException e) {
                return new RspBaseBO(e.getMsgCode(), e.getMessage());
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                return new RspBaseBO("9999", "\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38");
            }
            log.debug("\u672c\u6b21\u66f4\u65b0\u6d3b\u52a8\u3010{}\u3011\u6761", (Object)modifyBOs.size());
        }
        if (CollectionUtils.isNotEmpty(touchSpotBOs)) {
            try {
                this.actTouchSpotAtomService.updateStatusBatch(touchSpotBOs);
            }
            catch (ResourceException e) {
                return new RspBaseBO(e.getMsgCode(), e.getMessage());
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                return new RspBaseBO("9999", "\u6279\u91cf\u66f4\u65b0\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38");
            }
        }
        if (CollectionUtils.isNotEmpty(touchSpotBOs)) {
            try {
                this.actCommAtomService.updateStatusBatch(commodityBOs);
            }
            catch (ResourceException e) {
                return new RspBaseBO(e.getMsgCode(), e.getMessage());
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                return new RspBaseBO("9999", "\u6279\u91cf\u66f4\u65b0\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38");
            }
        }
        if (CollectionUtils.isNotEmpty(touchSpotBOs)) {
            try {
                this.activityBenefitAtomService.updateStatusBatch(benefitBOs);
            }
            catch (ResourceException e) {
                return new RspBaseBO(e.getMsgCode(), e.getMessage());
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                return new RspBaseBO("9999", "\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5f02\u5e38");
            }
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private QryActReqAtomBO getQryAtomBO(ActivityBO reqBO) {
        QryActReqAtomBO atomBO = new QryActReqAtomBO();
        HashSet<String> status = new HashSet<String>();
        status.add("00");
        status.add("01");
        status.add("02");
        status.add("03");
        atomBO.setActivityStatus(status);
        if (null != reqBO) {
            atomBO.setActivityType(reqBO.getActivityType());
            atomBO.setAdvDate(reqBO.getAdvanceNoticeTime());
            atomBO.setEndDate(reqBO.getEndTime());
            atomBO.setNowDate(reqBO.getStartTime());
        }
        return atomBO;
    }

    public RspBaseBO modifyCouponStatus(CouponBO reqBO) {
        CouponBO couponBO = new CouponBO();
        couponBO.setCouponStatus("00");
        List<CouponBO> couponBOs = this.couponAtomService.listByCondition(couponBO);
        if (CollectionUtils.isEmpty(couponBOs)) {
            return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<CouponBO> modifyBOs = new ArrayList<CouponBO>(couponBOs.size());
        Date nowDate = new Date();
        for (CouponBO bo : couponBOs) {
            if (null == bo.getUsefulEndTime() || bo.getUsefulEndTime().compareTo(nowDate) > 0) continue;
            bo.setCouponStatus("01");
            modifyBOs.add(bo);
        }
        if (CollectionUtils.isEmpty(modifyBOs)) {
            return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        this.couponAtomService.modifyBatch(modifyBOs);
        log.debug("\u672c\u6b21\u66f4\u65b0\u7535\u5b50\u5238\u3010{}\u3011\u6761", (Object)modifyBOs.size());
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }
}

