/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.ability.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.ability.QryCouponInstanceAbilityService;
import com.tydic.newretail.act.atom.CouponInstanceAtomService;
import com.tydic.newretail.act.bo.ActParticipationReqBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponInstanceReqBO;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryCouponInstanceAbilityServiceImpl
implements QryCouponInstanceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(QryCouponInstanceAbilityServiceImpl.class);
    @Autowired
    private CouponInstanceAtomService couponInstanceAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspPageBaseBO<CouponInstanceBO> queryCouponInstancePage(CouponInstanceReqBO couponInstanceReqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u5217\u8868\u5165\u53c2:" + JSON.toJSONString((Object)couponInstanceReqBO));
        }
        RspPageBaseBO<CouponInstanceBO> result = new RspPageBaseBO<CouponInstanceBO>();
        if (couponInstanceReqBO.getCurrent() <= 0 || couponInstanceReqBO.getPageSize() <= 0) {
            log.error("\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u5217\u8868\u63a5\u53e3\u5165\u53c2\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            result.setRespCode("0001");
            result.setRespDesc("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            return result;
        }
        try {
            result = this.couponInstanceAtomService.queryCouponInstancePage(couponInstanceReqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u5217\u8868\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
        }
        return result;
    }

    public RspBatchBaseBO<CouponInstanceBO> listRegGiftCouponIns(ActParticipationReqBO reqBO) {
        if (null == reqBO.getMemId()) {
            log.error("\u4f1a\u5458ID\u4e3a\u7a7a");
            return new RspBatchBaseBO("0002", "\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        return this.listCouponIns(reqBO.getMemId(), reqBO.getMemId().toString(), "MEM_REGISTER");
    }

    public RspBatchBaseBO<CouponInstanceBO> listPayGiftCouponIns(ActParticipationReqBO reqBO) {
        if (null == reqBO.getMemId()) {
            log.error("\u4f1a\u5458ID\u4e3a\u7a7a");
            return new RspBatchBaseBO("0002", "\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderId())) {
            log.error("\u8ba2\u5355ID\u4e3a\u7a7a");
            return new RspBatchBaseBO("0002", "\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        return this.listCouponIns(reqBO.getMemId(), reqBO.getOrderId(), "PAY_GIFT");
    }

    private RspBatchBaseBO<CouponInstanceBO> listCouponIns(Long memId, String instanceId, String channel) {
        List<CouponInstanceBO> bos;
        try {
            bos = this.couponInstanceAtomService.listByInstance(memId, instanceId, channel);
        }
        catch (ResourceException e) {
            return new RspBatchBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7535\u5b50\u5238\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBatchBaseBO("9999", "\u67e5\u8be2\u7535\u5b50\u5238\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(bos)) {
            for (CouponInstanceBO instanceBO : bos) {
                ConvertParamUtils.escapeCoupon(instanceBO, this.qryEscapeAtomService);
            }
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", bos);
    }
}

