/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.ActCalAtomService;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.bo.ActCalReqBO;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.constant.ActMemConstants;
import com.tydic.newretail.act.util.CalculationUtils;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActCalAtomServiceImpl
implements ActCalAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActCalAtomServiceImpl.class);
    @Autowired
    private ActCommAtomService actCommAtomService;

    @Override
    public Double calFullReduction(ActCommInfoBO reqBO, ActivityBO actBO, Long oriPrice) {
        if (null == reqBO || null == actBO) {
            log.error("\u6ee1\u51cf\u4ef7\u683c\u8ba1\u7b97\u5165\u53c2\u4e3a\u7a7a");
            ConvertParamUtils.setPrice(reqBO, 0L, 0L);
            return new Double(0.0);
        }
        if (!"00".equals(actBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (StringUtils.isBlank((CharSequence)actBO.getParam1()) || StringUtils.isBlank((CharSequence)actBO.getParam2())) {
            log.error("\u672a\u914d\u7f6e\u6ee1\u51cf\u89c4\u5219");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        Long fullPrice = Long.valueOf(actBO.getParam1());
        Long reducePrice = Long.valueOf(actBO.getParam2());
        if (fullPrice > oriPrice) {
            log.error("\u672a\u7b26\u5408\u6ee1\u51cf\u89c4\u5219");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        Double apportionPrice = CalculationUtils.calFullReduce(oriPrice, reqBO.getSkuDisPriceL(), reducePrice);
        ConvertParamUtils.setPrice(reqBO, TkCalculatorUtils.transferY((long)reqBO.getSkuDisPriceL()), apportionPrice);
        return apportionPrice;
    }

    @Override
    public Double callMemPrice(ActCommInfoBO reqBO, ActivityBO actBO, Integer memLevel) {
        String formula;
        if (null == reqBO || null == actBO || null == memLevel || null == reqBO.getSalePriceL() || null == reqBO.getPurchasePriceL()) {
            log.error("\u4f1a\u5458\u4ef7\u8ba1\u7b97\u5165\u53c2\u4e3a\u7a7a");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!"601".equals(reqBO.getPurchaseType())) {
            log.error("\u91c7\u8d2d\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!"02".equals(actBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (ActMemConstants.MEM_LEVEL_1.equals(memLevel) || ActMemConstants.MEM_LEVEL_2.equals(memLevel)) {
            formula = actBO.getParam1();
        } else if (ActMemConstants.MEM_LEVEL_3.equals(memLevel)) {
            formula = actBO.getParam2();
        } else if (ActMemConstants.MEM_LEVEL_4.equals(memLevel)) {
            formula = actBO.getParam3();
        } else {
            log.error("\u672a\u77e5\u4f1a\u5458\u7b49\u7ea7");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (StringUtils.isBlank((CharSequence)formula)) {
            log.error("\u672a\u914d\u7f6e\u4f1a\u5458\u4ef7\u683c\u8ba1\u7b97\u516c\u5f0f");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        Double disCount = CalculationUtils.calPriceByFormula(reqBO.getSkuDisPriceL(), formula, reqBO.getPurchasePriceL(), reqBO.getSalePriceL());
        ConvertParamUtils.setPrice(reqBO, TkCalculatorUtils.transferY((long)reqBO.getSkuDisPriceL()), disCount);
        reqBO.setMemPrice(reqBO.getSkuDisPrice());
        reqBO.setMemPriceL(reqBO.getSkuDisPriceL());
        return disCount;
    }

    @Override
    public Double calPriceByType(ActCommInfoBO commBO, ActivityBO actBO, Long oriPrice, ActCalReqBO reqBO) {
        Double amoPri;
        if (null == commBO.getSkuDisPriceL()) {
            commBO.setSkuDisPriceL(commBO.getSalePriceL());
        }
        switch (actBO.getActivityType()) {
            case "02": {
                amoPri = this.callMemPrice(commBO, actBO, reqBO.getMemLevel());
                break;
            }
            case "01": {
                amoPri = this.calSecKillPrice(commBO, actBO);
                break;
            }
            case "00": {
                amoPri = this.calFullReduction(commBO, actBO, oriPrice);
                break;
            }
            case "03": {
                amoPri = this.calStaffPrice(commBO, actBO, reqBO.getMemType());
                break;
            }
            case "12": {
                amoPri = this.calSingleReducePrice(commBO, actBO);
                break;
            }
            case "11": {
                amoPri = this.calGlobalOpenPrice(commBO, actBO, reqBO.getGrade());
                break;
            }
            default: {
                ConvertParamUtils.setPrice(commBO, commBO.getSkuDisPriceL(), 0L);
                amoPri = new Double(0.0);
            }
        }
        Double totalAmo = TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(commBO.getSkuDisAmount().toString()), (BigDecimal)new BigDecimal(commBO.getSkuCount().toString())).doubleValue();
        Long skuTotalPrice = TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(commBO.getSalePriceL().toString()), (BigDecimal)new BigDecimal(commBO.getSkuCount().toString())).longValue();
        Double totalPrice = TkCalculatorUtils.sub((BigDecimal)new BigDecimal(TkCalculatorUtils.transferY((long)skuTotalPrice).toString()), (BigDecimal)new BigDecimal(totalAmo.toString())).doubleValue();
        commBO.setSkuDisTotalAmount(totalAmo);
        commBO.setSkuDisTotalPrice(totalPrice);
        return amoPri;
    }

    @Override
    public Double calSecKillPrice(ActCommInfoBO reqBO, ActivityBO actBO) {
        if (null == actBO || null == reqBO) {
            log.error("\u79d2\u6740\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5165\u53c2\u4e3a\u7a7a");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!"01".equals(actBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(actBO.getActivityId());
        HashSet<String> actTypes = new HashSet<String>();
        actTypes.add("01");
        ActivityCommodityBO commodityBO = new ActivityCommodityBO();
        commodityBO.setObjType("99");
        commodityBO.setObjCode(reqBO.getSkuId().toString());
        ArrayList<ActivityCommodityBO> commodityBOS = new ArrayList<ActivityCommodityBO>(1);
        commodityBOS.add(commodityBO);
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setActTypes(actTypes);
        atomBO.setActIds(actIds);
        atomBO.setActComms(commodityBOS);
        atomBO.setCurrentDate(new Date());
        atomBO.setAdvanceFlag(false);
        atomBO.setActStatus("02");
        List<ActivityCommodityBO> commInfoBOS = this.actCommAtomService.listCommBySkuAndType(atomBO);
        if (CollectionUtils.isEmpty(commInfoBOS)) {
            log.error("\u672a\u67e5\u8be2\u5230\u79d2\u6740\u6d3b\u52a8\u5546\u54c1");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        ActivityCommodityBO actComm = commInfoBOS.get(0);
        if (actComm.getAvailableCount() <= 0 || reqBO.getSkuCount() > actComm.getAvailableCount()) {
            log.error("\u79d2\u6740\u5546\u54c1\u3010{}\u3011\u5e93\u5b58\u4e0d\u8db3", (Object)reqBO.getSkuId());
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        Long actPrice = commInfoBOS.get(0).getActPrice();
        if (null == actPrice) {
            log.error("\u79d2\u6740\u5546\u54c1\u3010{}\u3011\u672a\u914d\u7f6e\u79d2\u6740\u4ef7\u683c", (Object)reqBO.getSkuId());
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (null == reqBO.getTotalCount()) {
            reqBO.setTotalCount(actComm.getTotalCount());
        }
        if (null == reqBO.getAvailableCount()) {
            reqBO.setAvailableCount(actComm.getAvailableCount());
        }
        Long amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)actPrice);
        ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), amoPriceL);
        return TkCalculatorUtils.transferY((long)amoPriceL);
    }

    @Override
    public Double calStaffPrice(ActCommInfoBO reqBO, ActivityBO actBO, Integer memType) {
        if (null == reqBO || null == actBO || null == memType || null == reqBO.getSalePriceL() || null == reqBO.getPurchasePriceL()) {
            log.error("\u5185\u8d2d\u4ef7\u683c\u8ba1\u7b97\u5165\u53c2\u4e3a\u7a7a");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!(ActMemConstants.MEM_TYPE_STAFF_4.equals(memType) || ActMemConstants.MEM_TYPE_STAFF_5.equals(memType) || ActMemConstants.MEM_TYPE_STAFF_6.equals(memType))) {
            log.error("\u4f1a\u5458\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!"03".equals(actBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        String formula = actBO.getParam1();
        if (StringUtils.isBlank((CharSequence)formula)) {
            log.error("\u672a\u914d\u7f6e\u5185\u8d2d\u4ef7\u683c\u8ba1\u7b97\u516c\u5f0f");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(actBO.getActivityId());
        HashSet<String> actTypes = new HashSet<String>();
        actTypes.add("03");
        ActivityCommodityBO commodityBO = new ActivityCommodityBO();
        commodityBO.setObjType("99");
        commodityBO.setObjCode(reqBO.getSkuId().toString());
        ArrayList<ActivityCommodityBO> commodityBOS = new ArrayList<ActivityCommodityBO>(1);
        commodityBOS.add(commodityBO);
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setActTypes(actTypes);
        atomBO.setActIds(actIds);
        atomBO.setActComms(commodityBOS);
        atomBO.setCurrentDate(new Date());
        atomBO.setAdvanceFlag(false);
        atomBO.setActStatus("02");
        List<ActivityCommodityBO> commInfoBOS = this.actCommAtomService.listCommBySkuAndType(atomBO);
        if (CollectionUtils.isEmpty(commInfoBOS)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5185\u8d2d\u6d3b\u52a8\u5546\u54c1");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        ActivityCommodityBO actComm = commInfoBOS.get(0);
        if (null == actComm.getAvailableCount()) {
            log.error("\u672a\u914d\u7f6e\u5185\u8d2d\u5546\u54c1\u3010{}\u3011\u5e93\u5b58", (Object)reqBO.getSkuId());
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (actComm.getAvailableCount() <= 0 || reqBO.getSkuCount() > actComm.getAvailableCount()) {
            log.error("\u5185\u8d2d\u5546\u54c1\u3010{}\u3011\u5e93\u5b58\u4e0d\u8db3", (Object)reqBO.getSkuId());
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (null == reqBO.getTotalCount()) {
            reqBO.setTotalCount(actComm.getTotalCount());
        }
        if (null == reqBO.getAvailableCount()) {
            reqBO.setAvailableCount(actComm.getAvailableCount());
        }
        Double disCount = CalculationUtils.calPriceByFormula(reqBO.getSkuDisPriceL(), formula, reqBO.getPurchasePriceL(), reqBO.getSalePriceL());
        ConvertParamUtils.setPrice(reqBO, TkCalculatorUtils.transferY((long)reqBO.getSkuDisPriceL()), disCount);
        return disCount;
    }

    @Override
    public Double calSingleReducePrice(ActCommInfoBO reqBO, ActivityBO actBO) {
        Long amoPriceL;
        if (null == actBO || null == reqBO) {
            log.error("\u5355\u54c1\u51cf\u4ef7\u8ba1\u7b97\u5165\u53c2\u4e3a\u7a7a");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!"12".equals(actBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(actBO.getActivityId());
        HashSet<String> actTypes = new HashSet<String>();
        actTypes.add("12");
        ArrayList<ActivityCommodityBO> commodityBOS = new ArrayList<ActivityCommodityBO>(1);
        ActivityCommodityBO commodityBO = new ActivityCommodityBO();
        commodityBO.setObjType("99");
        commodityBO.setObjCode(reqBO.getSkuId().toString());
        commodityBOS.add(commodityBO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProvGoodsId())) {
            commodityBO = new ActivityCommodityBO();
            commodityBO.setObjCode(reqBO.getProvGoodsId());
            commodityBO.setObjType("12");
            commodityBOS.add(commodityBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMaterialId())) {
            commodityBO = new ActivityCommodityBO();
            commodityBO.setObjCode(reqBO.getMaterialId());
            commodityBO.setObjType("11");
            commodityBOS.add(commodityBO);
        }
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setActTypes(actTypes);
        atomBO.setActIds(actIds);
        atomBO.setActComms(commodityBOS);
        atomBO.setCurrentDate(new Date());
        atomBO.setAdvanceFlag(false);
        atomBO.setActStatus("02");
        List<ActivityCommodityBO> commInfoBOS = this.actCommAtomService.listCommBySkuAndType(atomBO);
        if (CollectionUtils.isEmpty(commInfoBOS)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u51cf\u4ef7\u6d3b\u52a8\u5546\u54c1");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        ActivityCommodityBO actComm = commInfoBOS.get(0);
        if (StringUtils.isNotBlank((CharSequence)actComm.getParam6())) {
            amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)Long.valueOf(actComm.getParam6()));
        } else if (StringUtils.isNotBlank((CharSequence)actComm.getParam7())) {
            Long price = TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(reqBO.getSkuDisPriceL().toString()), (BigDecimal)new BigDecimal(actComm.getParam7())).longValue();
            amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)price);
        } else if (StringUtils.isNotBlank((CharSequence)actComm.getParam8())) {
            amoPriceL = Long.valueOf(actComm.getParam8());
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u51cf\u4ef7\u8ba1\u7b97\u89c4\u5219");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), amoPriceL);
        return TkCalculatorUtils.transferY((long)amoPriceL);
    }

    @Override
    public Double calGlobalOpenPrice(ActCommInfoBO reqBO, ActivityBO actBO, String grade) {
        Long amoPriceL;
        if (null == actBO || null == reqBO || StringUtils.isBlank((CharSequence)grade)) {
            log.error("\u5168\u7403\u901a\u6d3b\u52a8\u8ba1\u7b97\u5165\u53c2\u4e3a\u7a7a");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        if (!"11".equals(actBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(actBO.getActivityId());
        HashSet<String> actTypes = new HashSet<String>();
        actTypes.add("11");
        ArrayList<ActivityCommodityBO> commodityBOS = new ArrayList<ActivityCommodityBO>(1);
        ActivityCommodityBO commodityBO = new ActivityCommodityBO();
        commodityBO.setObjType("99");
        commodityBO.setObjCode(reqBO.getSkuId().toString());
        commodityBOS.add(commodityBO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProvGoodsId())) {
            commodityBO = new ActivityCommodityBO();
            commodityBO.setObjCode(reqBO.getProvGoodsId());
            commodityBO.setObjType("12");
            commodityBOS.add(commodityBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMaterialId())) {
            commodityBO = new ActivityCommodityBO();
            commodityBO.setObjCode(reqBO.getMaterialId());
            commodityBO.setObjType("11");
            commodityBOS.add(commodityBO);
        }
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setActTypes(actTypes);
        atomBO.setActIds(actIds);
        atomBO.setActComms(commodityBOS);
        atomBO.setCurrentDate(new Date());
        atomBO.setAdvanceFlag(false);
        atomBO.setActStatus("02");
        List<ActivityCommodityBO> commInfoBOS = this.actCommAtomService.listCommBySkuAndType(atomBO);
        if (CollectionUtils.isEmpty(commInfoBOS)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5168\u7403\u901a\u6d3b\u52a8\u5546\u54c1");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        ActivityCommodityBO actComm = commInfoBOS.get(0);
        if (StringUtils.isNotBlank((CharSequence)actComm.getParam6()) && "01".equals(grade)) {
            amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)Long.valueOf(actComm.getParam6()));
        } else if (StringUtils.isNotBlank((CharSequence)actComm.getParam7()) && "02".equals(grade)) {
            amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)Long.valueOf(actComm.getParam7()));
        } else if (StringUtils.isNotBlank((CharSequence)actComm.getParam8()) && "03".equals(grade)) {
            amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)Long.valueOf(actComm.getParam8()));
        } else if (StringUtils.isNotBlank((CharSequence)actComm.getParam9()) && "04".equals(grade)) {
            amoPriceL = TkCalculatorUtils.sub((long)reqBO.getSkuDisPriceL(), (long)Long.valueOf(actComm.getParam9()));
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u5168\u7403\u901a\u6d3b\u52a8\u5546\u54c1\u6863\u4f4d\u4ef7\u683c");
            ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), 0L);
            return new Double(0.0);
        }
        ConvertParamUtils.setPrice(reqBO, reqBO.getSkuDisPriceL(), amoPriceL);
        return TkCalculatorUtils.transferY((long)amoPriceL);
    }
}

