/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.ActCombinationDetailAtomService;
import com.tydic.newretail.act.bo.ActivityCombinationDetailInfoBO;
import com.tydic.newretail.act.dao.ActivityCombinationDetailDAO;
import com.tydic.newretail.act.dao.po.ActivityCombinationDetailPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActCombinationDetailAtomServiceImpl
implements ActCombinationDetailAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActCombinationDetailAtomServiceImpl.class);
    @Autowired
    private ActivityCombinationDetailDAO activityCombinationDetailDAO;

    @Override
    public void saveActivityCombinationDetail(List<ActivityCombinationDetailInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityCombinationDetailPO> pos = new ArrayList<ActivityCombinationDetailPO>(reqBOs.size());
        for (ActivityCombinationDetailInfoBO bo : reqBOs) {
            ActivityCombinationDetailPO po = new ActivityCombinationDetailPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCrtTime(new Date());
            po.setIsValid("1");
            pos.add(po);
        }
        try {
            this.activityCombinationDetailDAO.insertByBatch(pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6279\u91cf\u65b0\u589e\u7ec4\u5408\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u7ec4\u5408\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public void removeByCombinationId(Long combinationId) {
        if (null == combinationId) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityCombinationDetailDAO.deleteByCombinationId(combinationId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public void invalidBatchByCombinationIds(Set<Long> combinationIds) {
        if (CollectionUtils.isEmpty(combinationIds)) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityCombinationDetailDAO.invalidByCombinationIds(combinationIds);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public List<ActivityCombinationDetailInfoBO> selectByCombinationId(ActivityCombinationDetailInfoBO reqBO) {
        ArrayList<ActivityCombinationDetailInfoBO> activityCombinationDetailInfoBOS = new ArrayList<ActivityCombinationDetailInfoBO>();
        ActivityCombinationDetailPO activityCombinationDetailPO = new ActivityCombinationDetailPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityCombinationDetailPO);
        List<ActivityCombinationDetailPO> pos = null;
        try {
            pos = this.activityCombinationDetailDAO.selectByCondition(activityCombinationDetailPO);
        }
        catch (Exception e) {
            TkThrExceptionUtils.thrQryExce((String)"\u6761\u4ef6\u67e5\u8be2\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u51fa\u9519\uff01");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (ActivityCombinationDetailPO po : pos) {
                ActivityCombinationDetailInfoBO bo = new ActivityCombinationDetailInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                activityCombinationDetailInfoBOS.add(bo);
            }
        }
        return activityCombinationDetailInfoBOS;
    }
}

