/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.bo.ActAndCommodityBO;
import com.tydic.newretail.act.bo.ActCommApplyScopeBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.busi.impl.QryActivityBusiServiceImpl;
import com.tydic.newretail.act.dao.ActivityCommodityDao;
import com.tydic.newretail.act.dao.po.ActAndCommodityPO;
import com.tydic.newretail.act.dao.po.ActivityCommodityPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActCommAtomServiceImpl
implements ActCommAtomService {
    private static final Logger log = LoggerFactory.getLogger(QryActivityBusiServiceImpl.class);
    @Autowired
    private ActivityCommodityDao activityCommodityDao;

    @Override
    public List<ActivityCommodityBO> listCommBySkuAndType(QryActCommReqAtomBO reqBO) {
        List<ActivityCommodityPO> pos = null;
        if (CollectionUtils.isNotEmpty(reqBO.getActComms())) {
            pos = new ArrayList<ActivityCommodityPO>(reqBO.getActComms().size());
            for (ActivityCommodityBO bo : reqBO.getActComms()) {
                pos.add(ActivityCommodityPO.toActivityCommodityPO(bo));
            }
        }
        Date currentToStartDate = null;
        Date currentToAdvDate = null;
        if (reqBO.getAdvanceFlag().booleanValue()) {
            currentToAdvDate = reqBO.getCurrentDate();
        } else {
            currentToStartDate = reqBO.getCurrentDate();
        }
        try {
            pos = this.activityCommodityDao.selectBySku(pos, reqBO.getActIds(), reqBO.getActTypes(), currentToStartDate, currentToAdvDate, reqBO.getStockFlag(), reqBO.getActStatus());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityCommodityBO> bos = new ArrayList<ActivityCommodityBO>(pos.size());
        for (ActivityCommodityPO po : pos) {
            bos.add(po.toActivityCommodityBO());
        }
        return bos;
    }

    @Override
    public List<ActivityCommodityBO> listCommStockBySkuAndType(QryActCommReqAtomBO reqBO) {
        List<ActivityCommodityPO> pos = null;
        if (CollectionUtils.isNotEmpty(reqBO.getActComms())) {
            pos = new ArrayList<ActivityCommodityPO>(reqBO.getActComms().size());
            for (ActivityCommodityBO bo : reqBO.getActComms()) {
                pos.add(ActivityCommodityPO.toActivityCommodityPO(bo));
            }
        }
        Date currentToStartDate = null;
        Date currentToAdvDate = null;
        if (reqBO.getAdvanceFlag().booleanValue()) {
            currentToAdvDate = reqBO.getCurrentDate();
        } else {
            currentToStartDate = reqBO.getCurrentDate();
        }
        try {
            pos = this.activityCommodityDao.selectStockBySku(pos, reqBO.getActIds(), reqBO.getActTypes(), currentToStartDate, currentToAdvDate, reqBO.getStockFlag());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityCommodityBO> bos = new ArrayList<ActivityCommodityBO>(pos.size());
        for (ActivityCommodityPO po : pos) {
            bos.add(po.toActivityCommodityBO());
        }
        return bos;
    }

    @Override
    public void modifyByBatch(List<ActivityCommodityBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityCommodityPO> pos = new ArrayList<ActivityCommodityPO>(reqBOs.size());
        for (ActivityCommodityBO bo : reqBOs) {
            this.checkActComm(bo);
            pos.add(ActivityCommodityPO.toActivityCommodityPO(bo));
        }
        try {
            this.activityCommodityDao.updateByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0004", "\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25");
        }
    }

    private void checkActComm(ActivityCommodityBO bo) {
        if (null == bo.getSeqId()) {
            log.error("\u4e3b\u952eID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u4e3b\u952eID\u4e3a\u7a7a");
        }
    }

    @Override
    public List<ActivityCommodityBO> listCommByActIdAndObjTypes(QryActCommReqAtomBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getActIds())) {
            log.error("\u6d3b\u52a8ID\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u96c6\u5408\u4e3a\u7a7a");
        }
        List<ActivityCommodityPO> pos = this.activityCommodityDao.selectByActAndObjType(reqBO.getActIds(), reqBO.getObjTypes());
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityCommodityBO> bos = new ArrayList<ActivityCommodityBO>(pos.size());
        for (ActivityCommodityPO po : pos) {
            bos.add(po.toActivityCommodityBO());
        }
        return bos;
    }

    @Override
    public void invalidBatchByActId(Set<Long> actIds) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityCommodityDao.invalidByActIds(actIds);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d3b\u52a8\u5546\u54c1\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u66f4\u65b0\u6d3b\u52a8\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    @Override
    public void saveByBatch(List<ActivityCommodityBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityCommodityPO> pos = new ArrayList<ActivityCommodityPO>(reqBOs.size());
        for (ActivityCommodityBO bo : reqBOs) {
            if (StringUtils.isBlank((CharSequence)bo.getActivityCode()) || null == bo.getActivityId() || StringUtils.isBlank((CharSequence)bo.getActivityType())) {
                log.error("\u6d3b\u52a8ID\u3001\u6d3b\u52a8\u7f16\u7801\u6216\u7c7b\u578b\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u3001\u6d3b\u52a8\u7f16\u7801\u6216\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getObjType()) || StringUtils.isBlank((CharSequence)bo.getObjCode())) {
                log.error("\u6d3b\u52a8\u5bf9\u8c61\u7f16\u7801\u6216\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5bf9\u8c61\u7f16\u7801\u6216\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (null == bo.getStartTime() || null == bo.getEndTime()) {
                log.error("\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a");
            }
            pos.add(ActivityCommodityPO.toActivityCommodityPO(bo));
        }
        try {
            this.activityCommodityDao.insertByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public void removeByActId(Long actId) {
        if (null == actId) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityCommodityDao.deleteByActId(actId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u6d3b\u52a8\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public List<ActivityCommodityBO> selectByActIdAndObjType(ActivityCommodityBO record) {
        if (null == record.getActivityId() || StringUtils.isEmpty((CharSequence)record.getObjType())) {
            log.error("\u6d3b\u52a8\u5546\u54c1\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5546\u54c1\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        ActivityCommodityPO reqPO = new ActivityCommodityPO();
        BeanUtils.copyProperties((Object)record, (Object)reqPO);
        List<Object> rspList = new ArrayList();
        try {
            rspList = this.activityCommodityDao.selectByActIdAndObjType(reqPO);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6d3b\u52a8id\u548c\u5bf9\u8c61\u7c7b\u578b\u67e5\u8be2\u6d3b\u52a8\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u6d3b\u52a8id\u548c\u5bf9\u8c61\u7c7b\u578b\u67e5\u8be2\u6d3b\u52a8\u5546\u54c1\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(rspList)) {
            return null;
        }
        ArrayList<ActivityCommodityBO> bos = new ArrayList<ActivityCommodityBO>(rspList.size());
        for (ActivityCommodityPO activityCommodityPO : rspList) {
            bos.add(activityCommodityPO.toActivityCommodityBO());
        }
        return bos;
    }

    @Override
    public List<ActivityCommodityBO> selectByApplyScope(ActCommApplyScopeBO record) {
        if (null == record) {
            log.error("\u6d3b\u52a8\u5546\u54c1\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5546\u54c1\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        List<Object> rspList = new ArrayList();
        try {
            rspList = this.activityCommodityDao.selectmApplyScope(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u67e5\u8be2\u6d3b\u52a8\u5546\u54c1\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(rspList)) {
            return null;
        }
        ArrayList<ActivityCommodityBO> bos = new ArrayList<ActivityCommodityBO>(rspList.size());
        for (ActivityCommodityPO activityCommodityPO : rspList) {
            bos.add(activityCommodityPO.toActivityCommodityBO());
        }
        return bos;
    }

    @Override
    public void updateStatusByAct(Set<Long> actIds, String actStatus) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)actStatus)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
        }
        try {
            this.activityCommodityDao.updateStatusByAct(actIds, actStatus);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
        }
    }

    @Override
    public void updateStatusBatch(List<ActivityCommodityBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ActivityCommodityPO> pos = new ArrayList<ActivityCommodityPO>();
        for (ActivityCommodityBO bo : reqBOs) {
            if (null == bo.getActivityId()) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u3010activityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u3010activityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getActivityStatus())) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u6d3b\u52a8\u72b6\u6001\u3010activityStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u6d3b\u52a8\u72b6\u6001\u3010activityStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ActivityCommodityPO po = new ActivityCommodityPO();
            po.setActivityId(bo.getActivityId());
            po.setActivityStatus(bo.getActivityStatus());
            pos.add(po);
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            try {
                this.activityCommodityDao.updateStatusBatch(pos);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u5546\u54c1\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            }
        }
    }

    @Override
    public List<ActAndCommodityBO> selectCommodityAct(Set<String> materials, String actType, String actSaleType, List<String> actStatus) {
        if (CollectionUtils.isEmpty(materials)) {
            log.error("\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u5165\u53c2\u673a\u578b\u96c6\u5408\u3010materials\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u5165\u53c2\u673a\u578b\u96c6\u5408\u3010materials\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ActAndCommodityBO> actAndCommodityBOList = new ArrayList<ActAndCommodityBO>();
        if (CollectionUtils.isEmpty(actStatus)) {
            actStatus = new ArrayList<String>();
            actStatus.add("00");
            actStatus.add("01");
            actStatus.add("02");
            actStatus.add("03");
        }
        List<ActAndCommodityPO> actAndCommodityPOS = null;
        try {
            actAndCommodityPOS = this.activityCommodityDao.selectCommodityAct(materials, actType, actSaleType, actStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u5931\u8d25");
            TkThrExceptionUtils.thrEmptyExce((String)"\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(actAndCommodityPOS)) {
            for (ActAndCommodityPO po : actAndCommodityPOS) {
                ActAndCommodityBO actAndCommodityBO = new ActAndCommodityBO();
                BeanUtils.copyProperties((Object)po, (Object)actAndCommodityBO);
                actAndCommodityBOList.add(actAndCommodityBO);
            }
        }
        return actAndCommodityBOList;
    }
}

