/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActCostAtomService;
import com.tydic.newretail.act.atom.impl.ActInfoAtomServiceImpl;
import com.tydic.newretail.act.bo.ActivityCostInfoBO;
import com.tydic.newretail.act.dao.ActivityCostDAO;
import com.tydic.newretail.act.dao.po.ActivityCostPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActCostAtomServiceImpl
implements ActCostAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActInfoAtomServiceImpl.class);
    @Autowired
    private ActivityCostDAO activityCostDAO;

    @Override
    public ActivityCostInfoBO saveActCostInfo(ActivityCostInfoBO reqBO) {
        this.checkActCostParams(reqBO);
        ActivityCostPO po = new ActivityCostPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setCrtTime(new Date());
        po.setIsValid("1");
        try {
            this.activityCostDAO.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
        }
        ActivityCostInfoBO bo = new ActivityCostInfoBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }

    @Override
    public ActivityCostInfoBO getActCostInfo(ActivityCostInfoBO reqBO) {
        ActivityCostPO po;
        boolean conditionEmpty;
        boolean bl = conditionEmpty = null == reqBO.getCostCode();
        if (null == reqBO || conditionEmpty) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u5355\u636eID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8\u8d39\u7528\u5355\u636eID\u4e3a\u7a7a");
        }
        ActivityCostPO record = new ActivityCostPO();
        record.setCostCode(reqBO.getCostCode());
        try {
            po = this.activityCostDAO.selectByCostCode(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
        }
        if (null == po) {
            return null;
        }
        ActivityCostInfoBO bo = new ActivityCostInfoBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }

    @Override
    public ActivityCostInfoBO modifyActCostInfo(ActivityCostInfoBO reqBO, boolean selectFlag) {
        if (null == reqBO.getCostCode()) {
            log.error("\u8d39\u7528\u5355\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d39\u7528\u5355\u53f7\u4e3a\u7a7a");
        }
        ActivityCostPO po = new ActivityCostPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setLastUpdTime(new Date());
        try {
            if (selectFlag) {
                this.activityCostDAO.updateByPrimaryKeySelective(po);
            } else {
                this.activityCostDAO.updateByPrimaryKey(po);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u66f4\u65b0\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
        }
        ActivityCostInfoBO bo = new ActivityCostInfoBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }

    @Override
    public List<ActivityCostInfoBO> selectByPage(ActivityCostInfoBO record, Page<Map<String, Object>> page) {
        ActivityCostPO po = new ActivityCostPO();
        BeanUtils.copyProperties((Object)record, (Object)po);
        List<ActivityCostPO> pos = null;
        try {
            pos = this.activityCostDAO.selectByPage(page, po);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityCostInfoBO> bos = new ArrayList<ActivityCostInfoBO>(pos.size());
        for (ActivityCostPO activityCostPO : pos) {
            ActivityCostInfoBO bo = new ActivityCostInfoBO();
            BeanUtils.copyProperties((Object)activityCostPO, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    @Override
    public List<ActivityCostInfoBO> selectByCondition(ActivityCostInfoBO record) {
        ActivityCostPO po = new ActivityCostPO();
        BeanUtils.copyProperties((Object)record, (Object)po);
        List<ActivityCostPO> pos = null;
        try {
            pos = this.activityCostDAO.selectByCondition(po);
        }
        catch (Exception e) {
            log.error("\u4e0d\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u4e0d\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityCostInfoBO> bos = new ArrayList<ActivityCostInfoBO>(pos.size());
        for (ActivityCostPO activityCostPO : pos) {
            ActivityCostInfoBO bo = new ActivityCostInfoBO();
            BeanUtils.copyProperties((Object)activityCostPO, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    private void checkActCostParams(ActivityCostInfoBO reqBO) {
        if (null == reqBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityName())) {
            log.error("\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCostCode())) {
            log.error("\u8d39\u7528\u5355\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d39\u7528\u5355\u53f7\u4e3a\u7a7a");
        }
        if (null == reqBO.getCostAmount()) {
            log.error("\u8d39\u7528\u91d1\u989d\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d39\u7528\u91d1\u989d\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCompanyType())) {
            log.error("\u516c\u53f8\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCompanyName())) {
            log.error("\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCompanyCode())) {
            log.error("\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAgent())) {
            log.error("\u7ecf\u529e\u4eba\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7ecf\u529e\u4eba\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getStatus())) {
            log.error("\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u72b6\u6001\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBelongRegion())) {
            log.error("\u5f52\u5c5e\u673a\u6784\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5f52\u5c5e\u673a\u6784\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBelongCode())) {
            log.error("\u5f52\u5c5e\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5f52\u5c5e\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCreateUser())) {
            log.error("\u521b\u5efa\u4eba\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u521b\u5efa\u4eba\u4e3a\u7a7a");
        }
    }
}

