/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.bo.QryActReqAtomBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.dao.ActivityDao;
import com.tydic.newretail.act.dao.po.ActivityPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActInfoAtomServiceImpl
implements ActInfoAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActInfoAtomServiceImpl.class);
    @Autowired
    private ActivityDao activityDao;

    @Override
    public ActivityBO getActivityInfo(ActivityBO reqBO) {
        ActivityPO po;
        boolean conditionEmpty;
        boolean bl = conditionEmpty = null == reqBO.getActivityId() && StringUtils.isBlank((CharSequence)reqBO.getActivityCode());
        if (null == reqBO || conditionEmpty) {
            log.error("\u6d3b\u52a8ID\u548c\u6d3b\u52a8\u7f16\u7801\u5fc5\u586b\u5176\u4e00");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u548c\u6d3b\u52a8\u7f16\u7801\u5fc5\u586b\u5176\u4e00");
        }
        ActivityPO record = new ActivityPO();
        record.setActivityId(reqBO.getActivityId());
        record.setActivityCode(reqBO.getActivityCode());
        record.setActivityStatus(reqBO.getActivityStatus());
        try {
            po = this.activityDao.selectByIdOrCode(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        if (null == po) {
            return null;
        }
        return po.toActivityBO();
    }

    @Override
    public List<ActivityBO> listActivityInfo(Set<Long> actIds, Date date) {
        List<ActivityPO> activityPOS;
        try {
            activityPOS = this.activityDao.selectByIds(actIds, date, null);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(activityPOS)) {
            return null;
        }
        ArrayList<ActivityBO> bos = new ArrayList<ActivityBO>(activityPOS.size());
        for (ActivityPO po : activityPOS) {
            bos.add(po.toActivityBO());
        }
        return bos;
    }

    @Override
    public List<ActivityBO> listActivityInfo(Set<Long> actIds) {
        List<ActivityPO> activityPOS;
        try {
            activityPOS = this.activityDao.selectByIdList(actIds);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(activityPOS)) {
            return null;
        }
        ArrayList<ActivityBO> bos = new ArrayList<ActivityBO>(activityPOS.size());
        for (ActivityPO po : activityPOS) {
            bos.add(po.toActivityBO());
        }
        return bos;
    }

    @Override
    public List<ActivityBO> listActByType(QryActReqAtomBO reqBO) {
        List<ActivityPO> pos;
        try {
            pos = this.activityDao.selectByType(reqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityBO> bos = new ArrayList<ActivityBO>(pos.size());
        for (ActivityPO po : pos) {
            bos.add(po.toActivityBO());
        }
        return bos;
    }

    @Override
    public List<ActivityBO> listActByCondition(ActivityBO reqBO) {
        List<ActivityPO> pos;
        ActivityPO record = null;
        if (null != reqBO) {
            record = ActivityPO.toActivityPO(reqBO);
        }
        try {
            pos = this.activityDao.selectByCondition(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityBO> bos = new ArrayList<ActivityBO>(pos.size());
        for (ActivityPO po : pos) {
            bos.add(po.toActivityBO());
        }
        return bos;
    }

    @Override
    public Integer modifyBatch(List<ActivityBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6d3b\u52a8\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ActivityPO> pos = new ArrayList<ActivityPO>(reqBOs.size());
        for (ActivityBO bo : reqBOs) {
            pos.add(ActivityPO.toActivityPO(bo));
        }
        try {
            int count = this.activityDao.updateBatch(pos);
            return count;
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0004", "\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public void modifyAct(ActivityBO reqBO, boolean selectFlag) {
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityPO po = ActivityPO.toActivityPO(reqBO);
        po.setLastUpdTime(new Date());
        try {
            if (selectFlag) {
                this.activityDao.updateByPrimaryKeySelective(po);
            } else {
                this.activityDao.updateByPrimaryKey(po);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u66f4\u65b0\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public ActivityBO saveActInfo(ActivityBO reqBO) {
        this.checkActParams(reqBO);
        ActivityPO po = ActivityPO.toActivityPO(reqBO);
        try {
            this.activityDao.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        return po.toActivityBO();
    }

    @Override
    public Set<Long> selectByIdsAndSaleType(String saleTpye, Set<Long> actIds) {
        List<ActivityPO> activityPOS;
        if (CollectionUtils.isEmpty(actIds)) {
            return null;
        }
        HashSet<Long> allowActs = new HashSet<Long>(actIds.size());
        try {
            activityPOS = this.activityDao.selectByIds(actIds, null, saleTpye);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(activityPOS)) {
            return null;
        }
        for (ActivityPO po : activityPOS) {
            allowActs.add(po.getActivityId());
        }
        return allowActs;
    }

    private void checkActParams(ActivityBO reqBO) {
        if (null == reqBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityCode())) {
            log.error("\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityStatus())) {
            log.error("\u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
        }
        if (null == reqBO.getStartTime() || null == reqBO.getEndTime()) {
            log.error("\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a");
        }
    }
}

