/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActParticipateAtomService;
import com.tydic.newretail.act.bo.ActivityParticipateRecordBO;
import com.tydic.newretail.act.bo.StaffPriceParticipateRecordBO;
import com.tydic.newretail.act.busi.impl.ActParticipationBusiServiceImpl;
import com.tydic.newretail.act.dao.ActivityParticipateRecordDao;
import com.tydic.newretail.act.dao.StaffPriceParticipateRecordDao;
import com.tydic.newretail.act.dao.po.ActivityParticipateRecordPO;
import com.tydic.newretail.act.dao.po.StaffPriceParticipateRecordPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActParticipateAtomServiceImpl
implements ActParticipateAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActParticipationBusiServiceImpl.class);
    @Autowired
    private ActivityParticipateRecordDao activityParticipateRecordDao;
    @Autowired
    private StaffPriceParticipateRecordDao staffPriceParticipateRecordDao;

    @Override
    public void saveActParticipateRecord(List<StaffPriceParticipateRecordBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        Date nowDate = new Date();
        ArrayList<StaffPriceParticipateRecordPO> staffPricePOs = new ArrayList<StaffPriceParticipateRecordPO>(reqBOs.size());
        ArrayList<ActivityParticipateRecordPO> actParPOs = new ArrayList<ActivityParticipateRecordPO>(reqBOs.size());
        for (StaffPriceParticipateRecordBO record : reqBOs) {
            if (null == record.getActivityId() || StringUtils.isBlank((CharSequence)record.getActivityType())) {
                log.error("\u6d3b\u52a8ID\u6216\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
                throw new ResourceException("0001", "\u6d3b\u52a8ID\u6216\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
            }
            ActivityParticipateRecordPO actPar = new ActivityParticipateRecordPO();
            actPar.setActivityId(record.getActivityId());
            actPar.setActivityType(record.getActivityType());
            actPar.setActivityPhaseId(record.getActivityPhaseId());
            actPar.setParticipateTime(nowDate);
            actPar.setTenantId(0L);
            actPar.setUid(record.getUid());
            actPar.setParam1(record.getParam1());
            actPar.setParam2(record.getParam2());
            actParPOs.add(actPar);
            if (null == record.getUid() || null == record.getSkuId()) continue;
            staffPricePOs.add(StaffPriceParticipateRecordPO.toStaffPriceParticipateRecordPO(record));
        }
        if (CollectionUtils.isNotEmpty(staffPricePOs)) {
            try {
                this.staffPriceParticipateRecordDao.insertSelectiveBatch(staffPricePOs);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u65b0\u589e\u5185\u8d2d\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589e\u5185\u8d2d\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25");
            }
        }
        if (CollectionUtils.isNotEmpty(actParPOs)) {
            try {
                this.activityParticipateRecordDao.insertSelectiveBatch(actParPOs);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25");
            }
        }
    }

    @Override
    public Integer getCountByActIdAndUid(Long actId, Long uid, Boolean isToday) {
        if (null == actId || null == uid) {
            log.error("\u6d3b\u52a8ID\u6216\u4f1a\u5458ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u6216\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        ActivityParticipateRecordPO record = new ActivityParticipateRecordPO();
        record.setActivityId(actId);
        record.setUid(uid);
        if (isToday != null) {
            record.setToday(isToday);
        }
        int count = 0;
        try {
            count = this.activityParticipateRecordDao.getCount(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u5931\u8d25");
        }
        return count;
    }

    @Override
    public Integer getTotalCountByActIdAndUidAndParam1(ActivityParticipateRecordBO reqBO) {
        if (null == reqBO || null == reqBO.getActivityId() || null == reqBO.getUid()) {
            log.error("\u6d3b\u52a8ID\u6216\u7528\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u6216\u7528\u6237ID\u4e3a\u7a7a");
        }
        ActivityParticipateRecordPO record = new ActivityParticipateRecordPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setToday(reqBO.getbToday());
        int count = 0;
        try {
            count = this.activityParticipateRecordDao.getTotalCount(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u5931\u8d25");
        }
        return count;
    }
}

