/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActRelationAtomService;
import com.tydic.newretail.act.bo.ActivityRelationBO;
import com.tydic.newretail.act.dao.ActivityRelationDao;
import com.tydic.newretail.act.dao.po.ActivityRelationPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActRelationAtomServiceImpl
implements ActRelationAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActRelationAtomServiceImpl.class);
    @Autowired
    private ActivityRelationDao activityRelationDao;

    @Override
    public List<ActivityRelationBO> listRelationById(Set<Long> actIds, String relType) {
        List<ActivityRelationPO> pos;
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            pos = this.activityRelationDao.selectByActId(actIds, relType);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u95f4\u5173\u7cfb\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u95f4\u5173\u7cfb\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityRelationBO> rspList = new ArrayList<ActivityRelationBO>(pos.size());
        for (ActivityRelationPO po : pos) {
            rspList.add(po.toActivityRelationBO());
        }
        return rspList;
    }

    @Override
    public List<ActivityRelationBO> listRelationByType(Set<String> actTypes, String relType) {
        List<ActivityRelationPO> pos;
        if (CollectionUtils.isEmpty(actTypes)) {
            log.error("\u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
        }
        try {
            pos = this.activityRelationDao.selectByActType(actTypes, relType);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u95f4\u5173\u7cfb\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u95f4\u5173\u7cfb\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityRelationBO> bos = new ArrayList<ActivityRelationBO>(pos.size());
        for (ActivityRelationPO po : pos) {
            bos.add(po.toActivityRelationBO());
        }
        return bos;
    }

    @Override
    public void saveBatch(List<ActivityRelationBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityRelationPO> pos = new ArrayList<ActivityRelationPO>(reqBOs.size());
        for (ActivityRelationBO relation : reqBOs) {
            pos.add(ActivityRelationPO.toActivityRelationPO(relation));
        }
        try {
            this.activityRelationDao.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u5173\u7cfb\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u5173\u7cfb\u5931\u8d25");
        }
    }

    @Override
    public void removeByCombinationId(Long combinationId) {
        if (null == combinationId) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityRelationDao.deleteByCombinationId(combinationId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u5173\u7cfb\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u5173\u7cfb\u5931\u8d25");
        }
    }

    @Override
    public void invalidBatchByCombinationIds(Set<Long> combinationIds) {
        if (CollectionUtils.isEmpty(combinationIds)) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityRelationDao.invalidByCombinationIds(combinationIds);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u5220\u9664\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u5931\u8d25");
        }
    }
}

