/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.ActReservoirLogAtomService;
import com.tydic.newretail.act.bo.ActivityReservoirLogInfoBO;
import com.tydic.newretail.act.dao.ActivityReservoirLogDAO;
import com.tydic.newretail.act.dao.po.ActivityReservoirLogPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActReservoirLogAtomServiceImpl
implements ActReservoirLogAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActReservoirLogAtomServiceImpl.class);
    @Autowired
    private ActivityReservoirLogDAO activityReservoirLogDAO;

    @Override
    public ActivityReservoirLogInfoBO saveActReservoirLogInfo(ActivityReservoirLogInfoBO reqBO) {
        this.checkParams(reqBO);
        ActivityReservoirLogPO po = new ActivityReservoirLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setCrtTime(new Date());
        try {
            this.activityReservoirLogDAO.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u84c4\u6c34\u6c60\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u84c4\u6c34\u6c60\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
        }
        ActivityReservoirLogInfoBO bo = new ActivityReservoirLogInfoBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }

    @Override
    public void saveByBatch(List<ActivityReservoirLogInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityReservoirLogPO> pos = new ArrayList<ActivityReservoirLogPO>(reqBOs.size());
        for (ActivityReservoirLogInfoBO bo : reqBOs) {
            this.checkParams(bo);
            ActivityReservoirLogPO po = new ActivityReservoirLogPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCrtTime(new Date());
            pos.add(po);
        }
        try {
            this.activityReservoirLogDAO.insertByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u84c4\u6c34\u6c60\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u84c4\u6c34\u6c60\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void checkParams(ActivityReservoirLogInfoBO reqBO) {
        if (null == reqBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getReservoirId()) {
            log.error("\u84c4\u6c34\u6c60ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u84c4\u6c34\u6c60ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperationType())) {
            log.error("\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
    }
}

