/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActTouchSpotAtomService;
import com.tydic.newretail.act.bo.ActivityTouchSpotBO;
import com.tydic.newretail.act.dao.ActivityTouchSpotDao;
import com.tydic.newretail.act.dao.po.ActivityTouchSpotPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActTouchSpotAtomServiceImpl
implements ActTouchSpotAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActTouchSpotAtomServiceImpl.class);
    @Autowired
    ActivityTouchSpotDao activityTouchSpotDao;

    @Override
    public List<ActivityTouchSpotBO> selectByCondition(ActivityTouchSpotBO reqBO) {
        ArrayList<ActivityTouchSpotBO> list = new ArrayList<ActivityTouchSpotBO>();
        ActivityTouchSpotPO po = new ActivityTouchSpotPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<ActivityTouchSpotPO> poListl = null;
        try {
            poListl = this.activityTouchSpotDao.selectByCondition(po);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(poListl)) {
            for (ActivityTouchSpotPO po1 : poListl) {
                ActivityTouchSpotBO bo = new ActivityTouchSpotBO();
                BeanUtils.copyProperties((Object)po1, (Object)bo);
                list.add(bo);
            }
        }
        return list;
    }

    @Override
    public void saveTouchSpot(List<ActivityTouchSpotBO> reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        for (ActivityTouchSpotBO activityTouchSpotBO : reqBO) {
            if (null == activityTouchSpotBO.getActivityId()) {
                log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
                throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
            }
            if (null != activityTouchSpotBO.getTouchSpotId()) continue;
            log.error("\u89e6\u70b9id\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u89e6\u70b9id\u4e3a\u7a7a");
        }
        ArrayList<ActivityTouchSpotPO> pos = new ArrayList<ActivityTouchSpotPO>();
        for (ActivityTouchSpotBO bo : reqBO) {
            ActivityTouchSpotPO po = new ActivityTouchSpotPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            this.activityTouchSpotDao.insertSelective(pos);
        }
        catch (Exception exception) {
            log.error("\u6d3b\u52a8\u89e6\u70b9\u65b0\u589e\u5931\u8d25\uff1a" + exception.getMessage());
            throw new ResourceException("0003", "\u6d3b\u52a8\u89e6\u70b9\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void removeTouchSpot(Long activityId) {
        if (null == activityId) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityTouchSpotDao.deleteByActivityId(activityId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u5220\u9664\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25");
        }
    }

    @Override
    public List<ActivityTouchSpotBO> selectByActIds(Set<Long> actIds) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u6d3b\u52a8IDs\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8IDs\u4e3a\u7a7a");
        }
        ArrayList<ActivityTouchSpotBO> list = new ArrayList<ActivityTouchSpotBO>();
        List<Object> pos = new ArrayList();
        try {
            pos = this.activityTouchSpotDao.selByActIds(actIds, null);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6d3b\u52a8ID\u96c6\u5408\u67e5\u8be2\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6839\u636e\u6d3b\u52a8ID\u96c6\u5408\u67e5\u8be2\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (ActivityTouchSpotPO activityTouchSpotPO : pos) {
                ActivityTouchSpotBO bo = new ActivityTouchSpotBO();
                BeanUtils.copyProperties((Object)activityTouchSpotPO, (Object)bo);
                list.add(bo);
            }
        }
        return list;
    }

    @Override
    public void invalidByActIds(Set<Long> actIds) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityTouchSpotDao.invalidByActIds(actIds);
        }
        catch (Exception e) {
            log.error("\u5931\u6548\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u5931\u6548\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25");
        }
    }

    @Override
    public void updateStatusByAct(Set<Long> actIds, String actStatus) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)actStatus)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
        }
        try {
            this.activityTouchSpotDao.updateStatusByAct(actIds, actStatus);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
        }
    }

    @Override
    public Set<Long> selectByIdsAndTouch(String touchSpotId, Set<Long> actIds) {
        if (CollectionUtils.isEmpty(actIds)) {
            return null;
        }
        HashSet<Long> allowActs = new HashSet<Long>(actIds.size());
        List<Object> pos = new ArrayList();
        try {
            pos = this.activityTouchSpotDao.selByActIds(actIds, touchSpotId);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6d3b\u52a8ID\u96c6\u5408\u67e5\u8be2\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6839\u636e\u6d3b\u52a8ID\u96c6\u5408\u67e5\u8be2\u6d3b\u52a8\u89e6\u70b9\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (ActivityTouchSpotPO activityTouchSpotPO : pos) {
                allowActs.add(activityTouchSpotPO.getActivityId());
            }
        }
        return allowActs;
    }

    @Override
    public void updateStatusBatch(List<ActivityTouchSpotBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ActivityTouchSpotPO> pos = new ArrayList<ActivityTouchSpotPO>();
        for (ActivityTouchSpotBO bo : reqBOs) {
            if (null == bo.getActivityId()) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u3010activityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u3010activityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getActivityStatus())) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u6d3b\u52a8\u72b6\u6001\u3010activityStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u6d3b\u52a8\u72b6\u6001\u3010activityStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ActivityTouchSpotPO po = new ActivityTouchSpotPO();
            po.setActivityId(bo.getActivityId());
            po.setActivityStatus(bo.getActivityStatus());
            pos.add(po);
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            try {
                this.activityTouchSpotDao.updateStatusBatch(pos);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u89e6\u70b9\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            }
        }
    }
}

