/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActUserAtomService;
import com.tydic.newretail.act.bo.ActivityUserBO;
import com.tydic.newretail.act.bo.MatchRuleBO;
import com.tydic.newretail.act.bo.UserInstanceBO;
import com.tydic.newretail.act.bo.UserInstanceSetBO;
import com.tydic.newretail.act.bo.UserSetBO;
import com.tydic.newretail.act.bo.UserSetInstanceBO;
import com.tydic.newretail.act.dao.ActivityUserDao;
import com.tydic.newretail.act.dao.MatchRuleDao;
import com.tydic.newretail.act.dao.UserInstanceDao;
import com.tydic.newretail.act.dao.UserSetDao;
import com.tydic.newretail.act.dao.po.ActivityUserMatchPO;
import com.tydic.newretail.act.dao.po.ActivityUserPO;
import com.tydic.newretail.act.dao.po.MatchRulePO;
import com.tydic.newretail.act.dao.po.UserInstancePO;
import com.tydic.newretail.act.dao.po.UserInstanceSetPO;
import com.tydic.newretail.act.dao.po.UserSetPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActUserAtomServiceImpl
implements ActUserAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActUserAtomServiceImpl.class);
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private UserInstanceDao userInstanceDao;
    @Autowired
    private MatchRuleDao matchRuleDao;
    @Autowired
    private UserSetDao userSetDao;

    @Override
    public List<ActivityUserBO> listUserMatch(Set<Long> actIds) {
        List<ActivityUserMatchPO> pos;
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            pos = this.activityUserDao.selectByActIds(actIds);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u8303\u56f4\u89c4\u5219\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u7528\u6237\u8303\u56f4\u89c4\u5219\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityUserBO> bos = new ArrayList<ActivityUserBO>(pos.size());
        for (ActivityUserMatchPO po : pos) {
            bos.add(po.toActivityUserBO());
        }
        return bos;
    }

    @Override
    public List<UserInstanceSetBO> listUserInstance(Long userSetId) {
        List<UserInstanceSetPO> pos;
        if (null == userSetId) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        try {
            pos = this.userInstanceDao.selectBySetId(userSetId);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u7528\u6237\u5b9e\u4f8b\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<UserInstanceSetBO> bos = new ArrayList<UserInstanceSetBO>(pos.size());
        for (UserInstanceSetPO po : pos) {
            bos.add(po.toUserInstanceSetBO());
        }
        return bos;
    }

    @Override
    public void saveUserRange(List<ActivityUserBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityUserPO> pos = new ArrayList<ActivityUserPO>(reqBOs.size());
        for (ActivityUserBO bo : reqBOs) {
            this.checkUserRangeParams(bo);
            pos.add(ActivityUserPO.toActivityUserPO(bo));
        }
        try {
            this.activityUserDao.insertByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u7528\u6237\u8303\u56f4\u5931\u8d25");
        }
    }

    private void checkUserRangeParams(ActivityUserBO bo) {
        if (null == bo.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        if (null == bo.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getMatchType())) {
            log.error("\u5339\u914d\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5339\u914d\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == bo.getRuleId()) {
            log.error("\u89c4\u5219ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
    }

    @Override
    public List<MatchRuleBO> listMatchRule(Set<Long> ruleIds) {
        List<MatchRulePO> pos = null;
        try {
            pos = this.matchRuleDao.selectByRuleIds(ruleIds);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u89c4\u5219\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u6279\u91cf\u67e5\u8be2\u89c4\u5219\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<MatchRuleBO> bos = new ArrayList<MatchRuleBO>(pos.size());
        for (MatchRulePO po : pos) {
            bos.add(po.toMatchRuleBO());
        }
        return bos;
    }

    @Override
    public List<MatchRuleBO> lisMatchRuleByCondition(MatchRuleBO reqBO) {
        MatchRulePO record = new MatchRulePO();
        if (null != reqBO) {
            record = MatchRulePO.toMatchRulePO(reqBO);
        }
        List<MatchRulePO> pos = null;
        try {
            pos = this.matchRuleDao.selectByCondition(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u89c4\u5219\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u89c4\u5219\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<MatchRuleBO> bos = new ArrayList<MatchRuleBO>(pos.size());
        for (MatchRulePO po : pos) {
            bos.add(po.toMatchRuleBO());
        }
        return bos;
    }

    @Override
    public void saveUserSet(UserSetInstanceBO reqBO) {
        if (null == reqBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSetName())) {
            log.error("\u7528\u6237\u96c6\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u96c6\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSetType())) {
            reqBO.setSetType("1");
        }
        UserSetPO userSetPO = UserSetPO.toUserSetPO(reqBO);
        userSetPO.setCrtTime(new Date());
        try {
            this.userSetDao.insertSelective(userSetPO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7528\u6237\u96c6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u7528\u6237\u96c6\u5931\u8d25");
        }
        if (null == userSetPO.getUserSetId()) {
            log.error("\u65b0\u589e\u7528\u6237\u96c6\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u7528\u6237\u96c6ID");
            TkThrExceptionUtils.thrQryRspEmptyExce((String)"\u65b0\u589e\u7528\u6237\u96c6\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u7528\u6237\u96c6ID");
        }
        reqBO.setUserSetId(userSetPO.getUserSetId());
        this.saveUserInstance(reqBO);
    }

    @Override
    public void saveUserInstance(UserSetInstanceBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getInstanceBOs())) {
            log.error("\u7528\u6237\u5b9e\u4f8b\u96c6\u5408\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u5b9e\u4f8b\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<UserInstancePO> instancePOS = new ArrayList<UserInstancePO>(reqBO.getInstanceBOs().size());
        Date nowDate = new Date();
        for (UserInstanceBO bo : reqBO.getInstanceBOs()) {
            if (null == bo.getUid()) {
                log.error("\u7528\u6237ID\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237ID\u4e3a\u7a7a");
            }
            UserInstancePO instancePO = UserInstancePO.toUserInstancePO(bo);
            instancePO.setCrtTime(nowDate);
            instancePO.setTenantId(reqBO.getTenantId());
            instancePO.setUserSetId(reqBO.getUserSetId());
            instancePOS.add(instancePO);
        }
        try {
            this.userInstanceDao.insertByBatch(instancePOS);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u7528\u6237\u5b9e\u4f8b\u5931\u8d25");
        }
    }

    @Override
    public void removeUserInstance(Long userSetId) {
        if (null == userSetId) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        try {
            this.userInstanceDao.deleteByUserSetId(userSetId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7528\u6237\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u7528\u6237\u5b9e\u4f8b\u5931\u8d25");
        }
    }

    @Override
    public UserSetBO getUserSet(Long userSetId) {
        if (null == userSetId) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        UserSetPO userSetPO = null;
        try {
            userSetPO = this.userSetDao.selectByPrimaryKey(userSetId);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u96c6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u7528\u6237\u96c6\u5931\u8d25");
        }
        if (null == userSetPO) {
            return null;
        }
        return userSetPO.toUserSetBO();
    }

    @Override
    public void modifyUserSet(UserSetBO bo) {
        if (null == bo.getUserSetId()) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        try {
            this.userSetDao.updateByPrimaryKeySelective(UserSetPO.toUserSetPO(bo));
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7528\u6237\u96c6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u66f4\u65b0\u7528\u6237\u96c6\u5931\u8d25");
        }
    }

    @Override
    public void removeUserRange(Long actId) {
        if (null == actId) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityUserDao.deleteByActId(actId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d3b\u52a8\u7528\u6237\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u6d3b\u52a8\u7528\u6237\u8303\u56f4\u5931\u8d25");
        }
    }

    @Override
    public List<UserSetBO> listUserSet(Set<Long> userSetIds) {
        if (CollectionUtils.isEmpty(userSetIds)) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        List<UserSetPO> pos = null;
        try {
            pos = this.userSetDao.selectByUserSetIds(userSetIds);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u96c6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u6279\u91cf\u67e5\u8be2\u7528\u6237\u96c6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<UserSetBO> bos = new ArrayList<UserSetBO>(pos.size());
        for (UserSetPO po : pos) {
            bos.add(po.toUserSetBO());
        }
        return bos;
    }
}

