/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.ActivityBenefitDistributeRecordBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.dao.ActivityBenefitDao;
import com.tydic.newretail.act.dao.ActivityBenefitDistributeRecordDao;
import com.tydic.newretail.act.dao.po.ActivityBenefitDistributeRecordPO;
import com.tydic.newretail.act.dao.po.ActivityBenefitPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityBenefitAtomServiceImpl
implements ActivityBenefitAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActivityBenefitAtomServiceImpl.class);
    @Autowired
    private ActivityBenefitDao activityBenefitDao;
    @Autowired
    private ActivityBenefitDistributeRecordDao activityBenefitDistributeRecordDao;

    @Override
    public List<ActivityBenefitBO> listBenefitByActId(ActivityBenefitBO reqBO) {
        List<ActivityBenefitPO> pos;
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            ActivityBenefitPO record = ActivityBenefitPO.toActivityBenefitPO(reqBO);
            pos = reqBO.getCheckCount().booleanValue() ? this.activityBenefitDao.selectByActId(record) : this.activityBenefitDao.selectByActIdWithoutCount(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u6743\u76ca\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u6743\u76ca\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityBenefitBO> bos = new ArrayList<ActivityBenefitBO>(pos.size());
        for (ActivityBenefitPO po : pos) {
            bos.add(po.toActivityBenefitBO());
        }
        return bos;
    }

    @Override
    public List<ActivityBenefitBO> selectByCondition(ActivityBenefitBO reqBO) {
        List<ActivityBenefitPO> pos;
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getParam4()) {
            log.error("\u6d3b\u52a8\u5206\u4eab\u9886\u5238\u4eba\u7c7b\u578b");
            throw new ResourceException("0001", "\u6d3b\u52a8\u5206\u4eab\u9886\u5238\u4eba\u7c7b\u578b");
        }
        try {
            ActivityBenefitPO record = ActivityBenefitPO.toActivityBenefitPO(reqBO);
            pos = this.activityBenefitDao.selectByCondition(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u6743\u76ca\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u6743\u76ca\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityBenefitBO> bos = new ArrayList<ActivityBenefitBO>(pos.size());
        for (ActivityBenefitPO po : pos) {
            bos.add(po.toActivityBenefitBO());
        }
        return bos;
    }

    @Override
    public List<ActivityBenefitBO> selectByBenefitType(ActivityBenefitBO reqBO) {
        List<ActivityBenefitPO> pos;
        try {
            ActivityBenefitPO record = ActivityBenefitPO.toActivityBenefitPO(reqBO);
            pos = this.activityBenefitDao.selectByBenefitType(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u6743\u76ca\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u6743\u76ca\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityBenefitBO> bos = new ArrayList<ActivityBenefitBO>(pos.size());
        for (ActivityBenefitPO po : pos) {
            bos.add(po.toActivityBenefitBO());
        }
        return bos;
    }

    @Override
    public void modifyBatch(List<ActivityBenefitBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6743\u76ca\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6743\u76ca\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ActivityBenefitPO> pos = new ArrayList<ActivityBenefitPO>(reqBOs.size());
        for (ActivityBenefitBO bo : reqBOs) {
            if (null == bo.getActivityBenefitId()) {
                log.error("\u6743\u76caID\u4e3a\u7a7a");
                throw new ResourceException("0001", "\u6743\u76caID\u4e3a\u7a7a");
            }
            pos.add(ActivityBenefitPO.toActivityBenefitPO(bo));
        }
        try {
            this.activityBenefitDao.updateBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public List<ActivityBenefitDistributeRecordBO> saveRecordBatch(List<ActivityBenefitDistributeRecordBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6743\u76ca\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6743\u76ca\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ActivityBenefitDistributeRecordPO> pos = new ArrayList<ActivityBenefitDistributeRecordPO>(reqBOs.size());
        for (ActivityBenefitDistributeRecordBO bo : reqBOs) {
            this.checkBenefitRecordParams(bo);
            pos.add(ActivityBenefitDistributeRecordPO.toActivityBenefitDistributeRecordPO(bo));
        }
        try {
            this.activityBenefitDistributeRecordDao.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589e\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u5931\u8d25");
        }
        ArrayList<ActivityBenefitDistributeRecordBO> rspList = new ArrayList<ActivityBenefitDistributeRecordBO>(pos.size());
        for (ActivityBenefitDistributeRecordPO po : pos) {
            rspList.add(po.toActivityBenefitDistributeRecordBO());
        }
        return rspList;
    }

    @Override
    public void saveCouponConsumeRecordBatch(List<CouponInstanceBO> reqBOs) {
    }

    @Override
    public void modifyRecordBatch(List<ActivityBenefitDistributeRecordBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ActivityBenefitDistributeRecordPO> pos = new ArrayList<ActivityBenefitDistributeRecordPO>(reqBOs.size());
        for (ActivityBenefitDistributeRecordBO bo : reqBOs) {
            if (null == bo.getBenefitDistRecordId()) {
                log.error("\u6743\u76ca\u53d1\u653e\u8bb0\u5f55ID\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76ca\u53d1\u653e\u8bb0\u5f55ID\u4e3a\u7a7a");
            }
            pos.add(ActivityBenefitDistributeRecordPO.toActivityBenefitDistributeRecordPO(bo));
        }
        try {
            this.activityBenefitDistributeRecordDao.updateBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u53d1\u653e\u8bb0\u5f55\u5931\u8d25");
        }
    }

    private void checkBenefitRecordParams(ActivityBenefitDistributeRecordBO bo) {
        if (null == bo.getActivityBenefitId()) {
            log.error("\u6743\u76caID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76caID\u4e3a\u7a7a");
        }
        if (null == bo.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getBenefitType())) {
            log.error("\u6743\u76ca\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76ca\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == bo.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (null == bo.getUid()) {
            log.error("\u7528\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getDistStatus())) {
            log.error("\u6d3e\u53d1\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3e\u53d1\u72b6\u6001\u4e3a\u7a7a");
        }
    }

    @Override
    public Integer getPartiCount(Long actId, Long memId) {
        if (null == actId || null == memId) {
            log.error("\u6d3b\u52a8ID\u6216\u4f1a\u5458ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u6216\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        ActivityBenefitDistributeRecordPO record = new ActivityBenefitDistributeRecordPO();
        record.setActivityId(actId);
        record.setUid(memId);
        int count = 0;
        try {
            count = this.activityBenefitDistributeRecordDao.selectCountByActIdAndUid(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u6743\u76ca\u53d1\u653e\u6b21\u6570\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u7528\u6237\u6743\u76ca\u53d1\u653e\u6b21\u6570\u5931\u8d25");
        }
        return count;
    }

    @Override
    public void saveBeneBatch(List<ActivityBenefitBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityBenefitPO> pos = new ArrayList<ActivityBenefitPO>(reqBOs.size());
        for (ActivityBenefitBO benefitBO : reqBOs) {
            if (null == benefitBO.getActivityId()) {
                log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
            }
            if (null == benefitBO.getTenantId()) {
                log.error("\u79df\u6237ID\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)benefitBO.getBenefitType())) {
                log.error("\u6743\u76ca\u7c7b\u578b\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76ca\u7c7b\u578b\u4e3a\u7a7a");
            }
            ActivityBenefitPO po = ActivityBenefitPO.toActivityBenefitPO(benefitBO);
            pos.add(po);
        }
        try {
            this.activityBenefitDao.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6743\u76ca\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u6743\u76ca\u5931\u8d25");
        }
    }

    @Override
    public void removeByActId(Long actId) {
        if (null == actId) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityBenefitDao.deleteByActivityId(actId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d3b\u52a8\u6743\u76ca\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u6d3b\u52a8\u6743\u76ca\u5931\u8d25");
        }
    }

    @Override
    public Integer getCountByCouponId(Long couponId) {
        if (null == couponId) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        int count = 0;
        try {
            count = this.activityBenefitDao.selectCountByCouponId(couponId.toString());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6743\u76ca\u6570\u91cf\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u6743\u76ca\u6570\u91cf\u5931\u8d25");
        }
        return count;
    }

    @Override
    public void invalidByActIds(Set<Long> actIds) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        try {
            this.activityBenefitDao.invalidByActIds(actIds);
        }
        catch (Exception e) {
            log.error("\u5931\u6548\u6d3b\u52a8\u6743\u76ca\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u5931\u6548\u6d3b\u52a8\u6743\u76ca\u5931\u8d25");
        }
    }

    @Override
    public void updateStatusByAct(Set<Long> actIds, String actStatus) {
        if (CollectionUtils.isEmpty(actIds)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)actStatus)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001 \u6d3b\u52a8\u72b6\u6001\u4e3a\u7a7a");
        }
        try {
            this.activityBenefitDao.updateStatusByAct(actIds, actStatus);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
        }
    }

    @Override
    public void updateStatusBatch(List<ActivityBenefitBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ActivityBenefitPO> pos = new ArrayList<ActivityBenefitPO>();
        for (ActivityBenefitBO bo : reqBOs) {
            if (null == bo.getActivityId()) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u3010activityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u3010activityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getActivityStatus())) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u6d3b\u52a8\u72b6\u6001\u3010activityStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5165\u53c2\u6d3b\u52a8\u72b6\u6001\u3010activityStatus\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ActivityBenefitPO po = new ActivityBenefitPO();
            po.setActivityId(bo.getActivityId());
            po.setActivityStatus(bo.getActivityStatus());
            pos.add(po);
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            try {
                this.activityBenefitDao.updateStatusBatch(pos);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u6d3b\u52a8\u6743\u76ca\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            }
        }
    }
}

