/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActivityCommodityModelAtomService;
import com.tydic.newretail.act.bo.ActivityCommodityModelInfoBO;
import com.tydic.newretail.act.bo.ActivityCommodityModelReqBO;
import com.tydic.newretail.act.dao.ActivityCommodityModelDAO;
import com.tydic.newretail.act.dao.po.ActivityCommodityModelPO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityCommodityModelAtomServiceImpl
implements ActivityCommodityModelAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCommodityModelAtomServiceImpl.class);
    @Autowired
    private ActivityCommodityModelDAO activityCommodityModelDAO;

    @Override
    public void invalidBatchByModelId(Set<Long> modelIds) {
        if (CollectionUtils.isEmpty(modelIds)) {
            log.error("\u673a\u578bID\u96c6\u5408\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u673a\u578bID\u96c6\u5408\u4e3a\u7a7a");
        }
        try {
            this.activityCommodityModelDAO.invalidByModelIds(modelIds);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5220\u9664\u6d3b\u52a8\u673a\u578b\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u6279\u91cf\u5220\u9664\u6d3b\u52a8\u673a\u578b\u5931\u8d25");
        }
    }

    @Override
    public List<ActivityCommodityModelInfoBO> saveByBatch(List<ActivityCommodityModelInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6d3b\u52a8\u673a\u578b\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8\u673a\u578b\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ActivityCommodityModelPO> pos = new ArrayList<ActivityCommodityModelPO>(reqBOs.size());
        for (ActivityCommodityModelInfoBO bo : reqBOs) {
            this.checkParams(bo);
            ActivityCommodityModelPO po = new ActivityCommodityModelPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCrtTime(new Date());
            po.setIsValid("1");
            pos.add(po);
        }
        try {
            this.activityCommodityModelDAO.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u5931\u8d25");
        }
        ArrayList<ActivityCommodityModelInfoBO> rspList = new ArrayList<ActivityCommodityModelInfoBO>(pos.size());
        for (ActivityCommodityModelPO po : pos) {
            ActivityCommodityModelInfoBO bo = new ActivityCommodityModelInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspList.add(bo);
        }
        return rspList;
    }

    @Override
    public List<ActivityCommodityModelInfoBO> selectByCommodityColor(ActivityCommodityModelInfoBO reqBO, Page<Map<String, Object>> page) {
        ActivityCommodityModelPO po = new ActivityCommodityModelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<ActivityCommodityModelPO> pos = null;
        try {
            pos = this.activityCommodityModelDAO.selectByPage(page, po);
        }
        catch (Exception e) {
            log.error("\u673a\u578b\u6c60\u54c1\u724c\u6a21\u7cca\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u673a\u578b\u6c60\u54c1\u724c\u6a21\u7cca\u67e5\u8be2\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityCommodityModelInfoBO> bos = new ArrayList<ActivityCommodityModelInfoBO>(pos.size());
        for (ActivityCommodityModelPO activityCommodityModelPO : pos) {
            ActivityCommodityModelInfoBO bo = new ActivityCommodityModelInfoBO();
            BeanUtils.copyProperties((Object)activityCommodityModelPO, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    @Override
    public ActivityCommodityModelInfoBO selectByModelId(ActivityCommodityModelInfoBO reqBO) {
        ActivityCommodityModelInfoBO activityCommodityModelInfoBO = new ActivityCommodityModelInfoBO();
        ActivityCommodityModelPO activityCommodityModelPO = null;
        try {
            activityCommodityModelPO = this.activityCommodityModelDAO.selectByPrimaryKey(reqBO.getModelId());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u8be6\u60c5\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)activityCommodityModelPO, (Object)activityCommodityModelInfoBO);
        return activityCommodityModelInfoBO;
    }

    @Override
    public List<ActivityCommodityModelInfoBO> selectByCondition(List<ActivityCommodityModelInfoBO> reqBOs) {
        List<ActivityCommodityModelPO> bos;
        ArrayList<ActivityCommodityModelPO> pos = new ArrayList<ActivityCommodityModelPO>(reqBOs.size());
        for (ActivityCommodityModelInfoBO bo : reqBOs) {
            ActivityCommodityModelPO po = new ActivityCommodityModelPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            bos = this.activityCommodityModelDAO.selectByCondition(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u673a\u578b\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u673a\u578b\u8868\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(bos)) {
            return null;
        }
        ArrayList<ActivityCommodityModelInfoBO> rspBOs = new ArrayList<ActivityCommodityModelInfoBO>(bos.size());
        for (ActivityCommodityModelPO po : bos) {
            ActivityCommodityModelInfoBO bo = new ActivityCommodityModelInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspBOs.add(bo);
        }
        return rspBOs;
    }

    @Override
    public void modifyByBatch(List<ActivityCommodityModelInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityCommodityModelPO> pos = new ArrayList<ActivityCommodityModelPO>(reqBOs.size());
        for (ActivityCommodityModelInfoBO bo : reqBOs) {
            this.checkParams(bo);
            ActivityCommodityModelPO po = new ActivityCommodityModelPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            this.activityCommodityModelDAO.updateByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u673a\u578b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0004", "\u6279\u91cf\u66f4\u65b0\u6d3b\u52a8\u673a\u578b\u5931\u8d25");
        }
    }

    @Override
    public RspPageBaseBO<ActivityCommodityModelInfoBO> selectListByCondition(ActivityCommodityModelReqBO reqBO, Boolean isPage) {
        RspPageBaseBO rspPageBaseBO = new RspPageBaseBO();
        rspPageBaseBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        rspPageBaseBO.setRespCode("0000");
        ArrayList<ActivityCommodityModelInfoBO> list = new ArrayList<ActivityCommodityModelInfoBO>();
        ActivityCommodityModelPO po = new ActivityCommodityModelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<ActivityCommodityModelPO> pos = null;
        Page page = new Page();
        try {
            if (isPage.booleanValue()) {
                page.setPageNo(reqBO.getCurrent());
                page.setPageSize(reqBO.getPageSize());
                pos = this.activityCommodityModelDAO.selectList((Page<ActivityCommodityModelPO>)page, po);
            } else {
                pos = this.activityCommodityModelDAO.selectList(po);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u673a\u578b\u5217\u8868\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff01" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u673a\u578b\u5217\u8868\u539f\u5b50\u670d\u52a1\u51fa\u9519!");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (ActivityCommodityModelPO po1 : pos) {
                ActivityCommodityModelInfoBO bo = new ActivityCommodityModelInfoBO();
                BeanUtils.copyProperties((Object)po1, (Object)bo);
                list.add(bo);
            }
        }
        if (isPage.booleanValue()) {
            rspPageBaseBO.setTotal(page.getTotalPages());
            rspPageBaseBO.setRecordsTotal(page.getTotalCount());
        }
        rspPageBaseBO.setRows(list);
        return rspPageBaseBO;
    }

    private void checkParams(ActivityCommodityModelInfoBO bo) {
        if (StringUtils.isBlank((CharSequence)bo.getCommoditytCode())) {
            log.error("\u5546\u54c1\u7f16\u7801\uff08\u7269\u6599\uff09\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5546\u54c1\u7f16\u7801\uff08\u7269\u6599\uff09\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getCommodityBrand())) {
            log.error("\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getCommoditytName())) {
            log.error("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
        }
    }
}

