/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActivityCommodityPoolAtomService;
import com.tydic.newretail.act.bo.ActivityCommodityPoolBO;
import com.tydic.newretail.act.bo.ActivityCommodityPoolInfoBO;
import com.tydic.newretail.act.bo.QryActivityCommodityPoolInfoBO;
import com.tydic.newretail.act.dao.ActivityCommodityPoolDAO;
import com.tydic.newretail.act.dao.po.ActivityCommodityPoolPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityCommodityPoolAtomServiceImpl
implements ActivityCommodityPoolAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCommodityPoolAtomServiceImpl.class);
    @Autowired
    private ActivityCommodityPoolDAO activityCommodityPoolDAO;

    @Override
    public List<ActivityCommodityPoolInfoBO> selectByCondition(List<ActivityCommodityPoolInfoBO> reqBOs, Page<Map<String, Object>> page) {
        List<ActivityCommodityPoolPO> bos;
        ArrayList<ActivityCommodityPoolPO> pos = new ArrayList<ActivityCommodityPoolPO>(reqBOs.size());
        for (ActivityCommodityPoolInfoBO bo : reqBOs) {
            ActivityCommodityPoolPO po = new ActivityCommodityPoolPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            bos = this.activityCommodityPoolDAO.selectByCondition(pos, page);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u673a\u578b\u6c60\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u673a\u578b\u6c60\u8868\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(bos)) {
            return null;
        }
        ArrayList<ActivityCommodityPoolInfoBO> rspBOs = new ArrayList<ActivityCommodityPoolInfoBO>(bos.size());
        for (ActivityCommodityPoolPO po : bos) {
            ActivityCommodityPoolInfoBO bo = new ActivityCommodityPoolInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspBOs.add(bo);
        }
        return rspBOs;
    }

    @Override
    public List<ActivityCommodityPoolInfoBO> selectByTypeAndCommCOde(QryActivityCommodityPoolInfoBO reqBOs) {
        List<ActivityCommodityPoolPO> bos;
        ArrayList<ActivityCommodityPoolPO> pos = new ArrayList<ActivityCommodityPoolPO>(reqBOs.getActivityCommodityPoolBOS().size());
        for (ActivityCommodityPoolBO bo : reqBOs.getActivityCommodityPoolBOS()) {
            ActivityCommodityPoolPO po = new ActivityCommodityPoolPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            bos = this.activityCommodityPoolDAO.selectByTypeAndCommCOde(pos);
        }
        catch (Exception e) {
            log.error("\u636e\u9500\u552e\u7c7b\u578b+\u6d3b\u52a8\u7c7b\u578b+\u7269\u6599\u7f16\u7801\u6279\u91cf\u67e5\u8be2\u673a\u578b\u6c60\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u636e\u9500\u552e\u7c7b\u578b+\u6d3b\u52a8\u7c7b\u578b+\u7269\u6599\u7f16\u7801\u6279\u91cf\u67e5\u8be2\u673a\u578b\u6c60\u8868\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(bos)) {
            return new ArrayList<ActivityCommodityPoolInfoBO>();
        }
        ArrayList<ActivityCommodityPoolInfoBO> rspBOs = new ArrayList<ActivityCommodityPoolInfoBO>(bos.size());
        for (ActivityCommodityPoolPO po : bos) {
            ActivityCommodityPoolInfoBO bo = new ActivityCommodityPoolInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspBOs.add(bo);
        }
        return rspBOs;
    }

    @Override
    public ActivityCommodityPoolInfoBO saveActivityCommodityPoolInfo(ActivityCommodityPoolInfoBO reqBO) {
        ActivityCommodityPoolInfoBO rsp = new ActivityCommodityPoolInfoBO();
        ActivityCommodityPoolPO po = new ActivityCommodityPoolPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setCrtTime(new Date());
        po.setIsValid("1");
        try {
            this.activityCommodityPoolDAO.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u673a\u578b\u6c60\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u673a\u578b\u6c60\u8868\u4fe1\u606f\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)po, (Object)rsp);
        return rsp;
    }

    @Override
    public List<ActivityCommodityPoolInfoBO> selectBySaleTypeAndActType(ActivityCommodityPoolInfoBO reqBO) {
        ArrayList<ActivityCommodityPoolInfoBO> bos = new ArrayList<ActivityCommodityPoolInfoBO>();
        ActivityCommodityPoolPO activityCommodityPoolPO = new ActivityCommodityPoolPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityCommodityPoolPO);
        List<ActivityCommodityPoolPO> pos = null;
        try {
            pos = this.activityCommodityPoolDAO.selectBySaleTypeAndActType(activityCommodityPoolPO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u673a\u578b\u6c60\u5931\u8d25");
            TkThrExceptionUtils.thrInsExce((String)"\u67e5\u8be2\u673a\u578b\u6c60\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (ActivityCommodityPoolPO po : pos) {
                ActivityCommodityPoolInfoBO bo = new ActivityCommodityPoolInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bos.add(bo);
            }
        }
        return bos;
    }
}

