/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.ActUserAtomService;
import com.tydic.newretail.act.atom.CheckUserRangeAtomService;
import com.tydic.newretail.act.bo.ActivityUserBO;
import com.tydic.newretail.act.bo.QryActivityReqBO;
import com.tydic.newretail.act.bo.UserInstanceSetBO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckUserRangeAtomServiceImpl
implements CheckUserRangeAtomService {
    private static final Logger log = LoggerFactory.getLogger(CheckUserRangeAtomServiceImpl.class);
    @Autowired
    private ActUserAtomService actUserAtomService;

    @Override
    public Set<Long> checkUser(QryActivityReqBO reqBO, Set<Long> actIds) {
        if (CollectionUtils.isEmpty(actIds)) {
            return null;
        }
        List<ActivityUserBO> matchPOS = this.actUserAtomService.listUserMatch(actIds);
        if (CollectionUtils.isEmpty(matchPOS)) {
            return actIds;
        }
        HashSet<Long> allowActs = new HashSet<Long>(actIds.size());
        for (ActivityUserBO user : matchPOS) {
            actIds.remove(user.getActivityId());
            switch (user.getMatchType()) {
                case "00": {
                    if (null == reqBO.getMemId()) {
                        log.error("\u672a\u83b7\u53d6\u5f53\u524d\u7528\u6237ID");
                        break;
                    }
                    if (null == user.getRuleId()) {
                        log.error("\u672a\u914d\u7f6e\u7528\u6237\u96c6ID");
                        break;
                    }
                    List<UserInstanceSetBO> userInstanceSetBOS = this.actUserAtomService.listUserInstance(user.getRuleId());
                    if (CollectionUtils.isEmpty(userInstanceSetBOS)) {
                        log.error("\u672a\u67e5\u8be2\u5230\u7528\u6237\u5b9e\u4f8b");
                        break;
                    }
                    for (UserInstanceSetBO instance : userInstanceSetBOS) {
                        if (!reqBO.getMemId().equals(instance.getUid())) continue;
                        allowActs.add(user.getActivityId());
                    }
                    break;
                }
                case "01": {
                    if (null == reqBO.getMemType()) {
                        log.error("\u672a\u83b7\u53d6\u7528\u6237\u7c7b\u578b");
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)user.getMatchRuleBO().getCalFormula())) {
                        log.error("\u672a\u914d\u7f6e\u7528\u6237\u7c7b\u578b\u5339\u914d\u8868\u8fbe\u5f0f");
                        break;
                    }
                    if (!Pattern.matches(user.getMatchRuleBO().getCalFormula(), reqBO.getMemType().toString())) break;
                    allowActs.add(user.getActivityId());
                    break;
                }
                case "02": {
                    if (null == reqBO.getMemLevel()) {
                        log.error("\u672a\u83b7\u53d6\u7528\u6237\u7b49\u7ea7");
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)user.getMatchRuleBO().getCalFormula())) {
                        log.error("\u672a\u914d\u7f6e\u7528\u6237\u7b49\u7ea7\u5339\u914d\u8868\u8fbe\u5f0f");
                        break;
                    }
                    if (!Pattern.matches(user.getMatchRuleBO().getCalFormula(), reqBO.getMemLevel().toString())) break;
                    allowActs.add(user.getActivityId());
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(actIds)) {
            allowActs.addAll(actIds);
        }
        return allowActs;
    }
}

