/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.dao.CouponDao;
import com.tydic.newretail.act.dao.po.CouponPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponAtomServiceImpl
implements CouponAtomService {
    private static final Logger log = LoggerFactory.getLogger(CouponAtomServiceImpl.class);
    @Autowired
    private CouponDao couponDao;

    @Override
    public List<CouponBO> listCouponById(Set<Long> couponIds) {
        if (CollectionUtils.isEmpty(couponIds)) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        List<CouponPO> pos = this.couponDao.selectByIds(couponIds);
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<CouponBO> bos = new ArrayList<CouponBO>(pos.size());
        for (CouponPO po : pos) {
            bos.add(po.toCouponBO());
        }
        return bos;
    }

    @Override
    public CouponBO qryCouponById(Long couponId) {
        CouponPO po = this.couponDao.selectByPrimaryKey(couponId);
        if (null == po) {
            return null;
        }
        CouponBO couponBO = po.toCouponBO();
        return couponBO;
    }

    @Override
    public CouponBO saveCoupon(CouponBO reqBO) {
        this.checkSaveParams(reqBO);
        CouponPO couponPO = CouponPO.toCouponPO(reqBO);
        try {
            this.couponDao.insertSelective(couponPO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7535\u5b50\u5238\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u7535\u5b50\u5238\u5931\u8d25");
        }
        return couponPO.toCouponBO();
    }

    private void checkSaveParams(CouponBO reqBO) {
        if (null == reqBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCouponType())) {
            log.error("\u7535\u5b50\u5238\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCouponName())) {
            log.error("\u7535\u5b50\u5238\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getUsefulStartTime() || null == reqBO.getUsefulEndTime()) {
            log.error("\u4f18\u60e0\u5238\u53ef\u6d3e\u53d1\u65f6\u95f4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4f18\u60e0\u5238\u53ef\u6d3e\u53d1\u65f6\u95f4\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyCouponSelective(CouponBO reqBO) {
        if (null == reqBO.getCouponId()) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        CouponPO po = CouponPO.toCouponPO(reqBO);
        try {
            this.couponDao.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u7535\u5b50\u5238\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u7535\u5b50\u5238\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public void modifyCoupon(CouponBO reqBO) {
        if (null == reqBO.getCouponId()) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        CouponPO po = CouponPO.toCouponPO(reqBO);
        try {
            this.couponDao.updateByPrimaryKey(po);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u7535\u5b50\u5238\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u7535\u5b50\u5238\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public List<CouponBO> listByCondition(CouponBO reqBO) {
        List<CouponPO> pos;
        CouponPO record = new CouponPO();
        if (null != reqBO) {
            record = CouponPO.toCouponPO(reqBO);
        }
        if (CollectionUtils.isEmpty(pos = this.couponDao.selectByCondition(record))) {
            return null;
        }
        ArrayList<CouponBO> bos = new ArrayList<CouponBO>(pos.size());
        for (CouponPO po : pos) {
            bos.add(po.toCouponBO());
        }
        return bos;
    }

    @Override
    public void modifyBatch(List<CouponBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u7535\u5b50\u5238\u96c6\u5408\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<CouponPO> pos = new ArrayList<CouponPO>(reqBOs.size());
        for (CouponBO bo : reqBOs) {
            if (null == bo.getCouponId()) {
                log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            }
            pos.add(CouponPO.toCouponPO(bo));
        }
        try {
            this.couponDao.updateBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u5238\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u5238\u5931\u8d25");
        }
    }
}

