/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.CouponCalAtomService;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.util.CalculationUtils;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CouponCalAtomServiceImpl
implements CouponCalAtomService {
    private static final Logger log = LoggerFactory.getLogger(CouponCalAtomServiceImpl.class);

    @Override
    public Double calNoThreshold(CouponInstanceBO instanceBO, ActCommInfoBO commInfoBO, Long totalPrice) {
        if (null == instanceBO.getParam2()) {
            log.error("\u672a\u914d\u7f6e\u4f18\u60e0\u989d\u5ea6");
            return new Double(0.0);
        }
        Long reducePrice = Long.parseLong(instanceBO.getParam2());
        if (totalPrice.compareTo(reducePrice) < 0) {
            log.error("\u5546\u54c1\u603b\u989d\u4f4e\u4e8e\u4f18\u60e0\u989d\u5ea6");
            return new Double(0.0);
        }
        Double apportionPrice = CalculationUtils.calFullReduce(totalPrice, commInfoBO.getSkuDisPriceL(), reducePrice);
        return apportionPrice;
    }

    @Override
    public Double calReduce(CouponInstanceBO instanceBO, ActCommInfoBO commInfoBO, Long totalPrice) {
        if (null == instanceBO.getParam1() || null == instanceBO.getParam2()) {
            log.error("\u672a\u914d\u7f6e\u6ee1\u51cf\u89c4\u5219");
            return new Double(0.0);
        }
        Long fullPrice = Long.parseLong(instanceBO.getParam1());
        Long reducePrice = Long.parseLong(instanceBO.getParam2());
        if (fullPrice.compareTo(totalPrice) > 0) {
            log.debug("\u672a\u7b26\u5408\u6ee1\u51cf\u89c4\u5219");
            return new Double(0.0);
        }
        Double apportionPrice = CalculationUtils.calFullReduce(totalPrice, commInfoBO.getSkuDisPriceL(), reducePrice);
        return apportionPrice;
    }

    @Override
    public Double calDiscount(CouponInstanceBO instanceBO, ActCommInfoBO commInfoBO, Long totalPrice) {
        Double disAmo = TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(commInfoBO.getSkuDisTotalPrice().toString()), (BigDecimal)new BigDecimal(instanceBO.getParam2())).setScale(2, 4).doubleValue();
        return disAmo;
    }

    @Override
    public Double calByType(CouponInstanceBO instanceBO, ActCommInfoBO commInfoBO, Long totalPrice) {
        switch (instanceBO.getCouponType()) {
            case "00": {
                return this.calNoThreshold(instanceBO, commInfoBO, totalPrice);
            }
            case "01": {
                return this.calReduce(instanceBO, commInfoBO, totalPrice);
            }
            case "02": 
            case "03": {
                return this.calDiscount(instanceBO, commInfoBO, totalPrice);
            }
        }
        return new Double(0.0);
    }
}

