/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.CouponCommAtomService;
import com.tydic.newretail.act.atom.bo.QryCouponCommReqAtomBO;
import com.tydic.newretail.act.bo.CouponCommodityBO;
import com.tydic.newretail.act.dao.CouponCommodityDao;
import com.tydic.newretail.act.dao.po.CouponCommodityPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponCommAtomServiceImpl
implements CouponCommAtomService {
    private static final Logger log = LoggerFactory.getLogger(CouponCommAtomServiceImpl.class);
    @Autowired
    private CouponCommodityDao couponCommodityDao;

    @Override
    public List<CouponCommodityBO> listCommByCondition(QryCouponCommReqAtomBO reqBO) {
        List<CouponCommodityPO> comms;
        ArrayList<CouponCommodityPO> pos = null;
        if (CollectionUtils.isNotEmpty(reqBO.getComms())) {
            pos = new ArrayList<CouponCommodityPO>(reqBO.getComms().size());
            for (CouponCommodityBO bo : reqBO.getComms()) {
                pos.add(CouponCommodityPO.toCouponCommodityPO(bo));
            }
        }
        try {
            comms = this.couponCommodityDao.selectByCondition(pos, reqBO.getCouponIds(), reqBO.getCouponTypes(), reqBO.getCurrentDate());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7535\u5b50\u5238\u4f7f\u7528\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u7535\u5b50\u5238\u4f7f\u7528\u5bf9\u8c61\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(comms)) {
            return null;
        }
        ArrayList<CouponCommodityBO> bos = new ArrayList<CouponCommodityBO>(pos.size());
        for (CouponCommodityPO po : comms) {
            bos.add(po.toCouponCommodityBO());
        }
        return bos;
    }

    @Override
    public List<CouponCommodityBO> listByObjTypeAndId(QryCouponCommReqAtomBO reqBO) {
        List<CouponCommodityPO> pos = this.couponCommodityDao.selectByObjTypesAndId(reqBO.getObjTypes(), reqBO.getCouponIds());
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<CouponCommodityBO> bos = new ArrayList<CouponCommodityBO>(pos.size());
        for (CouponCommodityPO po : pos) {
            bos.add(po.toCouponCommodityBO());
        }
        return bos;
    }

    @Override
    public void saveBatch(List<CouponCommodityBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<CouponCommodityPO> pos = new ArrayList<CouponCommodityPO>(reqBOs.size());
        for (CouponCommodityBO bo : reqBOs) {
            if (null == bo.getCouponId() || null == bo.getCouponType()) {
                log.error("\u7535\u5b50\u5238ID\u6216\u7c7b\u578b\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u6216\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getObjCode()) || StringUtils.isBlank((CharSequence)bo.getObjType())) {
                log.error("\u7535\u5b50\u5238\u9002\u7528\u5bf9\u8c61\u7f16\u7801\u6216\u7c7b\u578b\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u9002\u7528\u5bf9\u8c61\u7f16\u7801\u6216\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (null == bo.getStartTime() || null == bo.getEndTime()) {
                log.error("\u7535\u5b50\u5238\u9002\u7528\u65f6\u95f4\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u9002\u7528\u65f6\u95f4\u4e3a\u7a7a");
            }
            pos.add(CouponCommodityPO.toCouponCommodityPO(bo));
        }
        try {
            this.couponCommodityDao.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u7535\u5b50\u5238\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u7535\u5b50\u5238\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public void invalidByCouponId(Set<Long> couponIds) {
        if (CollectionUtils.isEmpty(couponIds)) {
            log.error("\u7535\u5b50\u5238ID\u96c6\u5408\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u96c6\u5408\u4e3a\u7a7a");
        }
        try {
            this.couponCommodityDao.invalidByCouponIds(couponIds);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7535\u5b50\u5238\u9002\u7528\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u7535\u5b50\u5238\u9002\u7528\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public void removeByCouponId(Long couponId) {
        if (null == couponId) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        try {
            this.couponCommodityDao.deleteByCouponId(couponId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7535\u5b50\u5238\u9002\u7528\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u7535\u5b50\u5238\u9002\u7528\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public List<CouponCommodityBO> selectByCouponIdAndObjType(CouponCommodityBO record) {
        if (null == record.getCouponId() || StringUtils.isEmpty((CharSequence)record.getObjType())) {
            log.error("\u4f18\u60e0\u5238\u5546\u54c1\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4f18\u60e0\u5238\u5546\u54c1\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        CouponCommodityPO reqPO = new CouponCommodityPO();
        BeanUtils.copyProperties((Object)record, (Object)reqPO);
        List<Object> rspList = new ArrayList();
        try {
            rspList = this.couponCommodityDao.selectByCouponIdAndObjType(reqPO);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6d3b\u52a8id\u548c\u5bf9\u8c61\u7c7b\u578b\u67e5\u8be2\u4f18\u60e0\u5238\u5546\u54c1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u6d3b\u52a8id\u548c\u5bf9\u8c61\u7c7b\u578b\u67e5\u8be2\u4f18\u60e0\u5238\u5546\u54c1\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(rspList)) {
            return null;
        }
        ArrayList<CouponCommodityBO> bos = new ArrayList<CouponCommodityBO>(rspList.size());
        for (CouponCommodityPO couponCommodityPO : rspList) {
            bos.add(couponCommodityPO.toCouponCommodityBO());
        }
        return bos;
    }
}

