/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.CouponInstanceAtomService;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponInstanceReqBO;
import com.tydic.newretail.act.dao.CouponInstanceDAO;
import com.tydic.newretail.act.dao.po.CouponInstancePO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CouponInstanceAtomServiceImpl
implements CouponInstanceAtomService {
    private static final Logger log = LoggerFactory.getLogger(CouponInstanceAtomServiceImpl.class);
    @Autowired
    private CouponInstanceDAO couponInstanceDAO;
    @Autowired
    private QryEscapeAtomService qryEscapeAtomService;
    @Value(value="${coupon.about.expire}")
    private Integer aboutExpireTime;

    @Override
    public RspPageBaseBO<CouponInstanceBO> queryCouponInstancePage(CouponInstanceReqBO couponInstanceReqBO) {
        if (couponInstanceReqBO.getCurrent() <= 0 || couponInstanceReqBO.getPageSize() <= 0) {
            log.error("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5206\u9875\u53c2\u6570current\u548cpageSize\u5fc5\u586b");
        }
        RspPageBaseBO result = new RspPageBaseBO();
        try {
            Page page = new Page();
            page.setOffset(couponInstanceReqBO.getOffset());
            page.setLimit(couponInstanceReqBO.getPageSize());
            CouponInstancePO couponInstancePOReq = this.req2PO(couponInstanceReqBO);
            List<CouponInstancePO> couponInstancePOList = this.couponInstanceDAO.selectByRecord(couponInstancePOReq, page);
            ArrayList<CouponInstanceBO> couponInstanceBOList = new ArrayList<CouponInstanceBO>();
            if (CollectionUtils.isNotEmpty(couponInstancePOList)) {
                for (CouponInstancePO couponInstancePO : couponInstancePOList) {
                    CouponInstanceBO bo;
                    String couponTypeStr = this.qryEscapeAtomService.getCodeTitle("COUPON_TYPE_NAME", (bo = couponInstancePO.toCouponInstanceBO()).getCouponType());
                    bo.setCouponTypeStr(StringUtils.isBlank((CharSequence)couponTypeStr) ? "\u672a\u5b9a\u4e49" : couponTypeStr);
                    String stateStr = this.qryEscapeAtomService.getCodeTitle("COUPON_STATE_NAME", bo.getUseStatus());
                    bo.setUseStatusStr(StringUtils.isBlank((CharSequence)stateStr) ? "\u672a\u5b9a\u4e49" : stateStr);
                    this.transferTime(bo);
                    if (null != bo.getTotalAmountL()) {
                        BigDecimal totalAmount = MoneyUtils.Long2BigDecimal((Long)bo.getTotalAmountL());
                        bo.setTotalAmount(totalAmount);
                    }
                    if (("02".equals(bo.getCouponType()) || "03".equals(bo.getCouponType())) && StringUtils.isNotBlank((CharSequence)bo.getParam2())) {
                        bo.setDiscountRate(TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(bo.getParam2()), (BigDecimal)new BigDecimal("100")).setScale(0, 1).toString());
                    }
                    couponInstanceBOList.add(bo);
                }
            }
            result.setRows(couponInstanceBOList);
            result.setRecordsTotal(page.getTotalPages());
            result.setTotal(page.getTotalCount());
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return result;
    }

    @Override
    public List<CouponInstanceBO> queryCouponInstance(CouponInstanceReqBO couponInstanceReqBO) {
        ArrayList<CouponInstanceBO> bos = new ArrayList<CouponInstanceBO>();
        try {
            CouponInstancePO record = this.req2PO(couponInstanceReqBO);
            List<CouponInstancePO> pos = this.couponInstanceDAO.selectByRecord(record);
            if (CollectionUtils.isNotEmpty(pos)) {
                for (CouponInstancePO couponInstancePO : pos) {
                    CouponInstanceBO bo = couponInstancePO.toCouponInstanceBO();
                    bos.add(bo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return bos;
    }

    private CouponInstancePO req2PO(CouponInstanceReqBO req) {
        CouponInstancePO rsp = new CouponInstancePO();
        rsp.setCouponInstanceId(req.getCouponInstanceId());
        rsp.setCouponId(req.getCouponId());
        rsp.setTenantId(req.getTenantId());
        rsp.setUid(req.getUid());
        rsp.setExchangeCode(req.getExchangeCode());
        rsp.setCouponType(req.getCouponType());
        rsp.setCouponName(req.getCouponName());
        rsp.setCouponDesc(req.getCouponDesc());
        rsp.setCrtTime(req.getCrtTime());
        rsp.setStartTime(req.getStartTime());
        rsp.setEndTime(req.getEndTime());
        rsp.setUseStatus(req.getUseStatus());
        rsp.setUsedTimes(req.getUsedTimes());
        rsp.setTotalAmount(req.getTotalAmount());
        rsp.setUsedAmount(req.getUsedAmount());
        rsp.setDiscountRate(req.getDiscountRate());
        rsp.setCouponSrcInstance(req.getCouponSrcInstance());
        rsp.setCouponSrcChannel(req.getCouponSrcChannel());
        rsp.setDistributeTime(req.getDistributeTime());
        rsp.setLastUseTime(req.getLastUseTime());
        rsp.setTemplateId(req.getTemplateId());
        rsp.setParam1(req.getParam1());
        rsp.setParam2(req.getParam2());
        rsp.setParam3(req.getParam3());
        rsp.setParam4(req.getParam4());
        rsp.setParam5(req.getParam5());
        rsp.setParam6(req.getParam6());
        rsp.setParam7(req.getParam7());
        rsp.setUsefulObjType(req.getUsefulObjType());
        rsp.setExpireQryTime(req.getExpireQryTime());
        rsp.setActivityId(req.getActivityId());
        return rsp;
    }

    private CouponInstancePO bo2PO(CouponInstanceBO req) {
        CouponInstancePO rsp = new CouponInstancePO();
        rsp.setCouponInstanceId(req.getCouponInstanceId());
        rsp.setCouponId(req.getCouponId());
        rsp.setTenantId(req.getTenantId());
        rsp.setUid(req.getUid());
        rsp.setExchangeCode(req.getExchangeCode());
        rsp.setCouponType(req.getCouponType());
        rsp.setCouponName(req.getCouponName());
        rsp.setCouponDesc(req.getCouponDesc());
        rsp.setCrtTime(req.getCrtTime());
        rsp.setStartTime(req.getStartTime());
        rsp.setEndTime(req.getEndTime());
        rsp.setUseStatus(req.getUseStatus());
        rsp.setUsedTimes(req.getUsedTimes());
        rsp.setTotalAmount(req.getTotalAmountL());
        rsp.setUsedAmount(req.getUsedAmount());
        rsp.setDiscountRate(req.getDiscountRateD());
        rsp.setCouponSrcInstance(req.getCouponSrcInstance());
        rsp.setCouponSrcChannel(req.getCouponSrcChannel());
        rsp.setDistributeTime(req.getDistributeTime());
        rsp.setLastUseTime(req.getLastUseTime());
        rsp.setTemplateId(req.getTemplateId());
        rsp.setParam1(req.getParam1());
        rsp.setParam2(req.getParam2());
        rsp.setParam3(req.getParam3());
        rsp.setParam4(req.getParam4());
        rsp.setParam5(req.getParam5());
        rsp.setParam6(req.getParam6());
        rsp.setParam7(req.getParam7());
        rsp.setUsefulObjType(req.getUsefulObjType());
        rsp.setActivityId(req.getActivityId());
        return rsp;
    }

    @Override
    public RspBaseBO updateCouponInstance(CouponInstanceBO couponInstanceReqBO) {
        RspBaseBO result = new RspBaseBO();
        if (null == couponInstanceReqBO.getCouponInstanceId()) {
            log.error("\u5165\u53c2\u7535\u5b50\u52b5\u5b9e\u4f8bid\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5165\u53c2\u7535\u5b50\u52b5\u5b9e\u4f8bid[couponInstanceId]\u4e3a\u7a7a");
        }
        try {
            CouponInstancePO couponInstancePO = this.bo2PO(couponInstanceReqBO);
            int i = this.couponInstanceDAO.updateByPrimaryKeySelective(couponInstancePO);
            if (i > 0) {
                result.setRespCode("0000");
                result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
                return result;
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return result;
    }

    private void transferTime(CouponInstanceBO couponInstanceBO) {
        int timeDur;
        if (null != couponInstanceBO.getStartTime()) {
            String startTimeStr = TkDateUtils.formatDate((Date)couponInstanceBO.getStartTime(), (String)"yyyy-MM-dd");
            couponInstanceBO.setStartTimeStr(startTimeStr);
        }
        if (null != couponInstanceBO.getEndTime()) {
            String endTimeStr = TkDateUtils.formatDate((Date)couponInstanceBO.getEndTime(), (String)"yyyy-MM-dd");
            couponInstanceBO.setEndTimeStr(endTimeStr);
        }
        couponInstanceBO.setAboutToExpire("1");
        if (null != couponInstanceBO.getStartTime() && null != couponInstanceBO.getEndTime() && couponInstanceBO.getStartTime().before(new Date()) && couponInstanceBO.getEndTime().after(new Date()) && (timeDur = this.timeDuration(couponInstanceBO.getEndTime())) <= this.aboutExpireTime) {
            couponInstanceBO.setAboutToExpire("0");
        }
    }

    private int timeDuration(Date start) {
        if (start == null) {
            return 0;
        }
        long durationSec = (start.getTime() - System.currentTimeMillis()) / 1000L;
        return (int)durationSec;
    }

    @Override
    public List<CouponInstanceBO> listInstance(Set<Long> ids) {
        List<CouponInstancePO> pos;
        if (CollectionUtils.isEmpty(ids)) {
            log.error("\u5b9e\u4f8bID\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5b9e\u4f8bID\u96c6\u5408\u4e3a\u7a7a");
        }
        try {
            pos = this.couponInstanceDAO.selectByIds(ids);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u7535\u5b50\u5238\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u7535\u5b50\u5238\u5b9e\u4f8b\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<CouponInstanceBO> bos = new ArrayList<CouponInstanceBO>(pos.size());
        for (CouponInstancePO po : pos) {
            bos.add(po.toCouponInstanceBO());
        }
        return bos;
    }

    @Override
    public List<CouponInstanceBO> listInsByCouponIds(Long memId, Set<Long> couponIds) {
        if (CollectionUtils.isEmpty(couponIds) || null == memId) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        List<CouponInstancePO> pos = null;
        try {
            pos = this.couponInstanceDAO.selectByMemIdAndCouponId(memId, couponIds);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u7535\u5b50\u5238\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u7535\u5b50\u5238\u5b9e\u4f8b\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<CouponInstanceBO> bos = new ArrayList<CouponInstanceBO>(pos.size());
        for (CouponInstancePO po : pos) {
            bos.add(po.toCouponInstanceBO());
        }
        return bos;
    }

    @Override
    public void removeByInstance(Long memId, String instanceId, String channel) {
        if (null == memId || StringUtils.isBlank((CharSequence)instanceId) || StringUtils.isBlank((CharSequence)channel)) {
            log.error("\u7535\u5b50\u5238\u5220\u9664\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u5220\u9664\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            this.couponInstanceDAO.updateByInstance(memId, instanceId, channel);
        }
        catch (Exception e) {
            log.error("\u7535\u5b50\u5238\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u7535\u5b50\u5238\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<CouponInstanceBO> listByInstance(Long memId, String instanceId, String channel) {
        if (null == memId || StringUtils.isBlank((CharSequence)instanceId) || StringUtils.isBlank((CharSequence)channel)) {
            log.error("\u7535\u5b50\u5238\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        List<CouponInstancePO> pos = null;
        try {
            pos = this.couponInstanceDAO.selectByInstance(memId, instanceId, channel);
        }
        catch (Exception e) {
            log.error("\u7535\u5b50\u5238\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u7535\u5b50\u5238\u67e5\u8be2\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<CouponInstanceBO> bos = new ArrayList<CouponInstanceBO>(pos.size());
        for (CouponInstancePO ins : pos) {
            bos.add(ins.toCouponInstanceBO());
        }
        return bos;
    }
}

