/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.GiftAtomService;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomBO;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomPageReqBO;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomReqBO;
import com.tydic.newretail.act.dao.GiftDAO;
import com.tydic.newretail.act.dao.po.GiftPO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftAtomServiceImpl
implements GiftAtomService {
    private static final Logger log = LoggerFactory.getLogger(GiftAtomServiceImpl.class);
    @Autowired
    private GiftDAO giftDAO;
    @Autowired
    private QryEscapeAtomService qryEscapeAtomService;

    @Override
    public void saveByBatch(GiftInfoAtomReqBO reqBOs) {
        if (null == reqBOs && CollectionUtils.isEmpty(reqBOs.getInsertList())) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<GiftPO> pos = new ArrayList<GiftPO>(reqBOs.getInsertList().size());
        for (GiftInfoAtomBO bo : reqBOs.getInsertList()) {
            pos.add(GiftPO.toGiftPO(bo));
        }
        try {
            this.giftDAO.insertByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
    }

    @Override
    public int removeBatch(List<Long> deleteList) {
        int result = 0;
        if (CollectionUtils.isNotEmpty(deleteList)) {
            try {
                result = this.giftDAO.deleteBatch(deleteList);
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u8d60\u54c1id\u5217\u8868\u6279\u91cf\u5220\u9664\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
                TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u8d60\u54c1id\u5217\u8868\u6279\u91cf\u5220\u9664\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            }
        }
        return result;
    }

    @Override
    public RspPageBaseBO<GiftInfoAtomBO> selectByPage(GiftInfoAtomPageReqBO reqBO) {
        if (reqBO.getCurrent() <= 0 || reqBO.getPageSize() <= 0) {
            log.error("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5206\u9875\u53c2\u6570current\u548cpageSize\u5fc5\u586b");
        }
        RspPageBaseBO result = new RspPageBaseBO();
        try {
            Page page = new Page();
            page.setOffset(reqBO.getOffset());
            page.setLimit(reqBO.getPageSize());
            GiftPO giftPO = new GiftPO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)giftPO);
            List<GiftPO> giftPOList = this.giftDAO.selectByPage((Page<GiftPO>)page, giftPO);
            ArrayList<GiftInfoAtomBO> rspList = new ArrayList<GiftInfoAtomBO>();
            if (CollectionUtils.isNotEmpty(giftPOList)) {
                for (GiftPO po : giftPOList) {
                    GiftInfoAtomBO bo = new GiftInfoAtomBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    String giftTypeStr = this.qryEscapeAtomService.getCodeTitle("GIFT_TYPE_NAME", po.getGiftType());
                    bo.setGiftTypeStr(StringUtils.isBlank((CharSequence)giftTypeStr) ? "\u672a\u5b9a\u4e49" : giftTypeStr);
                    if (null != po.getCrtTime()) {
                        String crtTimeStr = TkDateUtils.formatDate((Date)po.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss");
                        bo.setCrtTimeStr(crtTimeStr);
                    }
                    if (null != po.getLastUpdTime()) {
                        String lastUpdTimeStr = TkDateUtils.formatDate((Date)po.getLastUpdTime(), (String)"yyyy-MM-dd HH:mm:ss");
                        bo.setLastUpdTimeStr(lastUpdTimeStr);
                    }
                    if (null != po.getGiftPrice()) {
                        try {
                            BigDecimal bg = new BigDecimal(bo.getGiftPrice());
                            bo.setGiftPrice(bg.divide(new BigDecimal(10000)).toString());
                        }
                        catch (Exception e) {
                            log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                        }
                    }
                    rspList.add(bo);
                }
            }
            result.setRows(rspList);
            result.setRecordsTotal(page.getTotalCount());
            result.setTotal(page.getTotalPages());
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return result;
    }

    @Override
    public RspBatchBaseBO<GiftInfoAtomBO> selectGiftByCondition(GiftInfoAtomBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        RspBatchBaseBO result = new RspBatchBaseBO();
        List<Object> polist = new ArrayList();
        GiftPO po = new GiftPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        try {
            polist = this.giftDAO.selectGiftByCondition(po);
        }
        catch (Exception e) {
            log.error("\u5168\u91cf\u67e5\u8be2\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        if (CollectionUtils.isEmpty(polist)) {
            result.setRespCode("0002");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u8d60\u54c1\u5217\u8868");
            return result;
        }
        ArrayList<GiftInfoAtomBO> rspList = new ArrayList<GiftInfoAtomBO>();
        for (GiftPO giftPO : polist) {
            GiftInfoAtomBO bo = new GiftInfoAtomBO();
            BeanUtils.copyProperties((Object)giftPO, (Object)bo);
            rspList.add(bo);
        }
        result.setRows(rspList);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @Override
    public List<GiftInfoAtomBO> listGiftById(Set<Long> giftIds) {
        if (CollectionUtils.isEmpty(giftIds)) {
            log.error("\u8d60\u54c1ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u8d60\u54c1ID\u4e3a\u7a7a");
        }
        List<GiftPO> pos = null;
        try {
            pos = this.giftDAO.selectByGiftIds(giftIds);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8d60\u54c1ID\u96c6\u5408\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            TkThrExceptionUtils.thrQryExce((String)"\u6839\u636e\u8d60\u54c1ID\u96c6\u5408\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<GiftInfoAtomBO> bos = new ArrayList<GiftInfoAtomBO>(pos.size());
        for (GiftPO po : pos) {
            GiftInfoAtomBO bo = new GiftInfoAtomBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    @Override
    public GiftInfoAtomBO getGiftInfoDetail(Long giftId) {
        if (null == giftId) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        GiftInfoAtomBO rspBo = new GiftInfoAtomBO();
        GiftPO po = null;
        try {
            po = this.giftDAO.selectByPrimaryKey(giftId);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d60\u54c1\u660e\u7ec6\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            TkThrExceptionUtils.thrQryExce((String)"\u6839\u636e\u8d60\u54c1id\u6279\u91cf\u4fee\u6539\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
        if (null == po) {
            return null;
        }
        BeanUtils.copyProperties((Object)po, (Object)rspBo);
        return rspBo;
    }

    @Override
    public int updateBatch(GiftInfoAtomReqBO reqBO) {
        int result = 0;
        if (null == reqBO && CollectionUtils.isEmpty(reqBO.getInsertList())) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<GiftPO> poList = new ArrayList<GiftPO>();
        for (GiftInfoAtomBO bo : reqBO.getInsertList()) {
            GiftPO po = new GiftPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setLastUpdTime(new Date());
            poList.add(po);
        }
        try {
            result = this.giftDAO.updateBatch(poList);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8d60\u54c1id\u6279\u91cf\u4fee\u6539\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u8d60\u54c1id\u6279\u91cf\u4fee\u6539\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
        return result;
    }

    @Override
    public int updateAvailableCount(Long giftId, Integer usedCount) {
        int result = 0;
        if (null == giftId || null == usedCount) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            result = this.giftDAO.updateAvailableCount(giftId, usedCount);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8d60\u54c1\u53ef\u7528\u5e93\u5b58\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u66f4\u65b0\u8d60\u54c1\u53ef\u7528\u5e93\u5b58\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
        }
        return result;
    }
}

