/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.GiftInstanceAtomService;
import com.tydic.newretail.act.atom.bo.GiftInstanceAtomBO;
import com.tydic.newretail.act.atom.bo.GiftInstanceAtomPageReqBO;
import com.tydic.newretail.act.atom.bo.GiftInstanceAtomReqBO;
import com.tydic.newretail.act.dao.GiftInstanceDAO;
import com.tydic.newretail.act.dao.po.GiftInstancePO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftInstanceAtomServiceImpl
implements GiftInstanceAtomService {
    private static final Logger log = LoggerFactory.getLogger(GiftInstanceAtomServiceImpl.class);
    @Autowired
    private GiftInstanceDAO giftInstanceDAO;

    @Override
    public void saveByBatch(GiftInstanceAtomReqBO reqBOs) {
        if (null == reqBOs && CollectionUtils.isEmpty(reqBOs.getInsertList())) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<GiftInstancePO> pos = new ArrayList<GiftInstancePO>(reqBOs.getInsertList().size());
        for (GiftInstanceAtomBO bo : reqBOs.getInsertList()) {
            GiftInstancePO po = new GiftInstancePO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setLastUpdTime(new Date());
            pos.add(po);
        }
        try {
            this.giftInstanceDAO.insertByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
    }

    @Override
    public int removeBatch(List<Long> deleteList) {
        int result = 0;
        if (CollectionUtils.isNotEmpty(deleteList)) {
            try {
                result = this.giftInstanceDAO.deleteBatch(deleteList);
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bid\u5217\u8868\u6279\u91cf\u5220\u9664\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
                TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bid\u5217\u8868\u6279\u91cf\u5220\u9664\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            }
        }
        return result;
    }

    @Override
    public RspPageBaseBO<GiftInstanceAtomBO> selectByPage(GiftInstanceAtomPageReqBO reqBO) {
        if (reqBO.getCurrent() <= 0 || reqBO.getPageSize() <= 0) {
            log.error("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5206\u9875\u53c2\u6570current\u548cpageSize\u5fc5\u586b");
        }
        RspPageBaseBO result = new RspPageBaseBO();
        try {
            Page page = new Page();
            page.setOffset(reqBO.getOffset());
            page.setLimit(reqBO.getPageSize());
            GiftInstancePO giftInstancePO = new GiftInstancePO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)giftInstancePO);
            List<GiftInstancePO> giftInstancePOList = this.giftInstanceDAO.selectByPage((Page<GiftInstancePO>)page, giftInstancePO);
            ArrayList<GiftInstanceAtomBO> rspList = new ArrayList<GiftInstanceAtomBO>();
            if (CollectionUtils.isNotEmpty(giftInstancePOList)) {
                for (GiftInstancePO po : giftInstancePOList) {
                    GiftInstanceAtomBO bo = new GiftInstanceAtomBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rspList.add(bo);
                }
            }
            result.setRows(rspList);
            result.setRecordsTotal(page.getTotalPages());
            result.setTotal(page.getTotalCount());
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return result;
    }

    @Override
    public RspBatchBaseBO<GiftInstanceAtomBO> selectGiftInstanceByCondition(GiftInstanceAtomBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        RspBatchBaseBO result = new RspBatchBaseBO();
        List<Object> polist = new ArrayList();
        GiftInstancePO po = new GiftInstancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        try {
            polist = this.giftInstanceDAO.selectGiftInstanceByCondition(po);
        }
        catch (Exception e) {
            log.error("\u5168\u91cf\u67e5\u8be2\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        if (CollectionUtils.isEmpty(polist)) {
            result.setRespCode("0002");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u8d60\u54c1\u5b9e\u4f8b\u5217\u8868");
            return result;
        }
        ArrayList<GiftInstanceAtomBO> rspList = new ArrayList<GiftInstanceAtomBO>();
        for (GiftInstancePO giftInstancePO : polist) {
            GiftInstanceAtomBO bo = new GiftInstanceAtomBO();
            BeanUtils.copyProperties((Object)giftInstancePO, (Object)bo);
            rspList.add(bo);
        }
        result.setRows(rspList);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @Override
    public GiftInstanceAtomBO getGiftInfoDetail(GiftInstanceAtomBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        GiftInstanceAtomBO rspBo = new GiftInstanceAtomBO();
        GiftInstancePO giftInstancePO = null;
        try {
            giftInstancePO = this.giftInstanceDAO.selectByPrimaryKey(reqBO.getGiftInstanceId());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d60\u54c1\u5b9e\u4f8b\u660e\u7ec6\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        if (null == giftInstancePO) {
            return null;
        }
        BeanUtils.copyProperties((Object)giftInstancePO, (Object)rspBo);
        return rspBo;
    }

    @Override
    public int updateBatch(GiftInstanceAtomReqBO reqBO) {
        int result = 0;
        if (null == reqBO && CollectionUtils.isEmpty(reqBO.getInsertList())) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<GiftInstancePO> poList = new ArrayList<GiftInstancePO>();
        for (GiftInstanceAtomBO bo : reqBO.getInsertList()) {
            GiftInstancePO po = new GiftInstancePO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setLastUpdTime(new Date());
            poList.add(po);
        }
        try {
            result = this.giftInstanceDAO.updateBatch(poList);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bid\u5217\u8868\u6279\u91cf\u5220\u9664\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bid\u5217\u8868\u6279\u91cf\u5220\u9664\u8d60\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
        return result;
    }

    @Override
    public int updateBygiftInstanceIdAndtenantId(GiftInstanceAtomBO reqBO) {
        int result = 0;
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        GiftInstancePO po = new GiftInstancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setLastUpdTime(new Date());
        try {
            result = this.giftInstanceDAO.updateBygiftInstanceIdAndtenantId(po);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bid\u548c\u7528\u6237id\u4fee\u6539\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bid\u548c\u7528\u6237id\u4fee\u6539\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
        return result;
    }

    @Override
    public GiftInstanceAtomBO insertSelective(GiftInstanceAtomBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        GiftInstancePO po = new GiftInstancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setLastUpdTime(new Date());
        po.setIsValid("1");
        try {
            this.giftInstanceDAO.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
        GiftInstanceAtomBO bo = new GiftInstanceAtomBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }

    @Override
    public List<GiftInstanceAtomBO> listGiftInstanceById(Set<Long> giftInstanceId) {
        if (CollectionUtils.isEmpty(giftInstanceId)) {
            log.error("\u8d60\u54c1\u5b9e\u4f8bID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u8d60\u54c1\u5b9e\u4f8bID\u4e3a\u7a7a");
        }
        List<GiftInstancePO> pos = null;
        try {
            pos = this.giftInstanceDAO.selectByGiftInstanceIds(giftInstanceId);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bID\u96c6\u5408\u67e5\u8be2\u8d60\u54c1\u5b9e\u4f8b\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            TkThrExceptionUtils.thrQryExce((String)"\u6839\u636e\u8d60\u54c1\u5b9e\u4f8bID\u96c6\u5408\u67e5\u8be2\u8d60\u54c1\u5b9e\u4f8b\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u51fa\u9519");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<GiftInstanceAtomBO> bos = new ArrayList<GiftInstanceAtomBO>(pos.size());
        for (GiftInstancePO po : pos) {
            GiftInstanceAtomBO bo = new GiftInstanceAtomBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }
}

