/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.GiftPkgAtomService;
import com.tydic.newretail.act.bo.GiftPkgInfoBO;
import com.tydic.newretail.act.dao.GiftPkgDAO;
import com.tydic.newretail.act.dao.po.GiftPkgPO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftPkgAtomServiceImpl
implements GiftPkgAtomService {
    private static final Logger log = LoggerFactory.getLogger(GiftPkgAtomServiceImpl.class);
    @Autowired
    private GiftPkgDAO giftPkgDAO;

    @Override
    public GiftPkgInfoBO saveGiftPkgInfo(GiftPkgInfoBO reqBO) {
        GiftPkgInfoBO rsp = new GiftPkgInfoBO();
        GiftPkgPO po = new GiftPkgPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPkgPrice())) {
            po.setPkgPrice(Long.valueOf(TkCalculatorUtils.transfetL((String)reqBO.getPkgPrice())));
        }
        po.setCrtTime(new Date());
        po.setIsValid("1");
        try {
            this.giftPkgDAO.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u8d60\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)po, (Object)rsp);
        log.debug("\u65b0\u589e\u8d60\u54c1\u4fe1\u606f\u51fa\u53c2" + po.toString());
        return rsp;
    }

    @Override
    public GiftPkgInfoBO getGiftPkgInfo(GiftPkgInfoBO reqBO) {
        GiftPkgPO po;
        boolean conditionEmpty;
        boolean bl = conditionEmpty = null == reqBO.getPkgId();
        if (null == reqBO || conditionEmpty) {
            log.error("\u8d60\u54c1ID\u5fc5\u586b");
            throw new ResourceException("0001", "\u8d60\u54c1ID\u5fc5\u586b");
        }
        GiftPkgPO record = new GiftPkgPO();
        record.setPkgId(reqBO.getPkgId());
        try {
            po = this.giftPkgDAO.selectById(record);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        if (null == po) {
            return null;
        }
        GiftPkgInfoBO bo = new GiftPkgInfoBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }

    @Override
    public void modifyGiftPkg(GiftPkgInfoBO reqBO, boolean selectFlag) {
        if (null == reqBO.getPkgId()) {
            log.error("\u8d60\u54c1ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1ID\u4e3a\u7a7a");
        }
        GiftPkgPO po = new GiftPkgPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setLastUpdTime(new Date());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPkgPrice())) {
            po.setPkgPrice(Long.valueOf(reqBO.getPkgPrice()));
        }
        try {
            if (selectFlag) {
                this.giftPkgDAO.updateByPrimaryKeySelective(po);
            } else {
                this.giftPkgDAO.updateByPrimaryKey(po);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8d60\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u66f4\u65b0\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public RspPageBaseBO<GiftPkgInfoBO> getGiftPkgInfoList(GiftPkgInfoBO reqBO) {
        RspPageBaseBO pkgInfo = new RspPageBaseBO();
        ArrayList<GiftPkgInfoBO> giftPkgInfoBOS = new ArrayList<GiftPkgInfoBO>();
        GiftPkgPO giftPkgPO = new GiftPkgPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)giftPkgPO);
        List<GiftPkgPO> giftPkgPOS = null;
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getCurrent());
        try {
            giftPkgPOS = this.giftPkgDAO.selectByCondition(giftPkgPO, (Page<GiftPkgPO>)page);
        }
        catch (Exception e) {
            log.error("\u6761\u4ef6\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u6761\u4ef6\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(giftPkgPOS)) {
            for (GiftPkgPO po : giftPkgPOS) {
                GiftPkgInfoBO bo = new GiftPkgInfoBO();
                if (null != po.getPkgPrice()) {
                    bo.setPkgPrice(po.getPkgPrice().toString());
                }
                BeanUtils.copyProperties((Object)po, (Object)bo);
                giftPkgInfoBOS.add(bo);
            }
        }
        pkgInfo.setRows(giftPkgInfoBOS);
        pkgInfo.setTotal(page.getTotalPages());
        pkgInfo.setRecordsTotal(page.getTotalCount());
        return pkgInfo;
    }

    @Override
    public GiftPkgInfoBO getGiftPkgInfoById(Long pkgId) {
        GiftPkgInfoBO giftPkgInfoBO = new GiftPkgInfoBO();
        GiftPkgPO giftPkgPO = null;
        try {
            giftPkgPO = this.giftPkgDAO.selectByPrimaryKey(pkgId);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u8be6\u60c5\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)giftPkgPO, (Object)giftPkgInfoBO);
        if (null != giftPkgPO.getPkgPrice()) {
            giftPkgInfoBO.setPkgPrice(giftPkgPO.getPkgPrice().toString());
            giftPkgInfoBO.setPkgPriceDouble(TkCalculatorUtils.transferY((String)giftPkgPO.getPkgPrice().toString()));
        }
        return giftPkgInfoBO;
    }
}

