/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.GiftPkgObjectAtomService;
import com.tydic.newretail.act.bo.GiftPkgObjectInfoBO;
import com.tydic.newretail.act.dao.GiftPkgObjectDAO;
import com.tydic.newretail.act.dao.po.GiftPkgObjectPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftPkgObjectAtomServiceImpl
implements GiftPkgObjectAtomService {
    private static final Logger log = LoggerFactory.getLogger(GiftPkgObjectAtomServiceImpl.class);
    @Autowired
    private GiftPkgObjectDAO giftPkgObjectDAO;

    @Override
    public void saveByBatch(List<GiftPkgObjectInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<GiftPkgObjectPO> pos = new ArrayList<GiftPkgObjectPO>(reqBOs.size());
        for (GiftPkgObjectInfoBO bo : reqBOs) {
            if (StringUtils.isBlank((CharSequence)bo.getPkgCode()) || null == bo.getPkgId()) {
                log.error("\u8d60\u54c1\u5305ID\u3001\u8d60\u54c1\u5305\u7f16\u7801\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305ID\u3001\u8d60\u54c1\u5305\u7f16\u7801\u4e3a\u7a7a");
            }
            if (null == bo.getTenantId()) {
                log.error("\u79df\u6237ID\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getObjType()) || StringUtils.isBlank((CharSequence)bo.getObjCode())) {
                log.error("\u8d60\u54c1\u5305\u5bf9\u8c61\u7f16\u7801\u6216\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u5bf9\u8c61\u7f16\u7801\u6216\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
            }
            GiftPkgObjectPO po = new GiftPkgObjectPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateTime(new Date());
            po.setIsValid("1");
            pos.add(po);
        }
        try {
            this.giftPkgObjectDAO.insertByBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u89c4\u5219\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u89c4\u5219\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public void removeByPkgId(Long pkgId) {
        if (null == pkgId) {
            log.error("\u8d60\u54c1ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1ID\u4e3a\u7a7a");
        }
        try {
            this.giftPkgObjectDAO.deleteByPkgId(pkgId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8d60\u54c1\u9002\u7528\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u8d60\u54c1\u9002\u7528\u8303\u56f4\u5931\u8d25");
        }
    }

    @Override
    public List<GiftPkgObjectInfoBO> getGiftPkgObjectBOList(GiftPkgObjectInfoBO reqBO) {
        ArrayList<GiftPkgObjectInfoBO> list = new ArrayList<GiftPkgObjectInfoBO>();
        GiftPkgObjectPO giftPkgObjectPO = new GiftPkgObjectPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)giftPkgObjectPO);
        List<GiftPkgObjectPO> pos = null;
        try {
            pos = this.giftPkgObjectDAO.selectByCondition(giftPkgObjectPO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d60\u54c1\u9002\u7528\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u67e5\u8be2\u8d60\u54c1\u9002\u7528\u8303\u56f4\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (GiftPkgObjectPO po : pos) {
                GiftPkgObjectInfoBO bo = new GiftPkgObjectInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                list.add(bo);
            }
        }
        return list;
    }

    @Override
    public void invalidBatchByRuleId(Set<Long> pkgIds) {
        if (CollectionUtils.isEmpty(pkgIds)) {
            log.error("\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
        }
        try {
            this.giftPkgObjectDAO.invalidByPkgIds(pkgIds);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8d60\u54c1\u5305\u9002\u7528\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u5220\u9664\u8d60\u54c1\u5305\u9002\u7528\u8303\u56f4\u5931\u8d25");
        }
    }
}

