/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.tydic.newretail.act.atom.PkgComposeAtomService;
import com.tydic.newretail.act.bo.PkgComposeInfoBO;
import com.tydic.newretail.act.dao.PkgComposeDAO;
import com.tydic.newretail.act.dao.po.PkgComposePO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PkgComposeAtomServiceImpl
implements PkgComposeAtomService {
    private static final Logger log = LoggerFactory.getLogger(PkgComposeAtomServiceImpl.class);
    @Autowired
    private PkgComposeDAO pkgComposeDAO;

    @Override
    public void savePkgCompose(List<PkgComposeInfoBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<PkgComposePO> pos = new ArrayList<PkgComposePO>(reqBOs.size());
        for (PkgComposeInfoBO bo : reqBOs) {
            this.checkParams(bo);
            PkgComposePO po = new PkgComposePO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            if (StringUtils.isNotEmpty((CharSequence)bo.getGiftPrice())) {
                po.setGiftPrice(Long.valueOf(bo.getGiftPrice()));
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getGiftRealPrice())) {
                po.setGiftRealPrice(Long.valueOf(bo.getGiftRealPrice()));
            }
            po.setCrtTime(new Date());
            po.setIsValid("1");
            pos.add(po);
        }
        try {
            this.pkgComposeDAO.insertByBatch(pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u6784\u6210\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrInsExce((String)"\u6279\u91cf\u65b0\u589e\u8d60\u54c1\u6784\u6210\u5931\u8d25");
        }
    }

    @Override
    public void removeByPkgId(Long pkgId) {
        if (null == pkgId) {
            log.error("\u8d60\u54c1ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1ID\u4e3a\u7a7a");
        }
        try {
            this.pkgComposeDAO.deleteByPkgId(pkgId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8d60\u54c1\u6784\u6210\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u5220\u9664\u8d60\u54c1\u6784\u6210\u5931\u8d25");
        }
    }

    @Override
    public List<PkgComposeInfoBO> getPkgComposeInfoList(PkgComposeInfoBO reqBO) {
        ArrayList<PkgComposeInfoBO> pkgComposeInfoBOS = new ArrayList<PkgComposeInfoBO>();
        PkgComposePO pkgComposePO = new PkgComposePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)pkgComposePO);
        List<PkgComposePO> pos = null;
        try {
            pos = this.pkgComposeDAO.selectByCondition(pkgComposePO);
        }
        catch (Exception e) {
            TkThrExceptionUtils.thrQryExce((String)"\u6761\u4ef6\u67e5\u8be2\u8d60\u54c1\u96c6\u5408\u51fa\u9519\uff01");
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (PkgComposePO po : pos) {
                PkgComposeInfoBO bo = new PkgComposeInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                if (null != po.getGiftPrice()) {
                    bo.setGiftPrice(po.getGiftPrice().toString());
                    bo.setGiftPriceYuan(TkCalculatorUtils.transferY((String)po.getGiftPrice().toString()));
                }
                if (null != po.getGiftRealPrice()) {
                    bo.setGiftRealPrice(po.getGiftRealPrice().toString());
                    bo.setGiftRealPriceYuan(TkCalculatorUtils.transferY((String)po.getGiftRealPrice().toString()));
                }
                pkgComposeInfoBOS.add(bo);
            }
        }
        return pkgComposeInfoBOS;
    }

    @Override
    public void invalidBatchByRuleId(Set<Long> pkgIds) {
        if (CollectionUtils.isEmpty(pkgIds)) {
            log.error("\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
        }
        try {
            this.pkgComposeDAO.invalidByPkgIds(pkgIds);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8d60\u54c1\u5305\u6784\u6210\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u5220\u9664\u8d60\u54c1\u5305\u6784\u6210\u5931\u8d25");
        }
    }

    private void checkParams(PkgComposeInfoBO bo) {
        if (null == bo.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (null == bo.getPkgId()) {
            log.error("\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getPkgCode())) {
            log.error("\u8d60\u54c1\u5305\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getGiftName())) {
            log.error("\u8d60\u54c1\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == bo.getGiftPrice()) {
            log.error("\u8d60\u54c1\u4ef7\u683c\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u4ef7\u683c\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getObjectType())) {
            log.error("\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getObjectCode())) {
            log.error("\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == bo.getSendCount()) {
            log.error("\u5df2\u8d60\u6570\u91cf\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5df2\u8d60\u6570\u91cf\u4e3a\u7a7a");
        }
    }
}

