/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActRelationAtomService;
import com.tydic.newretail.act.atom.CouponRelationAtomService;
import com.tydic.newretail.act.atom.QryMutuallyExclusiveAtomService;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityRelationBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponRelationBO;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.act.util.SortActUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryMutuallyExclusiveAtomServiceImpl
implements QryMutuallyExclusiveAtomService {
    private static final Logger log = LoggerFactory.getLogger(QryMutuallyExclusiveAtomServiceImpl.class);
    @Autowired
    private ActRelationAtomService actRelationAtomService;
    @Autowired
    private CouponRelationAtomService couponRelationAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    Boolean checkNotExcAct = true;

    @Override
    public List<ActivityBO> checkAct(List<ActivityBO> checkList, List<ActivityBO> actList) {
        Object tempList;
        if (CollectionUtils.isEmpty(actList)) {
            log.debug("\u6d3b\u52a8\u96c6\u5408\u4e3a\u7a7a");
            return actList;
        }
        if (CollectionUtils.isNotEmpty(checkList)) {
            log.debug("\u6d3b\u52a8\u4e92\u65a5\u67e5\u8be2\u5165\u53c2:" + JSON.toJSONString(actList) + "||" + JSON.toJSONString(checkList));
        } else {
            log.debug("\u6d3b\u52a8\u4e92\u65a5\u67e5\u8be2\u5165\u53c2:" + JSON.toJSONString(actList) + "|| null");
        }
        this.checkNotExcAct = true;
        this.setActList(actList);
        HashSet<Long> checkSet = new HashSet<Long>(16);
        HashSet<String> actTypes = new HashSet<String>(16);
        HashSet<Long> actIds = new HashSet<Long>(16);
        for (ActivityBO act : actList) {
            if (!"1".equals(act.getCheckFlag())) continue;
            checkSet.add(act.getActivityId());
            actTypes.add(act.getActivityType());
            actIds.add(act.getActivityId());
        }
        if (!CollectionUtils.isEmpty(checkList)) {
            for (ActivityBO act : checkList) {
                if (!"0".equals(act.getForceChooseFlag())) continue;
                checkSet.add(act.getActivityId());
                actTypes.add(act.getActivityType());
                actIds.add(act.getActivityId());
                if (!"1".equals(act.getExclusiveFlag())) continue;
                this.checkNotExcAct = false;
            }
        }
        HashMap<Long, Set<String>> idsMap = new HashMap<Long, Set<String>>();
        HashMap<String, Set<String>> typesMap = new HashMap<String, Set<String>>();
        ArrayList shareActList = new ArrayList();
        if (CollectionUtils.isNotEmpty(actIds) && CollectionUtils.isNotEmpty(tempList = this.actRelationAtomService.listRelationById(actIds, "0"))) {
            shareActList.addAll(tempList);
        }
        if (CollectionUtils.isNotEmpty(actTypes) && CollectionUtils.isNotEmpty((Collection)(tempList = this.actRelationAtomService.listRelationByType(actTypes, "0")))) {
            shareActList.addAll(tempList);
        }
        if (CollectionUtils.isNotEmpty(shareActList)) {
            for (ActivityRelationBO rela : shareActList) {
                if (StringUtils.isBlank((CharSequence)rela.getObjectRegion())) continue;
                switch (rela.getObjectType()) {
                    case "00": {
                        HashSet<String> idSet = idsMap.containsKey(rela.getActivityId()) ? (Set)idsMap.get(rela.getActivityId()) : new HashSet<String>();
                        idSet.add(rela.getObjectRegion());
                        idsMap.put(rela.getActivityId(), idSet);
                        break;
                    }
                    case "01": {
                        HashSet<String> typeSet = typesMap.containsKey(rela.getActivityType()) ? (Set)typesMap.get(rela.getActivityType()) : new HashSet<String>();
                        typeSet.add(rela.getObjectRegion());
                        typesMap.put(rela.getActivityType(), typeSet);
                        break;
                    }
                }
            }
        }
        HashSet<String> shareIds = new HashSet<String>();
        HashSet<String> shareTypes = new HashSet<String>();
        this.getShareAct(idsMap, typesMap, shareIds, shareTypes);
        for (ActivityBO act : actList) {
            ConvertParamUtils.escaptAct(act, this.qryEscapeAtomService, false);
            if (checkSet.isEmpty()) {
                act.setOptionalFlag("1");
                continue;
            }
            if (checkSet.contains(act.getActivityId())) {
                act.setCheckFlag("1");
                act.setOptionalFlag("1");
                continue;
            }
            if ("1".equals(act.getForceChooseFlag())) continue;
            if (CollectionUtils.isNotEmpty(shareIds) && shareIds.contains(act.getActivityId().toString())) {
                act.setOptionalFlag("1");
                continue;
            }
            if (!CollectionUtils.isNotEmpty(shareTypes) || !shareTypes.contains(act.getActivityType()) || !this.checkNotExcAct.booleanValue() || !"0".equals(act.getExclusiveFlag())) continue;
            act.setOptionalFlag("1");
        }
        return actList;
    }

    private void getShareAct(Map<Long, Set<String>> idsMap, Map<String, Set<String>> typesMap, Set<String> actIds, Set<String> actTypes) {
        int index;
        if (!idsMap.isEmpty()) {
            index = 1;
            for (Set<String> idSet : idsMap.values()) {
                if (index == 1) {
                    actIds.addAll(idSet);
                    ++index;
                    continue;
                }
                ++index;
                actIds.retainAll(idSet);
            }
        }
        if (!typesMap.isEmpty()) {
            index = 1;
            for (Set<String> typeSet : typesMap.values()) {
                if (index == 1) {
                    actTypes.addAll(typeSet);
                    ++index;
                    continue;
                }
                ++index;
                actTypes.retainAll(typeSet);
            }
        }
        log.debug("\u53ef\u540c\u4eabID\u96c6\u5408\u4e3a\uff1a" + actIds.toString());
        log.debug("\u53ef\u540c\u4eab\u7c7b\u578b\u96c6\u5408\u4e3a\uff1a" + actTypes.toString());
    }

    private void setActList(List<ActivityBO> actList) {
        Long excActId = null;
        Long forceActId = null;
        boolean forceExcFlag = false;
        for (ActivityBO act : actList) {
            act.setOptionalFlag("0");
            act.setCheckFlag("0");
            if ("1".equals(act.getExclusiveFlag()) && null == excActId) {
                excActId = act.getActivityId();
            }
            if (!"1".equals(act.getForceChooseFlag())) continue;
            act.setCheckFlag("1");
            act.setOptionalFlag("1");
            if (null != forceActId) continue;
            forceActId = act.getActivityId();
            if (!"1".equals(act.getExclusiveFlag())) continue;
            forceExcFlag = true;
        }
        if (null != forceActId) {
            boolean excFlag = null != excActId && excActId.equals(forceActId);
            for (ActivityBO act : actList) {
                if (act.getActivityId().equals(forceActId) || !excFlag && !forceExcFlag) continue;
                act.setOptionalFlag("0");
                act.setCheckFlag("0");
                this.checkNotExcAct = false;
            }
        }
    }

    @Override
    public List<CouponInstanceBO> checkCoupon(List<CouponInstanceBO> reqBOs, Set<Long> notReachList) {
        List<CouponRelationBO> relationBOS;
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u7535\u5b50\u5238\u5b9e\u4f8b\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u7535\u5b50\u5238\u5b9e\u4f8b\u96c6\u5408\u4e3a\u7a7a");
        }
        HashSet<String> types = new HashSet<String>(16);
        HashSet<Long> checkSet = new HashSet<Long>(16);
        HashSet<Long> couponIds = new HashSet<Long>(16);
        for (CouponInstanceBO couponInstanceBO : reqBOs) {
            if (!"1".equals(couponInstanceBO.getCheckFlag())) continue;
            checkSet.add(couponInstanceBO.getCouponId());
            types.add(couponInstanceBO.getCouponType());
            couponIds.add(couponInstanceBO.getCouponId());
        }
        if (CollectionUtils.isNotEmpty(checkSet) && CollectionUtils.isNotEmpty(relationBOS = this.couponRelationAtomService.listRelation(checkSet, types))) {
            for (CouponRelationBO relation : relationBOS) {
                switch (relation.getObjectType()) {
                    case "00": {
                        couponIds.add(Long.parseLong(relation.getObjectRegion()));
                        break;
                    }
                    case "01": {
                        types.add(relation.getObjectRegion());
                        break;
                    }
                }
            }
        }
        for (CouponInstanceBO couponInstanceBO : reqBOs) {
            ConvertParamUtils.escapeCoupon(couponInstanceBO, this.qryEscapeAtomService);
            couponInstanceBO.setOptionalFlag("1");
            couponInstanceBO.setReachFlag("1");
            if ("1".equals(couponInstanceBO.getCheckFlag())) continue;
            couponInstanceBO.setCheckFlag("0");
            if (CollectionUtils.isNotEmpty(notReachList) && notReachList.contains(couponInstanceBO.getCouponInstanceId())) {
                couponInstanceBO.setReachFlag("0");
                couponInstanceBO.setOptionalFlag("0");
                continue;
            }
            if (CollectionUtils.isEmpty(types) && CollectionUtils.isEmpty(couponIds)) continue;
            if (types.contains(couponInstanceBO.getCouponType()) || couponIds.contains(couponInstanceBO.getCouponId())) {
                couponInstanceBO.setOptionalFlag("0");
                continue;
            }
            couponInstanceBO.setOptionalFlag("1");
        }
        SortActUtils.sortCouponByPriority(reqBOs);
        return reqBOs;
    }
}

