/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.act.atom.ActCombinationAtomService;
import com.tydic.newretail.act.atom.ActCombinationDetailAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActRelationAtomService;
import com.tydic.newretail.act.bo.ActCombinationConfigBO;
import com.tydic.newretail.act.bo.ActCombinationRspBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCombinationDetailInfoBO;
import com.tydic.newretail.act.bo.ActivityCombinationInfoBO;
import com.tydic.newretail.act.bo.ActivityRelationBO;
import com.tydic.newretail.act.bo.QryActCombinationByPageReqBO;
import com.tydic.newretail.act.busi.ActCombinationBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActCombinationBusiServiceImpl
implements ActCombinationBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActCombinationBusiServiceImpl.class);
    @Autowired
    private ActCombinationAtomService actCombinationAtomService;
    @Autowired
    private ActCombinationDetailAtomService actCombinationDetailAtomService;
    @Autowired
    private ActRelationAtomService actRelationAtomService;
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspBaseBO saveActCombination(ActCombinationConfigBO reqBO) {
        log.debug("\u7ec4\u5408\u6d3b\u52a8\u65b0\u589e\u5165\u53c2" + reqBO.toString());
        if (null == reqBO || CollectionUtils.isEmpty((Collection)reqBO.getDetailInfoBOS()) || reqBO.getDetailInfoBOS().size() == 1) {
            log.error("\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a\u6216");
            return new RspBaseBO("0001", "\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a\u6216");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getDetailInfoBOS()) && reqBO.getDetailInfoBOS().size() >= 2) {
            HashSet<Long> actIds = new HashSet<Long>();
            for (ActivityCombinationDetailInfoBO activityCombinationDetailInfoBO : reqBO.getDetailInfoBOS()) {
                actIds.add(activityCombinationDetailInfoBO.getActivityId());
            }
            List<ActivityBO> activityBOS = this.actInfoAtomService.listActivityInfo(actIds);
            if (CollectionUtils.isEmpty(activityBOS)) {
                log.error("\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
                return new RspBaseBO("0001", "\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
            }
            HashSet<Long> qryActIds = new HashSet<Long>();
            for (ActivityBO activityBO : activityBOS) {
                if (!"1".equals(activityBO.getExclusiveFlag())) continue;
                qryActIds.add(activityBO.getActivityId());
            }
            if (qryActIds.size() >= 2) {
                log.error("\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u6d3b\u52a8" + qryActIds + "\u662f\u5fc5\u9009");
                return new RspBaseBO("0001", "\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u6d3b\u52a8" + qryActIds + "\u662f\u5fc5\u9009");
            }
        }
        this.checkParams(reqBO);
        ActivityCombinationInfoBO record = new ActivityCombinationInfoBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        ActivityCombinationInfoBO qryBO = this.actCombinationAtomService.saveActivityCombinationInfo(record);
        if (null == qryBO.getCombinationId()) {
            log.error("\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u7ec4\u5408ID");
            return new RspBaseBO("0001", "\u65b0\u589e\u7ec4\u5408\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u7ec4\u5408ID");
        }
        ArrayList<ActivityCombinationDetailInfoBO> reqBOs = new ArrayList<ActivityCombinationDetailInfoBO>(reqBO.getDetailInfoBOS().size());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getDetailInfoBOS())) {
            this.saveDetail(qryBO, reqBO, reqBOs);
        }
        if (CollectionUtils.isNotEmpty(reqBOs)) {
            this.saveRelation(qryBO, reqBO, reqBOs);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO modifyActCombination(ActCombinationConfigBO reqBO) {
        log.debug("\u7ec4\u5408\u6d3b\u52a8\u7f16\u8f91\u5165\u53c2" + reqBO.toString());
        if (null == reqBO.getCombinationId()) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityCombinationInfoBO qryReqBO = new ActivityCombinationInfoBO();
        qryReqBO.setCombinationId(reqBO.getCombinationId());
        ActivityCombinationInfoBO qryRspBO = this.actCombinationAtomService.getActivityCombinationInfo(qryReqBO);
        if (null == qryRspBO) {
            log.error("\u7ec4\u5408\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u7ec4\u5408\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (!qryRspBO.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
            log.error("\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u7ec4\u5408\u6d3b\u52a8");
            return new RspBaseBO("0010", "\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u7ec4\u5408\u6d3b\u52a8");
        }
        ActivityCombinationInfoBO record = new ActivityCombinationInfoBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setLastUpdUid(String.valueOf(reqBO.getmUserId()));
        if (StringUtils.isEmpty((CharSequence)reqBO.getmLoginName())) {
            record.setLastUpdUsername(reqBO.getmLoginName());
        }
        this.actCombinationAtomService.modifyActivityCombination(record, true);
        this.actCombinationDetailAtomService.removeByCombinationId(qryRspBO.getCombinationId());
        this.actRelationAtomService.removeByCombinationId(qryRspBO.getCombinationId());
        ArrayList<ActivityCombinationDetailInfoBO> reqBOs = new ArrayList<ActivityCombinationDetailInfoBO>(reqBO.getDetailInfoBOS().size());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getDetailInfoBOS())) {
            this.saveDetail(qryRspBO, reqBO, reqBOs);
        }
        if (CollectionUtils.isNotEmpty(reqBOs)) {
            this.saveRelation(qryRspBO, reqBO, reqBOs);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO removeActCombination(ActCombinationConfigBO reqBO) {
        log.debug("\u7ec4\u5408\u6d3b\u52a8\u5220\u9664\u5165\u53c2" + reqBO.toString());
        if (null == reqBO.getCombinationId()) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityCombinationInfoBO qryReqBO = new ActivityCombinationInfoBO();
        qryReqBO.setCombinationId(reqBO.getCombinationId());
        ActivityCombinationInfoBO qryRspBO = this.actCombinationAtomService.getActivityCombinationInfo(qryReqBO);
        if (null == qryRspBO) {
            log.error("\u7ec4\u5408\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u7ec4\u5408\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (!qryRspBO.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
            log.error("\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u7ec4\u5408\u6d3b\u52a8");
            return new RspBaseBO("0010", "\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u7ec4\u5408\u6d3b\u52a8");
        }
        this.modifyMethod(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspPageBaseBO<ActCombinationRspBO> listActCombinationInfoByPage(QryActCombinationByPageReqBO reqBO) {
        log.debug("\u67e5\u8be2\u7ec4\u5408\u6d3b\u52a8\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        Page page = new Page();
        page.setPageNo(reqBO.getCurrent());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getCurrent() - 1));
        page.setPageNo(reqBO.getCurrent());
        page.setPageSize(reqBO.getPageSize());
        ActivityCombinationInfoBO record = new ActivityCombinationInfoBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        List<Object> qryList = new ArrayList();
        record.setBelongRegionProvince(reqBO.getmProvince());
        record.setBelongRegionCity(reqBO.getmCity());
        record.setBelongRegionDistrict(reqBO.getmDistrict());
        record.setBelongRegionStore(reqBO.getmShopId());
        try {
            qryList = this.actCombinationAtomService.selectByPage(record, (Page<Map<String, Object>>)page);
        }
        catch (Exception e) {
            log.debug("\u7ec4\u5408\u6d3b\u52a8\u5217\u8868\u67e5\u8be2\u5f02\u5e38", (Object)e.getMessage());
            return new RspPageBaseBO("0003", "\u7ec4\u5408\u6d3b\u52a8\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(qryList)) {
            log.debug("\u7ec4\u5408\u6d3b\u52a8\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return new RspPageBaseBO("0000", "\u7ec4\u5408\u6d3b\u52a8\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ArrayList<ActCombinationRspBO> bos = new ArrayList<ActCombinationRspBO>(qryList.size());
        for (ActivityCombinationInfoBO activityCombinationInfoBO : qryList) {
            ActCombinationRspBO rsp = new ActCombinationRspBO();
            ConvertParamUtils.escaptActCombination(activityCombinationInfoBO, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)activityCombinationInfoBO, (Object)rsp);
            rsp.setAllowModification("1");
            if (!rsp.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
                rsp.setAllowModification("0");
            }
            ActivityCombinationDetailInfoBO po = new ActivityCombinationDetailInfoBO();
            po.setCombinationId(activityCombinationInfoBO.getCombinationId());
            List<ActivityCombinationDetailInfoBO> tempList = this.actCombinationDetailAtomService.selectByCombinationId(po);
            if (CollectionUtils.isEmpty(tempList)) {
                log.debug("\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                return new RspPageBaseBO("0000", "\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            }
            ArrayList<Long> ids = new ArrayList<Long>(tempList.size());
            for (ActivityCombinationDetailInfoBO activityCombinationDetailInfoBO : tempList) {
                ids.add(activityCombinationDetailInfoBO.getActivityId());
            }
            rsp.setActivityIds(ids);
            bos.add(rsp);
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", bos, page.getTotalCount(), page.getTotalPages());
    }

    public RspBaseTBO<ActCombinationRspBO> getActCombinationDetail(ActCombinationConfigBO reqBO) {
        ActCombinationRspBO result = new ActCombinationRspBO();
        if (null == reqBO.getCombinationId()) {
            log.error("\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
            return new RspBaseTBO("0001", "\u7ec4\u5408\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityCombinationInfoBO activityCombinationInfoBO = new ActivityCombinationInfoBO();
        activityCombinationInfoBO.setCombinationId(reqBO.getCombinationId());
        ActivityCombinationInfoBO activityCombinationInfo = this.actCombinationAtomService.getActivityCombinationInfo(activityCombinationInfoBO);
        if (null == activityCombinationInfo) {
            log.error("\u7ec4\u5408\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0002", "\u7ec4\u5408\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        ConvertParamUtils.escaptActCombination(activityCombinationInfo, this.qryEscapeAtomService);
        BeanUtils.copyProperties((Object)activityCombinationInfo, (Object)result);
        ActivityCombinationDetailInfoBO po = new ActivityCombinationDetailInfoBO();
        po.setCombinationId(activityCombinationInfo.getCombinationId());
        List<ActivityCombinationDetailInfoBO> tempList = this.actCombinationDetailAtomService.selectByCombinationId(po);
        if (CollectionUtils.isEmpty(tempList)) {
            log.debug("\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return new RspBaseTBO("0000", "\u7ec4\u5408\u6d3b\u52a8\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ArrayList<Long> ids = new ArrayList<Long>(tempList.size());
        for (ActivityCombinationDetailInfoBO activityCombinationDetailInfoBO : tempList) {
            ids.add(activityCombinationDetailInfoBO.getActivityId());
        }
        result.setActivityIds(ids);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    private void checkParams(ActCombinationConfigBO reqBO) {
        if (null == reqBO.getmUserId()) {
            log.error("\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        reqBO.setCreateUser(String.valueOf(reqBO.getmUserId()));
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmLoginName())) {
            reqBO.setCreateUsername(reqBO.getmLoginName());
        }
        if (null == reqBO.getmTenantId()) {
            log.error("\u672a\u83b7\u79df\u6237ID");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u79df\u6237ID");
        }
        reqBO.setTenantId(reqBO.getmTenantId());
        if (StringUtils.isBlank((CharSequence)reqBO.getmOrgId())) {
            log.error("\u672a\u83b7\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
        }
        reqBO.setBelongCode(reqBO.getmOrgId());
        if ("1".equals(reqBO.getmUserLevel())) {
            log.debug("\u603b\u90e8");
            reqBO.setBelongRegion("00");
        } else if ("2".equals(reqBO.getmUserLevel())) {
            log.debug("\u7701\u4efd");
            reqBO.setBelongRegion("01");
        } else if ("3".equals(reqBO.getmUserLevel())) {
            log.debug("\u5730\u5e02");
            reqBO.setBelongRegion("02");
        } else if ("4".equals(reqBO.getmUserLevel())) {
            log.debug("\u533a\u53bf");
            reqBO.setBelongRegion("03");
        } else if ("5".equals(reqBO.getmUserLevel())) {
            log.debug("\u95e8\u5e97");
            reqBO.setBelongRegion("05");
        } else {
            log.error("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        reqBO.setBelongRegionProvince(reqBO.getmProvince());
        reqBO.setBelongRegionCity(reqBO.getmCity());
        reqBO.setBelongRegionDistrict(reqBO.getmDistrict());
        reqBO.setBelongRegionStore(reqBO.getmShopId());
        if (StringUtils.isEmpty((CharSequence)reqBO.getCombinationName())) {
            log.error("\u7ec4\u5408\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7ec4\u5408\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSaleType())) {
            log.error("\u9500\u552e\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u7c7b\u578b\u4e3a\u7a7a");
        }
        reqBO.setCombinationCode("ZH" + Sequence.getInstance().nextId());
        reqBO.setRelType("0");
        reqBO.setCombinationStatus("00");
    }

    private void saveDetail(ActivityCombinationInfoBO qryBO, ActCombinationConfigBO reqBO, List<ActivityCombinationDetailInfoBO> reqBOs) {
        for (ActivityCombinationDetailInfoBO detailInfoBO : reqBO.getDetailInfoBOS()) {
            ActivityCombinationDetailInfoBO po = new ActivityCombinationDetailInfoBO();
            po.setCombinationCode(qryBO.getCombinationCode());
            po.setCombinationId(qryBO.getCombinationId());
            po.setRelType(qryBO.getRelType());
            po.setActivityId(detailInfoBO.getActivityId());
            po.setActivityName(detailInfoBO.getActivityName());
            reqBOs.add(po);
        }
        this.actCombinationDetailAtomService.saveActivityCombinationDetail(reqBOs);
    }

    private void saveRelation(ActivityCombinationInfoBO qryBO, ActCombinationConfigBO reqBO, List<ActivityCombinationDetailInfoBO> reqBOs) {
        ArrayList<ActivityRelationBO> records = new ArrayList<ActivityRelationBO>();
        if (CollectionUtils.isNotEmpty(reqBOs) && reqBOs.size() > 1) {
            for (int i = 0; i < reqBOs.size(); ++i) {
                for (int j = 0; j < reqBOs.size(); ++j) {
                    if (i == j) continue;
                    ActivityRelationBO po = new ActivityRelationBO();
                    po.setActivityId(reqBOs.get(i).getActivityId());
                    po.setTenantId(qryBO.getTenantId());
                    po.setCombinationId(qryBO.getCombinationId());
                    po.setRelType(qryBO.getRelType());
                    po.setObjectType("00");
                    po.setObjectRegion(String.valueOf(reqBOs.get(j).getActivityId()));
                    po.setCrtTime(new Date());
                    po.setValidFlag("1");
                    records.add(po);
                }
            }
            log.debug("\u7ec4\u5408\u6d3b\u52a8----\u65b0\u589e\u6d3b\u52a8\u5173\u7cfb\u5165\u53c2" + ((Object)records).toString());
            this.actRelationAtomService.saveBatch(records);
        }
    }

    private void modifyMethod(ActCombinationConfigBO reqBO) {
        ActivityCombinationInfoBO record = new ActivityCombinationInfoBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setLastUpdUid(String.valueOf(reqBO.getmUserId()));
        if (StringUtils.isEmpty((CharSequence)reqBO.getmLoginName())) {
            record.setLastUpdUsername(reqBO.getmLoginName());
        }
        record.setLastUpdTime(new Date());
        record.setIsValid("0");
        record.setCombinationStatus("01");
        this.actCombinationAtomService.modifyActivityCombination(record, true);
        HashSet<Long> combinationIds = new HashSet<Long>(1);
        combinationIds.add(reqBO.getCombinationId());
        this.actCombinationDetailAtomService.invalidBatchByCombinationIds(combinationIds);
        this.actRelationAtomService.invalidBatchByCombinationIds(combinationIds);
    }
}

