/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActRelationAtomService;
import com.tydic.newretail.act.atom.ActTouchSpotAtomService;
import com.tydic.newretail.act.atom.ActUserAtomService;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.atom.GiftAtomService;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomBO;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.atom.bo.QryActReqAtomBO;
import com.tydic.newretail.act.bo.ActConfigBO;
import com.tydic.newretail.act.bo.ActConfigCommDetailBO;
import com.tydic.newretail.act.bo.ActConfigDetailsBO;
import com.tydic.newretail.act.bo.ActConfigObjBO;
import com.tydic.newretail.act.bo.ActConfigObjDetailsBO;
import com.tydic.newretail.act.bo.ActRelationConfigDetailBO;
import com.tydic.newretail.act.bo.ActRelationConfigReqBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.ActivityRelationBO;
import com.tydic.newretail.act.bo.ActivityTouchSpotBO;
import com.tydic.newretail.act.bo.ActivityUserBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.bo.GiftBO;
import com.tydic.newretail.act.bo.MatchRuleBO;
import com.tydic.newretail.act.bo.UserSetBO;
import com.tydic.newretail.act.busi.ActConfigBusiService;
import com.tydic.newretail.act.util.CheckParamUtils;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.act.util.SortActUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActConfigBusiServiceImpl
implements ActConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActConfigBusiServiceImpl.class);
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Autowired
    private ActCommAtomService actCommAtomService;
    @Autowired
    private ActUserAtomService actUserAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private ActivityBenefitAtomService activityBenefitAtomService;
    @Autowired
    private CouponAtomService couponAtomService;
    @Autowired
    private GiftAtomService giftAtomService;
    @Autowired
    private ActRelationAtomService actRelationAtomService;
    @Autowired
    private ActTouchSpotAtomService actTouchSpotAtomService;
    @Value(value="${ACT_PRIORITY_SECK_KILL:200}")
    private Integer seckillPri;
    @Value(value="${ACT_PRIORITY_INSTANT_REBATE:400}")
    private Integer instantRebatePri;
    @Value(value="${ACT_PRIORITY_FULL_PRESENT:400}")
    private Integer fullPresentPri;
    @Value(value="${ACT_PRIORITY_PRESENT_SALE_SINGLE:400}")
    private Integer presentSaleSinglePri;
    @Value(value="${ACT_PRIORITY_GLOBAL_OPEN:330}")
    private Integer globalOpenPri;
    @Value(value="${ACT_PRIORITY_REDUCE_SALE_SINGLE:360}")
    private Integer reduceSaleSinglePri;
    @Value(value="${ACT_PRIORITY_REG_GIFT:500}")
    private Integer regGiftPri;
    @Value(value="${ACT_PRIORITY_SCRATCH_CARD:600}")
    private Integer scratchPri;
    @Value(value="${ACT_PRIORITY_TURNAROUND_DRAW:600}")
    private Integer turnaroundPri;
    @Value(value="${ACT_PRIORITY_SHARE_COUPON:600}")
    private Integer shareCouponPri;
    @Value(value="${ACT_PRIORITY_PAY_GIFT:700}")
    private Integer payGiftPri;
    @Value(value="${ACT_PRIORITY_STAFF_PRICE:100}")
    private Integer staffPricePri;

    public RspBaseBO saveInstantRebate(ActConfigBO reqBO) {
        this.checkParams(reqBO);
        this.saveActPutMethod(reqBO, "00", this.instantRebatePri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveSeckill(ActConfigBO reqBO) {
        reqBO.setShowFlag("0");
        reqBO.setExclusiveFlag("1");
        reqBO.setForceChooseFlag("1");
        this.checkParams(reqBO);
        this.checkActTime(reqBO.getStartTime(), reqBO.getEndTime(), "01", null);
        this.saveActPutMethod(reqBO, "01", this.seckillPri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void checkActTime(Date startTime, Date endTime, String type, Long excludeActId) {
        QryActReqAtomBO qryActReqAtomBO = new QryActReqAtomBO();
        qryActReqAtomBO.setReStartTime(startTime);
        qryActReqAtomBO.setReEndTime(endTime);
        qryActReqAtomBO.setActivityType(type);
        qryActReqAtomBO.setExcludeActId(excludeActId);
        List<ActivityBO> activityBOS = this.actInfoAtomService.listActByType(qryActReqAtomBO);
        if (CollectionUtils.isNotEmpty(activityBOS)) {
            log.error("\u5f53\u524d\u65f6\u95f4\u6bb5\u5185\u5df2\u5b58\u5728\u540c\u4e00\u7c7b\u578b\u7684\u6d3b\u52a8");
            throw new ResourceException("0023", "\u5f53\u524d\u65f6\u95f4\u6bb5\u5185\u5df2\u5b58\u5728\u540c\u4e00\u7c7b\u578b\u7684\u6d3b\u52a8");
        }
    }

    public RspBaseBO saveScratchCard(ActConfigBO reqBO) {
        this.saveBenefitActPub(reqBO, this.scratchPri, "05", false);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveTurnaroundDraw(ActConfigBO reqBO) {
        this.saveBenefitActPub(reqBO, this.turnaroundPri, "07", false);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveShareCoupon(ActConfigBO reqBO) {
        this.saveBenefitActPub(reqBO, this.shareCouponPri, "08", false);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO savePayGift(ActConfigBO reqBO) {
        this.saveBenefitActPub(reqBO, this.payGiftPri, "06", true);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveRegGift(ActConfigBO reqBO) {
        this.saveBenefitActPub(reqBO, this.regGiftPri, "04", true);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveStaffPrice(ActConfigBO reqBO) {
        reqBO.setShowFlag("0");
        reqBO.setExclusiveFlag("1");
        reqBO.setForceChooseFlag("1");
        this.checkParams(reqBO);
        this.checkActTime(reqBO.getStartTime(), reqBO.getEndTime(), "03", null);
        this.saveActPutMethod(reqBO, "03", this.staffPricePri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveFullPresent(ActConfigBO reqBO) {
        this.checkParams(reqBO);
        this.saveActPutMethod(reqBO, "09", this.fullPresentPri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO savePresentSaleSingle(ActConfigBO reqBO) {
        this.checkParams(reqBO);
        this.saveActPutMethod(reqBO, "10", this.presentSaleSinglePri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveGlobalOpen(ActConfigBO reqBO) {
        this.checkParams(reqBO);
        this.saveActPutMethod(reqBO, "11", this.globalOpenPri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveReduceSaleSingle(ActConfigBO reqBO) {
        this.checkParams(reqBO);
        this.saveActPutMethod(reqBO, "12", this.reduceSaleSinglePri);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void saveBenefitActPub(ActConfigBO reqBO, Integer pri, String actTypePayGift, Boolean bCheckActTime) {
        reqBO.setShowFlag("0");
        reqBO.setExclusiveFlag("0");
        reqBO.setForceChooseFlag("0");
        this.checkParams(reqBO);
        if (bCheckActTime.booleanValue()) {
            this.checkActTime(reqBO.getStartTime(), reqBO.getEndTime(), actTypePayGift, null);
        }
        this.saveActPutMethod(reqBO, actTypePayGift, pri);
    }

    private void saveActPutMethod(ActConfigBO reqBO, String actType, Integer priority) {
        this.setConfigParams(reqBO, actType, priority);
        ActivityBO activityBO = reqBO.toActivityBO();
        CheckParamUtils.checkActParams(activityBO, reqBO);
        ActivityBO saveActRsp = this.actInfoAtomService.saveActInfo(activityBO);
        if (null == saveActRsp.getActivityId()) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u6d3b\u52a8ID");
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u6d3b\u52a8ID");
        }
        List<Object> touchSpotBOList = new ArrayList();
        touchSpotBOList = this.getTouchSpotBO(reqBO, saveActRsp);
        if (CollectionUtils.isNotEmpty(touchSpotBOList)) {
            this.actTouchSpotAtomService.saveTouchSpot(touchSpotBOList);
        }
        if (null != reqBO.getUserDetails()) {
            this.saveUserRange(reqBO, saveActRsp);
        }
        this.setDefaultComm(reqBO, saveActRsp);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommDetails())) {
            CheckParamUtils.checkCommParam(reqBO.getCommDetails(), actType);
            List<ActivityCommodityBO> comms = this.getActComms(reqBO, saveActRsp);
            this.actCommAtomService.saveByBatch(comms);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getBenefitDetails())) {
            List<ActivityBenefitBO> benefitBOS = this.getBenefitBOs(reqBO, saveActRsp);
            this.activityBenefitAtomService.saveBeneBatch(benefitBOS);
        }
    }

    private List<ActivityBenefitBO> getBenefitBOs(ActConfigBO reqBO, ActivityBO activityBO) {
        ArrayList<ActivityBenefitBO> benefitBOS = new ArrayList<ActivityBenefitBO>(reqBO.getBenefitDetails().size());
        Date nowDate = new Date();
        for (ActivityBenefitBO activityBenefitBO : reqBO.getBenefitDetails()) {
            ActivityBenefitBO benefitBO = new ActivityBenefitBO();
            benefitBO.setValidFlag("1");
            if (null != activityBenefitBO.getAmountCount()) {
                benefitBO.setAvailableCount(activityBenefitBO.getAmountCount());
                benefitBO.setAmountCount(activityBenefitBO.getAmountCount());
            }
            benefitBO.setActivityId(activityBO.getActivityId());
            benefitBO.setBenefitName(activityBenefitBO.getBenefitName());
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getBenefitDesc())) {
                benefitBO.setBenefitDesc(activityBenefitBO.getBenefitDesc());
            }
            benefitBO.setBenefitType(activityBenefitBO.getBenefitType());
            benefitBO.setCrtTime(nowDate);
            benefitBO.setWeight(activityBenefitBO.getWeight());
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam1())) {
                benefitBO.setParam1(activityBenefitBO.getParam1());
            }
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam2())) {
                if ("10".equals(activityBO.getActivityType())) {
                    benefitBO.setParam2(activityBenefitBO.getParam2());
                } else {
                    benefitBO.setParam2(TkCalculatorUtils.transfetL((String)activityBenefitBO.getParam2()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam3())) {
                benefitBO.setParam3(activityBenefitBO.getParam3());
            }
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam4())) {
                benefitBO.setParam4(activityBenefitBO.getParam4());
            }
            if ("08".equals(activityBO.getActivityType()) && StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam2())) {
                benefitBO.setParam2(activityBenefitBO.getParam2());
            }
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam5())) {
                benefitBO.setParam5(activityBenefitBO.getParam5());
            }
            if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam6())) {
                benefitBO.setParam6(activityBenefitBO.getParam6());
            }
            benefitBO.setTenantId(reqBO.getmTenantId());
            benefitBO.setActivityStatus(activityBO.getActivityStatus());
            benefitBOS.add(benefitBO);
        }
        return benefitBOS;
    }

    private List<ActivityTouchSpotBO> getTouchSpotBO(ActConfigBO reqBO, ActivityBO activityBO) {
        reqBO.setTouchSpotBOs(CollectionUtils.isEmpty((Collection)reqBO.getTouchSpotBOs()) ? new ArrayList() : reqBO.getTouchSpotBOs());
        switch (activityBO.getActivityType()) {
            case "01": 
            case "05": 
            case "08": 
            case "07": {
                ActivityTouchSpotBO activityTouchSpotBO = new ActivityTouchSpotBO();
                activityTouchSpotBO.setTouchSpotId("0001");
                activityTouchSpotBO.setMnomonicName("\u7ebf\u4e0a\u5546\u57ce");
                reqBO.getTouchSpotBOs().add(activityTouchSpotBO);
                break;
            }
            case "04": {
                ActivityTouchSpotBO spotBO1 = new ActivityTouchSpotBO();
                ActivityTouchSpotBO spotBO2 = new ActivityTouchSpotBO();
                spotBO1.setTouchSpotId("0001");
                spotBO1.setMnomonicName("\u7ebf\u4e0a\u5546\u57ce");
                spotBO2.setTouchSpotId("0003");
                spotBO2.setMnomonicName("\u81ea\u52a9\u6536\u94f6");
                reqBO.getTouchSpotBOs().add(spotBO1);
                reqBO.getTouchSpotBOs().add(spotBO2);
                break;
            }
            case "06": {
                ActivityTouchSpotBO spotBO3 = new ActivityTouchSpotBO();
                ActivityTouchSpotBO spotBO4 = new ActivityTouchSpotBO();
                ActivityTouchSpotBO spotBO5 = new ActivityTouchSpotBO();
                ActivityTouchSpotBO spotBO6 = new ActivityTouchSpotBO();
                spotBO3.setTouchSpotId("0001");
                spotBO3.setMnomonicName("\u7ebf\u4e0a\u5546\u57ce");
                spotBO4.setTouchSpotId("0003");
                spotBO4.setMnomonicName("\u81ea\u52a9\u6536\u94f6");
                spotBO5.setTouchSpotId("0002");
                spotBO5.setMnomonicName("\u4eba\u5de5\u6536\u94f6");
                spotBO6.setTouchSpotId("0004");
                spotBO6.setMnomonicName("PC\u6536\u94f6");
                reqBO.getTouchSpotBOs().add(spotBO3);
                reqBO.getTouchSpotBOs().add(spotBO4);
                reqBO.getTouchSpotBOs().add(spotBO5);
                reqBO.getTouchSpotBOs().add(spotBO6);
                break;
            }
        }
        for (ActivityTouchSpotBO bo : reqBO.getTouchSpotBOs()) {
            bo.setActivityId(activityBO.getActivityId());
            bo.setActivityStatus(activityBO.getActivityStatus());
            bo.setTenantId(activityBO.getTenantId());
            bo.setCrtTime(activityBO.getCrtTime());
            bo.setValidFlag("1");
            bo.setTouchSpotType("01");
        }
        return reqBO.getTouchSpotBOs();
    }

    private void saveUserRange(ActConfigBO reqBO, ActivityBO saveActRsp) {
        ArrayList<ActivityUserBO> userBOS = new ArrayList<ActivityUserBO>();
        Date nowDate = new Date();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getUserDetails().getUserSetIds())) {
            for (Long userSetId : reqBO.getUserDetails().getUserSetIds()) {
                ActivityUserBO userBO = this.toActUserBO(nowDate, saveActRsp, "00", userSetId);
                userBOS.add(userBO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getUserDetails().getRuleIds())) {
            List<MatchRuleBO> matchRuleBOS = this.actUserAtomService.listMatchRule(reqBO.getUserDetails().getRuleIds());
            if (CollectionUtils.isEmpty(matchRuleBOS)) {
                log.error("\u672a\u67e5\u8be2\u5230\u89c4\u5219");
                TkThrExceptionUtils.thrQryRspEmptyExce((String)"\u672a\u67e5\u8be2\u5230\u89c4\u5219");
            }
            for (MatchRuleBO bo : matchRuleBOS) {
                ActivityUserBO userBO = this.toActUserBO(nowDate, saveActRsp, bo.getRuleType(), bo.getRuleId());
                userBOS.add(userBO);
            }
        }
        if (CollectionUtils.isEmpty(userBOS)) {
            return;
        }
        this.actUserAtomService.saveUserRange(userBOS);
    }

    private ActivityUserBO toActUserBO(Date nowDate, ActivityBO saveActRsp, String matchType, Long ruleId) {
        ActivityUserBO userBO = new ActivityUserBO();
        userBO.setActivityId(saveActRsp.getActivityId());
        userBO.setMatchType(matchType);
        userBO.setRuleId(ruleId);
        userBO.setTenantId(saveActRsp.getTenantId());
        userBO.setCrtTime(nowDate);
        return userBO;
    }

    private void setDefaultComm(ActConfigBO reqBO, ActivityBO saveActRsp) {
        if ("01".equals(saveActRsp.getActivityType()) || "02".equals(saveActRsp.getActivityType()) || "03".equals(saveActRsp.getActivityType()) || "04".equals(saveActRsp.getActivityType()) || "05".equals(saveActRsp.getActivityType()) || "06".equals(saveActRsp.getActivityType()) || "08".equals(saveActRsp.getActivityType()) || "07".equals(saveActRsp.getActivityType())) {
            reqBO.setCommDetails(CollectionUtils.isNotEmpty((Collection)reqBO.getCommDetails()) ? reqBO.getCommDetails() : new ArrayList());
            ActConfigCommDetailBO actConfigCommDetailBO = new ActConfigCommDetailBO();
            actConfigCommDetailBO.setAllFlag("00");
            reqBO.getCommDetails().add(actConfigCommDetailBO);
        }
    }

    private List<ActivityCommodityBO> getActComms(ActConfigBO reqBO, ActivityBO saveActRsp) {
        ArrayList<ActivityCommodityBO> list = new ArrayList<ActivityCommodityBO>(reqBO.getCommDetails().size());
        boolean onlyShop = true;
        boolean hasShop = false;
        Date nowDate = new Date();
        for (ActConfigCommDetailBO actConfigCommDetailBO : reqBO.getCommDetails()) {
            ActivityCommodityBO comm = new ActivityCommodityBO();
            comm.setActivityCode(saveActRsp.getActivityCode());
            comm.setActivityId(saveActRsp.getActivityId());
            comm.setActivityType(saveActRsp.getActivityType());
            comm.setStartTime(saveActRsp.getStartTime());
            comm.setEndTime(saveActRsp.getEndTime());
            comm.setAdvanceNoticeTime(saveActRsp.getAdvanceNoticeTime());
            comm.setCrtTime(nowDate);
            comm.setTotalCount(actConfigCommDetailBO.getTotalCount());
            comm.setAvailableCount(actConfigCommDetailBO.getTotalCount());
            comm.setActivityStatus(saveActRsp.getActivityStatus());
            if (null != actConfigCommDetailBO.getActPrice()) {
                comm.setActPrice(TkCalculatorUtils.transfetL((double)actConfigCommDetailBO.getActPrice()));
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getSilverCard())) {
                comm.setParam6(actConfigCommDetailBO.getSilverCard());
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getGoldCard())) {
                comm.setParam7(actConfigCommDetailBO.getGoldCard());
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getPlatinumCard())) {
                comm.setParam8(actConfigCommDetailBO.getPlatinumCard());
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getDiamondCard())) {
                comm.setParam9(actConfigCommDetailBO.getDiamondCard());
            }
            comm.setSingleTypeFlag("0");
            list.add(comm);
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getAllFlag())) {
                comm.setObjType("00");
                comm.setObjCode("00");
                comm.setParam5("\u5168\u56fd");
                hasShop = true;
                continue;
            }
            if (null != actConfigCommDetailBO.getCompanyCode()) {
                comm.setParam6(actConfigCommDetailBO.getCompanyCode());
                hasShop = true;
            }
            if (null != actConfigCommDetailBO.getShopId()) {
                hasShop = true;
                comm.setObjCode(actConfigCommDetailBO.getShopId().toString());
                comm.setObjType("05");
                comm.setParam1(actConfigCommDetailBO.getProvinceCode());
                comm.setParam2(actConfigCommDetailBO.getCityCode());
                comm.setParam3(actConfigCommDetailBO.getCountyCode());
                comm.setParam4(actConfigCommDetailBO.getShopId().toString());
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getAreaCode())) {
                comm.setObjCode(actConfigCommDetailBO.getAreaCode());
                comm.setObjType("04");
                comm.setParam1(actConfigCommDetailBO.getProvinceCode());
                comm.setParam2(actConfigCommDetailBO.getCityCode());
                comm.setParam3(actConfigCommDetailBO.getCountyCode());
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getCountyCode())) {
                comm.setObjCode(actConfigCommDetailBO.getCountyCode());
                comm.setObjType("03");
                comm.setParam1(actConfigCommDetailBO.getProvinceCode());
                comm.setParam2(actConfigCommDetailBO.getCityCode());
                comm.setParam3(actConfigCommDetailBO.getCountyCode());
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getCityCode())) {
                comm.setObjCode(actConfigCommDetailBO.getCityCode());
                comm.setObjType("02");
                comm.setParam1(actConfigCommDetailBO.getProvinceCode());
                comm.setParam2(actConfigCommDetailBO.getCityCode());
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getProvinceCode())) {
                comm.setObjCode(actConfigCommDetailBO.getProvinceCode());
                comm.setObjType("01");
                comm.setParam1(actConfigCommDetailBO.getProvinceCode());
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (null != actConfigCommDetailBO.getSkuId()) {
                onlyShop = false;
                comm.setObjCode(actConfigCommDetailBO.getSkuId().toString());
                comm.setObjType("99");
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getProvinceCommodity())) {
                onlyShop = false;
                comm.setObjType("12");
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                comm.setObjCode(actConfigCommDetailBO.getProvinceCommodity());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)actConfigCommDetailBO.getMaterial())) {
                onlyShop = false;
                comm.setObjType("11");
                comm.setObjCode(actConfigCommDetailBO.getMaterial());
                comm.setParam5(actConfigCommDetailBO.getMaterial());
                continue;
            }
            if (null != actConfigCommDetailBO.getClassTypeId()) {
                onlyShop = false;
                comm.setObjCode(actConfigCommDetailBO.getClassTypeId().toString());
                comm.setObjType("08");
                continue;
            }
            if (null != actConfigCommDetailBO.getBrand()) {
                onlyShop = false;
                comm.setObjCode(actConfigCommDetailBO.getBrand());
                comm.setObjType("10");
                continue;
            }
            if (null == actConfigCommDetailBO.getPurchaseType()) continue;
            onlyShop = false;
            comm.setObjCode(actConfigCommDetailBO.getPurchaseType());
            comm.setObjType("07");
        }
        if (hasShop && onlyShop) {
            for (ActivityCommodityBO activityCommodityBO : list) {
                activityCommodityBO.setSingleTypeFlag("1");
            }
        }
        return list;
    }

    private void setConfigParams(ActConfigBO reqBO, String actType, Integer priority) {
        reqBO.setTenantId(reqBO.getmTenantId());
        reqBO.setBelongRegion(reqBO.getmOrgId());
        reqBO.setBelongRegionName(reqBO.getmTitle());
        reqBO.setCrtUid(reqBO.getmUserId());
        reqBO.setActivityType(actType);
        reqBO.setActivityStatus("00");
        reqBO.setPriority(priority);
    }

    private void checkParams(ActConfigBO reqBO) {
        if (null == reqBO.getStartTime() || null == reqBO.getEndTime()) {
            log.error("\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (null == reqBO.getmUserId()) {
            log.error("\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            reqBO.setReservedField1(reqBO.getmProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmCity())) {
            reqBO.setReservedField2(reqBO.getmCity());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmDistrict())) {
            reqBO.setReservedField3(reqBO.getmDistrict());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmShopId())) {
            reqBO.setReservedField4(reqBO.getmShopId());
        }
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getmOrgId())) {
            reqBO.setmOrgId("0");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getForceChooseFlag())) {
            reqBO.setForceChooseFlag("0");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getExclusiveFlag())) {
            reqBO.setExclusiveFlag("0");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getShowFlag())) {
            reqBO.setShowFlag("1");
        }
        reqBO.setUsefulObjType("01");
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommDetails())) {
            reqBO.setUsefulObjType("00");
        }
    }

    public RspBaseBO modifyAct(ActConfigBO reqBO) {
        List<ActivityTouchSpotBO> spotBO;
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityBO qryActReqBO = new ActivityBO();
        qryActReqBO.setActivityId(reqBO.getActivityId());
        ActivityBO activityBO = this.actInfoAtomService.getActivityInfo(qryActReqBO);
        if (null == activityBO) {
            log.error("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (!"01".equals(activityBO.getActivityStatus()) && !"00".equals(activityBO.getActivityStatus())) {
            String statusStr = this.qryEscapeAtomService.getCodeTitle("ACT_STATUS_NAME", activityBO.getActivityStatus());
            if (StringUtils.isBlank((CharSequence)statusStr)) {
                statusStr = "\u672a\u5b9a\u4e49";
            }
            log.error("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u3010" + statusStr + "\u3011\u4e0d\u80fd\u4fee\u6539");
            return new RspBaseBO("0010", "\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u3010" + statusStr + "\u3011\u4e0d\u80fd\u4fee\u6539");
        }
        this.modifyActInfo(activityBO, reqBO);
        if (!"00".equals(activityBO.getActivityType()) && !"05".equals(activityBO.getActivityType()) && !"07".equals(activityBO.getActivityType()) && !"08".equals(activityBO.getActivityType()) && "12".equals(activityBO.getActivityType()) && "11".equals(activityBO.getActivityType()) && "10".equals(activityBO.getActivityType()) && "09".equals(activityBO.getActivityType())) {
            this.checkActTime(reqBO.getStartTime(), reqBO.getEndTime(), activityBO.getActivityType(), activityBO.getActivityId());
        }
        this.actCommAtomService.removeByActId(reqBO.getActivityId());
        this.actUserAtomService.removeUserRange(reqBO.getActivityId());
        this.activityBenefitAtomService.removeByActId(reqBO.getActivityId());
        this.actTouchSpotAtomService.removeTouchSpot(reqBO.getActivityId());
        if (null != reqBO.getUserDetails()) {
            this.saveUserRange(reqBO, activityBO);
        }
        this.setDefaultComm(reqBO, activityBO);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommDetails())) {
            CheckParamUtils.checkCommParam(reqBO.getCommDetails(), activityBO.getActivityType());
            List<ActivityCommodityBO> comms = this.getActComms(reqBO, activityBO);
            this.actCommAtomService.saveByBatch(comms);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getBenefitDetails())) {
            List<ActivityBenefitBO> benefitBOS = this.getBenefitBOs(reqBO, activityBO);
            this.activityBenefitAtomService.saveBeneBatch(benefitBOS);
        }
        if (CollectionUtils.isNotEmpty(spotBO = this.getTouchSpotBO(reqBO, activityBO))) {
            this.actTouchSpotAtomService.saveTouchSpot(spotBO);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void modifyActInfo(ActivityBO activityBO, ActConfigBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getActivityName())) {
            activityBO.setActivityName(reqBO.getActivityName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getForceChooseFlag())) {
            activityBO.setForceChooseFlag(reqBO.getForceChooseFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExclusiveFlag())) {
            activityBO.setExclusiveFlag(reqBO.getExclusiveFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShowFlag())) {
            activityBO.setShowFlag(reqBO.getShowFlag());
        }
        if (null != reqBO.getStartTime()) {
            activityBO.setStartTime(reqBO.getStartTime());
        }
        if (null != reqBO.getEndTime()) {
            activityBO.setEndTime(reqBO.getEndTime());
        }
        if (null != reqBO.getAdvanceNoticeTime()) {
            activityBO.setAdvanceNoticeTime(reqBO.getAdvanceNoticeTime());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOpratorContactInfo())) {
            activityBO.setOpratorContactInfo(reqBO.getOpratorContactInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOpratorUsername())) {
            activityBO.setOpratorUsername(reqBO.getOpratorUsername());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommDetails())) {
            activityBO.setUsefulObjType("00");
        }
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getmOrgId())) {
            reqBO.setmOrgId("0");
        }
        activityBO.setParam1(reqBO.getParam1());
        activityBO.setParam2(reqBO.getParam2());
        activityBO.setParam3(reqBO.getParam3());
        activityBO.setParam4(reqBO.getParam4());
        activityBO.setParam5(reqBO.getParam5());
        activityBO.setParam6(reqBO.getParam6());
        activityBO.setParam7(reqBO.getParam7());
        activityBO.setLastUpdTime(new Date());
        activityBO.setLastUpdUid(reqBO.getmUserId());
        activityBO.setAliasName(reqBO.getAliasName());
        activityBO.setActivityDesc(reqBO.getActivityDesc());
        activityBO.setActivityInsideType(reqBO.getActivityInsideType());
        activityBO.setIsReservoir(reqBO.getIsReservoir());
        activityBO.setSaleType(reqBO.getSaleType());
        reqBO.setActivityType(activityBO.getActivityType());
        CheckParamUtils.checkActParams(activityBO, reqBO);
        this.actInfoAtomService.modifyAct(activityBO, false);
    }

    public RspBaseTBO<ActConfigDetailsBO> getActDetail(ActConfigBO reqBO) {
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            return new RspBaseTBO("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityBO qryActReqBO = new ActivityBO();
        qryActReqBO.setActivityId(reqBO.getActivityId());
        ActivityBO activityBO = this.actInfoAtomService.getActivityInfo(qryActReqBO);
        if (null == activityBO) {
            log.error("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0002", "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        ConvertParamUtils.escaptAct(activityBO, this.qryEscapeAtomService, true);
        ActConfigDetailsBO rsp = activityBO.toActConfigDetailsBO();
        this.getActBenefit(rsp);
        this.getActCommObj(rsp);
        this.getActUserRange(rsp);
        this.getActTouchSpotObj(rsp);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)rsp);
    }

    private void getActBenefit(ActConfigDetailsBO rsp) {
        List<GiftInfoAtomBO> giftBOS;
        List<CouponBO> couponBOS;
        ActivityBenefitBO benefitBO = new ActivityBenefitBO();
        benefitBO.setActivityId(rsp.getActivityId());
        benefitBO.setCheckCount(Boolean.valueOf(false));
        List<ActivityBenefitBO> benefits = this.activityBenefitAtomService.listBenefitByActId(benefitBO);
        if (CollectionUtils.isEmpty(benefits)) {
            return;
        }
        if ("08".equals(rsp.getActivityType())) {
            SortActUtils.sortActBenefitByPriority(benefits);
        }
        rsp.setBenefits(benefits);
        HashSet<Long> couponIds = new HashSet<Long>(benefits.size());
        HashSet<Long> giftIds = new HashSet<Long>(benefits.size());
        HashSet<Long> giftPkgIds = new HashSet<Long>(benefits.size());
        for (ActivityBenefitBO benefit : benefits) {
            if ("00".equals(benefit.getBenefitType())) {
                if (!StringUtils.isNotBlank((CharSequence)benefit.getParam1())) continue;
                couponIds.add(Long.parseLong(benefit.getParam1()));
                continue;
            }
            if ("01".equals(benefit.getBenefitType())) {
                if (!StringUtils.isNotBlank((CharSequence)benefit.getParam1())) continue;
                giftIds.add(Long.parseLong(benefit.getParam1()));
                continue;
            }
            if (!"02".equals(benefit.getBenefitType()) || !StringUtils.isNotBlank((CharSequence)benefit.getParam1())) continue;
            giftPkgIds.add(Long.parseLong(benefit.getParam1()));
        }
        HashMap<Long, CouponBO> couponMap = new HashMap<Long, CouponBO>(benefits.size());
        if (CollectionUtils.isNotEmpty(couponIds) && CollectionUtils.isNotEmpty(couponBOS = this.couponAtomService.listCouponById(couponIds))) {
            for (CouponBO couponBO : couponBOS) {
                couponMap.put(couponBO.getCouponId(), couponBO);
            }
        }
        HashMap<Long, GiftBO> giftMap = new HashMap<Long, GiftBO>(benefits.size());
        if (CollectionUtils.isNotEmpty(giftIds) && CollectionUtils.isNotEmpty(giftBOS = this.giftAtomService.listGiftById(giftIds))) {
            for (GiftInfoAtomBO giftInfoAtomBO : giftBOS) {
                GiftBO giftBo = new GiftBO();
                BeanUtils.copyProperties((Object)giftInfoAtomBO, (Object)giftBo);
                giftMap.put(giftBo.getGiftId(), giftBo);
            }
        }
        for (ActivityBenefitBO activityBenefitBO : benefits) {
            if (!"08".equals(rsp.getActivityType()) && StringUtils.isNotEmpty((CharSequence)activityBenefitBO.getParam2()) && !"10".equals(rsp.getActivityType())) {
                activityBenefitBO.setParam2(TkCalculatorUtils.transferY((String)activityBenefitBO.getParam2()));
            }
            if ("00".equals(activityBenefitBO.getBenefitType())) {
                CouponBO couponBO;
                if (StringUtils.isNotBlank((CharSequence)activityBenefitBO.getParam1())) {
                    if (!couponMap.containsKey(Long.parseLong(activityBenefitBO.getParam1()))) continue;
                    couponBO = new CouponBO();
                    BeanUtils.copyProperties(couponMap.get(Long.parseLong(activityBenefitBO.getParam1())), (Object)couponBO);
                    ConvertParamUtils.escapeCouponInfo(couponBO, this.qryEscapeAtomService, true);
                    activityBenefitBO.setCouponBO(couponBO);
                    continue;
                }
                couponBO = new CouponBO();
                couponBO.setCouponName("\u7a7a\u5238");
                couponBO.setCouponDesc("\u7a7a\u5238");
                activityBenefitBO.setCouponBO(couponBO);
                continue;
            }
            if (!"01".equals(activityBenefitBO.getBenefitType()) || StringUtils.isBlank((CharSequence)activityBenefitBO.getParam1()) || !giftMap.containsKey(Long.parseLong(activityBenefitBO.getParam1()))) continue;
            GiftBO giftBO = (GiftBO)giftMap.get(Long.parseLong(activityBenefitBO.getParam1()));
            ConvertParamUtils.escaptGiftInfo(giftBO, this.qryEscapeAtomService);
            activityBenefitBO.setGiftBO(giftBO);
        }
    }

    private void getActTouchSpotObj(ActConfigDetailsBO rsp) {
        ActivityTouchSpotBO activityTouchSpotBO = new ActivityTouchSpotBO();
        activityTouchSpotBO.setActivityId(rsp.getActivityId());
        List<ActivityTouchSpotBO> spotBOS = this.actTouchSpotAtomService.selectByCondition(activityTouchSpotBO);
        if (CollectionUtils.isEmpty(spotBOS)) {
            return;
        }
        rsp.setTouchSpotBOs(spotBOS);
    }

    private void getActCommObj(ActConfigDetailsBO rsp) {
        QryActCommReqAtomBO commReqBO = new QryActCommReqAtomBO();
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(rsp.getActivityId());
        commReqBO.setActIds(actIds);
        List<ActivityCommodityBO> commodityBOS = this.actCommAtomService.listCommByActIdAndObjTypes(commReqBO);
        if (CollectionUtils.isEmpty(commodityBOS)) {
            return;
        }
        HashMap<String, List<ActivityCommodityBO>> commMap = new HashMap<String, List<ActivityCommodityBO>>(commodityBOS.size());
        ArrayList<ActConfigObjDetailsBO> shops = new ArrayList<ActConfigObjDetailsBO>(commodityBOS.size());
        ArrayList<ActConfigObjDetailsBO> company = new ArrayList<ActConfigObjDetailsBO>(commodityBOS.size());
        block11: for (ActivityCommodityBO comm : commodityBOS) {
            if ("09".equals(rsp.getActivityType()) || "10".equals(rsp.getActivityType()) || "11".equals(rsp.getActivityType()) || "12".equals(rsp.getActivityType()) || "00".equals(rsp.getActivityType())) {
                switch (comm.getObjType()) {
                    case "00": {
                        rsp.setAllFlag("00");
                        ActConfigObjDetailsBO comp1 = new ActConfigObjDetailsBO();
                        comp1.setObjCode(comm.getParam6());
                        comp1.setMaterial(comm.getParam5());
                        company.add(comp1);
                        continue block11;
                    }
                    case "01": 
                    case "02": 
                    case "03": 
                    case "05": {
                        ActConfigObjDetailsBO comp2 = new ActConfigObjDetailsBO();
                        comp2.setObjCode(comm.getParam6());
                        comp2.setMaterial(comm.getParam5());
                        company.add(comp2);
                        continue block11;
                    }
                }
            } else if ("05".equals(comm.getObjType())) {
                ActConfigObjDetailsBO shop = new ActConfigObjDetailsBO();
                shop.setObjCode(comm.getObjCode());
                shops.add(shop);
                continue;
            }
            List<ActivityCommodityBO> comms = commMap.containsKey(comm.getObjType()) ? (List)commMap.get(comm.getObjType()) : new ArrayList(1);
            comms.add(comm);
            commMap.put(comm.getObjType(), comms);
        }
        if (MapUtils.isNotEmpty(commMap)) {
            List<ActConfigObjBO> objBOs = this.getCommObjDetails(commMap, rsp);
            rsp.setComms(objBOs);
        }
        if (CollectionUtils.isNotEmpty(shops)) {
            rsp.setShops(shops);
        }
        if (CollectionUtils.isNotEmpty(company)) {
            rsp.setCompany(company);
        }
    }

    private List<ActConfigObjBO> getCommObjDetails(Map<String, List<ActivityCommodityBO>> commMap, ActConfigDetailsBO rsp) {
        ArrayList<ActConfigObjBO> objBOs = new ArrayList<ActConfigObjBO>(commMap.size());
        for (Map.Entry<String, List<ActivityCommodityBO>> map : commMap.entrySet()) {
            ActConfigObjBO objBO = new ActConfigObjBO();
            objBO.setObjType(map.getKey());
            objBOs.add(objBO);
            ArrayList<ActConfigObjDetailsBO> details = new ArrayList<ActConfigObjDetailsBO>(map.getValue().size());
            for (ActivityCommodityBO comm : map.getValue()) {
                ActConfigObjDetailsBO detail = new ActConfigObjDetailsBO();
                detail.setObjCode(comm.getObjCode());
                if (null != comm.getActPrice()) {
                    detail.setActPrice(TkCalculatorUtils.transferY((long)comm.getActPrice()));
                }
                detail.setTotalCount(comm.getTotalCount());
                detail.setUserAvailableCount(comm.getUserAvailableCount());
                detail.setAvalibleCount(comm.getAvailableCount());
                detail.setMaterial(comm.getParam5());
                if (StringUtils.isNotBlank((CharSequence)comm.getParam6())) {
                    detail.setSilverCard(TkCalculatorUtils.transferY((String)comm.getParam6()));
                }
                if ("12".equals(rsp.getActivityType()) && StringUtils.isNotBlank((CharSequence)comm.getParam7())) {
                    detail.setGoldCard(String.valueOf((int)(Double.parseDouble(comm.getParam7()) * 100.0)));
                } else if ("11".equals(rsp.getActivityType()) && StringUtils.isNotBlank((CharSequence)comm.getParam7())) {
                    detail.setGoldCard(TkCalculatorUtils.transferY((String)comm.getParam7()));
                }
                if (StringUtils.isNotBlank((CharSequence)comm.getParam8())) {
                    detail.setPlatinumCard(TkCalculatorUtils.transferY((String)comm.getParam8()));
                }
                if (StringUtils.isNotBlank((CharSequence)comm.getParam9())) {
                    detail.setDiamondCard(TkCalculatorUtils.transferY((String)comm.getParam9()));
                }
                details.add(detail);
            }
            objBO.setDetails(details);
        }
        return objBOs;
    }

    private void getActUserRange(ActConfigDetailsBO rsp) {
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(rsp.getActivityId());
        List<ActivityUserBO> userBOS = this.actUserAtomService.listUserMatch(actIds);
        if (CollectionUtils.isEmpty(userBOS)) {
            return;
        }
        HashMap<String, Set<String>> userMap = new HashMap<String, Set<String>>(userBOS.size());
        for (ActivityUserBO user : userBOS) {
            Set<String> ruleIds = userMap.containsKey(user.getMatchType()) ? (Set)userMap.get(user.getMatchType()) : new HashSet(1);
            ruleIds.add(user.getRuleId().toString());
            userMap.put(user.getMatchType(), ruleIds);
        }
        if (MapUtils.isNotEmpty(userMap)) {
            List<ActConfigObjBO> objBOs = this.getUserObjDetails(userMap);
            rsp.setUsers(objBOs);
        }
    }

    private List<ActConfigObjBO> getUserObjDetails(Map<String, Set<String>> objMap) {
        ArrayList<ActConfigObjBO> objBOs = new ArrayList<ActConfigObjBO>(objMap.size());
        for (Map.Entry<String, Set<String>> map : objMap.entrySet()) {
            ActConfigObjBO objBO = new ActConfigObjBO();
            objBO.setObjType(map.getKey());
            Map<String, String> codeName = this.getUserCodeName(map.getKey(), map.getValue());
            ArrayList<ActConfigObjDetailsBO> details = new ArrayList<ActConfigObjDetailsBO>(map.getValue().size());
            for (String code : map.getValue()) {
                ActConfigObjDetailsBO detail = new ActConfigObjDetailsBO();
                detail.setObjCode(code);
                if (codeName.containsKey(code)) {
                    detail.setObjName(codeName.get(code));
                }
                details.add(detail);
            }
            objBO.setDetails(details);
            objBOs.add(objBO);
        }
        return objBOs;
    }

    private Map<String, String> getUserCodeName(String key, Set<String> value) {
        HashSet<Long> ids = new HashSet<Long>(value.size());
        for (String id : value) {
            ids.add(Long.parseLong(id));
        }
        HashMap<String, String> map = new HashMap<String, String>(value.size());
        switch (key) {
            case "00": {
                List<UserSetBO> userSetBOs = this.actUserAtomService.listUserSet(ids);
                if (CollectionUtils.isEmpty(userSetBOs)) break;
                for (UserSetBO set : userSetBOs) {
                    map.put(set.getUserSetId().toString(), set.getSetName());
                }
                break;
            }
            case "02": 
            case "01": {
                List<MatchRuleBO> ruleBOs = this.actUserAtomService.listMatchRule(ids);
                if (CollectionUtils.isEmpty(ruleBOs)) break;
                for (MatchRuleBO rule : ruleBOs) {
                    map.put(rule.getRuleId().toString(), rule.getRuleAliasName());
                }
                break;
            }
        }
        return map;
    }

    public RspBaseBO saveActRelation(ActRelationConfigReqBO reqBO) {
        List<ActivityRelationBO> relations;
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetails())) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        if (CollectionUtils.isNotEmpty(relations = this.getRelationBOs(reqBO))) {
            this.actRelationAtomService.saveBatch(relations);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private List<ActivityRelationBO> getRelationBOs(ActRelationConfigReqBO reqBO) {
        ArrayList<ActivityRelationBO> relations = new ArrayList<ActivityRelationBO>();
        Date nowDate = new Date();
        for (ActRelationConfigDetailBO detailBO : reqBO.getDetails()) {
            ActivityRelationBO targetRelation;
            String targetRegionType;
            String targetRegion;
            ActivityRelationBO sourceRelation;
            if (null == detailBO.getSourceActId() && StringUtils.isBlank((CharSequence)detailBO.getSourceActType())) {
                log.error("\u6d3b\u52a8ID\u548c\u6d3b\u52a8\u7c7b\u578b\u5fc5\u586b\u5176\u4e00");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u548c\u6d3b\u52a8\u7c7b\u578b\u5fc5\u586b\u5176\u4e00");
            }
            if (CollectionUtils.isNotEmpty((Collection)detailBO.getTargetActIds())) {
                for (Long actId : detailBO.getTargetActIds()) {
                    sourceRelation = this.getActRelationBO(detailBO.getSourceActId(), detailBO.getSourceActType(), actId.toString(), "00", reqBO.getmTenantId(), nowDate);
                    relations.add(sourceRelation);
                    targetRegion = null == detailBO.getSourceActId() ? detailBO.getSourceActType() : detailBO.getSourceActId().toString();
                    targetRegionType = null == detailBO.getSourceActId() ? "01" : "00";
                    targetRelation = this.getActRelationBO(actId, null, targetRegion, targetRegionType, reqBO.getmTenantId(), nowDate);
                    relations.add(targetRelation);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)detailBO.getTargetActTypes())) continue;
            for (String actType : detailBO.getTargetActTypes()) {
                sourceRelation = this.getActRelationBO(detailBO.getSourceActId(), detailBO.getSourceActType(), actType, "01", reqBO.getmTenantId(), nowDate);
                relations.add(sourceRelation);
                targetRegion = null == detailBO.getSourceActId() ? detailBO.getSourceActType() : detailBO.getSourceActId().toString();
                targetRegionType = null == detailBO.getSourceActId() ? "01" : "00";
                targetRelation = this.getActRelationBO(null, actType, targetRegion, targetRegionType, reqBO.getmTenantId(), nowDate);
                relations.add(targetRelation);
            }
        }
        return relations;
    }

    private ActivityRelationBO getActRelationBO(Long actId, String actType, String region, String regionType, Long tenantId, Date nowDate) {
        ActivityRelationBO relationBO = new ActivityRelationBO();
        if (null == actId) {
            relationBO.setActivityType(actType);
        } else {
            relationBO.setActivityId(actId);
        }
        relationBO.setCrtTime(nowDate);
        relationBO.setRelType("1");
        relationBO.setTenantId(tenantId);
        relationBO.setObjectRegion(region);
        relationBO.setObjectType(regionType);
        return relationBO;
    }
}

