/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.act.atom.ActCostAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.bo.ActCostConfigBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCostInfoBO;
import com.tydic.newretail.act.bo.ActivityCostInfoExcelBO;
import com.tydic.newretail.act.bo.QryActCostByPageReqBO;
import com.tydic.newretail.act.busi.ActCostConfigBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActCostConfigBusiServiceImpl
implements ActCostConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActCostConfigBusiServiceImpl.class);
    @Autowired
    private ActCostAtomService actCostAtomService;
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspBaseBO saveActCost(ActCostConfigBO reqBO) {
        log.debug("\u6d3b\u52a8\u8d39\u7528\u65b0\u589e\u5165\u53c2" + reqBO.toString());
        ActivityCostInfoBO po = new ActivityCostInfoBO();
        this.checkParams(reqBO, po);
        try {
            this.actCostAtomService.saveActCostInfo(po);
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u65b0\u589e\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO modifyActCost(ActCostConfigBO reqBO) {
        if (null == reqBO.getCostCode()) {
            log.error("\u8d39\u7528\u5355\u636eID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u8d39\u7528\u5355\u636eID\u4e3a\u7a7a");
        }
        ActivityCostInfoBO activityCostInfoBO = new ActivityCostInfoBO();
        activityCostInfoBO.setCostCode(reqBO.getCostCode());
        ActivityCostInfoBO actCostInfo = this.actCostAtomService.getActCostInfo(activityCostInfoBO);
        if (null == actCostInfo) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u6d3b\u52a8\u8d39\u7528\u4e0d\u5b58\u5728");
        }
        if (!actCostInfo.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
            log.error("\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d60\u54c1\u5305");
            return new RspBaseBO("0010", "\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d60\u54c1\u5305");
        }
        ActivityCostInfoBO record = new ActivityCostInfoBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getCostAmount())) {
            record.setCostAmount(Long.valueOf(new BigDecimal(reqBO.getCostAmount()).setScale(2, 4).multiply(new BigDecimal("10000")).longValue()));
        }
        record.setLastUpdTime(new Date());
        record.setLastUpdUid(String.valueOf(reqBO.getmUserId()));
        try {
            this.actCostAtomService.modifyActCostInfo(record, true);
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u7f16\u8f91\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspPageBaseBO<ActivityCostInfoBO> listActCostInfoByPage(QryActCostByPageReqBO reqBO) {
        List<ActivityCostInfoBO> pos;
        log.debug("\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        Page page = new Page();
        page.setPageNo(reqBO.getCurrent());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getCurrent() - 1));
        page.setPageNo(reqBO.getCurrent());
        page.setPageSize(reqBO.getPageSize());
        ActivityCostInfoBO record = new ActivityCostInfoBO();
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getCompanyType())) {
            record.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
            record.setCompanyCodeCity(reqBO.getCompanyCodeCity());
            record.setCompanyCodeDistrict(reqBO.getCompanyCodeDistrict());
            record.setCompanyCodeStore(reqBO.getCompanyCodeStore());
        }
        record.setActivityId(reqBO.getActivityId());
        record.setStartTime(reqBO.getStartTime());
        record.setEndTime(reqBO.getEndTime());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmProvince())) {
            record.setCompanyCodeProvince(reqBO.getmProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmCity())) {
            record.setCompanyCodeCity(reqBO.getmCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmDistrict())) {
            record.setCompanyCodeDistrict(reqBO.getmDistrict());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmShopId())) {
            record.setCompanyCodeStore(reqBO.getmShopId());
        }
        try {
            pos = this.actCostAtomService.selectByPage(record, (Page<Map<String, Object>>)page);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return new RspPageBaseBO("0000", "\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
        }
        ArrayList<ActivityCostInfoBO> bos = new ArrayList<ActivityCostInfoBO>(pos.size());
        for (ActivityCostInfoBO po : pos) {
            ActivityCostInfoBO bo = new ActivityCostInfoBO();
            ConvertParamUtils.escaptActCost(po, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bo.setAllowModification("1");
            if (!bo.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
                bo.setAllowModification("0");
            }
            bos.add(bo);
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", bos, page.getTotalCount(), page.getTotalPages());
    }

    public RspBaseTBO<ActivityCostInfoBO> getActCostDetail(ActCostConfigBO reqBO) {
        if (null == reqBO.getCostCode()) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u5355\u53f7ID\u4e3a\u7a7a");
            return new RspBaseTBO("0001", "\u6d3b\u52a8\u8d39\u7528\u5355\u53f7ID\u4e3a\u7a7a");
        }
        ActivityCostInfoBO activityCostInfoBO = new ActivityCostInfoBO();
        activityCostInfoBO.setCostCode(reqBO.getCostCode());
        ActivityCostInfoBO actCostInfo = this.actCostAtomService.getActCostInfo(activityCostInfoBO);
        if (null == actCostInfo) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0002", "\u6d3b\u52a8\u8d39\u7528\u4e0d\u5b58\u5728");
        }
        ConvertParamUtils.escaptActCost(actCostInfo, this.qryEscapeAtomService);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)actCostInfo);
    }

    public RspBaseBO removeActCost(ActCostConfigBO reqBO) {
        log.debug("\u6d3b\u52a8\u8d39\u7528\u5220\u9664\u5165\u53c2" + reqBO.toString());
        if (null == reqBO.getCostCode()) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u5355\u53f7ID\u4e3a\u7a7a");
            return new RspBaseTBO("0001", "\u6d3b\u52a8\u8d39\u7528\u5355\u53f7ID\u4e3a\u7a7a");
        }
        ActivityCostInfoBO activityCostInfoBO = new ActivityCostInfoBO();
        activityCostInfoBO.setCostCode(reqBO.getCostCode());
        ActivityCostInfoBO actCostInfo = this.actCostAtomService.getActCostInfo(activityCostInfoBO);
        if (null == actCostInfo) {
            log.error("\u6d3b\u52a8\u8d39\u7528\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0002", "\u6d3b\u52a8\u8d39\u7528\u4e0d\u5b58\u5728");
        }
        if (!actCostInfo.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
            log.error("\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d39\u7528");
            return new RspBaseBO("0010", "\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d39\u7528");
        }
        this.modifyMethod(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBatchBaseBO<ActivityCostInfoExcelBO> listActCostInfo(QryActCostByPageReqBO reqBO) {
        List<ActivityCostInfoBO> pos;
        RspBatchBaseBO result = new RspBatchBaseBO();
        ActivityCostInfoBO record = new ActivityCostInfoBO();
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getCompanyType())) {
            record.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
            record.setCompanyCodeCity(reqBO.getCompanyCodeCity());
            record.setCompanyCodeDistrict(reqBO.getCompanyCodeDistrict());
            record.setCompanyCodeStore(reqBO.getCompanyCodeStore());
        }
        record.setActivityId(reqBO.getActivityId());
        record.setStartTime(reqBO.getStartTime());
        record.setEndTime(reqBO.getEndTime());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmProvince())) {
            record.setCompanyCodeProvince(reqBO.getmProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmCity())) {
            record.setCompanyCodeCity(reqBO.getmCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmDistrict())) {
            record.setCompanyCodeDistrict(reqBO.getmDistrict());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmShopId())) {
            record.setCompanyCodeStore(reqBO.getmShopId());
        }
        try {
            pos = this.actCostAtomService.selectByCondition(record);
        }
        catch (Exception e) {
            log.error("\u4e0d\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("0003");
            result.setRespDesc("\u4e0d\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u8d39\u7528\u4fe1\u606f\u5931\u8d25");
            return result;
        }
        if (CollectionUtils.isEmpty(pos)) {
            result.setRespCode("0000");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
            result.setRows(new ArrayList());
            return result;
        }
        ArrayList<ActivityCostInfoExcelBO> bos = new ArrayList<ActivityCostInfoExcelBO>(pos.size());
        for (ActivityCostInfoBO po : pos) {
            ActivityCostInfoExcelBO bo = new ActivityCostInfoExcelBO();
            ConvertParamUtils.escaptActCost(po, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        result.setRows(bos);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    private void checkParams(ActCostConfigBO reqBO, ActivityCostInfoBO po) {
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (null == reqBO.getmUserId()) {
            log.error("\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        po.setCreateUser(String.valueOf(reqBO.getmUserId()));
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmLoginName())) {
            po.setCreateUsername(reqBO.getmLoginName());
        }
        po.setTenantId(reqBO.getmTenantId());
        po.setBelongCode(reqBO.getmOrgId());
        if ("1".equals(reqBO.getmUserLevel())) {
            log.debug("\u603b\u90e8");
            po.setBelongRegion("00");
        } else if ("2".equals(reqBO.getmUserLevel())) {
            log.debug("\u7701\u4efd");
            po.setBelongRegion("01");
        } else if ("3".equals(reqBO.getmUserLevel())) {
            log.debug("\u5730\u5e02");
            po.setBelongRegion("02");
        } else if ("4".equals(reqBO.getmUserLevel())) {
            log.debug("\u533a\u53bf");
            po.setBelongRegion("03");
        } else if ("5".equals(reqBO.getmUserLevel())) {
            log.debug("\u95e8\u5e97");
            po.setBelongRegion("05");
        } else {
            log.error("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        if ("01".equals(reqBO.getCompanyType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeProvince())) {
                log.error("\u516c\u53f8\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
            }
            po.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
        }
        if ("02".equals(reqBO.getCompanyType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeProvince()) || StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeCity())) {
                log.error("\u516c\u53f8\u7701\u4efd\u7f16\u7801\u6216\u8005\u516c\u53f8\u5730\u5e02\u7f16\u7801\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u7701\u4efd\u7f16\u7801\u6216\u8005\u516c\u53f8\u5730\u5e02\u7f16\u7801\u4e3a\u7a7a");
            }
            po.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
            po.setCompanyCodeCity(reqBO.getCompanyCodeCity());
        }
        if ("03".equals(reqBO.getCompanyType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeProvince()) || StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeCity()) || StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeDistrict())) {
                log.error("\u516c\u53f8\u7701\u4efd\u7f16\u7801\u6216\u8005\u516c\u53f8\u5730\u5e02\u7f16\u7801\u6216\u8005\u516c\u53f8\u533a\u53bf\u7f16\u7801\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u7701\u4efd\u7f16\u7801\u6216\u8005\u516c\u53f8\u5730\u5e02\u7f16\u7801\u6216\u8005\u516c\u53f8\u533a\u53bf\u7f16\u7801\u4e3a\u7a7a");
            }
            po.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
            po.setCompanyCodeCity(reqBO.getCompanyCodeCity());
            po.setCompanyCodeDistrict(reqBO.getCompanyCodeDistrict());
        }
        if ("05".equals(reqBO.getCompanyType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeProvince()) || StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeCity()) || StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeDistrict()) || StringUtils.isBlank((CharSequence)reqBO.getCompanyCodeStore())) {
                log.error("\u516c\u53f8\u7701\u4efd\u7f16\u7801\u6216\u8005\u516c\u53f8\u5730\u5e02\u7f16\u7801\u6216\u8005\u516c\u53f8\u533a\u53bf\u7f16\u7801\u6216\u8005\u516c\u53f8\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u516c\u53f8\u7701\u4efd\u7f16\u7801\u6216\u8005\u516c\u53f8\u5730\u5e02\u7f16\u7801\u6216\u8005\u516c\u53f8\u533a\u53bf\u7f16\u7801\u6216\u8005\u516c\u53f8\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            }
            po.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
            po.setCompanyCodeCity(reqBO.getCompanyCodeCity());
            po.setCompanyCodeDistrict(reqBO.getCompanyCodeDistrict());
            po.setCompanyCodeStore(reqBO.getCompanyCodeStore());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getCostAmount())) {
            po.setCostAmount(Long.valueOf(new BigDecimal(reqBO.getCostAmount()).setScale(2, 4).multiply(new BigDecimal("10000")).longValue()));
        }
        po.setStatus("01");
        ActivityBO activityBO = new ActivityBO();
        activityBO.setActivityId(po.getActivityId());
        ActivityBO activityInfo = this.actInfoAtomService.getActivityInfo(activityBO);
        if (null != activityInfo) {
            po.setStartTime(activityInfo.getStartTime());
            po.setEndTime(activityInfo.getEndTime());
        }
        po.setCostCode("CS" + Sequence.getInstance().nextId());
    }

    private void modifyMethod(ActCostConfigBO reqBO) {
        ActivityCostInfoBO activityCostInfoBO = new ActivityCostInfoBO();
        activityCostInfoBO.setCostCode(reqBO.getCostCode());
        activityCostInfoBO.setLastUpdUid(reqBO.getLastUpdUid());
        activityCostInfoBO.setLastUpdUsername(reqBO.getmLoginName());
        activityCostInfoBO.setIsValid("0");
        activityCostInfoBO.setStatus("00");
        this.actCostAtomService.modifyActCostInfo(activityCostInfoBO, true);
    }
}

