/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.ability.CouponInstanceAbilityService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActParticipateAtomService;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.bo.QryActReqAtomBO;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.ActParticipationReqBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.QryActBenefitRspBO;
import com.tydic.newretail.act.bo.QryScratchCardRspBO;
import com.tydic.newretail.act.bo.StaffPriceParticipateRecordBO;
import com.tydic.newretail.act.busi.ActParticipationBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActParticipationBusiServiceImpl
implements ActParticipationBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActParticipationBusiServiceImpl.class);
    @Autowired
    private ActParticipateAtomService actParticipateAtomService;
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Autowired
    private ActivityBenefitAtomService activityBenefitAtomService;
    @Autowired
    private CouponInstanceAbilityService couponInstanceAbilityService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspBaseBO saveActRecord(ActParticipationReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActCommList())) {
            log.error("\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<StaffPriceParticipateRecordBO> staffPars = new ArrayList<StaffPriceParticipateRecordBO>(reqBO.getActCommList().size());
        for (ActCommInfoBO comm : reqBO.getActCommList()) {
            if (CollectionUtils.isEmpty((Collection)comm.getActList())) continue;
            if (null == comm.getSkuCount() || null == comm.getSkuId()) {
                log.error("\u9500\u552e\u6570\u91cf\u6216\u5546\u54c1ID\u4e3a\u7a7a");
                throw new ResourceException("0001", "\u9500\u552e\u6570\u91cf\u6216\u5546\u54c1ID\u4e3a\u7a7a");
            }
            for (ActivityBO act : comm.getActList()) {
                if (null == act.getActivityId() || StringUtils.isBlank((CharSequence)act.getActivityType())) {
                    log.error("\u6d3b\u52a8ID\u6216\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
                    throw new ResourceException("0001", "\u6d3b\u52a8ID\u6216\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
                }
                StaffPriceParticipateRecordBO staff = new StaffPriceParticipateRecordBO();
                staff.setActivityId(act.getActivityId());
                staff.setActivityType(act.getActivityType());
                staff.setPurchaseCount(comm.getSkuCount());
                staff.setSkuId(comm.getSkuId());
                staff.setTenantId(Long.valueOf(0L));
                staff.setUid(reqBO.getMemId());
                staffPars.add(staff);
            }
        }
        if (CollectionUtils.isNotEmpty(staffPars)) {
            this.actParticipateAtomService.saveActParticipateRecord(staffPars);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public QryActBenefitRspBO listBenefits(ActParticipationReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBO.getMemId()) {
            log.error("\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        QryActBenefitRspBO rsp = new QryActBenefitRspBO();
        this.getGiftMethod(reqBO, rsp);
        return rsp;
    }

    private List<ActivityBenefitBO> getGiftMethod(ActParticipationReqBO reqBO, QryActBenefitRspBO rsp) {
        QryActReqAtomBO atomBO = new QryActReqAtomBO();
        atomBO.setActivityType(reqBO.getActivityType());
        atomBO.setNowDate(reqBO.getRegTime());
        atomBO.setEndDate(reqBO.getRegTime());
        HashSet<String> actStatus = new HashSet<String>(1);
        actStatus.add("02");
        List<ActivityBO> activityBOS = this.actInfoAtomService.listActByType(atomBO);
        if (CollectionUtils.isEmpty(activityBOS)) {
            return null;
        }
        ActivityBO actInfo = activityBOS.get(0);
        String escapeStr = this.qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", actInfo.getActivityType());
        if (StringUtils.isBlank((CharSequence)escapeStr)) {
            escapeStr = "\u672a\u5b9a\u4e49";
        }
        rsp.setActivityId(actInfo.getActivityId());
        rsp.setActivityTypeStr(escapeStr);
        rsp.setTenantId(actInfo.getTenantId());
        rsp.setActivityType(actInfo.getActivityType());
        if (StringUtils.isNotBlank((CharSequence)actInfo.getParam2())) {
            int grandCount = this.actParticipateAtomService.getCountByActIdAndUid(actInfo.getActivityId(), reqBO.getMemId(), false);
            if (Integer.parseInt(actInfo.getParam2()) <= grandCount) {
                return null;
            }
        }
        ActivityBenefitBO qryBenefitBO = new ActivityBenefitBO();
        qryBenefitBO.setActivityId(actInfo.getActivityId());
        qryBenefitBO.setBenefitType("00");
        List<ActivityBenefitBO> benefitBOS = this.activityBenefitAtomService.listBenefitByActId(qryBenefitBO);
        if (CollectionUtils.isEmpty(benefitBOS)) {
            return null;
        }
        int count = benefitBOS.size();
        boolean payGift = false;
        if ("06".equals(actInfo.getActivityType())) {
            payGift = true;
            Collections.sort(benefitBOS, new Comparator<ActivityBenefitBO>(){

                @Override
                public int compare(ActivityBenefitBO o1, ActivityBenefitBO o2) {
                    return -o1.getParam2().compareTo(o2.getParam2());
                }
            });
            count = StringUtils.isNotBlank((CharSequence)actInfo.getParam1()) ? Integer.parseInt(actInfo.getParam1()) : 1;
        }
        ArrayList<ActivityBenefitBO> rspList = new ArrayList<ActivityBenefitBO>();
        for (ActivityBenefitBO bene : benefitBOS) {
            if (!payGift) {
                rspList.add(bene);
                continue;
            }
            if (null == reqBO.getTotalAmount()) {
                log.error("\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u652f\u4ed8\u91d1\u989d\u4e3a\u7a7a");
            }
            if (reqBO.getTotalAmount().compareTo(Long.parseLong(bene.getParam2())) < 0) continue;
            rspList.add(bene);
        }
        rspList = rspList.subList(0, count > rspList.size() ? rspList.size() : count);
        rsp.setBenefitBOS(rspList);
        return rspList;
    }

    public QryScratchCardRspBO getScratchCardInfo(ActParticipationReqBO reqBO) {
        if (null == reqBO.getMemId() || null == reqBO.getActivityId()) {
            log.error("\u4f1a\u5458ID\u6216\u6d3b\u52a8ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4f1a\u5458ID\u6216\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        ActivityBO qryActReqBO = new ActivityBO();
        qryActReqBO.setActivityId(reqBO.getActivityId());
        ActivityBO qryActRspBO = this.actInfoAtomService.getActivityInfo(qryActReqBO);
        if (null == qryActRspBO) {
            return new QryScratchCardRspBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        Integer partiCount = null;
        if (StringUtils.isNotBlank((CharSequence)qryActRspBO.getParam2())) {
            int grandCount = this.actParticipateAtomService.getCountByActIdAndUid(qryActRspBO.getActivityId(), reqBO.getMemId(), false);
            partiCount = Integer.parseInt(qryActRspBO.getParam2()) - grandCount;
            if (partiCount < 0) {
                partiCount = 0;
            }
        }
        Integer todayPartiCount = null;
        if (StringUtils.isNotBlank((CharSequence)qryActRspBO.getParam1())) {
            int grandCount = this.actParticipateAtomService.getCountByActIdAndUid(qryActRspBO.getActivityId(), reqBO.getMemId(), true);
            todayPartiCount = Integer.parseInt(qryActRspBO.getParam1()) - grandCount;
            if (todayPartiCount < 0) {
                todayPartiCount = 0;
            }
        }
        if (null != partiCount && null != todayPartiCount && partiCount < todayPartiCount) {
            todayPartiCount = partiCount;
        }
        ConvertParamUtils.escaptAct(qryActRspBO, this.qryEscapeAtomService, true);
        return new QryScratchCardRspBO("0000", "\u64cd\u4f5c\u6210\u529f", qryActRspBO, partiCount, todayPartiCount);
    }
}

