/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.newretail.act.atom.ActCalAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.bo.ActCalReqBO;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.ActPriceCalRspBO;
import com.tydic.newretail.act.bo.ActShopInfoBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponPriceDetailBO;
import com.tydic.newretail.act.bo.QryActivityReqBO;
import com.tydic.newretail.act.busi.ActPriceCalBusiService;
import com.tydic.newretail.act.busi.CouponPriceCalBusiService;
import com.tydic.newretail.act.busi.QryActivityBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.act.util.SortActUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActPriceCalBusiServiceImpl
implements ActPriceCalBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActPriceCalBusiServiceImpl.class);
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Autowired
    private ActCalAtomService actCalAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private QryActivityBusiService qryActivityBusiService;
    @Autowired
    private CouponPriceCalBusiService couponPriceCalBusiService;
    private Long oriAmount;

    public ActPriceCalRspBO calPrice(ActCalReqBO reqBO) {
        if (reqBO != null) {
            log.debug("\u6d3b\u52a8\u8ba1\u7b97\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        }
        this.checkParams(reqBO);
        HashMap<Long, List<ActCommInfoBO>> actCommMap = new HashMap<Long, List<ActCommInfoBO>>(16);
        ArrayList<ActivityBO> participateList = new ArrayList<ActivityBO>();
        HashMap<Long, List<ActivityBO>> allowActMap = new HashMap<Long, List<ActivityBO>>(16);
        this.oriAmount = 0L;
        this.reOrgParams(reqBO, participateList, actCommMap, allowActMap);
        HashMap commActMap = new HashMap(16);
        if (MapUtils.isNotEmpty(actCommMap)) {
            SortActUtils.sortByPriority(participateList);
            block0: for (ActivityBO act : participateList) {
                Long amoPrice;
                Double diffAmo;
                Object comm2;
                List actCommInfoBOS = (List)actCommMap.get(act.getActivityId());
                long oriPrice = 0L;
                if ("00".equals(act.getActivityType()) || "09".equals(act.getActivityType())) {
                    for (Object comm2 : actCommInfoBOS) {
                        long price = comm2.getSalePriceL();
                        if (null != comm2.getSkuDisPriceL()) {
                            price = comm2.getSkuDisPriceL();
                        }
                        oriPrice = TkCalculatorUtils.add((long)oriPrice, (long)TkCalculatorUtils.muliti((long)price, (long)comm2.getSkuCount().intValue()));
                    }
                }
                Double totalAmo = new Double(0.0);
                comm2 = actCommInfoBOS.iterator();
                while (comm2.hasNext()) {
                    ActCommInfoBO comm3 = (ActCommInfoBO)comm2.next();
                    Double amoPrice2 = this.actCalAtomService.calPriceByType(comm3, act, oriPrice, reqBO);
                    List<ActivityBO> commActs = commActMap.containsKey(comm3.getSkuId()) ? (List)commActMap.get(comm3.getSkuId()) : new ArrayList(1);
                    act.setCheckFlag("1");
                    commActs.add(act);
                    commActMap.put(comm3.getSkuId(), commActs);
                    if (!"00".equals(act.getActivityType())) continue;
                    totalAmo = TkCalculatorUtils.add((BigDecimal)new BigDecimal(totalAmo.toString()), (BigDecimal)TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(amoPrice2), (BigDecimal)new BigDecimal(comm3.getSkuCount()))).doubleValue();
                }
                if (!(totalAmo > 0.0) || !"00".equals(act.getActivityType()) || !StringUtils.isNotBlank((CharSequence)act.getParam2()) || (diffAmo = Double.valueOf(TkCalculatorUtils.sub((BigDecimal)new BigDecimal(TkCalculatorUtils.transferY((long)(amoPrice = Long.valueOf(Long.parseLong(act.getParam2())))).toString()), (BigDecimal)new BigDecimal(totalAmo.toString())).doubleValue())) == 0.0) continue;
                for (ActCommInfoBO commInfoBO : actCommInfoBOS) {
                    if (commInfoBO.getSkuDisTotalPrice().compareTo(diffAmo) < 0) continue;
                    double finalAmo = TkCalculatorUtils.add((BigDecimal)new BigDecimal(commInfoBO.getSkuDisTotalAmount().toString()), (BigDecimal)new BigDecimal(diffAmo.toString())).doubleValue();
                    commInfoBO.setSkuDisTotalAmount(Double.valueOf(finalAmo));
                    commInfoBO.setSkuDisTotalPrice(Double.valueOf(TkCalculatorUtils.sub((BigDecimal)new BigDecimal(commInfoBO.getSkuDisTotalPrice().toString()), (BigDecimal)new BigDecimal(diffAmo.toString())).doubleValue()));
                    continue block0;
                }
            }
        }
        for (ActCommInfoBO comm : reqBO.getCommList()) {
            if (null != comm.getSkuNewPriceL()) {
                this.calNewPrice(reqBO, comm);
                ConvertParamUtils.escapePrice(comm);
                continue;
            }
            boolean hasAct = false;
            if (commActMap.containsKey(comm.getSkuId())) {
                comm.setActList((List)commActMap.get(comm.getSkuId()));
                hasAct = true;
            }
            if (allowActMap.containsKey(comm.getSkuId())) {
                List acts = hasAct ? comm.getActList() : new ArrayList();
                acts.addAll((Collection)allowActMap.get(comm.getSkuId()));
            }
            if (CollectionUtils.isEmpty((Collection)comm.getActIds()) || !commActMap.containsKey(comm.getSkuId())) {
                ConvertParamUtils.setPrice(comm, comm.getSalePriceL(), 0L);
            }
            if (CollectionUtils.isNotEmpty((Collection)comm.getActList())) {
                SortActUtils.sortByPriority(comm.getActList());
                this.displayPrice(comm, reqBO, this.oriAmount);
            }
            ConvertParamUtils.escapePrice(comm);
            if (null != comm.getSkuDisTotalPrice() && null != comm.getSkuDisTotalAmount()) continue;
            comm.setSkuDisTotalPrice(Double.valueOf(TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(comm.getSkuDisPrice().toString()), (BigDecimal)new BigDecimal(comm.getSkuCount().toString())).doubleValue()));
            comm.setSkuDisTotalAmount(Double.valueOf(TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(comm.getSkuDisAmount().toString()), (BigDecimal)new BigDecimal(comm.getSkuCount().toString())).doubleValue()));
        }
        ActCalReqBO couponCalRsp = this.couponPriceCalBusiService.calPrice(reqBO);
        ActPriceCalRspBO rsp = this.calTotalPrice(couponCalRsp);
        if (rsp != null) {
            log.debug("\u6d3b\u52a8\u8ba1\u7b97\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rsp));
        }
        return rsp;
    }

    private void displayPrice(ActCommInfoBO comm, ActCalReqBO reqBO, long oriPrice) {
        for (ActivityBO act : comm.getActList()) {
            String disName;
            if (null != comm.getDisPrice() || !"1".equals(act.getForceChooseFlag()) || !"1".equals(act.getCheckFlag())) continue;
            Double price = comm.getSkuDisPrice();
            Double discount = comm.getSkuDisAmount();
            Double totalPrice = comm.getSkuDisTotalPrice();
            Double totalDis = comm.getSkuDisTotalAmount();
            this.actCalAtomService.calPriceByType(comm, act, oriPrice, reqBO);
            try {
                comm.setDisPrice(Double.valueOf(MoneyUtils.Long2BigDecimal((Long)comm.getSkuDisPriceL()).doubleValue()));
            }
            catch (Exception e) {
                log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            }
            comm.setDisActType(act.getActivityType());
            comm.setSkuDisAmount(discount);
            comm.setSkuDisPrice(price);
            comm.setSkuDisTotalAmount(totalDis);
            comm.setSkuDisTotalPrice(totalPrice);
            if (comm.getSkuDisPrice().compareTo(comm.getDisPrice()) < 0) {
                comm.setDisPrice(comm.getSkuDisPrice());
                comm.setDisActType("-1");
            }
            comm.setDisActName(StringUtils.isBlank((CharSequence)(disName = this.qryEscapeAtomService.getCodeTitle("ACT_TYPE_DISPLAY_NAME", comm.getDisActType()))) ? "\u672a\u5b9a\u4e49" : disName);
        }
    }

    private void reOrgParams(ActCalReqBO reqBO, List<ActivityBO> participateList, Map<Long, List<ActCommInfoBO>> actCommMap, Map<Long, List<ActivityBO>> allowActMap) {
        HashSet<Long> participateSet = new HashSet<Long>(16);
        for (ActCommInfoBO comm : reqBO.getCommList()) {
            this.checkDetailParams(comm);
            this.oriAmount = this.oriAmount + comm.getSalePriceL() * (long)comm.getSkuCount().intValue();
            List<ActivityBO> acts = this.getCommAct(reqBO, comm);
            if (CollectionUtils.isEmpty(acts)) {
                log.debug("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u3010{}\u3011\u53ef\u53c2\u4e0e\u7684\u6d3b\u52a8", (Object)comm.getSkuId());
                continue;
            }
            Map<Long, ActivityBO> actMap = this.getActMap(acts);
            if (CollectionUtils.isNotEmpty((Collection)comm.getActIds())) {
                for (Long actId : comm.getActIds()) {
                    if (!actMap.containsKey(actId)) {
                        log.debug("\u6d3b\u52a8\u3010{}\u3011\u8fc7\u671f", (Object)actId);
                        continue;
                    }
                    if (!"1".equals(actMap.get(actId).getOptionalFlag())) {
                        log.debug("\u6d3b\u52a8\u3010{}\u3011\u4e0d\u53ef\u9009", (Object)actId);
                        continue;
                    }
                    ActivityBO act = actMap.get(actId);
                    if (!participateSet.contains(actId)) {
                        participateList.add(act);
                        participateSet.add(actId);
                    }
                    actMap.remove(actId);
                    List<Object> actComms = actCommMap.containsKey(actId) ? actCommMap.get(actId) : new ArrayList(1);
                    actComms.add(comm);
                    actCommMap.put(actId, actComms);
                }
            }
            if (!MapUtils.isNotEmpty(actMap)) continue;
            ArrayList<ActivityBO> actList = new ArrayList<ActivityBO>(actMap.size());
            for (Map.Entry<Long, ActivityBO> map : actMap.entrySet()) {
                actList.add(map.getValue());
            }
            allowActMap.put(comm.getSkuId(), actList);
        }
    }

    private Map<Long, ActivityBO> getActMap(List<ActivityBO> acts) {
        HashMap<Long, ActivityBO> map = new HashMap<Long, ActivityBO>(acts.size());
        for (ActivityBO act : acts) {
            map.put(act.getActivityId(), act);
        }
        return map;
    }

    private List<ActivityBO> getCommAct(ActCalReqBO reqBO, ActCommInfoBO comm) {
        QryActivityReqBO qryReqBO = new QryActivityReqBO();
        qryReqBO.setMemType(reqBO.getMemType());
        qryReqBO.setMemLevel(reqBO.getMemLevel());
        qryReqBO.setMemId(reqBO.getMemId());
        qryReqBO.setCalPorPriority(Boolean.valueOf(false));
        qryReqBO.setSaleType(reqBO.getSaleType());
        qryReqBO.setChannel(reqBO.getChannel());
        ArrayList<ActCommInfoBO> commInfoBOS = new ArrayList<ActCommInfoBO>(1);
        commInfoBOS.add(comm);
        qryReqBO.setSkuList(commInfoBOS);
        RspBatchBaseBO qryRspBO = this.qryActivityBusiService.listActivityBySku(qryReqBO);
        if (!"0000".equals(qryRspBO.getRespCode())) {
            throw new ResourceException(qryRspBO.getRespCode(), qryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            return null;
        }
        return ((ActCommInfoBO)qryRspBO.getRows().get(0)).getActList();
    }

    private void calNewPrice(ActCalReqBO reqBO, ActCommInfoBO comm) {
        if (null != reqBO.getMemId() && "601".equals(comm.getPurchaseType())) {
            ActivityBO actReqBO = new ActivityBO();
            actReqBO.setActivityType("02");
            actReqBO.setActivityStatus("02");
            List<ActivityBO> memActs = this.actInfoAtomService.listActByCondition(actReqBO);
            if (CollectionUtils.isNotEmpty(memActs)) {
                comm.setSkuDisPriceL(comm.getSalePriceL());
                this.actCalAtomService.callMemPrice(comm, memActs.get(0), reqBO.getMemLevel());
                comm.setMemPriceL(comm.getSkuDisPriceL());
            }
        }
        comm.setSkuDisPriceL(comm.getSkuNewPriceL());
        comm.setSkuDisAmountL(Long.valueOf(new BigDecimal(comm.getSalePriceL()).subtract(new BigDecimal(comm.getSkuNewPriceL())).longValue()));
        comm.setSkuDisTotalPriceL(TkCalculatorUtils.muliti((long)comm.getSkuDisPriceL(), (long)comm.getSkuCount().longValue()));
        comm.setSkuDisTotalAmountL(TkCalculatorUtils.muliti((long)comm.getSkuDisAmountL(), (long)comm.getSkuCount().longValue()));
    }

    private void checkDetailParams(ActCommInfoBO comm) {
        if (null == comm.getSkuId()) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8ID\u96c6\u5408\u4e3a\u7a7a");
        }
        if (null == comm.getSkuCount()) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
        }
        if (null == comm.getSalePriceL()) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u5546\u54c1\u9500\u552e\u4ef7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)comm.getPurchaseType())) {
            comm.setPurchaseType("0");
        }
    }

    private void checkParams(ActCalReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommList())) {
            log.error("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == reqBO.getMemId()) {
            return;
        }
        if (null == reqBO.getMemLevel() || null == reqBO.getMemType()) {
            log.error("\u4f1a\u5458\u7c7b\u578b\u6216\u4f1a\u5458\u7b49\u7ea7\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u4f1a\u5458\u7c7b\u578b\u6216\u4f1a\u5458\u7b49\u7ea7\u4e3a\u7a7a");
        }
    }

    public static void main(String[] args) {
        System.out.println(new BigDecimal(300000).divide(new BigDecimal(900000), 10, 1).multiply(new BigDecimal(200000)));
    }

    private ActPriceCalRspBO calTotalPrice(ActCalReqBO reqBO) {
        ActPriceCalRspBO rsp = new ActPriceCalRspBO("0000", "\u64cd\u4f5c\u6210\u529f");
        long oriPirce = 0L;
        Double totalPrice = new Double(0.0);
        Double actDiscount = new Double(0.0);
        Double couponDiscount = new Double(0.0);
        Double postageTotalPrice = new Double(0.0);
        HashMap<Long, Double> shopMap = new HashMap<Long, Double>(reqBO.getCommList().size());
        for (ActCommInfoBO comm : reqBO.getCommList()) {
            Double price = comm.getSkuDisTotalPrice();
            if (!shopMap.containsKey(comm.getShopId())) {
                shopMap.put(comm.getShopId(), price);
            } else {
                shopMap.put(comm.getShopId(), TkCalculatorUtils.add((BigDecimal)new BigDecimal(((Double)shopMap.get(comm.getShopId())).toString()), (BigDecimal)new BigDecimal(price.toString())).doubleValue());
            }
            totalPrice = TkCalculatorUtils.add((BigDecimal)new BigDecimal(totalPrice.toString()), (BigDecimal)new BigDecimal(price.toString())).doubleValue();
            oriPirce = TkCalculatorUtils.add((long)oriPirce, (long)TkCalculatorUtils.muliti((long)comm.getSalePriceL(), (long)comm.getSkuCount().intValue()));
            actDiscount = TkCalculatorUtils.add((BigDecimal)new BigDecimal(actDiscount.toString()), (BigDecimal)new BigDecimal(comm.getSkuDisTotalAmount().toString())).doubleValue();
            if (CollectionUtils.isNotEmpty((Collection)comm.getCouponPrices())) {
                for (CouponPriceDetailBO priceDetail : comm.getCouponPrices()) {
                    couponDiscount = TkCalculatorUtils.add((BigDecimal)new BigDecimal(couponDiscount.toString()), (BigDecimal)new BigDecimal(priceDetail.getDisAmount().toString())).doubleValue();
                }
            }
            ConvertParamUtils.escapePrice(comm);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getShopList())) {
            this.postageCal(shopMap, postageTotalPrice, totalPrice, reqBO, rsp);
        }
        Double totalDiscount = TkCalculatorUtils.add((BigDecimal)new BigDecimal(actDiscount.toString()), (BigDecimal)new BigDecimal(couponDiscount.toString())).doubleValue();
        this.escapeTotal(rsp, totalDiscount, couponDiscount, actDiscount, totalPrice, oriPirce);
        rsp.setActCommList(reqBO.getCommList());
        rsp.setCoupons(reqBO.getCheckIns());
        int couponCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCheckIns())) {
            for (CouponInstanceBO ins : reqBO.getCheckIns()) {
                if (!"1".equals(ins.getOptionalFlag()) || !"1".equals(ins.getReachFlag())) continue;
                ++couponCount;
            }
        }
        rsp.setCouponsCount(Integer.valueOf(couponCount));
        log.info("rsp=" + rsp.toString());
        return rsp;
    }

    private void postageCal(Map<Long, Double> shopMap, Double postageTotalPrice, Double totalPrice, ActCalReqBO reqBO, ActPriceCalRspBO rsp) {
        ArrayList<ActShopInfoBO> shopList = new ArrayList<ActShopInfoBO>();
        for (ActShopInfoBO actShopInfoBO : reqBO.getShopList()) {
            if (null == actShopInfoBO.getFreightLimit()) {
                actShopInfoBO.setFreightLimit(Double.valueOf(0.0));
            }
            if (null == actShopInfoBO.getFreightPrice()) {
                actShopInfoBO.setFreightPrice(Double.valueOf(0.0));
            }
            ActShopInfoBO ShopRsp = new ActShopInfoBO();
            BeanUtils.copyProperties((Object)actShopInfoBO, (Object)ShopRsp);
            if (actShopInfoBO.getbMail().booleanValue()) {
                if (ShopRsp.getFreightLimit().compareTo(shopMap.get(actShopInfoBO.getShopId())) > 0) {
                    ShopRsp.setPayPostage(ShopRsp.getFreightPrice());
                } else {
                    ShopRsp.setPayPostage(Double.valueOf(0.0));
                }
                totalPrice = TkCalculatorUtils.add((BigDecimal)new BigDecimal(totalPrice.toString()), (BigDecimal)new BigDecimal(ShopRsp.getPayPostage().toString())).doubleValue();
                postageTotalPrice = TkCalculatorUtils.add((BigDecimal)new BigDecimal(postageTotalPrice.toString()), (BigDecimal)new BigDecimal(ShopRsp.getPayPostage().toString())).doubleValue();
            }
            shopList.add(ShopRsp);
        }
        rsp.setPostageTotalPrice(postageTotalPrice);
        rsp.setShopList(shopList);
    }

    private void escapeTotal(ActPriceCalRspBO rsp, double totalDiscount, double couponDiscount, double actDiscount, double totalPrice, long oriPirce) {
        rsp.setCouponDisAmo(Double.valueOf(couponDiscount));
        rsp.setCouponDisAmoL(TkCalculatorUtils.transfetL((double)rsp.getCouponDisAmo()));
        rsp.setActDisAmo(Double.valueOf(actDiscount));
        rsp.setActDisAmoL(TkCalculatorUtils.transfetL((double)rsp.getActDisAmo()));
        rsp.setDisTotalAmo(Double.valueOf(totalDiscount));
        rsp.setDisTotalAmoL(TkCalculatorUtils.transfetL((double)rsp.getDisTotalAmo()));
        rsp.setTotalAmount(Double.valueOf(totalPrice));
        rsp.setTotalAmountL(TkCalculatorUtils.transfetL((double)rsp.getTotalAmount()));
        rsp.setTotalSalePrice(TkCalculatorUtils.transferY((long)oriPirce));
        rsp.setTotalSalePriceL(TkCalculatorUtils.transfetL((double)rsp.getTotalSalePrice()));
    }
}

