/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActReservoirAtomService;
import com.tydic.newretail.act.atom.ActReservoirLogAtomService;
import com.tydic.newretail.act.bo.ActReservoirTaskReqBO;
import com.tydic.newretail.act.bo.ActivityReservoirConfigReqBO;
import com.tydic.newretail.act.bo.ActivityReservoirInfoBO;
import com.tydic.newretail.act.bo.ActivityReservoirInfoReqBO;
import com.tydic.newretail.act.bo.ActivityReservoirInfoRspBO;
import com.tydic.newretail.act.bo.ActivityReservoirLogInfoBO;
import com.tydic.newretail.act.busi.ActReservoirBusiService;
import com.tydic.newretail.act.constant.GiftPkgInfoConstance;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActReservoirBusiServiceImpl
implements ActReservoirBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActReservoirBusiServiceImpl.class);
    @Autowired
    private ActReservoirAtomService actReservoirAtomService;
    @Autowired
    private ActReservoirLogAtomService actReservoirLogAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public ActivityReservoirInfoRspBO listActReservoirInfoByPage(ActivityReservoirInfoReqBO reqBO) {
        List<ActivityReservoirInfoBO> pos;
        ActivityReservoirInfoRspBO rsp = new ActivityReservoirInfoRspBO();
        log.debug("\u67e5\u8be2\u84c4\u6c34\u6c60\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        Page page = new Page();
        page.setPageNo(reqBO.getCurrent());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getCurrent() - 1));
        page.setPageNo(reqBO.getCurrent());
        page.setPageSize(reqBO.getPageSize());
        ActivityReservoirInfoReqBO record = new ActivityReservoirInfoReqBO();
        ArrayList<String> types = new ArrayList<String>();
        record.setReservoirDate(reqBO.getReservoirDate());
        record.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
        record.setCompanyCodeCity(reqBO.getCompanyCodeCity());
        record.setCompanyCodeDistrict(reqBO.getCompanyCodeDistrict());
        record.setCompanyCodeStore(reqBO.getCompanyCodeStore());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmUserLevel())) {
            switch (reqBO.getmUserLevel()) {
                case "1": {
                    types.add("01");
                    types.add("02");
                    types.add("05");
                    break;
                }
                case "2": {
                    types.add("01");
                    types.add("02");
                    break;
                }
                case "3": {
                    types.add("05");
                    types.add("02");
                    break;
                }
                case "4": {
                    types.add("05");
                    break;
                }
                case "5": {
                    types.add("05");
                    break;
                }
                default: {
                    rsp.setRespCode("0008");
                    rsp.setRespDesc("\u7528\u6237\u7b49\u7ea7\u4fe1\u606f\u5f02\u5e38");
                    return rsp;
                }
            }
        } else {
            rsp.setRespCode("0008");
            rsp.setRespDesc("\u7528\u6237\u7b49\u7ea7\u4fe1\u606f\u5f02\u5e38");
            return rsp;
        }
        record.setCompanyTypes(types);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            record.setCompanyCodeProvince(reqBO.getmProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmCity())) {
            record.setCompanyCodeCity(reqBO.getmCity());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmDistrict())) {
            record.setCompanyCodeDistrict(reqBO.getmDistrict());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmShopId())) {
            record.setCompanyCodeStore(reqBO.getmShopId());
        }
        try {
            pos = this.actReservoirAtomService.selectByPage(record, (Page<Map<String, Object>>)page);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u84c4\u6c34\u6c60\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            rsp.setRespCode("0003");
            rsp.setRespDesc("\u5206\u9875\u67e5\u8be2\u84c4\u6c34\u6c60\u4fe1\u606f\u5931\u8d25");
            return rsp;
        }
        if (CollectionUtils.isEmpty(pos)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
            return rsp;
        }
        ActivityReservoirInfoBO qryBO = new ActivityReservoirInfoBO();
        if ("2".equals(reqBO.getmUserLevel()) || "3".equals(reqBO.getmUserLevel())) {
            log.debug("\u7701\u4efd\u6216\u8005\u5730\u5e02");
            qryBO.setCompanyCodeProvince(reqBO.getmProvince());
            qryBO.setCompanyType("01");
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getmCity())) {
                qryBO.setCompanyCodeCity(reqBO.getmCity());
                qryBO.setCompanyType("02");
            }
            ActivityReservoirInfoBO activityReservoirInfoBO = this.actReservoirAtomService.selectByCondition(qryBO);
            ConvertParamUtils.escaptActReservoir(activityReservoirInfoBO, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)activityReservoirInfoBO, (Object)rsp);
        }
        ArrayList<ActivityReservoirInfoBO> bos = new ArrayList<ActivityReservoirInfoBO>(pos.size());
        for (ActivityReservoirInfoBO po : pos) {
            ActivityReservoirInfoBO bo = new ActivityReservoirInfoBO();
            ConvertParamUtils.escaptActReservoir(po, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        rsp.setRows(bos);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        return rsp;
    }

    public RspBatchBaseBO<ActivityReservoirInfoBO> listActReservoirInfo(ActivityReservoirInfoReqBO reqBO) {
        List<ActivityReservoirInfoBO> pos;
        log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u5bfc\u51fa\u5165\u53c2" + reqBO.toString());
        RspBatchBaseBO result = new RspBatchBaseBO();
        ActivityReservoirInfoBO record = new ActivityReservoirInfoBO();
        ArrayList<String> types = new ArrayList<String>();
        record.setReservoirDateStr(reqBO.getReservoirDate());
        record.setCompanyCodeProvince(reqBO.getCompanyCodeProvince());
        record.setCompanyCodeCity(reqBO.getCompanyCodeCity());
        record.setCompanyCodeDistrict(reqBO.getCompanyCodeDistrict());
        record.setCompanyCodeStore(reqBO.getCompanyCodeStore());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmUserLevel())) {
            switch (reqBO.getmUserLevel()) {
                case "1": {
                    types.add("01");
                    types.add("02");
                    types.add("05");
                    break;
                }
                case "2": {
                    types.add("01");
                    types.add("02");
                    break;
                }
                case "3": {
                    types.add("05");
                    types.add("02");
                    break;
                }
                case "4": {
                    types.add("05");
                    break;
                }
                case "5": {
                    types.add("05");
                    break;
                }
                default: {
                    result.setRespCode("0008");
                    result.setRespDesc("\u7528\u6237\u7b49\u7ea7\u4fe1\u606f\u5f02\u5e38");
                    return result;
                }
            }
        } else {
            result.setRespCode("0008");
            result.setRespDesc("\u7528\u6237\u7b49\u7ea7\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        record.setCompanyTypes(types);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            record.setCompanyCodeProvince(reqBO.getmProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmCity())) {
            record.setCompanyCodeCity(reqBO.getmCity());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmDistrict())) {
            record.setCompanyCodeDistrict(reqBO.getmDistrict());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmShopId())) {
            record.setCompanyCodeStore(reqBO.getmShopId());
        }
        log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2" + reqBO.toString());
        try {
            pos = this.actReservoirAtomService.selectListByCondition(record);
        }
        catch (Exception e) {
            log.error("\u4e0d\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u84c4\u6c34\u6c60\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("0003");
            result.setRespDesc("\u4e0d\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u84c4\u6c34\u6c60\u4fe1\u606f\u5931\u8d25");
            return result;
        }
        if (CollectionUtils.isEmpty(pos)) {
            result.setRespCode("0000");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
            result.setRows(new ArrayList());
            return result;
        }
        ArrayList<ActivityReservoirInfoBO> bos = new ArrayList<ActivityReservoirInfoBO>(pos.size());
        for (ActivityReservoirInfoBO po : pos) {
            ActivityReservoirInfoBO bo = new ActivityReservoirInfoBO();
            ConvertParamUtils.escaptActReservoir(po, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        result.setRows(bos);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspBaseBO modifyActReservoir(ActivityReservoirConfigReqBO reqBO) {
        Boolean role;
        log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u7f16\u8f91\u5165\u53c2" + reqBO.toString());
        if (CollectionUtils.isEmpty((Collection)reqBO.getActivityReservoirInfoBOList())) {
            log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e\u5165\u53c2\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e\u5165\u53c2\u4e3a\u7a7a");
        }
        List<ActivityReservoirInfoBO> activityReservoirInfoBOS = this.selectByReservoirIds(reqBO);
        if ("1".equals(reqBO.getmUserLevel())) {
            log.debug("\u603b\u90e8");
            for (ActivityReservoirInfoBO activityReservoirInfoBO : activityReservoirInfoBOS) {
                if ("01".equals(activityReservoirInfoBO.getCompanyType())) continue;
                log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e-\u603b\u90e8\u4e0d\u53ef\u56de\u51b2\u6216\u8005\u8bbe\u7f6e");
                return new RspBaseBO("0008", "\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e-\u603b\u90e8\u4e0d\u53ef\u56de\u51b2\u6216\u8005\u8bbe\u7f6e");
            }
            role = true;
        } else if ("2".equals(reqBO.getmUserLevel())) {
            log.debug("\u7701\u4efd");
            for (ActivityReservoirInfoBO activityReservoirInfoBO : activityReservoirInfoBOS) {
                if (!activityReservoirInfoBO.getCompanyCodeProvince().equals(reqBO.getmProvince()) || "02".equals(activityReservoirInfoBO.getCompanyType())) continue;
                log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e-\u7701\u4efd\u4e0d\u53ef\u81ea\u884c\u56de\u51b2\u6216\u8005\u8bbe\u7f6e");
                return new RspBaseBO("0008", "\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e-\u7701\u4efd\u4e0d\u53ef\u81ea\u884c\u56de\u51b2\u6216\u8005\u8bbe\u7f6e");
            }
            role = false;
        } else if ("3".equals(reqBO.getmUserLevel())) {
            log.debug("\u5730\u5e02");
            for (ActivityReservoirInfoBO activityReservoirInfoBO : activityReservoirInfoBOS) {
                if (!activityReservoirInfoBO.getCompanyCodeProvince().equals(reqBO.getmProvince()) || !activityReservoirInfoBO.getCompanyCodeCity().equals(reqBO.getmCity()) || "05".equals(activityReservoirInfoBO.getCompanyType())) continue;
                log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e-\u5730\u5e02\u4e0d\u53ef\u81ea\u884c\u56de\u51b2\u6216\u8005\u8bbe\u7f6e");
                return new RspBaseBO("0008", "\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u6216\u8005\u8bbe\u7f6e-\u5730\u5e02\u4e0d\u53ef\u81ea\u884c\u56de\u51b2\u6216\u8005\u8bbe\u7f6e");
            }
            role = false;
        } else {
            log.error("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return new RspBaseBO("0009", "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        if ("0".equals(reqBO.getSource())) {
            log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u8bbe\u7f6e\u5165\u53c2" + reqBO.getActivityReservoirInfoBOList().toString());
            List<ActivityReservoirInfoBO> lists = new ArrayList<ActivityReservoirInfoBO>();
            if (role.booleanValue()) {
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getActivityReservoirInfoBOList())) {
                    log.debug("\u603b\u90e8\u6743\u9650-\u8bbe\u7f6e\u5165\u53c2\u5168\u4e3a\u7701\u4efd" + reqBO.getActivityReservoirInfoBOList().toString());
                    this.allProvicen(activityReservoirInfoBOS, reqBO);
                    lists = activityReservoirInfoBOS;
                    log.debug("\u603b\u90e8\u6743\u9650-\u8bbe\u7f6e\u51fa\u53c2\u5168\u4e3a\u7701\u4efd" + lists.toString());
                }
            } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getActivityReservoirInfoBOList())) {
                log.debug("\u7701\u4efd\u7ed9\u5730\u5e02\u8bbe\u7f6e\u6216\u8005\u5730\u5e02\u7ed9\u95e8\u5e97\u8bbe\u7f6e\u5165\u53c2" + reqBO.getActivityReservoirInfoBOList().toString());
                this.allCity(activityReservoirInfoBOS, reqBO, "01", "02");
                lists = activityReservoirInfoBOS;
                log.debug("\u7701\u4efd\u7ed9\u5730\u5e02\u8bbe\u7f6e\u6216\u8005\u5730\u5e02\u7ed9\u95e8\u5e97\u8bbe\u7f6e\u51fa" + lists.toString());
            }
            log.debug("\u84c4\u6c34\u6c60\u6279\u91cf\u8bbe\u7f6e\u6700\u7ec8\u5165\u53c2" + lists.toString());
            try {
                this.actReservoirAtomService.updateBatch(lists);
            }
            catch (Exception e) {
                log.debug("\u8bbe\u7f6e\u9884\u8bbe\u503c\u65f6-\u6279\u91cf\u4fee\u6539\u9884\u8bbe\u503c\u5931\u8d25");
                return new RspBaseBO("9999", "\u8bbe\u7f6e\u9884\u8bbe\u503c\u65f6-\u6279\u91cf\u4fee\u6539\u9884\u8bbe\u503c\u5931\u8d25");
            }
            this.saveBatchLog(lists, reqBO);
        }
        if ("1".equals(reqBO.getSource())) {
            log.debug("\u6d3b\u52a8\u84c4\u6c34\u6c60\u56de\u51b2\u8bbe\u7f6e\u5165\u53c2" + ((ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0)).toString());
            ActivityReservoirInfoBO activityReservoirInfoBO = this.updateCurrent(reqBO);
            if ("05".equals(activityReservoirInfoBO.getCompanyType())) {
                ActivityReservoirInfoBO activityReservoirBO = this.updateLocal(activityReservoirInfoBO, reqBO);
                this.updateProvince(activityReservoirBO, reqBO);
            }
            if ("02".equals(activityReservoirInfoBO.getCompanyType())) {
                this.updateProvince(activityReservoirInfoBO, reqBO);
            }
            this.saveLog(activityReservoirInfoBO, reqBO);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO saveActReservoirBatch(ActReservoirTaskReqBO reqBO) {
        log.debug("\u84c4\u6c34\u6c60\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2" + reqBO.toString());
        if (null == reqBO || CollectionUtils.isEmpty((Collection)reqBO.getActivityReservoirInfoBOList())) {
            log.error("\u84c4\u6c34\u6c60\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2\u4e3a\u7a7a\uff1a");
            return new RspBaseBO("0001", "\u84c4\u6c34\u6c60\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ActivityReservoirInfoBO> reqBOs = new ArrayList<ActivityReservoirInfoBO>();
        this.checkParams(reqBO, reqBOs);
        try {
            this.actReservoirAtomService.saveByBatch(reqBOs);
        }
        catch (Exception e) {
            log.error("\u84c4\u6c34\u6c60\u5b9a\u65f6\u4efb\u52a1\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void saveLog(ActivityReservoirInfoBO activityReservoirInfoBO, ActivityReservoirConfigReqBO reqBO) {
        ActivityReservoirInfoBO reservoirInfoBO = (ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0);
        ActivityReservoirLogInfoBO record = new ActivityReservoirLogInfoBO();
        record.setTenantId(activityReservoirInfoBO.getTenantId());
        record.setReservoirId(activityReservoirInfoBO.getReservoirId());
        record.setOperationType("02");
        if (StringUtils.isNotEmpty((CharSequence)reservoirInfoBO.getRemark())) {
            record.setRemark(reservoirInfoBO.getRemark());
        }
        if (StringUtils.isNotEmpty((CharSequence)reservoirInfoBO.getRecoilAmountStr())) {
            record.setOperationAmount(Long.valueOf(TkCalculatorUtils.transfetL((String)reservoirInfoBO.getRecoilAmountStr())));
        }
        record.setParam1(String.valueOf(reqBO.getmUserId()));
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmLoginName())) {
            record.setParam2(reqBO.getmLoginName());
        }
        this.actReservoirLogAtomService.saveActReservoirLogInfo(record);
    }

    private void saveBatchLog(List<ActivityReservoirInfoBO> lists, ActivityReservoirConfigReqBO reqBO) {
        ArrayList<ActivityReservoirLogInfoBO> reqBOs = new ArrayList<ActivityReservoirLogInfoBO>();
        if (CollectionUtils.isNotEmpty(lists)) {
            for (ActivityReservoirInfoBO bo : lists) {
                ActivityReservoirLogInfoBO po = new ActivityReservoirLogInfoBO();
                po.setTenantId(bo.getTenantId());
                po.setReservoirId(bo.getReservoirId());
                po.setOperationType("01");
                if (StringUtils.isNotEmpty((CharSequence)bo.getRemark())) {
                    po.setRemark(bo.getRemark());
                }
                if (StringUtils.isNotEmpty((CharSequence)bo.getRecoilAmountStr())) {
                    po.setOperationAmount(Long.valueOf(TkCalculatorUtils.transfetL((String)bo.getRecoilAmountStr())));
                }
                po.setParam1(String.valueOf(reqBO.getmUserId()));
                if (StringUtils.isNotEmpty((CharSequence)reqBO.getmLoginName())) {
                    po.setParam2(reqBO.getmLoginName());
                }
                reqBOs.add(po);
            }
        }
        log.debug("\u6279\u91cf\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55\u5165\u53c2" + ((Object)reqBOs).toString());
        this.actReservoirLogAtomService.saveByBatch(reqBOs);
    }

    private List<ActivityReservoirInfoBO> selectByReservoirIds(ActivityReservoirConfigReqBO reqBO) {
        List<ActivityReservoirInfoBO> pos;
        HashSet<Long> ids = new HashSet<Long>();
        for (ActivityReservoirInfoBO po : reqBO.getActivityReservoirInfoBOList()) {
            ids.add(po.getReservoirId());
        }
        try {
            pos = this.actReservoirAtomService.listByReservoirIds(ids);
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u84c4\u6c34\u6c60\u9884\u8bbe\u503c\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25");
            throw new BusinessException("9999", e.getMessage());
        }
        if (CollectionUtils.isEmpty(pos) || ids.size() > pos.size()) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            throw new BusinessException("9999", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        log.debug("\u6279\u91cf\u67e5\u8be2\u8bbe\u7f6e\u51fa\u53c2" + pos.toString());
        return pos;
    }

    private void currentPreMoney(ActivityReservoirInfoBO city, ActivityReservoirInfoBO req) {
        city.setPresetAmount(Long.valueOf(new BigDecimal(req.getRecoilAmountStr()).setScale(2, 1).multiply(new BigDecimal("10000")).longValue()));
        city.setCurrentAmount(Long.valueOf(city.getPresetAmount() - city.getConsumeAmount() - city.getDistributionAmount() + city.getTotalRecoilAmount()));
        city.setSurplusAmount(city.getCurrentAmount());
    }

    private void supperrePreMoney(Long citySum, ActivityReservoirInfoBO province) {
        province.setDistributionAmount(citySum);
        province.setCurrentAmount(Long.valueOf(province.getPresetAmount() - province.getConsumeAmount() - province.getDistributionAmount() + province.getTotalRecoilAmount()));
        province.setSurplusAmount(province.getCurrentAmount());
    }

    private void allProvicen(List<ActivityReservoirInfoBO> provinces, ActivityReservoirConfigReqBO reqBO) {
        Long sumCity = 0L;
        for (ActivityReservoirInfoBO province : provinces) {
            for (ActivityReservoirInfoBO req : reqBO.getActivityReservoirInfoBOList()) {
                Long reqSum = new BigDecimal(req.getRecoilAmountStr()).setScale(2, 4).multiply(new BigDecimal("10000")).longValue();
                if (!req.getReservoirId().equals(province.getReservoirId())) continue;
                sumCity = sumCity + reqSum;
                province.setRemark(req.getRemark());
                int i = reqSum.compareTo(province.getDistributionAmount());
                if (i < 0) {
                    log.debug("\u603b\u90e8\u7ed9\u6240\u5c5e\u7701\u4efd\u8bbe\u7f6e\u9884\u8bbe\u503c\u65f6-\u7701\u4efd\u3010" + req.getReservoirId() + "\u3011\u7684\u5df2\u5206\u914d\u8d85\u8fc7\u8be5\u9884\u8bbe\u503c");
                    throw new BusinessException("0013", "\u603b\u90e8\u7ed9\u6240\u5c5e\u7701\u4efd\u8bbe\u7f6e\u9884\u8bbe\u503c\u65f6-\u7701\u4efd\u3010" + req.getReservoirId() + "\u3011\u7684\u5df2\u5206\u914d\u8d85\u8fc7\u8be5\u9884\u8bbe\u503c");
                }
                this.currentPreMoney(province, req);
            }
        }
    }

    private void allCity(List<ActivityReservoirInfoBO> citys, ActivityReservoirConfigReqBO reqBO, String companyType1, String companyType2) {
        ActivityReservoirInfoBO record = new ActivityReservoirInfoBO();
        record.setCompanyCodeProvince(citys.get(0).getCompanyCodeProvince());
        record.setReservoirDateStr(((ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0)).getReservoirDateStr());
        record.setCompanyType(companyType1);
        List<ActivityReservoirInfoBO> tempList = this.selectByConditon(record);
        ActivityReservoirInfoBO province = tempList.get(0);
        record.setCompanyType(companyType2);
        List<ActivityReservoirInfoBO> qryCitys = this.selectByConditon(record);
        Long tempCitySum = 0L;
        Long allCitySum = 0L;
        Long sumCity = 0L;
        if (CollectionUtils.isNotEmpty(qryCitys)) {
            for (ActivityReservoirInfoBO qryCity : qryCitys) {
                allCitySum = allCitySum + qryCity.getPresetAmount();
                for (ActivityReservoirInfoBO city : citys) {
                    if (!qryCity.getReservoirId().equals(city.getReservoirId())) continue;
                    tempCitySum = tempCitySum + qryCity.getPresetAmount();
                }
            }
        }
        for (ActivityReservoirInfoBO city : citys) {
            for (ActivityReservoirInfoBO req : reqBO.getActivityReservoirInfoBOList()) {
                Long reqSum = new BigDecimal(req.getRecoilAmountStr()).setScale(2, 4).multiply(new BigDecimal("10000")).longValue();
                if (!req.getReservoirId().equals(city.getReservoirId())) continue;
                sumCity = sumCity + reqSum;
                city.setRemark(req.getRemark());
                int i = reqSum.compareTo(city.getDistributionAmount());
                if (i < 0) {
                    log.debug("\u7701\u4efd\u7ed9\u5730\u5e02\u8bbe\u7f6e\u6216\u8005\u5730\u5e02\u7ed9\u95e8\u5e97\u8bbe\u7f6e-\u5730\u5e02\u6216\u3010" + req.getReservoirId() + "\u3011\u7684\u5df2\u5206\u914d\u8d85\u8fc7\u8be5\u9884\u8bbe\u503c");
                    throw new BusinessException("0013", "\u7701\u4efd\u7ed9\u5730\u5e02\u8bbe\u7f6e\u6216\u8005\u5730\u5e02\u7ed9\u95e8\u5e97\u8bbe\u7f6e-\u5730\u5e02\u3010" + req.getReservoirId() + "\u3011\u7684\u5df2\u5206\u914d\u8d85\u8fc7\u8be5\u9884\u8bbe\u503c");
                }
                this.currentPreMoney(city, req);
            }
        }
        Long otherCitySum = allCitySum - tempCitySum;
        Long allCity = sumCity + otherCitySum;
        int i = province.getPresetAmount().compareTo(allCity);
        if (i < 0) {
            log.debug("\u7701\u4efd\u7ed9\u5730\u5e02\u8bbe\u7f6e\u6216\u8005\u5730\u5e02\u7ed9\u95e8\u5e97\u8bbe\u7f6e-\u5b50\u516c\u53f8\u9884\u8bbe\u503c\u4e4b\u548c\u8d85\u8fc7\u4e0a\u7ea7\u516c\u53f8\u8bbe\u5b9a\u7684\u9884\u8bbe\u503c");
            throw new BusinessException("0013", "\u7701\u4efd\u7ed9\u5730\u5e02\u8bbe\u7f6e\u6216\u8005\u5730\u5e02\u7ed9\u95e8\u5e97\u8bbe\u7f6e-\u5b50\u516c\u53f8\u9884\u8bbe\u503c\u4e4b\u548c\u8d85\u8fc7\u4e0a\u7ea7\u516c\u53f8\u8bbe\u5b9a\u7684\u9884\u8bbe\u503c");
        }
        this.supperrePreMoney(allCity, province);
        citys.add(province);
    }

    private void calAmount(ActivityReservoirConfigReqBO reqBO, ActivityReservoirInfoBO activityReservoirInfoBO) {
        ActivityReservoirInfoBO reservoirInfoBO = (ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0);
        activityReservoirInfoBO.setTotalRecoilAmount(Long.valueOf(activityReservoirInfoBO.getTotalRecoilAmount() + new BigDecimal(reservoirInfoBO.getRecoilAmountStr()).setScale(0, 1).multiply(new BigDecimal("10000")).longValue()));
        activityReservoirInfoBO.setCurrentAmount(Long.valueOf(activityReservoirInfoBO.getPresetAmount() - activityReservoirInfoBO.getConsumeAmount() - activityReservoirInfoBO.getDistributionAmount() + activityReservoirInfoBO.getTotalRecoilAmount()));
        activityReservoirInfoBO.setSurplusAmount(activityReservoirInfoBO.getCurrentAmount());
    }

    private ActivityReservoirInfoBO updateCurrent(ActivityReservoirConfigReqBO reqBO) {
        ActivityReservoirInfoBO reservoirInfoBO = (ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0);
        ActivityReservoirInfoBO activityReservoirInfoBO = this.actReservoirAtomService.getActReservoirInfo(reservoirInfoBO);
        if (null == activityReservoirInfoBO) {
            log.error("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
            throw new BusinessException("9999", "\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        this.calAmount(reqBO, activityReservoirInfoBO);
        log.debug("\u56de\u51b2\u4fee\u6539\u8be5\u8bb0\u5f55\u5165\u53c2" + activityReservoirInfoBO.toString());
        try {
            this.actReservoirAtomService.modifyActReservoirInfo(activityReservoirInfoBO);
        }
        catch (Exception e) {
            log.error("\u56de\u51b2\u4fee\u6539\u8be5\u8bb0\u5f55\u5931\u8d25");
            throw new BusinessException("9999", e.getMessage());
        }
        log.debug("\u56de\u51b2\u4fee\u6539\u8be5\u8bb0\u5f55\u51fa\u53c2" + activityReservoirInfoBO.toString());
        return activityReservoirInfoBO;
    }

    private ActivityReservoirInfoBO updateLocal(ActivityReservoirInfoBO activityReservoirInfoBO, ActivityReservoirConfigReqBO reqBO) {
        ActivityReservoirInfoBO reservoirInfoBO = (ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0);
        ActivityReservoirInfoBO record = new ActivityReservoirInfoBO();
        record.setCompanyType("02");
        record.setCompanyCodeProvince(activityReservoirInfoBO.getCompanyCodeProvince());
        record.setCompanyCodeCity(activityReservoirInfoBO.getCompanyCodeCity());
        record.setReservoirDateStr(reservoirInfoBO.getReservoirDateStr());
        List<ActivityReservoirInfoBO> tempList = this.selectByConditon(record);
        ActivityReservoirInfoBO reservoirInfo = tempList.get(0);
        this.calAmount(reqBO, reservoirInfo);
        this.updateByCondition(reservoirInfo);
        return reservoirInfo;
    }

    private void updateProvince(ActivityReservoirInfoBO activityReservoirInfoBO, ActivityReservoirConfigReqBO reqBO) {
        ActivityReservoirInfoBO reservoirInfoBO = (ActivityReservoirInfoBO)reqBO.getActivityReservoirInfoBOList().get(0);
        ActivityReservoirInfoBO record = new ActivityReservoirInfoBO();
        record.setCompanyType("01");
        record.setCompanyCodeProvince(activityReservoirInfoBO.getCompanyCodeProvince());
        record.setReservoirDateStr(reservoirInfoBO.getReservoirDateStr());
        List<ActivityReservoirInfoBO> tempList = this.selectByConditon(record);
        ActivityReservoirInfoBO reservoirInfo = tempList.get(0);
        this.calAmount(reqBO, reservoirInfo);
        this.updateByCondition(reservoirInfo);
    }

    private List<ActivityReservoirInfoBO> selectByConditon(ActivityReservoirInfoBO record) {
        ArrayList<ActivityReservoirInfoBO> reservoirInfo = new ArrayList();
        try {
            reservoirInfo = this.actReservoirAtomService.selectListByCondition(record);
        }
        catch (Exception e) {
            log.error("\u56de\u51b2\u67e5\u8be2\u8be5\u8bb0\u5f55\u7684\u4e0a\u4e00\u7ea7\u4fe1\u606f\u5931\u8d25");
            throw new BusinessException("9999", e.getMessage());
        }
        if (CollectionUtils.isEmpty(reservoirInfo)) {
            log.debug("\u7701\u4efd\u7ed9\u6240\u5c5e\u5730\u5e02\u8bbe\u7f6e\u9884\u8bbe\u503c\u65f6-\u67e5\u8be2\u4e0a\u4e00\u7ea7\u7701\u4efd\u6216\u8005\u540c\u7ea7\u5730\u5e02\u7ed3\u679c\u4e3a\u7a7a");
            throw new BusinessException("0002", "\u7701\u4efd\u7ed9\u6240\u5c5e\u5730\u5e02\u8bbe\u7f6e\u9884\u8bbe\u503c\u65f6-\u67e5\u8be2\u4e0a\u4e00\u7ea7\u7701\u4efd\u6216\u8005\u540c\u7ea7\u5730\u5e02\u7ed3\u679c\u4e3a\u7a7a");
        }
        return reservoirInfo;
    }

    private void updateByCondition(ActivityReservoirInfoBO reservoirInfo) {
        try {
            this.actReservoirAtomService.modifyActReservoirInfo(reservoirInfo);
        }
        catch (Exception e) {
            log.error("\u56de\u51b2\u4fee\u6539\u8be5\u8bb0\u5f55\u7684\u4e0a\u4e00\u7ea7\u5931\u8d25");
            throw new BusinessException("9999", e.getMessage());
        }
        log.debug("\u56de\u51b2\u4fee\u6539\u8be5\u8bb0\u5f55\u7684\u4e0a\u4e00\u7ea7\u5165\u53c2" + reservoirInfo.toString());
    }

    private void checkParams(ActReservoirTaskReqBO reqBO, List<ActivityReservoirInfoBO> reqBOs) {
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActivityReservoirInfoBOList())) {
            for (ActivityReservoirInfoBO activityReservoirInfoBO : reqBO.getActivityReservoirInfoBOList()) {
                ActivityReservoirInfoBO po = new ActivityReservoirInfoBO();
                BeanUtils.copyProperties((Object)activityReservoirInfoBO, (Object)po);
                if (StringUtils.isNotEmpty((CharSequence)po.getCompanyType())) {
                    switch (po.getCompanyType()) {
                        case "1": {
                            po.setCompanyType("00");
                            break;
                        }
                        case "2": {
                            po.setCompanyType("01");
                            break;
                        }
                        case "3": {
                            po.setCompanyType("02");
                            break;
                        }
                        case "4": {
                            po.setCompanyType("03");
                            break;
                        }
                        case "5": {
                            po.setCompanyType("05");
                            break;
                        }
                    }
                }
                po.setPresetAmount(GiftPkgInfoConstance.INIT_VALUE);
                po.setCurrentAmount(GiftPkgInfoConstance.INIT_VALUE);
                po.setConsumeAmount(GiftPkgInfoConstance.INIT_VALUE);
                po.setDistributionAmount(GiftPkgInfoConstance.INIT_VALUE);
                po.setSurplusAmount(GiftPkgInfoConstance.INIT_VALUE);
                po.setTotalRecoilAmount(GiftPkgInfoConstance.INIT_VALUE);
                po.setStatus("01");
                reqBOs.add(po);
            }
        }
    }
}

