/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActivityCommodityModelAtomService;
import com.tydic.newretail.act.atom.ActivityCommodityModelObjAtomService;
import com.tydic.newretail.act.atom.ActivityCommodityPoolAtomService;
import com.tydic.newretail.act.bo.ActivityCommodityModelInfoBO;
import com.tydic.newretail.act.bo.ActivityCommodityModelInfoRspBO;
import com.tydic.newretail.act.bo.ActivityCommodityModelObjInfoBO;
import com.tydic.newretail.act.bo.ActivityCommodityPoolConfigReqBO;
import com.tydic.newretail.act.bo.ActivityCommodityPoolInfoBO;
import com.tydic.newretail.act.bo.MaterialAndScopeBO;
import com.tydic.newretail.act.bo.QryActByCommodityReqBO;
import com.tydic.newretail.act.bo.QryActByCommodityRspBO;
import com.tydic.newretail.act.busi.ActivityCommodityModelBusiService;
import com.tydic.newretail.act.busi.QryActByCommodityBusiService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityCommodityModelBusiServiceImpl
implements ActivityCommodityModelBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCommodityModelBusiServiceImpl.class);
    @Autowired
    private ActivityCommodityModelAtomService activityCommodityModelAtomService;
    @Autowired
    private ActivityCommodityModelObjAtomService activityCommodityModelObjAtomService;
    @Autowired
    private ActivityCommodityPoolAtomService activityCommodityPoolAtomService;
    @Autowired
    private QryActByCommodityBusiService qryActByCommodityBusiService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspBaseTBO<ActivityCommodityModelInfoRspBO> selectByModelId(ActivityCommodityModelInfoBO reqBO) {
        ActivityCommodityModelInfoBO activityCommodityModelInfoBO;
        ActivityCommodityModelInfoRspBO result = new ActivityCommodityModelInfoRspBO();
        if (null == reqBO.getModelId()) {
            log.error("\u673a\u578bID\u4e3a\u7a7a");
            return new RspBaseTBO("0001", "\u673a\u578bID\u4e3a\u7a7a");
        }
        try {
            activityCommodityModelInfoBO = this.activityCommodityModelAtomService.selectByModelId(reqBO);
        }
        catch (Exception e) {
            log.error("\u673a\u578b\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBaseTBO("0003", "\u673a\u578b\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38");
        }
        if (null == activityCommodityModelInfoBO) {
            log.error("\u673a\u578b\u8be6\u60c5\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0000", "\u673a\u578b\u8be6\u60c5\u4e0d\u5b58\u5728");
        }
        result.setActivityCommodityModelInfoBO(activityCommodityModelInfoBO);
        ActivityCommodityModelObjInfoBO activityCommodityModelObjInfoBO = new ActivityCommodityModelObjInfoBO();
        activityCommodityModelObjInfoBO.setModelId(reqBO.getModelId());
        activityCommodityModelObjInfoBO.setPoolId(activityCommodityModelInfoBO.getPoolId());
        List<ActivityCommodityModelObjInfoBO> activityCommodityModelObjInfoBOS = null;
        try {
            activityCommodityModelObjInfoBOS = this.activityCommodityModelObjAtomService.selectByModelId(activityCommodityModelObjInfoBO);
        }
        catch (Exception e) {
            log.error("\u673a\u578b\u8be6\u60c5\u8303\u56f4\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBaseTBO("0003", "\u673a\u578b\u8be6\u60c5\u8303\u56f4\u67e5\u8be2\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(activityCommodityModelObjInfoBOS)) {
            log.error("\u673a\u578b\u8be6\u60c5\u9002\u7528\u8303\u56f4\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0000", "\u673a\u578b\u8be6\u60c5\u9002\u7528\u8303\u56f4\u4e0d\u5b58\u5728");
        }
        result.setActivityCommodityModelObjInfoBOS(activityCommodityModelObjInfoBOS);
        String obj = "";
        for (ActivityCommodityModelObjInfoBO bo : activityCommodityModelObjInfoBOS) {
            obj = StringUtils.isBlank((CharSequence)obj) ? bo.getMnomonicName() : obj + ";" + bo.getMnomonicName();
        }
        result.setApplicableCompany(obj);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RspBaseBO saveActivityCommodityPool(ActivityCommodityPoolConfigReqBO reqBO) {
        log.debug("\u64cd\u4f5c\u673a\u578b\u5165\u53c2" + reqBO.toString());
        if (null == reqBO || StringUtils.isEmpty((CharSequence)reqBO.getOperationType())) {
            log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u4e3a\u7a7a");
        }
        if ("00".equals(reqBO.getOperationType())) {
            log.debug("\u64cd\u4f5c\u673a\u578b-\u65b0\u589e\u64cd\u4f5c");
            if (StringUtils.isEmpty((CharSequence)reqBO.getActivityCommodityPoolInfoBO().getPoolName())) {
                log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u673a\u578b\u6c60\u8868\u4fe1\u606f\u4e3a\u7a7a");
                return new RspBaseBO("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u673a\u578b\u6c60\u8868\u4fe1\u606f\u4e3a\u7a7a");
            }
            ArrayList<ActivityCommodityPoolInfoBO> tempList = new ArrayList<ActivityCommodityPoolInfoBO>();
            if (!this.selectActCommPool(reqBO, tempList).booleanValue()) {
                log.error("\u67e5\u8be2\u673a\u578b\u6c60\u8868\u5165\u53c2\u4e3a\u7a7a");
                return new RspBaseBO("0001", "\u67e5\u8be2\u673a\u578b\u6c60\u8868\u5165\u53c2\u4e3a\u7a7a");
            }
            ActivityCommodityPoolInfoBO saveActivityCommodityPoolInfo = this.addActCommPool(reqBO, tempList);
            if (null == saveActivityCommodityPoolInfo.getPoolId()) {
                log.error("\u65b0\u589e\u673a\u578b\u6c60\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u673a\u578b\u6c60ID");
                return new RspBaseBO("0001", "\u65b0\u589e\u673a\u578b\u6c60\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u673a\u578b\u6c60ID");
            }
            this.selectActCommModel(reqBO, saveActivityCommodityPoolInfo);
            return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        log.debug("\u64cd\u4f5c\u673a\u578b-\u7f16\u8f91\u64cd\u4f5c");
        ArrayList<ActivityCommodityModelInfoBO> addList = new ArrayList<ActivityCommodityModelInfoBO>();
        ArrayList<ActivityCommodityModelInfoBO> updateList = new ArrayList<ActivityCommodityModelInfoBO>();
        ArrayList<ActivityCommodityModelInfoBO> removeList = new ArrayList<ActivityCommodityModelInfoBO>();
        this.breakUpParam(reqBO, addList, updateList, removeList);
        if (CollectionUtils.isNotEmpty(removeList)) {
            this.removeActCommModelandObj(removeList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.updateActCommModelandObj(updateList);
        }
        if (!CollectionUtils.isNotEmpty(addList)) return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        this.addActCommModelandObj(addList);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void breakUpParam(ActivityCommodityPoolConfigReqBO reqBO, List<ActivityCommodityModelInfoBO> addList, List<ActivityCommodityModelInfoBO> updateList, List<ActivityCommodityModelInfoBO> removeList) {
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActivityCommodityModelInfoBOS())) {
            for (ActivityCommodityModelInfoBO activityCommodityModelInfoBO : reqBO.getActivityCommodityModelInfoBOS()) {
                if (StringUtils.isEmpty((CharSequence)activityCommodityModelInfoBO.getOptType())) {
                    log.error("\u7f16\u8f91\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
                    throw new ResourceException("0001", "\u7f16\u8f91\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (null == activityCommodityModelInfoBO.getPoolId()) {
                    log.error("\u7f16\u8f91\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u673a\u578b\u6c60ID\u4e3a\u7a7a");
                    throw new ResourceException("0001", "\u7f16\u8f91\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u673a\u578b\u6c60ID\u4e3a\u7a7a");
                }
                if ("00".equals(activityCommodityModelInfoBO.getOptType())) {
                    addList.add(activityCommodityModelInfoBO);
                    log.debug("\u673a\u578b\u6c60\u7f16\u8f91\u65f6-\u65b0\u589e\u53c2\u6570" + addList.toString());
                    continue;
                }
                if ("01".equals(activityCommodityModelInfoBO.getOptType())) {
                    removeList.add(activityCommodityModelInfoBO);
                    log.debug("\u673a\u578b\u6c60\u7f16\u8f91\u65f6-\u5220\u9664\u53c2\u6570" + removeList.toString());
                    continue;
                }
                updateList.add(activityCommodityModelInfoBO);
                log.debug("\u673a\u578b\u6c60\u7f16\u8f91\u65f6-\u4fee\u6539\u53c2\u6570" + updateList.toString());
            }
        }
    }

    private void removeActCommModelandObj(List<ActivityCommodityModelInfoBO> removeList) {
        if (CollectionUtils.isNotEmpty(removeList)) {
            HashSet<Long> modelIds = new HashSet<Long>();
            ArrayList<String> objCodes = new ArrayList<String>();
            ArrayList<MaterialAndScopeBO> materialAndScopeBOS = new ArrayList<MaterialAndScopeBO>();
            for (ActivityCommodityModelInfoBO activityCommodityModelInfoBO : removeList) {
                if (null != activityCommodityModelInfoBO.getModelId()) {
                    modelIds.add(activityCommodityModelInfoBO.getModelId());
                }
                MaterialAndScopeBO bo = new MaterialAndScopeBO();
                bo.setMaterial(activityCommodityModelInfoBO.getCommoditytCode());
                if (CollectionUtils.isNotEmpty((Collection)activityCommodityModelInfoBO.getActivityCommodityModelObjInfoBOS())) {
                    for (ActivityCommodityModelObjInfoBO bo1 : activityCommodityModelInfoBO.getActivityCommodityModelObjInfoBOS()) {
                        if (!StringUtils.isNotEmpty((CharSequence)bo1.getObjCode())) continue;
                        objCodes.add(bo1.getObjCode());
                    }
                }
                if (CollectionUtils.isNotEmpty(objCodes)) {
                    bo.setObjCodes(objCodes);
                }
                materialAndScopeBOS.add(bo);
            }
            QryActByCommodityReqBO qryActByCommodityReqBO = new QryActByCommodityReqBO();
            if (CollectionUtils.isNotEmpty(materialAndScopeBOS)) {
                qryActByCommodityReqBO.setMaterialAndScopes(materialAndScopeBOS);
            }
            RspBatchBaseBO rspBORspBatchBaseBO = null;
            if (null != qryActByCommodityReqBO && CollectionUtils.isNotEmpty((Collection)qryActByCommodityReqBO.getMaterialAndScopes())) {
                try {
                    rspBORspBatchBaseBO = this.qryActByCommodityBusiService.qryActByCommodity(qryActByCommodityReqBO);
                }
                catch (Exception e) {
                    log.error("\u7f16\u8f91\u673a\u578b\u6c60-\u5220\u9664\u6d3b\u52a8\u673a\u578b\u53ca\u8303\u56f4\u67e5\u8be2\u662f\u5426\u5173\u8054\u6709\u6548\u6d3b\u52a8\u5f02\u5e38");
                    throw new ResourceException("9999", "\u7f16\u8f91\u673a\u578b\u6c60-\u5220\u9664\u6d3b\u52a8\u673a\u578b\u53ca\u8303\u56f4\u67e5\u8be2\u662f\u5426\u5173\u8054\u6709\u6548\u6d3b\u52a8\u5f02\u5e38");
                }
                if (CollectionUtils.isNotEmpty((Collection)rspBORspBatchBaseBO.getRows())) {
                    for (QryActByCommodityRspBO bo : rspBORspBatchBaseBO.getRows()) {
                        if (!StringUtils.isNotEmpty((CharSequence)bo.getMaterial()) || !CollectionUtils.isNotEmpty((Collection)bo.getActIds())) continue;
                        for (ActivityCommodityModelInfoBO activityCommodityModelInfoBO : removeList) {
                            if (!bo.getMaterial().equals(activityCommodityModelInfoBO.getCommoditytCode())) continue;
                            log.error("\u7269\u6599\u3010" + activityCommodityModelInfoBO.getCommoditytCode() + "\u3011\u7684\u673a\u578b\u6c60\uff0c\u5df2\u5173\u8054\u6709\u6548\u6d3b\u52a8" + bo.getActIds() + "\u4e0d\u53ef\u5220\u9664");
                            throw new ResourceException("0023", "\u7269\u6599\u3010" + activityCommodityModelInfoBO.getCommoditytCode() + "\u3011\u7684\u673a\u578b\u6c60\uff0c\u5df2\u5173\u8054\u6709\u6548\u6d3b\u52a8" + bo.getActIds() + "\u4e0d\u53ef\u5220\u9664");
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(modelIds)) {
                log.debug("\u673a\u578b\u6c60\u7f16\u8f91\u64cd\u4f5c\u65f6-\u5220\u9664\u673a\u578bID\u96c6" + ((Object)modelIds).toString());
                try {
                    this.activityCommodityModelAtomService.invalidBatchByModelId(modelIds);
                    this.activityCommodityModelObjAtomService.invalidBatchByModelId(modelIds);
                }
                catch (Exception e) {
                    log.error("\u7f16\u8f91\u673a\u578b\u6c60-\u5220\u9664\u6d3b\u52a8\u673a\u578b\u53ca\u8303\u56f4\u5f02\u5e38");
                    throw new ResourceException("9999", "\u7f16\u8f91\u673a\u578b\u6c60-\u5220\u9664\u6d3b\u52a8\u673a\u578b\u53ca\u8303\u56f4\u5f02\u5e38");
                }
            }
        }
    }

    private void updateActCommModelandObj(List<ActivityCommodityModelInfoBO> updateList) {
        ArrayList<ActivityCommodityModelInfoBO> updateModelList = new ArrayList<ActivityCommodityModelInfoBO>();
        ArrayList<ActivityCommodityModelObjInfoBO> updateObjList = new ArrayList<ActivityCommodityModelObjInfoBO>();
        HashSet<Long> updateObjIdList = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(updateList)) {
            for (ActivityCommodityModelInfoBO activityCommodityModelInfoBO : updateList) {
                if (StringUtils.isNotEmpty((CharSequence)activityCommodityModelInfoBO.getCommoditytCode())) {
                    log.debug("\u4fee\u6539\u4e86\u7269\u6599");
                    updateModelList.add(activityCommodityModelInfoBO);
                }
                if (!CollectionUtils.isNotEmpty((Collection)activityCommodityModelInfoBO.getActivityCommodityModelObjInfoBOS())) continue;
                updateObjIdList.add(activityCommodityModelInfoBO.getModelId());
                for (ActivityCommodityModelObjInfoBO activityCommodityModelObjInfoBO : activityCommodityModelInfoBO.getActivityCommodityModelObjInfoBOS()) {
                    updateObjList.add(activityCommodityModelObjInfoBO);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(updateModelList) && this.selectActCommModelList(updateModelList).booleanValue()) {
            log.debug("\u673a\u578b\u6c60\u7f16\u8f91\u64cd\u4f5c\u65f6-\u4fee\u6539\u65f6\u53c2\u6570" + ((Object)updateModelList).toString());
            try {
                this.activityCommodityModelAtomService.modifyByBatch(updateModelList);
            }
            catch (Exception e) {
                log.error("\u7f16\u8f91\u6d3b\u52a8\u673a\u578b\u53ca\u8303\u56f4\u4fe1\u606f\u5f02\u5e38");
                throw new ResourceException("9999", "\u7f16\u8f91\u6d3b\u52a8\u673a\u578b\u53ca\u8303\u56f4\u4fe1\u606f\u5f02\u5e38");
            }
        }
        if (CollectionUtils.isNotEmpty(updateObjList)) {
            this.activityCommodityModelObjAtomService.invalidBatchByModelId(updateObjIdList);
            if (this.selectActCommModelObjList(updateObjList).booleanValue()) {
                this.activityCommodityModelObjAtomService.saveByBatch(updateObjList);
            }
        }
    }

    private void addActCommModelandObj(List<ActivityCommodityModelInfoBO> addList) {
        if (CollectionUtils.isNotEmpty(addList)) {
            ArrayList<ActivityCommodityModelObjInfoBO> addModelObjList = new ArrayList<ActivityCommodityModelObjInfoBO>();
            if (this.selectActCommModelList(addList).booleanValue()) {
                List<ActivityCommodityModelInfoBO> saveActCommModel = this.addActCommModelList(addList);
                if (CollectionUtils.isNotEmpty(saveActCommModel)) {
                    for (ActivityCommodityModelInfoBO activityCommodityModelInfoBO : addList) {
                        for (ActivityCommodityModelInfoBO savebo : saveActCommModel) {
                            if (!activityCommodityModelInfoBO.getCommoditytCode().equals(savebo.getCommoditytCode()) || activityCommodityModelInfoBO.getPoolId() != savebo.getPoolId() || !CollectionUtils.isNotEmpty((Collection)activityCommodityModelInfoBO.getActivityCommodityModelObjInfoBOS())) continue;
                            for (ActivityCommodityModelObjInfoBO activityCommodityModelObjInfoBO : activityCommodityModelInfoBO.getActivityCommodityModelObjInfoBOS()) {
                                activityCommodityModelObjInfoBO.setPoolId(savebo.getPoolId());
                                activityCommodityModelObjInfoBO.setModelId(savebo.getModelId());
                                addModelObjList.add(activityCommodityModelObjInfoBO);
                            }
                        }
                    }
                }
                log.debug("\u6d4b\u8bd5\u65b0\u589e\u8303\u56f4\u67e5\u8be2\u5165\u53c2" + ((Object)addModelObjList).toString());
                if (this.selectActCommModelObjList(addModelObjList).booleanValue()) {
                    this.addActCommModelObj(addModelObjList);
                } else {
                    Iterator<Object> iterator = addModelObjList.iterator();
                    if (iterator.hasNext()) {
                        ActivityCommodityModelObjInfoBO bo = (ActivityCommodityModelObjInfoBO)iterator.next();
                        log.error("\u5df2\u5b58\u5728\u540c\u4e00\u673a\u578b\u6c60\u3010" + bo.getPoolId() + "\u3011\u540c\u4e00\u673a\u578b\u3010" + bo.getModelId() + "\u3011\u540c\u4e00\u8303\u56f4\u3010" + bo.getObjCode() + "\u3011\u7684\u6d3b\u52a8\u673a\u578b");
                        throw new ResourceException("0001", "\u5df2\u5b58\u5728\u540c\u4e00\u673a\u578b\u6c60\u3010" + bo.getPoolId() + "\u3011\u540c\u4e00\u673a\u578b\u3010" + bo.getModelId() + "\u3011\u540c\u4e00\u8303\u56f4\u3010" + bo.getObjCode() + "\u3011\u7684\u6d3b\u52a8\u673a\u578b");
                    }
                }
            } else {
                log.debug("\u6d4b\u8bd5\u65b0\u589e\u8303\u56f4\u67e5\u8be2\u5165\u53c2" + ((Object)addModelObjList).toString());
                if (this.selectActCommModelObjList(addModelObjList).booleanValue()) {
                    this.addActCommModelObj(addModelObjList);
                }
            }
        }
    }

    private Boolean selectActCommPool(ActivityCommodityPoolConfigReqBO reqBO, List<ActivityCommodityPoolInfoBO> tempList) {
        Iterator iterator;
        Page page = new Page();
        ActivityCommodityPoolInfoBO activityCommodityPoolInfoBO = reqBO.getActivityCommodityPoolInfoBO();
        activityCommodityPoolInfoBO.setTenantId(reqBO.getmTenantId());
        activityCommodityPoolInfoBO.setPoolType("01");
        tempList.add(activityCommodityPoolInfoBO);
        List<ActivityCommodityPoolInfoBO> rspList = null;
        if (CollectionUtils.isNotEmpty(tempList)) {
            try {
                rspList = this.activityCommodityPoolAtomService.selectByCondition(tempList, (Page<Map<String, Object>>)page);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u673a\u578b\u6c60\u8868\u5f02\u5e38");
                throw new ResourceException("9999", "\u67e5\u8be2\u673a\u578b\u6c60\u8868\u5f02\u5e38");
            }
        }
        if (CollectionUtils.isNotEmpty(rspList) && (iterator = rspList.iterator()).hasNext()) {
            ActivityCommodityPoolInfoBO bo = (ActivityCommodityPoolInfoBO)iterator.next();
            log.error("\u5df2\u5b58\u5728\u540c\u4e00\uff08\u673a\u578b\u6c60\u7c7b\u578b\u3001\u6d3b\u52a8\u7c7b\u578b\u3001\u9500\u552e\u7c7b\u578b\uff09\u7c7b\u578b\u3010" + bo.getPoolType() + bo.getActivityType() + bo.getSaleType() + "\u3011\u7684\u673a\u578b\u6c60");
            throw new ResourceException("0023", "\u5df2\u5b58\u5728\u540c\u4e00\u7c7b\u578b\u7684\u673a\u578b\u6c60");
        }
        return true;
    }

    private ActivityCommodityPoolInfoBO addActCommPool(ActivityCommodityPoolConfigReqBO reqBO, List<ActivityCommodityPoolInfoBO> tempList) {
        ActivityCommodityPoolInfoBO activityCommodityPoolInfoBO = tempList.get(0);
        if (null == activityCommodityPoolInfoBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrInsExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)activityCommodityPoolInfoBO.getPoolName())) {
            log.error("\u673a\u578b\u6c60\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrInsExce((String)"\u673a\u578b\u6c60\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)activityCommodityPoolInfoBO.getPoolType())) {
            log.error("\u673a\u578b\u6c60\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrInsExce((String)"\u673a\u578b\u6c60\u7c7b\u578b\u4e3a\u7a7a");
        }
        ActivityCommodityPoolInfoBO saveActivityCommodityPoolInfo = null;
        try {
            saveActivityCommodityPoolInfo = this.activityCommodityPoolAtomService.saveActivityCommodityPoolInfo(activityCommodityPoolInfoBO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u673a\u578b\u6c60\u4fe1\u606f\u5f02\u5e38");
            throw new ResourceException("9999", "\u65b0\u589e\u673a\u578b\u6c60\u4fe1\u606f\u5f02\u5e38");
        }
        return saveActivityCommodityPoolInfo;
    }

    private void selectActCommModel(ActivityCommodityPoolConfigReqBO reqBO, ActivityCommodityPoolInfoBO saveActCommPool) {
        ArrayList<ActivityCommodityModelInfoBO> detailList = new ArrayList<ActivityCommodityModelInfoBO>();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActivityCommodityModelInfoBOS())) {
            for (ActivityCommodityModelInfoBO bo : reqBO.getActivityCommodityModelInfoBOS()) {
                if (StringUtils.isEmpty((CharSequence)bo.getCommoditytCode())) {
                    log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u7269\u6599\u4e3a\u7a7a\u6216");
                    throw new ResourceException("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u7269\u6599\u4e3a\u7a7a\u6216");
                }
                if (StringUtils.isEmpty((CharSequence)bo.getCommoditytName())) {
                    log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a\u6216");
                    throw new ResourceException("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a\u6216");
                }
                if (StringUtils.isEmpty((CharSequence)bo.getCommodityBrand())) {
                    log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a\u6216");
                    throw new ResourceException("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u5546\u54c1\u54c1\u724c\u4e3a\u7a7a\u6216");
                }
                bo.setPoolId(saveActCommPool.getPoolId());
                detailList.add(bo);
            }
            if (CollectionUtils.isNotEmpty(detailList)) {
                ArrayList<ActivityCommodityModelInfoBO> saveList = new ArrayList();
                if (this.selectActCommModelList(detailList).booleanValue()) {
                    log.debug("\u4e0d\u5b58\u5728\u76f8\u540c\u7269\u6599");
                    saveList = this.addActCommModelList(detailList);
                    if (CollectionUtils.isNotEmpty(saveList)) {
                        this.selectActCommModelObj(reqBO, saveList);
                    }
                } else {
                    log.debug("\u5b58\u5728\u76f8\u540c\u7269\u6599");
                    this.selectActCommModelObj(reqBO, detailList);
                }
            }
        }
    }

    private List<ActivityCommodityModelInfoBO> addActCommModelList(List<ActivityCommodityModelInfoBO> addList) {
        List<ActivityCommodityModelInfoBO> saveActCommModel = new ArrayList<ActivityCommodityModelInfoBO>();
        if (CollectionUtils.isNotEmpty(addList)) {
            try {
                saveActCommModel = this.activityCommodityModelAtomService.saveByBatch(addList);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u4fe1\u606f\u5f02\u5e38");
                throw new ResourceException("9999", "\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u4fe1\u606f\u5f02\u5e38");
            }
        }
        if (CollectionUtils.isEmpty(saveActCommModel)) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u4fe1\u606f\u5931\u8d25");
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u4fe1\u606f\u5931\u8d25");
        }
        return saveActCommModel;
    }

    private void selectActCommModelObj(ActivityCommodityPoolConfigReqBO reqBO, List<ActivityCommodityModelInfoBO> saveActCommModelList) {
        ArrayList<ActivityCommodityModelObjInfoBO> list = new ArrayList<ActivityCommodityModelObjInfoBO>();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActivityCommodityModelInfoBOS())) {
            for (ActivityCommodityModelInfoBO reqbo : reqBO.getActivityCommodityModelInfoBOS()) {
                for (ActivityCommodityModelInfoBO savebo : saveActCommModelList) {
                    if (!reqbo.getCommoditytCode().equals(savebo.getCommoditytCode()) || reqbo.getPoolId() != savebo.getPoolId() || !CollectionUtils.isNotEmpty((Collection)reqbo.getActivityCommodityModelObjInfoBOS())) continue;
                    for (ActivityCommodityModelObjInfoBO po : reqbo.getActivityCommodityModelObjInfoBOS()) {
                        if (StringUtils.isEmpty((CharSequence)po.getObjCode())) {
                            log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u8303\u56f4\u5bf9\u8c61\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\u6216");
                            throw new ResourceException("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u8303\u56f4\u5bf9\u8c61\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\u6216");
                        }
                        if (StringUtils.isEmpty((CharSequence)po.getObjType())) {
                            log.error("\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u8303\u56f4\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a\u6216");
                            throw new ResourceException("0001", "\u64cd\u4f5c\u673a\u578b\u5165\u53c2\u8303\u56f4\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a\u6216");
                        }
                        po.setPoolId(savebo.getPoolId());
                        po.setModelId(savebo.getModelId());
                        list.add(po);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                if (this.selectActCommModelObjList(list).booleanValue()) {
                    log.debug("\u4e0d\u5b58\u5728\u76f8\u540c\u8303\u56f4");
                    this.addActCommModelObj(list);
                } else {
                    log.debug("\u5b58\u5728\u76f8\u540c\u8303\u56f4");
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext()) {
                        ActivityCommodityModelObjInfoBO bo = (ActivityCommodityModelObjInfoBO)iterator.next();
                        log.error("\u5df2\u5b58\u5728\u540c\u4e00\u673a\u578b\u6c60\u3010" + bo.getPoolId() + "\u3011\u540c\u4e00\u673a\u578b\u3010" + bo.getModelId() + "\u3011\u540c\u4e00\u8303\u56f4\u3010" + bo.getObjCode() + "\u3011\u7684\u6d3b\u52a8\u673a\u578b");
                        throw new ResourceException("0001", "\u5df2\u5b58\u5728\u540c\u4e00\u673a\u578b\u6c60\u3010" + bo.getPoolId() + "\u3011\u540c\u4e00\u673a\u578b\u3010" + bo.getModelId() + "\u3011\u540c\u4e00\u8303\u56f4\u3010" + bo.getObjCode() + "\u3011\u7684\u6d3b\u52a8\u673a\u578b");
                    }
                }
            }
        }
    }

    private void addActCommModelObj(List<ActivityCommodityModelObjInfoBO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            try {
                this.activityCommodityModelObjAtomService.saveByBatch(list);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u8303\u56f4\u4fe1\u606f\u5f02\u5e38");
                throw new ResourceException("9999", "\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u673a\u578b\u8303\u56f4\u4fe1\u606f\u5f02\u5e38");
            }
        }
    }

    private Boolean selectActCommModelObjList(List<ActivityCommodityModelObjInfoBO> addModelObjList) {
        if (CollectionUtils.isNotEmpty(addModelObjList)) {
            List<Object> list = new ArrayList();
            try {
                list = this.activityCommodityModelObjAtomService.selectByCondition(addModelObjList);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u673a\u578b\u8303\u56f4\u4fe1\u606f\u5f02\u5e38");
                throw new ResourceException("9999", "\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u673a\u578b\u8303\u56f4\u4fe1\u606f\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty(list)) {
                HashSet<Long> updateObjIdList = new HashSet<Long>();
                for (ActivityCommodityModelObjInfoBO activityCommodityModelObjInfoBO : addModelObjList) {
                    log.debug("\u5165\u53c2\u662f\u5168\u56fd\u5c06\u7701\u4efd\u7f6e\u4e3a\u5931\u6548");
                    if (!"00".equals(activityCommodityModelObjInfoBO.getObjCode())) continue;
                    updateObjIdList.add(activityCommodityModelObjInfoBO.getModelId());
                }
                for (ActivityCommodityModelObjInfoBO activityCommodityModelObjInfoBO : list) {
                    log.debug("\u67e5\u8be2\u51fa\u53c2\u662f\u5168\u56fd\u5c06\u5168\u56fd\u7f6e\u4e3a\u5931\u6548");
                    if (!"00".equals(activityCommodityModelObjInfoBO.getObjCode())) continue;
                    updateObjIdList.add(activityCommodityModelObjInfoBO.getModelId());
                }
                if (CollectionUtils.isNotEmpty(updateObjIdList)) {
                    this.activityCommodityModelObjAtomService.invalidBatchByModelId(updateObjIdList);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private Boolean selectActCommModelList(List<ActivityCommodityModelInfoBO> addList) {
        if (CollectionUtils.isNotEmpty(addList)) {
            List<Object> tempList = new ArrayList();
            try {
                tempList = this.activityCommodityModelAtomService.selectByCondition(addList);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u673a\u578b\u4fe1\u606f\u5f02\u5e38");
                throw new ResourceException("9999", "\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u673a\u578b\u4fe1\u606f\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty(tempList)) {
                for (ActivityCommodityModelInfoBO activityCommodityModelInfoBO : tempList) {
                    for (ActivityCommodityModelInfoBO bo1 : addList) {
                        bo1.setModelId(activityCommodityModelInfoBO.getModelId());
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

