/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActivityCommodityPoolAtomService;
import com.tydic.newretail.act.bo.ActivityCommodityPoolBO;
import com.tydic.newretail.act.bo.ActivityCommodityPoolInfoBO;
import com.tydic.newretail.act.bo.QryActivityCommodityPoolInfoBO;
import com.tydic.newretail.act.busi.ActivityCommodityPoolBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityCommodityPoolBusiServiceImpl
implements ActivityCommodityPoolBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCommodityPoolBusiServiceImpl.class);
    @Autowired
    private ActivityCommodityPoolAtomService activityCommodityPoolAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspPageBaseBO<ActivityCommodityPoolInfoBO> selectByCondition(ActivityCommodityPoolInfoBO reqBOs) {
        List<ActivityCommodityPoolInfoBO> bos;
        Page page = new Page();
        page.setPageNo(reqBOs.getCurrent());
        page.setPageSize(reqBOs.getPageSize());
        page.setLimit(reqBOs.getPageSize());
        page.setOffset(reqBOs.getPageSize() * (reqBOs.getCurrent() - 1));
        page.setPageNo(reqBOs.getCurrent());
        page.setPageSize(reqBOs.getPageSize());
        ArrayList<ActivityCommodityPoolInfoBO> pos = new ArrayList<ActivityCommodityPoolInfoBO>();
        pos.add(reqBOs);
        try {
            bos = this.activityCommodityPoolAtomService.selectByCondition(pos, (Page<Map<String, Object>>)page);
        }
        catch (Exception e) {
            log.error("\u673a\u578b\u6c60\u5217\u8868\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u673a\u578b\u6c60\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(bos)) {
            log.debug("\u673a\u578b\u6c60\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return new RspPageBaseBO("0000", "\u673a\u578b\u6c60\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", new ArrayList());
        }
        ArrayList<ActivityCommodityPoolInfoBO> rspList = new ArrayList<ActivityCommodityPoolInfoBO>(pos.size());
        for (ActivityCommodityPoolInfoBO po : bos) {
            ActivityCommodityPoolInfoBO bo = new ActivityCommodityPoolInfoBO();
            ConvertParamUtils.escaptActivityCommodityPoolInfo(po, this.qryEscapeAtomService);
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspList.add(bo);
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList, page.getTotalCount(), page.getTotalPages());
    }

    public RspBatchBaseBO<ActivityCommodityPoolBO> machinePoolIsExist(QryActivityCommodityPoolInfoBO reqBOs) {
        List<ActivityCommodityPoolInfoBO> bos;
        if (null == reqBOs || CollectionUtils.isEmpty((Collection)reqBOs.getActivityCommodityPoolBOS())) {
            log.error("\u673a\u578b\u6c60\u5185\u673a\u578b\u6821\u9a8c\u5165\u53c2\u4e3a\u7a7a");
            return new RspBatchBaseBO("0001", "\u673a\u578b\u6c60\u5185\u673a\u578b\u6821\u9a8c\u5165\u53c2\u4e3a\u7a7a");
        }
        for (ActivityCommodityPoolBO activityCommodityPoolBO : reqBOs.getActivityCommodityPoolBOS()) {
            if (!StringUtils.isEmpty((CharSequence)activityCommodityPoolBO.getCommoditytCode())) continue;
            log.error("\u673a\u578b\u6c60\u5185\u673a\u578b\u6821\u9a8c\u5165\u53c2\u5546\u54c1\u7f16\u7801\uff08\u7269\u6599\uff09\u4e3a\u7a7a");
            return new RspBatchBaseBO("0001", "\u673a\u578b\u6c60\u5185\u673a\u578b\u6821\u9a8c\u5165\u53c2\u5546\u54c1\u7f16\u7801\uff08\u7269\u6599\uff09\u4e3a\u7a7a");
        }
        try {
            bos = this.activityCommodityPoolAtomService.selectByTypeAndCommCOde(reqBOs);
        }
        catch (Exception e) {
            log.error("\u673a\u578b\u6c60\u5185\u673a\u578b\u6821\u9a8c\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBatchBaseBO("0003", "\u673a\u578b\u6c60\u5185\u673a\u578b\u6821\u9a8c\u8be2\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(bos)) {
            for (ActivityCommodityPoolBO bo : reqBOs.getActivityCommodityPoolBOS()) {
                bo.setExist("0");
            }
        }
        ArrayList<ActivityCommodityPoolBO> rspList = new ArrayList<ActivityCommodityPoolBO>(bos.size());
        for (ActivityCommodityPoolBO bo : reqBOs.getActivityCommodityPoolBOS()) {
            ActivityCommodityPoolBO rspbo = new ActivityCommodityPoolBO();
            BeanUtils.copyProperties((Object)bo, (Object)rspbo);
            rspbo.setExist("0");
            for (ActivityCommodityPoolInfoBO po : bos) {
                if (!rspbo.getCommoditytCode().equals(po.getCommoditytCode())) continue;
                rspbo.setExist("1");
                if (StringUtils.isNotEmpty((CharSequence)rspbo.getSaleType()) && rspbo.getSaleType().equals(po.getSaleType())) {
                    rspbo.setExist("1");
                }
                if (!StringUtils.isNotEmpty((CharSequence)rspbo.getActivityType()) || !rspbo.getActivityType().equals(po.getActivityType())) continue;
                rspbo.setExist("1");
            }
            rspList.add(rspbo);
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }
}

