/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.atom.CouponCommAtomService;
import com.tydic.newretail.act.bo.ActConfigCommDetailBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.bo.CouponCommodityBO;
import com.tydic.newretail.act.bo.CouponConfigBO;
import com.tydic.newretail.act.busi.CouponConfigBusiService;
import com.tydic.newretail.act.util.CheckParamUtils;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponConfigBusiServiceImpl
implements CouponConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(CouponConfigBusiServiceImpl.class);
    @Autowired
    private CouponAtomService couponAtomService;
    @Autowired
    private CouponCommAtomService couponCommAtomService;
    @Autowired
    private ActivityBenefitAtomService activityBenefitAtomService;

    public RspBaseBO saveCouponInfo(CouponConfigBO reqBO) {
        this.checkParams(reqBO);
        this.saveCouponPub(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public void saveCouponPub(CouponConfigBO reqBO) {
        CouponBO couponBO = CouponBO.toCouponBO((CouponConfigBO)reqBO);
        CheckParamUtils.checkCouponParams(couponBO);
        CouponBO saveRspBO = this.couponAtomService.saveCoupon(couponBO);
        if (null == saveRspBO.getCouponId()) {
            log.error("\u65b0\u589e\u7535\u5b50\u5238\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u7535\u5b50\u5238ID");
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u7535\u5b50\u5238\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u7535\u5b50\u5238ID");
        }
        this.saveCouponObj(reqBO, saveRspBO);
    }

    private void saveCouponObj(CouponConfigBO reqBO, CouponBO saveRspBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getComms())) {
            return;
        }
        List<CouponCommodityBO> couponComms = this.getCouponComms(reqBO.getComms(), saveRspBO);
        if (CollectionUtils.isEmpty(couponComms)) {
            return;
        }
        this.couponCommAtomService.saveBatch(couponComms);
    }

    private List<CouponCommodityBO> getCouponComms(List<ActConfigCommDetailBO> comms, CouponBO saveRspBO) {
        ArrayList<CouponCommodityBO> bos = new ArrayList<CouponCommodityBO>(comms.size());
        boolean onlyShop = true;
        boolean hasShop = false;
        Date nowDate = new Date();
        for (ActConfigCommDetailBO actConfigCommDetailBO : comms) {
            CouponCommodityBO comm = new CouponCommodityBO();
            comm.setCouponId(saveRspBO.getCouponId());
            comm.setCouponType(saveRspBO.getCouponType());
            if (saveRspBO.getUsefulLifeDays() > 0) {
                comm.setStartTime(saveRspBO.getUsefulStartTime());
                comm.setEndTime(TkDateUtils.getDate((Date)saveRspBO.getUsefulEndTime(), (Integer)saveRspBO.getUsefulLifeDays()));
            } else {
                comm.setStartTime(saveRspBO.getStartTime());
                comm.setEndTime(saveRspBO.getEndTime());
            }
            comm.setCrtTime(nowDate);
            comm.setSingleTypeFlag("0");
            bos.add(comm);
            if (null != actConfigCommDetailBO.getShopId()) {
                hasShop = true;
                comm.setObjCode(actConfigCommDetailBO.getShopId().toString());
                comm.setObjType("05");
                continue;
            }
            if (null != actConfigCommDetailBO.getSkuId()) {
                onlyShop = false;
                comm.setObjCode(actConfigCommDetailBO.getSkuId().toString());
                comm.setObjType("99");
                continue;
            }
            if (null != actConfigCommDetailBO.getClassTypeId()) {
                onlyShop = false;
                comm.setObjCode(actConfigCommDetailBO.getClassTypeId().toString());
                comm.setObjType("08");
                continue;
            }
            if (null != actConfigCommDetailBO.getBrand()) {
                onlyShop = false;
                comm.setObjCode(actConfigCommDetailBO.getBrand());
                comm.setObjType("10");
                continue;
            }
            if (null == actConfigCommDetailBO.getPurchaseType()) continue;
            onlyShop = false;
            comm.setObjCode(actConfigCommDetailBO.getPurchaseType());
            comm.setObjType("07");
        }
        if (hasShop && onlyShop) {
            for (CouponCommodityBO couponCommodityBO : bos) {
                couponCommodityBO.setSingleTypeFlag("1");
            }
        }
        return bos;
    }

    private void checkParams(CouponConfigBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getCouponType())) {
            log.error("\u7535\u5b50\u5238\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBO.getmUserId()) {
            log.error("\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getmOrgId())) {
            reqBO.setmOrgId("0");
        }
        if (null == reqBO.getUsefulStartTime() || null == reqBO.getUsefulEndTime()) {
            log.error("\u6d3e\u53d1\u65f6\u95f4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3e\u53d1\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (null == reqBO.getUsefulLifeDays() && null == reqBO.getStartTime() && null == reqBO.getEndTime()) {
            log.error("\u4f7f\u7528\u671f\u9650\u548c\u8d77\u6b62\u65f6\u95f4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4f7f\u7528\u671f\u9650\u548c\u8d77\u6b62\u65f6\u95f4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCouponName())) {
            log.error("\u7535\u5b50\u5238\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getUsefulLifeDays()) {
            if (null == reqBO.getStartTime() || null == reqBO.getEndTime()) {
                log.error("\u8d77\u6b62\u65f6\u95f4\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u8d77\u6b62\u65f6\u95f4\u4e3a\u7a7a");
            }
            reqBO.setUsefulLifeDays(Integer.valueOf(0));
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getComms())) {
            reqBO.setUsefulObjType("00");
        } else {
            reqBO.setUsefulObjType("01");
        }
        reqBO.setLastUpdUid(reqBO.getmUserId());
        reqBO.setTenantId(reqBO.getmTenantId());
        reqBO.setBelongRegion(reqBO.getmOrgId());
        reqBO.setLastUpdUsername(reqBO.getmName());
    }

    public RspBaseBO removeCoupon(CouponBO reqBO) {
        int benefitCount;
        if (null == reqBO.getCouponId()) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        if ((benefitCount = this.activityBenefitAtomService.getCountByCouponId(reqBO.getCouponId()).intValue()) > 0) {
            log.error("\u7535\u5b50\u5238\u5df2\u5173\u8054\u6d3b\u52a8\uff0c\u4e0d\u80fd\u5220\u9664");
            return new RspBaseBO("0010", "\u7535\u5b50\u5238\u5df2\u5173\u8054\u6d3b\u52a8\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        reqBO.setIsValid("0");
        this.couponAtomService.modifyCouponSelective(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO modifyCoupon(CouponConfigBO reqBO) {
        if (null == reqBO.getCouponId()) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        CouponBO couponBO = this.couponAtomService.qryCouponById(reqBO.getCouponId());
        if (null == couponBO) {
            log.error("\u7535\u5b50\u5238\u4e0d\u5b58\u5728");
            TkThrExceptionUtils.thrQryRspEmptyExce((String)"\u7535\u5b50\u5238\u4e0d\u5b58\u5728");
        }
        reqBO.setCouponType(couponBO.getCouponType());
        this.checkParams(reqBO);
        couponBO.setCouponName(reqBO.getCouponName());
        couponBO.setCouponDesc(reqBO.getCouponDesc());
        couponBO.setCouponDescKeyword(reqBO.getCouponDescKeyword());
        couponBO.setParam1(reqBO.getParam1());
        couponBO.setParam2(reqBO.getParam2());
        couponBO.setUsefulLifeDays(reqBO.getUsefulLifeDays());
        couponBO.setUsefulEndTime(reqBO.getUsefulEndTime());
        couponBO.setUsefulStartTime(reqBO.getUsefulStartTime());
        couponBO.setStartTime(reqBO.getStartTime());
        couponBO.setEndTime(reqBO.getEndTime());
        couponBO.setUsefulObjType(reqBO.getUsefulObjType());
        couponBO.setLastUpdTime(new Date());
        couponBO.setLastUpdUid(reqBO.getmUserId());
        couponBO.setLastUpdUsername(reqBO.getmName());
        couponBO.setTotalCountLimit(reqBO.getTotalCountLimit());
        couponBO.setUserCountLimit(reqBO.getUserCountLimit());
        CheckParamUtils.checkCouponParams(couponBO);
        this.couponAtomService.modifyCoupon(couponBO);
        this.couponCommAtomService.removeByCouponId(couponBO.getCouponId());
        this.saveCouponObj(reqBO, couponBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }
}

