/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.tydic.newretail.act.atom.CouponCalAtomService;
import com.tydic.newretail.act.atom.CouponCommAtomService;
import com.tydic.newretail.act.atom.CouponInstanceAtomService;
import com.tydic.newretail.act.atom.QryMutuallyExclusiveAtomService;
import com.tydic.newretail.act.atom.bo.QryCouponCommReqAtomBO;
import com.tydic.newretail.act.bo.ActCalReqBO;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.CouponCommodityBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponInstanceReqBO;
import com.tydic.newretail.act.bo.CouponPriceDetailBO;
import com.tydic.newretail.act.busi.CouponPriceCalBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponPriceCalBusiServiceImpl
implements CouponPriceCalBusiService {
    private static final Logger log = LoggerFactory.getLogger(CouponPriceCalBusiServiceImpl.class);
    @Autowired
    private CouponInstanceAtomService couponInstanceAtomService;
    @Autowired
    private CouponCommAtomService couponCommAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private CouponCalAtomService couponCalAtomService;
    @Autowired
    private QryMutuallyExclusiveAtomService qryMutuallyExclusiveAtomService;
    private Map<Long, Long> skuIdMap;
    private Map<String, Set<Long>> prTypeMap;
    private Map<Long, Set<Long>> classIdMap;
    private Map<String, Set<Long>> brandMap;
    private Map<Long, Set<Long>> shopMap;
    private Map<Long, Set<Long>> shopAllowCoupon;

    public ActCalReqBO calPrice(ActCalReqBO reqBO) {
        log.info("\u4f18\u60e0\u5238\u8ba1\u7b97\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        if (null == reqBO.getMemId()) {
            log.debug("\u4f1a\u5458ID\u4e3a\u7a7a");
            return reqBO;
        }
        Date nowDate = new Date();
        List<CouponInstanceBO> fullCataIns = this.getFullCataIns(reqBO, nowDate);
        if (CollectionUtils.isEmpty(fullCataIns)) {
            return reqBO;
        }
        this.initObjMap();
        ArrayList<CouponInstanceBO> nonDirecIns = new ArrayList<CouponInstanceBO>(fullCataIns.size());
        Map<Long, CouponInstanceBO> couponMap = this.getCouponMap(fullCataIns, nonDirecIns);
        List<CouponCommodityBO> allowCoupons = this.getAllowCoupons(reqBO, nowDate);
        if (CollectionUtils.isEmpty(allowCoupons) && CollectionUtils.isEmpty(nonDirecIns)) {
            return reqBO;
        }
        Map<Long, ActCommInfoBO> skuMap = this.getSkuMap(reqBO);
        ArrayList<CouponInstanceBO> instanceBOS = new ArrayList<CouponInstanceBO>(fullCataIns.size());
        HashMap<Long, Set<Long>> couponCommMap = new HashMap<Long, Set<Long>>(fullCataIns.size());
        this.reorgComm(reqBO, couponCommMap, allowCoupons, instanceBOS, couponMap, nonDirecIns);
        log.info("\u7535\u5b50\u5238\u7b2c\u4e00\u6b21\u4e92\u65a5\u67e5\u8be2\u5165\u53c2\uff1a" + ((Object)instanceBOS).toString());
        List<CouponInstanceBO> checkIns = this.qryMutuallyExclusiveAtomService.checkCoupon(instanceBOS, null);
        Double discountAmo = new Double(0.0);
        log.info("\u7535\u5b50\u5238\u7b2c\u4e00\u6b21\u4e92\u65a5\u67e5\u8be2\u51fa\u53c2\uff1a" + checkIns.toString());
        HashSet<Long> notReachList = new HashSet<Long>(checkIns.size());
        HashSet<Integer> indexSet = new HashSet<Integer>(checkIns.size());
        for (int i = 0; i < checkIns.size(); ++i) {
            CouponInstanceBO instanceBO = checkIns.get(i);
            ConvertParamUtils.escapeCoupon(instanceBO, this.qryEscapeAtomService);
            if (!couponCommMap.containsKey(instanceBO.getCouponInstanceId())) continue;
            Set<Long> shopSet = this.shopMap.containsKey(instanceBO.getCouponId()) ? this.shopMap.get(instanceBO.getCouponId()) : null;
            HashSet<Long> skuIdSet = new HashSet<Long>(((Set)couponCommMap.get(instanceBO.getCouponInstanceId())).size());
            long totalPrice = this.getCommTotalPrice(skuIdSet, instanceBO, couponCommMap, skuMap, shopSet);
            if (CollectionUtils.isEmpty(skuIdSet)) {
                indexSet.add(i);
                continue;
            }
            log.info("totalPrice\uff1a" + totalPrice);
            couponCommMap.put(instanceBO.getCouponInstanceId(), skuIdSet);
            this.checkCondition(instanceBO, totalPrice, notReachList);
            if (!"1".equals(instanceBO.getCheckFlag())) continue;
            this.calculate(couponCommMap, instanceBO, totalPrice, skuMap, discountAmo, reqBO.getApportionFlag());
        }
        if (CollectionUtils.isNotEmpty(indexSet)) {
            for (Integer id : indexSet) {
                int i = id;
                checkIns.remove(i);
            }
        }
        log.info("\u7b2c\u4e8c\u6b21checkIns=" + checkIns.toString());
        if (CollectionUtils.isNotEmpty(notReachList)) {
            log.info("notReachList=" + ((Object)notReachList).toString());
            this.qryMutuallyExclusiveAtomService.checkCoupon(checkIns, notReachList);
        }
        reqBO.setCheckIns(checkIns);
        return reqBO;
    }

    private void calculate(Map<Long, Set<Long>> couponCommMap, CouponInstanceBO instanceBO, long totalPrice, Map<Long, ActCommInfoBO> skuMap, Double discountAmo, String apportionFlag) {
        ActCommInfoBO skuInfo;
        Long amoPrice;
        Double diffAmo;
        Double totalAmo = new Double(0.0);
        Long firstSkuId = null;
        for (Long skuId : couponCommMap.get(instanceBO.getCouponInstanceId())) {
            Double skuDisPrice;
            Double skuTotalPrice;
            Double totalAmount;
            if (null == firstSkuId) {
                firstSkuId = skuId;
            }
            ActCommInfoBO skuInfoBO = skuMap.get(skuId);
            Double discount = this.couponCalAtomService.calByType(instanceBO, skuInfoBO, totalPrice);
            discountAmo = TkCalculatorUtils.add((BigDecimal)new BigDecimal(discountAmo.toString()), (BigDecimal)new BigDecimal(discount.toString())).doubleValue();
            if ("02".equals(instanceBO.getCouponType()) || "03".equals(instanceBO.getCouponType())) {
                totalAmount = TkCalculatorUtils.sub((BigDecimal)new BigDecimal(skuInfoBO.getSkuDisTotalPrice().toString()), (BigDecimal)new BigDecimal(discount.toString())).doubleValue();
                skuTotalPrice = TkCalculatorUtils.sub((BigDecimal)new BigDecimal(skuInfoBO.getSkuDisTotalPrice().toString()), (BigDecimal)new BigDecimal(totalAmount.toString())).doubleValue();
                skuDisPrice = TkCalculatorUtils.divide((BigDecimal)new BigDecimal(skuTotalPrice.toString()), (BigDecimal)new BigDecimal(skuInfoBO.getSkuCount().toString()), (int)2).doubleValue();
            } else {
                skuDisPrice = TkCalculatorUtils.sub((BigDecimal)new BigDecimal(TkCalculatorUtils.transferY((long)skuInfoBO.getSkuDisPriceL()).toString()), (BigDecimal)new BigDecimal(discount.toString())).doubleValue();
                totalAmount = TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(discount.toString()), (BigDecimal)new BigDecimal(skuInfoBO.getSkuCount().toString())).doubleValue();
                skuTotalPrice = TkCalculatorUtils.sub((BigDecimal)new BigDecimal(skuInfoBO.getSkuDisTotalPrice().toString()), (BigDecimal)new BigDecimal(totalAmount.toString())).doubleValue();
            }
            skuInfoBO.setSkuDisTotalPrice(skuTotalPrice);
            skuInfoBO.setSkuDisPrice(skuDisPrice);
            skuInfoBO.setSkuDisPriceL(TkCalculatorUtils.transfetL((double)skuDisPrice));
            skuInfoBO.setSkuDisTotalPriceL(TkCalculatorUtils.transfetL((double)skuTotalPrice));
            if ("01".equals(instanceBO.getCouponType()) || "00".equals(instanceBO.getCouponType())) {
                totalAmo = TkCalculatorUtils.add((BigDecimal)new BigDecimal(totalAmo.toString()), (BigDecimal)new BigDecimal(totalAmount.toString())).doubleValue();
            }
            CouponPriceDetailBO detailBO = new CouponPriceDetailBO();
            BeanUtils.copyProperties((Object)instanceBO, (Object)detailBO);
            detailBO.setDisAmount(totalAmount);
            List detailBOS = CollectionUtils.isNotEmpty((Collection)skuInfoBO.getCouponPrices()) ? skuInfoBO.getCouponPrices() : new ArrayList(1);
            detailBOS.add(detailBO);
            skuInfoBO.setCouponPrices(detailBOS);
        }
        if (totalAmo > 0.0 && (diffAmo = Double.valueOf(TkCalculatorUtils.sub((BigDecimal)new BigDecimal(TkCalculatorUtils.transferY((long)(amoPrice = Long.valueOf(Long.parseLong(instanceBO.getParam2())))).toString()), (BigDecimal)new BigDecimal(totalAmo.toString())).doubleValue())) != 0.0 && (skuInfo = skuMap.get(firstSkuId)).getSkuDisTotalPrice().compareTo(diffAmo) >= 0) {
            skuInfo.setSkuDisTotalPrice(Double.valueOf(TkCalculatorUtils.sub((BigDecimal)new BigDecimal(skuInfo.getSkuDisTotalPrice().toString()), (BigDecimal)new BigDecimal(diffAmo.toString())).doubleValue()));
            CouponPriceDetailBO detailBO = (CouponPriceDetailBO)skuInfo.getCouponPrices().get(0);
            Double finalAmo = TkCalculatorUtils.add((BigDecimal)new BigDecimal(detailBO.getDisAmount().toString()), (BigDecimal)new BigDecimal(diffAmo.toString())).doubleValue();
            detailBO.setDisAmount(finalAmo);
            detailBO.setDisAmountL(TkCalculatorUtils.transfetL((double)finalAmo));
        }
    }

    private long getCommTotalPrice(Set<Long> skuIdSet, CouponInstanceBO instanceBO, Map<Long, Set<Long>> couponCommMap, Map<Long, ActCommInfoBO> skuMap, Set<Long> shopSet) {
        long totalPrice = 0L;
        for (Long skuId : couponCommMap.get(instanceBO.getCouponInstanceId())) {
            ActCommInfoBO skuInfoBO = skuMap.get(skuId);
            if (CollectionUtils.isNotEmpty(shopSet) && !shopSet.contains(skuInfoBO.getShopId())) continue;
            totalPrice = TkCalculatorUtils.add((long)totalPrice, (long)TkCalculatorUtils.muliti((long)skuInfoBO.getSkuDisPriceL(), (long)skuInfoBO.getSkuCount().intValue()));
            skuIdSet.add(skuId);
        }
        return totalPrice;
    }

    private void initObjMap() {
        this.skuIdMap = new HashMap<Long, Long>(16);
        this.prTypeMap = new HashMap<String, Set<Long>>(16);
        this.shopMap = new HashMap<Long, Set<Long>>(16);
        this.classIdMap = new HashMap<Long, Set<Long>>(16);
        this.shopAllowCoupon = new HashMap<Long, Set<Long>>(16);
        this.brandMap = new HashMap<String, Set<Long>>(16);
    }

    private void checkCondition(CouponInstanceBO instanceBO, long totalPrice, Set<Long> notReachList) {
        instanceBO.setReachFlag("1");
        switch (instanceBO.getCouponType()) {
            case "00": {
                if (StringUtils.isBlank((CharSequence)instanceBO.getParam2())) {
                    log.debug("\u5f53\u524d\u65e0\u95e8\u69db\u5238\u3010{}\u3011\u65e0\u6cd5\u4f7f\u7528\uff1a\u672a\u914d\u7f6e\u4f18\u60e0\u91d1\u989d", (Object)instanceBO.getCouponInstanceId());
                    instanceBO.setReachFlag("0");
                    instanceBO.setOptionalFlag("0");
                    instanceBO.setCheckFlag("0");
                    notReachList.add(instanceBO.getCouponInstanceId());
                    break;
                }
                if (Long.valueOf(instanceBO.getParam2()).compareTo(totalPrice) <= 0) break;
                log.debug("\u5f53\u524d\u65e0\u95e8\u69db\u5238\u3010{}\u3011\u65e0\u6cd5\u4f7f\u7528\uff1a\u5546\u54c1\u91d1\u989d\u5c0f\u4e8e\u4f18\u60e0\u91d1\u989d", (Object)instanceBO.getCouponInstanceId());
                instanceBO.setReachFlag("0");
                instanceBO.setOptionalFlag("0");
                instanceBO.setCheckFlag("0");
                notReachList.add(instanceBO.getCouponInstanceId());
                break;
            }
            case "01": {
                if (StringUtils.isBlank((CharSequence)instanceBO.getParam2()) || StringUtils.isBlank((CharSequence)instanceBO.getParam1())) {
                    log.debug("\u5f53\u524d\u6ee1\u51cf\u5238\u3010{}\u3011\u65e0\u6cd5\u4f7f\u7528\uff1a\u672a\u914d\u7f6e\u8ba1\u7b97\u89c4\u5219", (Object)instanceBO.getCouponInstanceId());
                    instanceBO.setReachFlag("0");
                    instanceBO.setOptionalFlag("0");
                    instanceBO.setCheckFlag("0");
                    notReachList.add(instanceBO.getCouponInstanceId());
                    break;
                }
                if (Long.valueOf(instanceBO.getParam1()).compareTo(totalPrice) <= 0) break;
                log.debug("\u5f53\u524d\u6ee1\u51cf\u5238\u3010{}\u3011\u65e0\u6cd5\u4f7f\u7528\uff1a\u672a\u8fbe\u5230\u95e8\u69db\u91d1\u989d", (Object)instanceBO.getCouponInstanceId());
                instanceBO.setReachFlag("0");
                instanceBO.setOptionalFlag("0");
                instanceBO.setCheckFlag("0");
                notReachList.add(instanceBO.getCouponInstanceId());
                break;
            }
            case "02": 
            case "03": {
                Long price;
                if (StringUtils.isBlank((CharSequence)instanceBO.getParam2())) {
                    log.debug("\u5f53\u524d\u6298\u6263\u5238\u3010{}\u3011\u65e0\u6cd5\u4f7f\u7528\uff1a\u672a\u914d\u7f6e\u6298\u6263\u7387", (Object)instanceBO.getCouponInstanceId());
                    instanceBO.setReachFlag("0");
                    instanceBO.setOptionalFlag("0");
                    instanceBO.setCheckFlag("0");
                    notReachList.add(instanceBO.getCouponInstanceId());
                }
                if (StringUtils.isBlank((CharSequence)instanceBO.getParam1()) || (price = Long.valueOf(Long.parseLong(instanceBO.getParam1()))).compareTo(totalPrice) <= 0) break;
                log.debug("\u5f53\u524d\u6298\u6263\u5238\u3010{}\u3011\u65e0\u6cd5\u4f7f\u7528\uff1a\u672a\u8fbe\u5230\u95e8\u69db\u91d1\u989d", (Object)instanceBO.getCouponInstanceId());
                instanceBO.setReachFlag("0");
                instanceBO.setOptionalFlag("0");
                instanceBO.setCheckFlag("0");
                notReachList.add(instanceBO.getCouponInstanceId());
                break;
            }
        }
    }

    private void reorgComm(ActCalReqBO reqBO, Map<Long, Set<Long>> couponCommMap, List<CouponCommodityBO> allowCoupons, List<CouponInstanceBO> instanceBOS, Map<Long, CouponInstanceBO> couponMap, List<CouponInstanceBO> nonDirecIns) {
        HashSet<Long> tempSet = new HashSet<Long>(couponMap.size());
        HashSet<Long> instanceIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(allowCoupons)) {
            for (CouponCommodityBO coupon : allowCoupons) {
                tempSet.add(coupon.getCouponInstanceId());
                if (!couponMap.containsKey(coupon.getCouponInstanceId())) {
                    log.debug("\u7535\u5b50\u5238\u3010" + coupon.getCouponInstanceId() + "\u3011\u8fc7\u671f\u6216\u5df2\u4f7f\u7528");
                    continue;
                }
                CouponInstanceBO instanceBO = couponMap.get(coupon.getCouponInstanceId());
                if (!instanceIds.contains(coupon.getCouponInstanceId())) {
                    instanceIds.add(coupon.getCouponInstanceId());
                    instanceBOS.add(instanceBO);
                }
                if (CollectionUtils.isEmpty((Collection)reqBO.getCouponInstanceIds()) || !reqBO.getCouponInstanceIds().contains(instanceBO.getCouponInstanceId())) {
                    instanceBO.setCheckFlag("0");
                } else {
                    instanceBO.setCheckFlag("1");
                }
                switch (coupon.getObjType()) {
                    case "07": {
                        String prType = coupon.getObjCode();
                        if (!this.prTypeMap.containsKey(prType)) break;
                        Set<Object> skuSet = couponCommMap.containsKey(coupon.getCouponInstanceId()) ? couponCommMap.get(coupon.getCouponInstanceId()) : new HashSet(1);
                        skuSet.addAll((Collection)this.prTypeMap.get(prType));
                        couponCommMap.put(coupon.getCouponInstanceId(), skuSet);
                        break;
                    }
                    case "99": {
                        Long skuId = Long.parseLong(coupon.getObjCode());
                        if (!this.skuIdMap.containsKey(skuId)) break;
                        Set<Object> skuSet = couponCommMap.containsKey(coupon.getCouponInstanceId()) ? couponCommMap.get(coupon.getCouponInstanceId()) : new HashSet(1);
                        skuSet.add(this.skuIdMap.get(skuId));
                        couponCommMap.put(coupon.getCouponInstanceId(), skuSet);
                        break;
                    }
                    case "08": {
                        Long classId = Long.parseLong(coupon.getObjCode());
                        if (!this.classIdMap.containsKey(classId)) break;
                        Set<Object> skuSet = couponCommMap.containsKey(coupon.getCouponInstanceId()) ? couponCommMap.get(coupon.getCouponInstanceId()) : new HashSet(1);
                        skuSet.addAll((Collection<Object>)this.classIdMap.get(classId));
                        couponCommMap.put(coupon.getCouponInstanceId(), skuSet);
                        break;
                    }
                    case "10": {
                        String brand = coupon.getObjCode();
                        if (!this.brandMap.containsKey(brand)) break;
                        Set<Object> skuSet = couponCommMap.containsKey(coupon.getCouponInstanceId()) ? couponCommMap.get(coupon.getCouponInstanceId()) : new HashSet(1);
                        skuSet.addAll((Collection<Object>)this.brandMap.get(brand));
                        couponCommMap.put(coupon.getCouponInstanceId(), skuSet);
                        break;
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(nonDirecIns)) {
            for (CouponInstanceBO instanceBO : nonDirecIns) {
                if (tempSet.contains(instanceBO.getCouponInstanceId())) continue;
                tempSet.add(instanceBO.getCouponInstanceId());
                if (!instanceIds.contains(instanceBO.getCouponInstanceId())) {
                    instanceIds.add(instanceBO.getCouponInstanceId());
                    instanceBOS.add(instanceBO);
                }
                if (CollectionUtils.isEmpty((Collection)reqBO.getCouponInstanceIds()) || !reqBO.getCouponInstanceIds().contains(instanceBO.getCouponInstanceId())) {
                    instanceBO.setCheckFlag("0");
                } else {
                    instanceBO.setCheckFlag("1");
                }
                HashSet<Long> skuSet = new HashSet<Long>(reqBO.getCommList().size());
                for (ActCommInfoBO comm : reqBO.getCommList()) {
                    skuSet.add(comm.getSkuId());
                }
                couponCommMap.put(instanceBO.getCouponInstanceId(), skuSet);
            }
        }
        if (MapUtils.isNotEmpty(this.shopAllowCoupon)) {
            for (ActCommInfoBO comm : reqBO.getCommList()) {
                if (!this.shopAllowCoupon.containsKey(comm.getShopId())) continue;
                for (Long instanceid : this.shopAllowCoupon.get(comm.getShopId())) {
                    Set<Object> skuSet = couponCommMap.containsKey(instanceid) ? couponCommMap.get(instanceid) : new HashSet(1);
                    skuSet.add(comm.getSkuId());
                    couponCommMap.put(instanceid, skuSet);
                }
            }
        }
    }

    private Map<Long, ActCommInfoBO> getSkuMap(ActCalReqBO reqBO) {
        HashMap<Long, ActCommInfoBO> skuMap = new HashMap<Long, ActCommInfoBO>(reqBO.getCommList().size());
        for (ActCommInfoBO comm : reqBO.getCommList()) {
            this.skuIdMap.put(comm.getSkuId(), comm.getSkuId());
            HashSet<Long> prSet = this.prTypeMap.containsKey(comm.getPurchaseType()) ? this.prTypeMap.get(comm.getPurchaseType()) : new HashSet<Long>(1);
            prSet.add(comm.getSkuId());
            this.prTypeMap.put(comm.getPurchaseType(), prSet);
            if (null != comm.getClassTypeId()) {
                HashSet<Long> classSet = this.classIdMap.containsKey(comm.getClassTypeId()) ? this.classIdMap.get(comm.getClassTypeId()) : new HashSet<Long>(1);
                classSet.add(comm.getSkuId());
                this.classIdMap.put(comm.getClassTypeId(), classSet);
            }
            if (StringUtils.isNotBlank((CharSequence)comm.getBrand())) {
                HashSet<Long> brandSet = this.brandMap.containsKey(comm.getBrand()) ? this.brandMap.get(comm.getBrand()) : new HashSet<Long>(1);
                brandSet.add(comm.getSkuId());
                this.brandMap.put(comm.getBrand(), brandSet);
            }
            skuMap.put(comm.getSkuId(), comm);
        }
        return skuMap;
    }

    private List<CouponCommodityBO> getAllowCoupons(ActCalReqBO reqBO, Date nowDate) {
        ArrayList<CouponCommodityBO> comms = new ArrayList<CouponCommodityBO>(reqBO.getCommList().size());
        ArrayList<CouponCommodityBO> qryShopComms = new ArrayList<CouponCommodityBO>(reqBO.getCommList().size());
        for (ActCommInfoBO commInfoBO : reqBO.getCommList()) {
            CouponCommodityBO comm = new CouponCommodityBO();
            comm.setObjType("07");
            comm.setObjCode(commInfoBO.getPurchaseType());
            comms.add(comm);
            comm = new CouponCommodityBO();
            comm.setObjType("99");
            comm.setObjCode(commInfoBO.getSkuId().toString());
            comms.add(comm);
            if (null != commInfoBO.getClassTypeId()) {
                comm = new CouponCommodityBO();
                comm.setObjType("08");
                comm.setObjCode(commInfoBO.getClassTypeId().toString());
                comms.add(comm);
            }
            if (StringUtils.isNotBlank((CharSequence)commInfoBO.getBrand())) {
                comm = new CouponCommodityBO();
                comm.setObjType("10");
                comm.setObjCode(commInfoBO.getBrand());
                comms.add(comm);
            }
            if (null == commInfoBO.getShopId()) continue;
            comm = new CouponCommodityBO();
            comm.setObjType("05");
            comm.setObjCode(commInfoBO.getShopId().toString());
            qryShopComms.add(comm);
        }
        QryCouponCommReqAtomBO atomBO = new QryCouponCommReqAtomBO();
        atomBO.setComms(comms);
        atomBO.setCurrentDate(nowDate);
        List<CouponCommodityBO> allowCoupons = this.couponCommAtomService.listCommByCondition(atomBO);
        atomBO.setComms(qryShopComms);
        List<CouponCommodityBO> shopCoupons = this.couponCommAtomService.listCommByCondition(atomBO);
        HashSet<Long> couponIds = new HashSet<Long>();
        HashMap<Long, Object> map = new HashMap<Long, Object>(16);
        if (CollectionUtils.isNotEmpty(allowCoupons)) {
            for (CouponCommodityBO comm : allowCoupons) {
                List<Object> commList = map.containsKey(comm.getCouponId()) ? (List)map.get(comm.getCouponId()) : new ArrayList<CouponCommodityBO>();
                commList.add(comm);
                map.put(comm.getCouponId(), commList);
                couponIds.add(comm.getCouponId());
            }
        }
        HashSet<Long> shopCoupon = null;
        HashMap shopAllow = null;
        if (CollectionUtils.isNotEmpty(shopCoupons)) {
            shopAllow = new HashMap(shopCoupons.size());
            shopCoupon = new HashSet<Long>(shopCoupons.size());
            for (CouponCommodityBO comm : shopCoupons) {
                if (!"05".equals(comm.getObjType()) || !"1".equals(comm.getSingleTypeFlag())) continue;
                ArrayList<CouponCommodityBO> commList = map.containsKey(comm.getCouponId()) ? (List)map.get(comm.getCouponId()) : new ArrayList<CouponCommodityBO>();
                commList.add(comm);
                map.put(comm.getCouponId(), commList);
                couponIds.add(comm.getCouponId());
                shopCoupon.add(comm.getCouponId());
                Set<Long> couponSet = shopAllow.containsKey(comm.getCouponId()) ? (Set)shopAllow.get(comm.getCouponId()) : new HashSet(1);
                couponSet.add(comm.getCouponId());
                shopAllow.put(Long.parseLong(comm.getObjCode()), couponSet);
            }
        }
        if (CollectionUtils.isEmpty(couponIds)) {
            return null;
        }
        List<CouponInstanceBO> instanceBOS = this.couponInstanceAtomService.listInsByCouponIds(reqBO.getMemId(), couponIds);
        if (CollectionUtils.isEmpty(instanceBOS)) {
            log.debug("\u672a\u67e5\u8be2\u5230\u53ef\u7528\u7535\u5b50\u5238\u5b9e\u4f8b");
            return null;
        }
        ArrayList<CouponCommodityBO> allowList = new ArrayList<CouponCommodityBO>();
        HashSet<Long> qryCouponIds = new HashSet<Long>(instanceBOS.size());
        HashMap instanceMap = new HashMap(instanceBOS.size());
        for (CouponInstanceBO couponInstanceBO : instanceBOS) {
            List tempList = (List)map.get(couponInstanceBO.getCouponId());
            for (CouponCommodityBO temp : tempList) {
                CouponCommodityBO couponComm = new CouponCommodityBO();
                couponComm.setObjCode(temp.getObjCode());
                couponComm.setObjType(temp.getObjType());
                couponComm.setStartTime(temp.getStartTime());
                couponComm.setSeqId(temp.getSeqId());
                couponComm.setEndTime(temp.getEndTime());
                couponComm.setCrtTime(temp.getCrtTime());
                couponComm.setCouponType(temp.getCouponType());
                couponComm.setCouponInstanceId(couponInstanceBO.getCouponInstanceId());
                couponComm.setCouponId(couponInstanceBO.getCouponId());
                allowList.add(couponComm);
            }
            qryCouponIds.add(couponInstanceBO.getCouponId());
            if (!CollectionUtils.isNotEmpty(shopCoupon) || !shopCoupon.contains(couponInstanceBO.getCouponId())) continue;
            Set<Long> instanceSet = instanceMap.containsKey(couponInstanceBO.getCouponId()) ? (Set)instanceMap.get(couponInstanceBO.getCouponId()) : new HashSet(1);
            instanceSet.add(couponInstanceBO.getCouponInstanceId());
            instanceMap.put(couponInstanceBO.getCouponId(), instanceSet);
        }
        if (MapUtils.isNotEmpty(instanceMap) && MapUtils.isNotEmpty(shopAllow)) {
            for (Map.Entry entry : shopAllow.entrySet()) {
                for (Long couponId : (Set)entry.getValue()) {
                    if (!instanceMap.containsKey(couponId)) continue;
                    HashSet instanceSet = this.shopAllowCoupon.containsKey(entry.getKey()) ? this.shopAllowCoupon.get(entry.getKey()) : new HashSet(1);
                    instanceSet.addAll((Collection)instanceMap.get(couponId));
                    this.shopAllowCoupon.put((Long)entry.getKey(), instanceSet);
                }
            }
        }
        this.getCouponAllowShop(qryCouponIds);
        return allowList;
    }

    private void getCouponAllowShop(Set<Long> qryCouponIds) {
        QryCouponCommReqAtomBO atomBO = new QryCouponCommReqAtomBO();
        atomBO.setCouponIds(qryCouponIds);
        HashSet<String> objTypes = new HashSet<String>(1);
        objTypes.add("05");
        atomBO.setObjTypes(objTypes);
        List<CouponCommodityBO> shopComms = this.couponCommAtomService.listByObjTypeAndId(atomBO);
        if (CollectionUtils.isEmpty(shopComms)) {
            return;
        }
        for (CouponCommodityBO comm : shopComms) {
            HashSet<Long> shopSet = this.shopMap.containsKey(comm.getCouponId()) ? this.shopMap.get(comm.getCouponId()) : new HashSet<Long>(1);
            shopSet.add(Long.parseLong(comm.getObjCode()));
            this.shopMap.put(comm.getCouponId(), shopSet);
        }
    }

    private Map<Long, CouponInstanceBO> getCouponMap(List<CouponInstanceBO> fullCataIns, List<CouponInstanceBO> nonDirecIns) {
        HashMap<Long, CouponInstanceBO> map = new HashMap<Long, CouponInstanceBO>(fullCataIns.size());
        for (CouponInstanceBO bo : fullCataIns) {
            map.put(bo.getCouponInstanceId(), bo);
            if (!"00".equals(bo.getUsefulObjType())) continue;
            nonDirecIns.add(bo);
        }
        return map;
    }

    private List<CouponInstanceBO> getFullCataIns(ActCalReqBO reqBO, Date nowDate) {
        CouponInstanceReqBO instanceReqBO = new CouponInstanceReqBO();
        instanceReqBO.setUid(reqBO.getMemId());
        instanceReqBO.setStartTime(nowDate);
        instanceReqBO.setEndTime(nowDate);
        instanceReqBO.setUseStatus("0");
        List<CouponInstanceBO> fullCataIns = this.couponInstanceAtomService.queryCouponInstance(instanceReqBO);
        return fullCataIns;
    }
}

