/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.bo.DistributeCouponBusiReqBO;
import com.tydic.newretail.act.busi.DistributeCouponBusiService;
import com.tydic.newretail.act.dao.CouponInstanceDAO;
import com.tydic.newretail.act.dao.po.CouponInstancePO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributeCouponBusiServiceImpl
implements DistributeCouponBusiService {
    private static final Logger log = LoggerFactory.getLogger(DistributeCouponBusiServiceImpl.class);
    @Autowired
    private CouponAtomService couponAtomService;
    @Autowired
    private CouponInstanceDAO couponInstanceDAO;

    public RspBaseBO distributeCoupon(DistributeCouponBusiReqBO distributeCouponReqBO) {
        RspBaseBO result = new RspBaseBO();
        try {
            boolean isAmount;
            if (null == distributeCouponReqBO.getCouponBO() && null == distributeCouponReqBO.getCouponId()) {
                log.error("\u5165\u53c2\u4f18\u60e0\u5238ID[couponId]\u548c\u4f18\u60e0\u5238\u4fe1\u606f\u3010couponBO\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                result.setRespCode("0001");
                result.setRespDesc("\u5165\u53c2\u4f18\u60e0\u5238ID[couponId]\u548c\u4f18\u60e0\u5238\u4fe1\u606f\u3010couponBO\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                return result;
            }
            CouponBO couponBO = null;
            if (null != distributeCouponReqBO.getCouponBO()) {
                couponBO = distributeCouponReqBO.getCouponBO();
            } else {
                CouponInstancePO countReq;
                couponBO = this.couponAtomService.qryCouponById(distributeCouponReqBO.getCouponId());
                if (null == couponBO) {
                    log.error("\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u4e0d\u5b58\u5728\u3002");
                    result.setRespCode("0002");
                    result.setRespDesc("\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u4e0d\u5b58\u5728\u3002");
                    return result;
                }
                if (null != couponBO.getUsefulStartTime() && null != couponBO.getUsefulEndTime() && (new Date().before(couponBO.getUsefulStartTime()) || new Date().after(couponBO.getUsefulEndTime()))) {
                    log.error("\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u4e0d\u5728\u53ef\u6d3e\u53d1\u65f6\u95f4\u5185\u3002");
                    result.setRespCode("0010");
                    result.setRespDesc("\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u4e0d\u5728\u53ef\u6d3e\u53d1\u65f6\u95f4\u5185\u3002");
                    return result;
                }
                if (couponBO.getTotalCountLimit() > 0) {
                    countReq = new CouponInstancePO();
                    countReq.setCouponId(distributeCouponReqBO.getCouponId());
                    int couponTotal = this.couponInstanceDAO.selectCountByCoupon(countReq);
                    if (couponTotal >= couponBO.getTotalCountLimit()) {
                        log.error("\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u53d1\u653e\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u53ef\u6d3e\u53d1\u3002");
                        result.setRespCode("0012");
                        result.setRespDesc("\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u53d1\u653e\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u53ef\u6d3e\u53d1\u3002");
                        return result;
                    }
                }
                if (couponBO.getUserCountLimit() > 0) {
                    countReq = new CouponInstancePO();
                    countReq.setCouponId(distributeCouponReqBO.getCouponId());
                    countReq.setUid(distributeCouponReqBO.getUserId());
                    int couponUserTotal = this.couponInstanceDAO.selectCountByCoupon(countReq);
                    if (couponUserTotal >= couponBO.getUserCountLimit()) {
                        log.error("\u7528\u6237" + distributeCouponReqBO.getUserId() + "\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u53d1\u653e\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u53ef\u6d3e\u53d1\u3002");
                        result.setRespCode("0012");
                        result.setRespDesc("\u7528\u6237" + distributeCouponReqBO.getUserId() + "\u4f18\u60e0\u5238ID[" + distributeCouponReqBO.getCouponId() + "]\u53d1\u653e\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u53ef\u6d3e\u53d1\u3002");
                        return result;
                    }
                }
            }
            CouponInstancePO couponInstancePO = new CouponInstancePO();
            couponInstancePO.setCouponId(couponBO.getCouponId());
            couponInstancePO.setUid(distributeCouponReqBO.getUserId());
            couponInstancePO.setTenantId(couponBO.getTenantId());
            couponInstancePO.setExchangeCode(distributeCouponReqBO.getExchangeCode());
            couponInstancePO.setCouponType(couponBO.getCouponType());
            couponInstancePO.setCouponName(couponBO.getCouponName());
            couponInstancePO.setCouponDesc(couponBO.getCouponDesc());
            couponInstancePO.setCouponDescKeyWord(couponBO.getCouponDescKeyword());
            couponInstancePO.setCrtTime(new Date());
            couponInstancePO.setUseStatus("0");
            couponInstancePO.setUsefulObjType(couponBO.getUsefulObjType());
            couponInstancePO.setPriority(couponBO.getPriority());
            if (null != couponBO.getStartTime() && null != couponBO.getEndTime()) {
                couponInstancePO.setStartTime(couponBO.getStartTime());
                couponInstancePO.setEndTime(couponBO.getEndTime());
            } else if (couponBO.getUsefulLifeDays() > 0) {
                couponInstancePO.setStartTime(new Date());
                couponInstancePO.setEndTime(TkDateUtils.getDate((Date)new Date(), (Integer)couponBO.getUsefulLifeDays()));
            }
            couponInstancePO.setParam1(couponBO.getParam1());
            couponInstancePO.setParam2(couponBO.getParam2());
            boolean bl = isAmount = "01".equals(couponBO.getCouponType()) || "00".equals(couponBO.getCouponType());
            if (isAmount && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{couponBO.getParam2()})) {
                couponInstancePO.setTotalAmount(Long.valueOf(couponBO.getParam2()));
            } else if (("02".equals(couponBO.getCouponType()) || "03".equals(couponBO.getCouponType())) && StringUtils.isNotBlank((CharSequence)couponBO.getParam2())) {
                couponInstancePO.setDiscountRate(new Double(couponBO.getParam2()));
            }
            couponInstancePO.setCouponSrcInstance(distributeCouponReqBO.getCouponSrcInstance());
            couponInstancePO.setCouponSrcChannel(distributeCouponReqBO.getCouponSrcChannel());
            couponInstancePO.setDistributeTime(new Date());
            couponInstancePO.setActivityId(distributeCouponReqBO.getActivityId());
            this.couponInstanceDAO.insert(couponInstancePO);
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u6d3e\u52b5\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            result.setRespCode("9999");
            result.setRespDesc(e.getMessage());
            return result;
        }
        return result;
    }
}

